
########################### Granger causality analysis of the electricity price volatility
################# Multivariate Granger-causality test

library(vars)
library(lmtest)

CPI.elec<- "C:\\Users\\segnon\\Documents\\R\\elec_bernd_sea.csv"
CPIelec <- read.csv2(file = CPI.elec,dec=",",sep=";",na.strings="-",header=TRUE,stringsAsFactors=FALSE)
####################################################

sCPIelec <- data.frame(NSW = (CPIelec$NSW)^2, QLD = (CPIelec$QLD)^2, SA = (CPIelec$SA)^2, TAS = (CPIelec$TAS)^2, VIC = (CPIelec$VIC)^2)


causevariables<- names(sCPIelec)
mpvalue<- matrix(NA, nrow = 5, ncol = 1)
for (j in 1:length(causevariables)) {
  Mdataused<- sCPIelec[1:3776,]
  optimallag<- VARselect(Mdataused, lag.max = 8, type = "const")
  var.2c <- VAR(Mdataused, p = as.numeric(optimallag$selection[3]), type = "const")
  multitest<- causality(var.2c, cause = causevariables[j], vcov.=vcovHC(var.2c))
  mpvalue[j,1]<- as.numeric(multitest$Granger$p.value)
  
}

mpvalue



causevariables<- names(sCPIelec)
mpvalue<- matrix(NA, nrow = 5, ncol = 1)
for (j in 1:length(causevariables)) {
  Mdataused<- sCPIelec[1:1888,]
  optimallag<- VARselect(Mdataused, lag.max = 8, type = "const")
  var.2c <- VAR(Mdataused, p = as.numeric(optimallag$selection[3]), type = "const")
  multitest<- causality(var.2c, cause = causevariables[j], vcov.=vcovHC(var.2c))
  mpvalue[j,1]<- as.numeric(multitest$Granger$p.value)
  
}
mpvalue



causevariables<- names(sCPIelec)
mpvalue<- matrix(NA, nrow = 5, ncol = 1)
for (j in 1:length(causevariables)) {
  Mdataused<- sCPIelec[1:944,]
  optimallag<- VARselect(Mdataused, lag.max = 8, type = "const")
  var.2c <- VAR(Mdataused, p = as.numeric(optimallag$selection[3]), type = "const")
  multitest<- causality(var.2c, cause = causevariables[j], vcov.=vcovHC(var.2c))
  mpvalue[j,1]<- as.numeric(multitest$Granger$p.value)
  
}
mpvalue



causevariables<- names(sCPIelec)
mpvalue<- matrix(NA, nrow = 5, ncol = 1)
for (j in 1:length(causevariables)) {
  Mdataused<- sCPIelec[1888:3776,]
  optimallag<- VARselect(Mdataused, lag.max = 8, type = "const")
  var.2c <- VAR(Mdataused, p = as.numeric(optimallag$selection[3]), type = "const")
  multitest<- causality(var.2c, cause = causevariables[j], vcov.=vcovHC(var.2c))
  mpvalue[j,1]<- as.numeric(multitest$Granger$p.value)
  
}
mpvalue



causevariables<- names(sCPIelec)
mpvalue<- matrix(NA, nrow = 5, ncol = 1)
for (j in 1:length(causevariables)) {
  Mdataused<- sCPIelec[2832:3776,]
  optimallag<- VARselect(Mdataused, lag.max = 8, type = "const")
  var.2c <- VAR(Mdataused, p = as.numeric(optimallag$selection[3]), type = "const")
  multitest<- causality(var.2c, cause = causevariables[j], vcov.=vcovHC(var.2c))
  mpvalue[j,1]<- as.numeric(multitest$Granger$p.value)
  
}
mpvalue



#####################################################################
########################################################################## Bivariate Granger causality test

CPI.elec<- "C:\\Users\\segnon\\Documents\\R\\elec_bernd_sea.csv"
CPIelec <- read.csv2(file = CPI.elec,dec=",",sep=";",na.strings="-",header=TRUE,stringsAsFactors=FALSE)
####################################################

sCPIelec <- data.frame(NSW = (CPIelec$NSW)^2, QLD = (CPIelec$QLD)^2, SA = (CPIelec$SA)^2, TAS = (CPIelec$TAS)^2, VIC = (CPIelec$VIC)^2)

#### Whole data
pv1<- matrix(NA, nrow = 5, ncol = 5)
tt<- 1
N1<- round((dim(sCPIelec)[1])*tt)

for (i in 1:5) {
  for (j in 1:5) {
    if (i==j){
      pv1[i,j]<- 0
    } else {
    dat1<- sCPIelec[1:N1,c(i,j)]
    optimallag <- as.numeric(VARselect(dat1,lag.max=10, type="const")$selection[3])
    Testfirst<- grangertest(dat1[,1] ~ dat1[,2], order = optimallag, data = dat1) 
    pv1[i,j]<- as.numeric(Testfirst$`Pr(>F)`)[2]
    }
  }
}

pv1


#### 75% of Whole data
pv1<- matrix(NA, nrow = 5, ncol = 5)
tt<- 0.75
N1<- round((dim(sCPIelec)[1])*tt)

for (i in 1:5) {
  for (j in 1:5) {
    if (i==j){
      pv1[i,j]<- 0
    } else {
      dat1<- sCPIelec[1:N1,c(i,j)]
      optimallag <- as.numeric(VARselect(dat1,lag.max=10, type="const")$selection[3])
      Testfirst<- grangertest(dat1[,1] ~ dat1[,2], order = optimallag, data = dat1) 
      pv1[i,j]<- as.numeric(Testfirst$`Pr(>F)`)[2]
    }
  }
  
}

#### 66% of Whole data
pv1<- matrix(NA, nrow = 5, ncol = 5)
tt<- 2/3
N1<- round((dim(sCPIelec)[1])*tt)

for (i in 1:5) {
  for (j in 1:5) {
    if (i==j){
      pv1[i,j]<- 0
    } else {
      dat1<- sCPIelec[1:N1,c(i,j)]
      optimallag <- as.numeric(VARselect(dat1,lag.max=10, type="const")$selection[3])
      Testfirst<- grangertest(dat1[,1] ~ dat1[,2], order = optimallag, data = dat1) 
      pv1[i,j]<- as.numeric(Testfirst$`Pr(>F)`)[2]
    }
  }
  
}



#### 50% of Whole data
pv1<- matrix(NA, nrow = 5, ncol = 5)
tt<- 0.5
N1<- round((dim(sCPIelec)[1])*tt)

for (i in 1:5) {
  for (j in 1:5) {
    if (i==j){
      pv1[i,j]<- 0
    } else {
      dat1<- sCPIelec[1:N1,c(i,j)]
      optimallag <- as.numeric(VARselect(dat1,lag.max=10, type="const")$selection[3])
      Testfirst<- grangertest(dat1[,1] ~ dat1[,2], order = optimallag, data = dat1) 
      pv1[i,j]<- as.numeric(Testfirst$`Pr(>F)`)[2]
    }
  }
}
pv1

#### 25% of Whole data
pv1<- matrix(NA, nrow = 5, ncol = 5)
tt<- 0.25
N1<- round((dim(sCPIelec)[1])*tt)

for (i in 1:5) {
  for (j in 1:5) {
    if (i==j){
      pv1[i,j]<- 0
    } else {
      dat1<- sCPIelec[1:N1,c(i,j)]
      optimallag <- as.numeric(VARselect(dat1,lag.max=10, type="const")$selection[3])
      Testfirst<- grangertest(dat1[,1] ~ dat1[,2], order = optimallag, data = dat1) 
      pv1[i,j]<- as.numeric(Testfirst$`Pr(>F)`)[2]
    }
  }
  
}
pv1


####################################################
############################################################# Robustness
#################################################################### other 



pv1<- matrix(NA, nrow = 5, ncol = 5)
tt<- 0.25
NN1<- round((dim(sCPIelec)[1])*tt)
NN<- dim(sCPIelec)[1]
for (i in 1:5) {
  for (j in 1:5) {
    if (i==j){
      pv1[i,j]<- 0
    } else {
      dat1<- sCPIelec[NN1:NN,c(i,j)]
      optimallag <- as.numeric(VARselect(dat1,lag.max=10, type="const")$selection[3])
      Testfirst<- grangertest(dat1[,1] ~ dat1[,2], order = optimallag, data = dat1) 
      pv1[i,j]<- as.numeric(Testfirst$`Pr(>F)`)[2]
    }
  }
}
pv1



pv1<- matrix(NA, nrow = 5, ncol = 5)
tt<- 0.50
NN1<- round((dim(sCPIelec)[1])*tt)
NN<- dim(sCPIelec)[1]
for (i in 1:5) {
  for (j in 1:5) {
    if (i==j){
      pv1[i,j]<- 0
    } else {
      dat1<- sCPIelec[NN1:NN,c(i,j)]
      optimallag <- as.numeric(VARselect(dat1,lag.max=10, type="const")$selection[3])
      Testfirst<- grangertest(dat1[,1] ~ dat1[,2], order = optimallag, data = dat1) 
      pv1[i,j]<- as.numeric(Testfirst$`Pr(>F)`)[2]
    }
  }
}
pv1

pv1<- matrix(NA, nrow = 5, ncol = 5)
tt<- 0.67
NN1<- round((dim(sCPIelec)[1])*tt)
NN<- dim(sCPIelec)[1]
for (i in 1:5) {
  for (j in 1:5) {
    if (i==j){
      pv1[i,j]<- 0
    } else {
      dat1<- sCPIelec[NN1:NN,c(i,j)]
      optimallag <- as.numeric(VARselect(dat1,lag.max=10, type="const")$selection[3])
      Testfirst<- grangertest(dat1[,1] ~ dat1[,2], order = optimallag, data = dat1) 
      pv1[i,j]<- as.numeric(Testfirst$`Pr(>F)`)[2]
    }
  }
}
pv1


pv1<- matrix(NA, nrow = 5, ncol = 5)
tt<- 0.75
NN1<- round((dim(sCPIelec)[1])*tt)
NN<- dim(sCPIelec)[1]
for (i in 1:5) {
  for (j in 1:5) {
    if (i==j){
      pv1[i,j]<- 0
    } else {
      dat1<- sCPIelec[NN1:NN,c(i,j)]
      optimallag <- as.numeric(VARselect(dat1,lag.max=10, type="const")$selection[3])
      Testfirst<- grangertest(dat1[,1] ~ dat1[,2], order = optimallag, data = dat1) 
      pv1[i,j]<- as.numeric(Testfirst$`Pr(>F)`)[2]
    }
  }
}
pv1


#####################################################################
###########################################
