function for_msgarch

clear
addpath('./STARFIMA');
k = 2; % Regimes
s = 20; % horizons

 data = xlsread('elec_bernd_sea.xls',1);
% data extraction
% NSW
     y = data(:,1);
     T = length(y);
     T1 = length(1402:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     
     forecastmsgarch = zeros(T1-h,h);
     for t=1:T1-h
         data1 = y(t:T-T1+t);
         lag1 = lagmatrix(data1,1);
         residuals = lstar(data1,lag1,length(data1),1,3);        

        [estimation, probabilities, ~] = MSgarch(residuals, 2, 'NORMAL' ,[]);
         Hg = estimation.HH;
         predict = probabilities.predict;
         parameters1 = estimation.garch;
         parameters2 = estimation.transM;
         forecasts =MSforecasts(Hg,predict,parameters1,parameters2,k,s);
         forecastmsgarch(t,:) = forecasts;
     end
     
    xlswrite('Eforecasts_msgarch_rev.xls',forecastmsgarch,1,'A1'); 
      

% QLD
     y = data(:,2);
     T = length(y);
     T1 = length(1508:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     
     forecastmsgarch = zeros(T1-h,h);
     for t=1:T1-h
         data2 = y(t:T-T1+t);
         lag2 = lagmatrix(data2,1);
         residuals = lstar(data2,lag2,length(data2),1,2);

        [estimation, probabilities, ~] = MSgarch(residuals, 2, 'NORMAL' ,[]);
         Hg = estimation.HH;
         predict = probabilities.predict;
         parameters1 = estimation.garch;
         parameters2 = estimation.transM;
         forecasts =MSforecasts(Hg,predict,parameters1,parameters2,k,s);
         forecastmsgarch(t,:) = forecasts;       
     end
    xlswrite('Eforecasts_msgarch_rev.xls',forecastmsgarch,2,'A1'); 

 % SA

     y = data(:,3);
     T = length(y);
     T1 = length(1503:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     
     forecastmsgarch = zeros(T1-h,h);
     for t=1:T1-h
         data3 = y(t:T-T1+t);
         lag3 = lagmatrix(data3,1);
         residuals = lstar(data3,lag3,length(data3),1,2);
       
        [estimation, probabilities, ~] = MSgarch(residuals, 2, 'NORMAL' ,[]);
         Hg = estimation.HH;
         predict = probabilities.predict;
         parameters1 = estimation.garch;
         parameters2 = estimation.transM;
         forecasts =MSforecasts(Hg,predict,parameters1,parameters2,k,s);
         forecastmsgarch(t,:) = forecasts;      
     end
    xlswrite('Eforecasts_msgarch_rev.xls',forecastmsgarch,3,'A1'); 

%TAS
     y = data(:,4);
     T = length(y);
     T1 = length(1402:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     forecastmsgarch = zeros(T1-h,h);
     for t=1:T1-h
         data4 = y(t:T-T1+t);
         lag4 = lagmatrix(data4,1);
         residuals = lstar(data4,lag4,length(data4),1,2);
 
        [estimation, probabilities, ~] = MSgarch(residuals, 2, 'NORMAL' ,[]);
         Hg = estimation.HH;
         predict = probabilities.predict;
         parameters1 = estimation.garch;
         parameters2 = estimation.transM;
         forecasts =MSforecasts(Hg,predict,parameters1,parameters2,k,s);
         forecastmsgarch(t,:) = forecasts;  
       
     end
    xlswrite('Eforecasts_msgarch_rev.xls',forecastmsgarch,4,'A1'); 

%VIC
     y = data(:,5);
     T = length(y);
     T1 = length(1574:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     forecastmsgarch = zeros(T1-h,h);
     for t=1:T1-h
         data5 = y(t:T-T1+t);
         lag5 = lagmatrix(data5,1);
         residuals = lstar(data5,lag5,length(data5),1,2);

        [estimation, probabilities, ~] = MSgarch(residuals, 2, 'NORMAL' ,[]);
         Hg = estimation.HH;
         predict = probabilities.predict;
         parameters1 = estimation.garch;
         parameters2 = estimation.transM;
         forecasts =MSforecasts(Hg,predict,parameters1,parameters2,k,s);
         forecastmsgarch(t,:) = forecasts; 
               
     end
    xlswrite('Eforecasts_msgarch_rev.xls',forecastmsgarch,5,'A1');    
    
 