function p_hat = pestimation(y,s,T,pmax,k,IC)

% y:    dependent variable
% s:    transition variable
% T:    number of observations
% pmax: maximum AR order
% k:    order of the polynominal expansion
% IC:   ic to be used (AIC=1,BIC=2)

% This program uses a polynomial expansion of the nonlinear function to
% determine the AR order in the nonlinear ARFIMA model

d_linear = 0.3;

ybar = mean(y);
y = y - ybar;

if isempty(s)==0
    s = s(pmax+1:end);
end

options = optimset('Display','off','GradObj','off','MaxFunEvals',1e10,...
        'MaxIter',6000,'TolFun',1e-8,'DerivativeCheck','off',...
        'TolX',1e-8); %'LineSearchType','cubicpoly',

AIC = zeros(pmax,1);
BIC = zeros(pmax,1);
for p=1:pmax
    % linear estimation
    d_linear= fminunc(@(d_linear) msecost(d_linear,y,p,T),d_linear,options);
     
    % construct filtered series
    %v = fracfilter(y,d_linear);
    v = fractint_filter_d(y,d_linear,100);

    % Construct lagged series
    V = zeros(T-pmax,pmax);
    for i=1:pmax
        V(:,i) = v(pmax-i+1:T-i);
    end
    v = v(pmax+1:end);
    
    X = zeros(T-pmax,(k+1)*p);
    X(:,1:p) = V(:,1:p);
    if isempty(s)==0
        for i=1:k
            X(:,i*p+1:(i+1)*p) = V(:,1:p).*repmat((s.^k),1,p);
        end
    end
    beta = pinv(X'*X)*X'*v;
    u    = v-X*beta;
    AIC(p) = log(var(u))+ 2*(1+size(beta,1))/(T-pmax);
    BIC(p) = log(var(u))+ log(T-pmax)*(1+size(beta,1))/(T-pmax);
end

if IC==1
    p_hat = find(AIC==min(AIC));
else
    p_hat = find(BIC==min(BIC));
end
p_hat = p_hat(1);