function L = msecost(d,y,p,T)

% construct filtered series
%v = fracfilter(y,d);
v = fractint_filter_d(y,d,100);

% construct lagged series
V = zeros(T-p,p);
for i=1:p
    V(:,i) = v(p-i+1:T-i);
end
v = v(p+1:end);

phi  = pinv(V'*V)*V'*v;
vhat = V*phi;
u    = v - vhat;

if abs(d)<0.5
    L = sum(u.^2)/T;
else
    L = 100000;
end
