
function forecasts =MSforecasts(Hg,predict,parameters1,parameters2,k,s)

% Conditional variance computation for a MSgarch(k) following Haas & al (2004)
parametersgarch = parameters1;
parameterstransM = parameters2;
omega = parametersgarch(:,1);
alpha = parametersgarch(:,2);
beta = parametersgarch(:,3);
P = parameterstransM;
predict_prob = predict;
H = Hg;

T = size(H,1);
xitst = zeros(s,k);
ffc = zeros(s,k);
fc = zeros(s,1);

xitst(1,:) = P*predict_prob(T,:)';
ffc(1,:) = omega + (H(T,:)').*(alpha + beta);
fc(1,1) = xitst(1,:)*ffc(1,:)';

for jj=2:s
    xitst(jj,:) = P*xitst(jj-1,:)';
    ffc(jj,:) = omega + (ffc(jj-1,:)').*(alpha + beta);
    fc(jj) = xitst(jj,:)*ffc(jj,:)';
end

forecasts = fc;

