function G = calcgrad(V,u,z,s,fX,d,phi,gamma,c,M,p,T)

sigma2_u = var(u);

aux = zeros(T-p-100,1);

dldphi0 = -repmat(u./sigma2_u,1,p).*V(:,1:p);

if M>0
    dldgammam = zeros(T-p,M);
    dldcm     = zeros(T-p,M);
    dldphim   = -repmat((u./sigma2_u),1,p*M).*V(:,p+1:end);
end

for m = 1:M  
    dldgammam(:,m)= -(u./sigma2_u).*(V(:,1:p)*phi(:,m+1)).*fX(:,m).*(1-fX(:,m)).*(s-c(m));
    dldcm(:,m)     = gamma(m)*(u./sigma2_u).*(V(:,1:p)*phi(:,m+1)).*fX(:,m).*(1-fX(:,m));
end

trunc = 100;
for j=1:trunc
    i=0:j-1;
    aux(:,j) = ((((-1)^j)/factorial(j))*sum(1./(d-i))*prod(d-i)).*z(trunc-j+1:T-p-j);
end
dldd = [zeros(trunc,1);sum(aux,2)].*(u./sigma2_u);

if M>0
    G = [dldd dldphi0 dldphim dldgammam dldcm];
else
    G = [dldd dldphi0];
end