function lambda = MSfigarch_weights(parameters,truncLag,k)

%
% Parse parameters
phi = parameters(1:k);
d = parameters(k+1:2*k);
beta = parameters(2*k+1:3*k);


% Recursive weight computation
lambda = zeros(truncLag,k);
delta = zeros(truncLag,k);
lambda(1,:) = (phi - beta + d)';
delta(1,:) = d';
for i=2:truncLag
    delta(i,:) = ((i-1-d')/i).* delta(i-1,:);
    lambda(i,:) = beta'.*lambda(i-1,:) + (delta(i,:) -phi'.*delta(i-1,:));
end