function [LL, LLS, Ht,H, predict_prob, filtered_prob] = MSfigarch_likelihood(parameters, data, k, error_type, ms_type, T, estim_flag)

%LL(count) = MSfigarch_likelihood(startvaltemp(:,count), data, k, error_type, ms_type, T,0);

% Log likelihood for swgarch(k) estimation
%
% USAGE:
%   [LL, LLS, Ht, predict_prob, filtered_prob] = swgarch_likelihood(parameters, data, k, error_type, ms_type, T, estim_flag)
%
% INPUTS:
%   parameters    - A vector of parameters (see swgarch_itransform)
%   data          - Vector of mean zero residuals
%   k             - The number of regimes
%   error_type    - The type of error being assumed, valid types are:
%                     1 if 'NORMAL'
%                     2 if 'STUDENTST' [NOT IMPLEMENTED]
%   ms_type       - 1 for 'GRAY'     [NOT IMPLEMENTED YET]
%                 - 2 for 'KLAASSEN'
%                 - 3 for 'HAAS'
%   T             - Length of data
%   ESTIM_FLAG    - [OPTIONAL] Flag (0 or 1) to indicate if the function
%                   is being used in estimation.  If it is 1, then the parameters are
%                   transformed from unconstrained values to constrained by standard
%                   garch model constraints. If it's 0, the parameters are
%                   nod transformed as usual with fmincon.
%
% OUTPUTS:
%   LL             - Minus 1 times the log likelihood
%   LLS            - Time series of log likelihoods (Also multiplied by -1)
%   HT             - Time series of conditional variances
%   predict_prob   - Time series of the predicted probabilities
%                    computed for the estimation
%   filtered_prob  - Time series of the filtered probabilities
%
% COMMENTS:
%   See also swgarch

%LL = [];

%If for estimation, transform the parameters otherwise they must be parsed
if nargin==7 && estim_flag
    parameters = MSfigarch_itransform(parameters,k,error_type);
end

%Compute the conditional variances and the time series of log likelihoods
truncLag = 1000;
%[Ht,H, predict_prob, filtered_prob, loglik]= MSfigarch_coreNH(data,parameters,k,T,truncLag);
% LL = -ones(1,T-1)*loglik(2:T);
% LLS = -loglik;


switch ms_type
    case 1 
	switch error_type
	    case 1
		[Ht,H, predict_prob,filtered_prob,loglik] = MSfigarch_coreNG(data, parameters,k,T,truncLag);
		LL = -ones(1,T-1)*loglik(2:T);
		LLS = -loglik;
	    case 2

	end
    case 2
        switch error_type
            case 1
                [Ht,H, predict_prob, filtered_prob, loglik]= MSfigarch_coreNK(data,parameters,k,T,truncLag);
                LL = -ones(1,T-1)*loglik(2:T);
                LLS = -loglik;   
            case 2
                            
        end
    case 3
        switch error_type
            case 1
                [Ht,H, predict_prob, filtered_prob, loglik]= MSfigarch_coreNH(data,parameters,k,T,truncLag);
                LL = -ones(1,T-1)*loglik(2:T);
                LLS = -loglik;
            case 2     

        end
end

end

