function [Ht,ht, predict_prob, filtered_prob, loglik] =MSfigarch_coreNH(data,parameters,k,T,truncLag)

% Conditional variance computation for a MSfigarch(k) following Haas & al (2004)
%
% USAGE:
%   [Ht, predict_prob, filtered_prob, loglik] =MSfigarch_coreH(data,parameters,p,q,k,m,T,ms_type)
%
% INPUTS:
%   data          - A column of mean zero data transformed according to F (see COMMENTS)
%   parameters    - (1+p+q) x k + (k x k) by 1 vector of parameters
%   k             - The number of regimes
%   T             - Length of data
%
% OUTPUTS:
%   Ht            - Vector of conditonal varainces, T by 1
%   predict_prob  - Time series of the predicted probabilities (size T x k)
%   filtered_prob - Time series of the filtered probabilities (size T x k)
%   loglik        - Time series of log likelihoods 
%
%
%

omega = parameters(1:k);
MSfigarchWeightParameters = parameters(k+1:4*k);
epsilon2 = [zeros(truncLag,1);data.^2];
%T = size(data,1);
archWeights = MSfigarch_weights(MSfigarchWeightParameters,truncLag,k);
tau = truncLag+1:truncLag+T;
ht = zeros(length(epsilon2),k);
for t = tau;
    ht(t,:) = omega' + (archWeights'*epsilon2(t-1:-1:t-truncLag))';
end
ht = ht(tau,:);



filtered_prob = zeros(T+1,k);
predict_prob = zeros(T,k);
loglik = zeros(T,1);

P = parameters(4*k+1:4*k+(k*k));
P = reshape(P,k,k);    

A = [eye(k)-P;ones(1,k)];
I3 = eye(k+1);
c3 = I3(:,k+1);
pinf = ((A'*A)\A'*c3);
filtered_prob(1:2,:) = repmat(pinf',2,1);
Ht = zeros(T,1);


for t = 2:T,
    LL(1,1:k) = filtered_prob(t,1:k).*normpdf(data(t),0,sqrt(ht(t,1:k)));
    predict_prob(t,:) = LL/sum(LL);
    filtered_prob(t+1,:) = P*predict_prob(t,:)';
    loglik(t,1) = log(LL*ones(k,1));
    Ht(t) = predict_prob(t,:)*ht(t,:)';
end

end