function for_msfiaparch
clear
addpath('./STARFIMA');
k = 2; % Regimes
s = 20; % horizons
truncLag = 1000;

 data = xlsread('elec_bernd_sea.xls',1);
% data extraction
% NSW
     y = data(:,1);
     T = length(y);
     T1 = length(1402:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     
     forecastmsfiaparch = zeros(T1-h,h);
     for t=1:T1-h
         data1 = y(t:T-T1+t);
         lag1 = lagmatrix(data1,1);
         residuals = lstar(data1,lag1,length(data1),1,3);        

        [estimation, probabilities, ~] = MSfigarch(residuals, 2, 'NORMAL' ,[]);
         predict = probabilities.predict;
         parameters1 = estimation.figarch;
         parameters2 = estimation.transM;
         forecasts = MSfiaparchforecasts(predict,parameters1,parameters2,k,s,truncLag,residuals);

         forecastmsfiaparch(t,:) = forecasts;
     end
     
    xlswrite('Eforecasts_msfiaparch_rev.xls',forecastmsfiaparch,1,'A1'); 
      

% QLD
     y = data(:,2);
     T = length(y);
     T1 = length(1508:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     
     forecastmsfiaparch = zeros(T1-h,h);
     for t=1:T1-h
         data2 = y(t:T-T1+t);
         lag2 = lagmatrix(data2,1);
         residuals = lstar(data2,lag2,length(data2),1,2);

        [estimation, probabilities, ~] = MSfigarch(residuals, 2, 'NORMAL' ,[]);
         predict = probabilities.predict;
         parameters1 = estimation.figarch;
         parameters2 = estimation.transM;
         forecasts = MSfiaparchforecasts(predict,parameters1,parameters2,k,s,truncLag,residuals);
         forecastmsfiaparch(t,:) = forecasts;       
     end
    xlswrite('Eforecasts_msfiaparch_rev.xls',forecastmsfiaparch,2,'A1'); 

 % SA

     y = data(:,3);
     T = length(y);
     T1 = length(1503:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     
     forecastmsfiaparch = zeros(T1-h,h);
     for t=1:T1-h
         data3 = y(t:T-T1+t);
         lag3 = lagmatrix(data3,1);
         residuals = lstar(data3,lag3,length(data3),1,2);
       
        [estimation, probabilities, ~] = MSfigarch(residuals, 2, 'NORMAL' ,[]);
         predict = probabilities.predict;
         parameters1 = estimation.garch;
         parameters2 = estimation.transM;
         forecasts = MSfiaparchforecasts(predict,parameters1,parameters2,k,s,truncLag,residuals);
         forecastmsfiaparch(t,:) = forecasts;      
     end
    xlswrite('Eforecasts_msfiaparch_rev.xls',forecastmsfiaparch,3,'A1'); 

%TAS
     y = data(:,4);
     T = length(y);
     T1 = length(1402:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     forecastmsfiaparch = zeros(T1-h,h);
     for t=1:T1-h
         data4 = y(t:T-T1+t);
         lag4 = lagmatrix(data4,1);
         residuals = lstar(data4,lag4,length(data4),1,2);
 
        [estimation, probabilities, ~] = MSfigarch(residuals, 2, 'NORMAL' ,[]);
         predict = probabilities.predict;
         parameters1 = estimation.garch;
         parameters2 = estimation.transM;
         forecasts = MSfiaparchforecasts(predict,parameters1,parameters2,k,s,truncLag,residuals);
         forecastmsfiaparch(t,:) = forecasts;  
       
     end
    xlswrite('Eforecasts_msfiaparch_rev.xls',forecastmsfiaparch,4,'A1'); 

%VIC
     y = data(:,5);
     T = length(y);
     T1 = length(1574:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     forecastmsfiaparch = zeros(T1-h,h);
     for t=1:T1-h
         data5 = y(t:T-T1+t);
         lag5 = lagmatrix(data5,1);
         residuals = lstar(data5,lag5,length(data5),1,2);

        [estimation, probabilities, ~] = MSfigarch(residuals, 2, 'NORMAL' ,[]);
         predict = probabilities.predict;
         parameters1 = estimation.garch;
         parameters2 = estimation.transM;
         forecasts = MSfiaparchforecasts(predict,parameters1,parameters2,k,s,truncLag,residuals);
         forecastmsfiaparch(t,:) = forecasts; 
               
     end
    xlswrite('Eforecasts_msfiaparch_rev.xls',forecastmsfiaparch,5,'A1');    
    
 