function [garch_startval,M,dist_startval,LLf]=MSfiaparch_starting_values(startval,data,k,T,error_type,ms_type,startvalopt)

%[startingvals,nu,lambda,LLs,outputParameters]=figarch_starting_values(startingvals,epsilon,epsilon2,p,q,errorType,truncLag)
% If starting values are user supplied (and thus nonempty), reformats
% as vectors. 
% If not, ask the user a number of starting values he wants
% to try. Then, the function drawn randomnly these vectors of starting
% values and returns the most decent one. 
%
% USAGE:
%   [garch_startval,M,LLf] = swgarch_starting_values(startval,data,k,T,error_type,ms_type)
%
% INPUTS:
%   startval         - A vector of starting values or empty if the user wants them to be random   
%   data             - Vector of mean zero residuals
%   k                - The number of regimes
%   T                - Length of data
%   error_type       - The type of error being assumed, valid types are:
%                        1 if 'NORMAL'
%                        2 if 'STUDENTST' [NOT IMPLEMENTED YET]
%
%   ms_type          - 1 for 'GRAY'     [NOT IMPLEMENTED YET]
%                    - 2 for 'KLAASSEN'
%                    - 3 for 'HAAS'
%  startvalopt       - A vector of two integer The first element has to be equal to 0 or 1, 
%		       the second is a positive interger 
%
% OUTPUTS:
%   garch_startval    - A vector 3 x k by 1 of starting values for the GARCH parameters 
%   M                 - A vecto of k x k starting values for the transition
%                       matrix probabilities
%   LLf               - A vector of log likelihoods 
%

%if startvalopt(1),
%    count = 0;
%    m = startvalopt(2);
%    switch error_type
%        case 1
%            startvaltemp = zeros(4*k + k*k,m);
%        case 2
%            startvaltemp = zeros(4*k + k*k +1,m);
%    end    
%    LL = zeros(m,1);
%    while count ~= m,
% Random simulation of bounding parameters 
% - Omega belong to the interval 0.0001 and 0.2
% - Alpha belong to the interval 0.01 and 0.3
% - Beta belong to the interval 0.4 and 0.9
        %omega = 0.15*rand(k,1);
        %phi = 0.1+0.2*rand(k,1);
        %beta = 0.4 + 0.5*rand(k,1);
        
%        phiRatio = 0.1+0.2*rand(1,k);%[.1 .2];
%        betaRatio = 0.4 + 0.5*rand(1,k);%[.1 .6];
%        d = rand(1,k);%[.2 .8];
%        phi = ((1-d)/2).*phiRatio;
%        beta = (d + phi).*betaRatio;
%        M = rand(k,k);
%        colSums = sum(M,1);
%        normalizingM = repmat(colSums,k,1);
%        M = M./normalizingM;
        
%        param = [phi';d';beta'];
%        lambda = MSfigarch_weights(param, 1000,k);
%        omega = (1-sum(lambda));
% Stationnarity check 
        %x = [omega ; reshape(phi,k,1) ; reshape(d,k,1) ; reshape(beta,k,1) ; reshape(M,k*k,1)];
        %if MSgarch_constr(x,k) < 0
        % If stationary, implement count, if not, do nothing
        
        
%            count = count+1;
%            startvaltemp(:,count) = [omega' ; phi' ; d' ; beta' ; reshape(M,k*k,1)];             
%            LL(count) = MSfigarch_likelihood(startvaltemp(:,count), data, k, error_type, T,0);
        %end       
%    end 
%    [~, index] = min(LL);
%    startval = startvaltemp(:,index);  
%    LLf = min(LL);
%end

%Parse starting values

%garch_startval=startval(1:4*k);
%M = startval(4*k+1:4*k+k*k);
%if error_type == 2,
%   dist_startval = startval((4*k)+(k*k)+1);
%else
%   dist_startval = [];
%end

%end






% If starting values are user supplied (and thus nonempty), reformats
% as vectors. 
% If not, ask the user a number of starting values he wants
% to try. Then, the function drawn randomnly these vectors of starting
% values and returns the most decent one. 
%
% USAGE:
%   [fiaparch_startval,M,LLf] = swgarch_starting_values(startval,data,k,T,error_type,ms_type)
%
% INPUTS:
%   startval         - A vector of starting values or empty if the user wants them to be random   
%   data             - Vector of mean zero residuals
%   k                - The number of regimes
%   T                - Length of data
%   error_type       - The type of error being assumed, valid types are:
%                        1 if 'NORMAL'
%                        2 if 'STUDENTST' [NOT IMPLEMENTED YET]
%
%   ms_type          - 1 for 'GRAY'     [NOT IMPLEMENTED YET]
%                    - 2 for 'KLAASSEN'
%                    - 3 for 'HAAS'
%  startvalopt       - A vector of two integer The first element has to be equal to 0 or 1, 
%		       the second is a positive interger 
%
% OUTPUTS:
%   garch_startval    - A vector 3 x k by 1 of starting values for the GARCH parameters 
%   M                 - A vecto of k x k starting values for the transition
%                       matrix probabilities
%   LLf               - A vector of log likelihoods 
%

%No starting values provided
if startvalopt(1),
    count = 0;
    m = startvalopt(2);
    switch error_type
        case 1
            startvaltemp = zeros(6*k + k*k,m);
        case 2
            startvaltemp = zeros(6*k + k*k +1,m);
    end    
    LL = zeros(m,1);
    while count ~= m,
% Random simulation of bounding parameters 
% - Omega belong to the interval 0.0001 and 0.2
% - Alpha belong to the interval 0.01 and 0.3
% - Beta belong to the interval 0.4 and 0.9

        omega = 0.15*rand(k,1);
        phi = [.2 .25]';%0.01 + 0.6*rand(k,1);
        beta = [.1 .5]';%0.4 + 0.5*rand(k,1);
        d = [.2 .25]'; %0.1 + .9*rand(k,1);
        gamma = -.4 + .9999*rand(k,1);
        delta = [2 2]';%1.001 + 5*rand(k,1); 
        M = rand(k,k);
        colSums = sum(M,1);
        normalizingM = repmat(colSums,k,1);
        M = M./normalizingM;
        if error_type == 2,
            dist_startval = 2+10*rand(1,1);
        else
            dist_startval = [];
        end
% Stationnarity check 
        x = [omega ; reshape(phi,k,1)  ; reshape(d,k,1); reshape(beta,k,1) ; gamma;reshape(delta,k,1) ; reshape(M,k*k,1)];
        if MSfiaparch_constr(x,k) < 0
        % If stationary, implement count, if not, do nothing
            count = count+1;
            startvaltemp(:,count) = [omega ; phi ; d ; beta ; gamma ; delta; reshape(M,k*k,1);dist_startval];             
            LL(count) = MSfiaparch_likelihood(startvaltemp(:,count), data, k, error_type, ms_type, T,0);
        end       
    end 
    [~, index] = min(LL);
    startval = startvaltemp(:,index);  
    LLf = min(LL);
end
%Parse starting values
garch_startval=startval(1:6*k);
M = startval(6*k+1:6*k+k*k);
if error_type == 2,
   dist_startval = startval((6*k)+(k*k)+1);
else
   dist_startval = [];
end

end
