function [k,error_type,ms_type,estim_cons,startvalopt,startval,options] = MSfiaparch_parameters_check(data,k,error_type,ms_type,estim_cons,startvalopt,startvalG,startvalM,startvalDist,options)

% swarch(k) input validation.  Ensures that the input parameters are
% conformable to what is expected.
%
% USAGE:
%   [k,error_type,ms_type,estim_cons,startvalopt,startval,options] = 
%           swgarch_parameters_check(data,k,error_type,ms_type,estim_cons,startvalopt,startvalG,startvalM,options)
%
% INPUTS:
%   See swgarch.
%
% OUTPUTS:
%   See swgarch.
%
% COMMENTS:
%   See also swgarch


%%%%%%%%%%%%%%%
% data
%%%%%%%%%%%%%%%

if size(data,2) > 1 || length(data)==1
    error('data series must be a column vector.')
elseif isempty(data)
    error('data is empty.')
end

%%%%%%%%%%%%%%%
% k
%%%%%%%%%%%%%%%

if (length(k) > 1) || any(k <  1) || isempty(k)
    error('k must be positive scalar.')
end

%%%%%%%%%%%%%%%
% error_type
%%%%%%%%%%%%%%%

if nargin<3
    error_type='NORMAL';
end

if isempty(error_type)
    error_type='NORMAL';
end

if strcmp(error_type,'NORMAL')
    error_type = 1;
elseif strcmp(error_type,'STUDENTST')
    error_type = 2;
else
    error('error_type must be a string and one of: ''NORMAL'', ''STUDENTST''.');
end

%%%%%%%%%%%%%%%
% ms_type
%%%%%%%%%%%%%%%

if nargin<4
    ms_type='HAAS';
end

if isempty(ms_type)
    ms_type='HAAS';
end

if strcmp(ms_type, 'GRAY')
    ms_type = 1;
elseif strcmp(ms_type,'KLAASSEN')
    ms_type = 2;
elseif strcmp(ms_type,'HAAS')
    ms_type = 3;
else
    error('ms_type must be a string and one of: ''HAAS'', ''KLAASSEN''.');
end

%%%%%%%%%%%%%%%
% estim_cons
%%%%%%%%%%%%%%%

if nargin<5
    estim_cons='UNCONS';
end
if isempty(estim_cons)
    estim_cons='UNCONS';
end

if strcmp(estim_cons,'UNCONS')
    estim_cons = 1;
elseif strcmp(estim_cons,'CONS')
    estim_cons = 2;
else
    error('estim_cons must be a string and one of: ''UNCONS'', ''CONS''.');
end


%%%%%%%%%%%%%%%%%
% starting values
%%%%%%%%%%%%%%%%%
if nargin<6
 	startvalopt = {'NO',10};
end
if isempty(startvalopt),
	startvalopt = {'NO',10};
end

if strcmp(startvalopt{1},'YES'),
	startvalopt = [0,0];
else
	startvalopt = [1,startvalopt{2}];
end

% Starting values GARCH parameters

if nargin>6
    if ~isempty(startvalG)
        %Validate starting vals of GARCH parameters       
        if  sum((size(startvalG) == [k 6])) ~= 2
            error(['startvalG must be a matrix ', num2str(k),' x ', num2str(3)]);
        end
        startval = reshape(startvalG,6*k,1);
        omega = startval(1:k);
        phi = startval(k+1:2*k);
        d = startval(2*k+1:3*k);
        beta = startval(3*k+1:4*k);
        gamma = startval(4*k+1:5*k);
        delta = startval(5*k+1:6*k);
    if omega<=0
        error('Omega must be a positive vector in STARTINGVALS.')
    end
    if delta<=0
        error('delta must be a positive vector in STARTINGVALS.')
    end    
    if d<=0 || d>=1
        error('d must be strictly between 0 and 1 in STARTINGVALS.')
    end
    if gamma<=-1 || d>=1
        error('gamma must be strictly between -1 and 1 in STARTINGVALS.')
    end
    if (phi>=((1-d)/2) || phi<=0)
        error('phi must satisfy 0<phi<(1-d)/2 with strict inequalities in STARTINGVALS.')
    end
        if (phi + d - beta)<=0 || beta<=0
            error('beta must satisfy 0<beta<phi + d with strict inequalities in STARTINGVALS.')
        elseif (d - beta)<=0 || beta<=0
            error('beta must satisfy 0<beta< d with strict inequalities in STARTINGVALS.')
        end
    end
else
    startval=[];
end




% Starting values transition matrix

if nargin>7
    if ~isempty(startvalM)
        %Validate starting vals of transition probabilities       
        if  sum((size(startvalM) == [k k])) ~= 2,  
            error(['startvalM must be a matrix ', num2str(k),' x ', num2str(k)]);
        end
        startvalMv = reshape(startvalM,k*k,1);
        if any(startvalMv<=0) || any(startvalMv >= 1)
            error('All single element of M must be strictly greater than zero and below than one');
        end 
            startval = [startval ; startvalMv];  
    end
else
    startval=[];
end

if nargin>8
    if ~isempty(startvalDist) && error_type == 2
        %Validate starting vals of Student parameters       
        if (length(startvalDist) > 1) || any(startvalDist <  1) 
            error('startvalDist = Nu, the student parameters must be positive scalar.')
        end
            startval = [startval ; startvalDist];  
    end
end

if isempty(startval) && (startvalopt(1) == 0),
	startvalopt = [1,10];
	fprintf('The starting values option and the starting values are not coherent. The estimation continues with random starting values.');
end



if nargin>9 &&	~isempty(options)
   try
        	optimset(options);
    	catch
        	error('options is not a valid minimization option structure');
   end
elseif estim_cons == 1,
    options  =  optimset('fminunc');
    options  =  optimset(options , 'TolFun'      , 1e-005);
    options  =  optimset(options , 'TolX'        , 1e-005);
    options  =  optimset(options , 'Display'     , 'iter');
    options  =  optimset(options , 'Diagnostics' , 'on');
    options  =  optimset(options , 'LargeScale'  , 'off');
    options  =  optimset(options , 'MaxFunEvals' , 3000);
else
    options  =  optimset('fmincon');
    options  =  optimset(options , 'Algorithm ','interior-point');
    options  =  optimset(options, 'Hessian','lbfgs');
    options  =  optimset(options , 'TolFun'      , 1e-008);
    options  =  optimset(options , 'TolX'        , 1e-008);
    options  =  optimset(options , 'TolCon'      , 1e-008);
    options  =  optimset(options , 'Display'     , 'iter');
    options  =  optimset(options , 'Diagnostics' , 'on');
    options  =  optimset(options , 'LargeScale'  , 'off');
    options  =  optimset(options , 'MaxIter'     , 1000);
    options  =  optimset(options , 'Jacobian'     ,'off');
    options  =  optimset(options , 'MeritFunction'     ,'multiobj');
    options  =  optimset(options , 'MaxFunEvals' , 3000);
end




