function [LL, LLS, Ht,H, predict_prob, filtered_prob] = MSfiaparch_likelihood(parameters, data, k, error_type, ms_type, T, estim_flag)

%LL(count) = MSfigarch_likelihood(startvaltemp(:,count), data, k, error_type, ms_type, T,0);

% Log likelihood for swgarch(k) estimation
%
% USAGE:
%   [LL, LLS, Ht, predict_prob, filtered_prob] = swgarch_likelihood(parameters, data, k, error_type, ms_type, T, estim_flag)
%
% INPUTS:
%   parameters    - A vector of parameters (see swgarch_itransform)
%   data          - Vector of mean zero residuals
%   k             - The number of regimes
%   error_type    - The type of error being assumed, valid types are:
%                     1 if 'NORMAL'
%                     2 if 'STUDENTST' [NOT IMPLEMENTED]
%   ms_type       - 1 for 'GRAY'     [NOT IMPLEMENTED YET]
%                 - 2 for 'KLAASSEN'
%                 - 3 for 'HAAS'
%   T             - Length of data
%   ESTIM_FLAG    - [OPTIONAL] Flag (0 or 1) to indicate if the function
%                   is being used in estimation.  If it is 1, then the parameters are
%                   transformed from unconstrained values to constrained by standard
%                   garch model constraints. If it's 0, the parameters are
%                   nod transformed as usual with fmincon.
%
% OUTPUTS:
%   LL             - Minus 1 times the log likelihood
%   LLS            - Time series of log likelihoods (Also multiplied by -1)
%   HT             - Time series of conditional variances
%   predict_prob   - Time series of the predicted probabilities
%                    computed for the estimation
%   filtered_prob  - Time series of the filtered probabilities
%

%LL = [];

%If for estimation, transform the parameters otherwise they must be parsed
if nargin==7 && estim_flag
    parameters = MSfiaparch_itransform(parameters,k,error_type,1);
end

%Compute the conditional variances and the time series of log likelihoods
truncLag = 1000;
%[Ht,H, predict_prob, filtered_prob, loglik]= MSfigarch_coreNH(data,parameters,k,T,truncLag);
% LL = -ones(1,T-1)*loglik(2:T);
% LLS = -loglik;





delta = parameters(5*k+1:6*k);
% Local back casting

back_cast_length = max(floor(length(data)^(1/2)),1);
back_cast_weights = .05*(.9.^(0:back_cast_length ));
back_cast_weights = back_cast_weights/sum(back_cast_weights);
back_cast = back_cast_weights*([abs(data(1:back_cast_length+1)).^delta(1)  abs(data(1:back_cast_length+1)).^delta(2)]);
if back_cast==0
    back_cast=[mean(abs(data(1:T)).^delta); mean(abs(data(1:T)).^delta)];
end

%Upper and lower bounds, should be moved out of this function
LB = (cov(data(1:T))/10000).^delta;
UB = (10*max(data.^2)).^delta;


switch ms_type
    case 1 
	switch error_type
	    case 1
		[Ht,H, predict_prob,filtered_prob,loglik] = MSgarch_coreNG(data, parameters,k,T);
		LL = -ones(1,T-1)*loglik(2:T);
		LLS = -loglik;
	    case 2
		nu = parameters(3*k+(k*k)+1);
		c = (gamma((nu+1)*0.5)/gamma(nu*0.5))*pi^(-.5)*((nu-2)^(-.5));
		[Ht,H, predict_prob, filtered_prob, loglik] = MSgarch_coreSTDG(data,parameters,k,T,c);
		LL = -ones(1,T-1)*loglik(2:T);
		LLS = -loglik;
	end
    case 2
        switch error_type
            case 1
                [Ht,H, predict_prob, filtered_prob, loglik]= MSgarch_coreNK(data,parameters,k,T);
                LL = -ones(1,T-1)*loglik(2:T);
                LLS = -loglik;   
            case 2
                nu = parameters(3*k+(k*k) +1);                
                c =  (gamma((nu+1)*0.5)/gamma(nu*0.5))*pi^(-.5)*((nu-2)^(-.5)); 
                [Ht,H, predict_prob, filtered_prob, loglik]= MSgarch_coreSTDK(data,parameters,k,T,c);
                LL = -ones(1,T-1)*loglik(2:T);
                LLS = -loglik;                             
        end
    case 3
        switch error_type
            case 1
                [Ht,H, predict_prob, filtered_prob, loglik]= MSfiaparch_coreNH(data,parameters,k,T,truncLag,back_cast,LB,UB);
                LL = -ones(1,T-1)*loglik(2:T);
                LLS = -loglik;
            case 2     
                nu = parameters(3*k+(k*k) +1);
                c =  (gamma((nu+1)*0.5)/gamma(nu*0.5))*pi^(-.5)*((nu-2)^(-.5)); 
                [Ht,H, predict_prob, filtered_prob, loglik]= MSgarch_coreSTDH(data,parameters,k,T,c);
                LL = -ones(1,T-1)*loglik(2:T);
                LLS = -loglik;
        end
end

end

