function [Ht,ht, predict_prob, filtered_prob, loglik] =MSfiaparch_coreNH(data,parameters,k,T,truncLag,back_cast,LB,UB)

% Conditional variance computation for a MSfiaparch(k) following Haas & al (2004)
%
% USAGE:
%   [Ht, predict_prob, filtered_prob, loglik] =MSfiaparch_coreH(data,parameters,p,q,k,m,T,ms_type)
%
% INPUTS:
%   data          - A column of mean zero data transformed according to F (see COMMENTS)
%   parameters    - (1+p+q) x k + (k x k) by 1 vector of parameters
%   k             - The number of regimes
%   T             - Length of data
%
% OUTPUTS:
%   Ht            - Vector of conditonal varainces, T by 1
%   predict_prob  - Time series of the predicted probabilities (size T x k)
%   filtered_prob - Time series of the filtered probabilities (size T x k)
%   loglik        - Time series of log likelihoods 
%
%
%
epsilonaug = [zeros(truncLag,1);data];

htdelta=zeros(size(epsilonaug,1),k);
ht=zeros(size(epsilonaug,1),k);


omega = parameters(1:k);
MSfiaparchWeightParameters = parameters(k+1:4*k);
gamma = parameters(4*k+1:5*k);
delta = parameters(5*k+1:6*k);

%Set the back casts
htdelta(1:truncLag,:)= [(back_cast(1).*ones(truncLag,1)) (back_cast(2).*ones(truncLag,1))];
ht(1:truncLag,:)=epsilonaug(truncLag+1:length(epsilonaug))'*epsilonaug(truncLag+1:length(epsilonaug))/(length(epsilonaug)-truncLag);
%Recursion Loop
deltainv=2./delta;


archWeights = MSfiaparch_weights(MSfiaparchWeightParameters,truncLag,k);
tau = truncLag+1:truncLag+T;
%ht = zeros(length(epsilonaug),k);
for t = tau;
    htdelta(t,1) = omega(1) + (archWeights(:,1)'*(abs(epsilonaug(t-1:-1:t-truncLag))-gamma(1).*epsilonaug(t-1:-1:t-truncLag)).^(delta(1)));
    htdelta(t,2) = omega(2) + (archWeights(:,2)'*(abs(epsilonaug(t-1:-1:t-truncLag))-gamma(2).*epsilonaug(t-1:-1:t-truncLag)).^(delta(2)));
    if htdelta(t,1)<LB(1) && htdelta(t,2)<LB(2)
       htdelta(t,1)=LB(1);
       htdelta(t,2)=LB(2);
    elseif htdelta(t,1)>UB(1) && htdelta(t,2)>UB(2)
        htdelta(t,1)=UB(1);
        htdelta(t,2)=UB(2);
    end
    ht(t,1)=htdelta(t,1).^deltainv(1);
    ht(t,2)=htdelta(t,2).^deltainv(2);
end
ht = ht(tau,:);






filtered_prob = zeros(T+1,k);
predict_prob = zeros(T,k);
loglik = zeros(T,1);

P = parameters(6*k+1:6*k+(k*k));
P = reshape(P,k,k);    

A = [eye(k)-P;ones(1,k)];
I3 = eye(k+1);
c3 = I3(:,k+1);
pinf = ((A'*A)\A'*c3);
filtered_prob(1:2,:) = repmat(pinf',2,1);
Ht = zeros(T,1);


for t = 2:T,
    LL(1,1:k) = filtered_prob(t,1:k).*normpdf(data(t),0,sqrt(ht(t,1:k)));
    predict_prob(t,:) = LL/sum(LL);
    filtered_prob(t+1,:) = P*predict_prob(t,:)';
    loglik(t,1) = log(LL*ones(k,1));
    Ht(t) = predict_prob(t,:)*ht(t,:)';
end

end