 function [tailindex] = tailtest(ret)
 % Initialize output variables
 
 nobs = length(ret);

 tests = length(ret)/nobs; %# estimates to be produced
 alpha.p025 = zeros(tests,1); %tail index with 2.5% threshold
 alpha.p05 = zeros(tests,1); %tail index with 5% threshold
 alpha.p10 = zeros(tests,1); %tail index with 10% threshold


 % Start loop over number of Hill estimates to be produced

 for test = 1:tests
 % Select absolute return window from return series
 data = abs(ret((test-1)*nobs+1:test*nobs)); %(NOBS*1)

 % Calculate tail index estimates (see code in HILLPLOT)
 ordered = flipud(sort(data)); %(NOBS*1) upper order stat.
 ordered = ordered(ordered>0); %restrict to strictly pos.
 n = length(ordered); %length of restricted data
 loggs = log(ordered); %(N*1) logarithms of above
 avesumlog = cumsum(loggs)./(1:n)'; %(N*1) avg.logs
 diffs = avesumlog-loggs; %(N*1) xi-estimates
 diffs = [NaN; diffs(2:n)]; %replace 0 with NaN
 hill = 1./diffs; %(N*1) Hill estimates

 % Read out relevant thresholds
 alpha.p025(test) = hill(floor(0.025*n)); %2.5% thresh.
 alpha.p05(test) = hill(floor(0.05*n)); %5% thresh.
 alpha.p10(test) = hill(floor(0.1*n)); %10% thresh.

 end %End of loop over number of Hill estimates to be produced


 % Generate summary matrix
 alphamat = [alpha.p025 alpha.p05 alpha.p10]; %(tests*3)
 
 tailindex = alphamat(2);
 
 