function seasonality
A = importdata('elec_bernd.xls');
Date = A.textdata.returns;
NSW = A.data.returns(:,1);
QLD = A.data.returns(:,2);
SA = A.data.returns(:,3);
TAS = A.data.returns(:,4);
VIC = A.data.returns(:,5);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

datenumber = zeros(3776,1);
for i = 1:3776
    dd = Date(i);
    datenumber(i)= datenum(char(dd),'dd-mmm-yyyy HH:MM:SS');
end

PriceTimes = yearfrac(datenumber(1), datenumber);

% Calibrate parameters for the seasonality model
seasonMatrix = @(t) [sin(2.*pi.*t) cos(2.*pi.*t) sin(4.*pi.*t) ...
    cos(4.*pi.*t) t ones(size(t, 1), 1)];
C = seasonMatrix(PriceTimes);

seasonParam1 = C\NSW;
seasonParam2 = C\QLD;
seasonParam3 = C\SA;
seasonParam4 = C\TAS;
seasonParam5 = C\VIC;

X1 = NSW-C*seasonParam1;
X2 = QLD-C*seasonParam2;
X3 = SA-C*seasonParam3;
X4 = TAS-C*seasonParam4;
X5 = VIC-C*seasonParam5;

dataseaso = [X1 X2 X3 X4 X5];

xlswrite('elec_bernd_sea.xls',dataseaso,1,'A1'); 

