
function multifractalplot
data = xlsread('elec_bernd_sea.xls',1);

%%% NSW
multifractal1 = data(:,1);

%%% QLD
multifractal2 = data(:,2);

%%% SA
multifractal3 = data(:,3);

%%% TAS
multifractal4 = data(:,4);

%%% VIC
multifractal5 = data(:,5);

X1=cumsum(multifractal1-mean(multifractal1));
X2=cumsum(multifractal2-mean(multifractal2));
X3=cumsum(multifractal3-mean(multifractal3));
X4=cumsum(multifractal4-mean(multifractal4));
X5=cumsum(multifractal5-mean(multifractal5));

X1=transpose(X1);
X2=transpose(X2);
X3=transpose(X3);
X4=transpose(X4);
X5=transpose(X5);

scmin=16;
scmax=256;
scres=19;
exponents=linspace(log2(scmin),log2(scmax),scres);
scale1=round(2.^exponents);
q1=linspace(-5,5,101);
qindex=[21,41,61,81];
m1=1;
for ns=1:length(scale1),
    segments1(ns)=floor(length(X1)/scale1(ns));
    for v=1:segments1(ns),
        Index1=((((v-1)*scale1(ns))+1):(v*scale1(ns)));
        C1=polyfit(Index1,X1(Index1),m1);
        C2=polyfit(Index1,X2(Index1),m1);
        C3=polyfit(Index1,X3(Index1),m1);
        C4=polyfit(Index1,X4(Index1),m1);
        C5=polyfit(Index1,X5(Index1),m1);
        
        fit1=polyval(C1,Index1);
        fit2=polyval(C2,Index1);
        fit3=polyval(C3,Index1);
        fit4=polyval(C4,Index1);
        fit5=polyval(C5,Index1);
        
        RMS_scale1{ns}(v)=sqrt(mean((X1(Index1)-fit1).^2));
        RMS_scale2{ns}(v)=sqrt(mean((X2(Index1)-fit2).^2));
        RMS_scale3{ns}(v)=sqrt(mean((X3(Index1)-fit3).^2));
        RMS_scale4{ns}(v)=sqrt(mean((X4(Index1)-fit4).^2));
        RMS_scale5{ns}(v)=sqrt(mean((X5(Index1)-fit5).^2));
    end
    for nq=1:length(q1),
        qRMS1{ns}=RMS_scale1{ns}.^q1(nq);
        qRMS2{ns}=RMS_scale2{ns}.^q1(nq);
        qRMS3{ns}=RMS_scale3{ns}.^q1(nq);
        qRMS4{ns}=RMS_scale4{ns}.^q1(nq);
        qRMS5{ns}=RMS_scale5{ns}.^q1(nq);
        
        Fq1(nq,ns)=mean(qRMS1{ns}).^(1/q1(nq));
        Fq2(nq,ns)=mean(qRMS2{ns}).^(1/q1(nq));
        Fq3(nq,ns)=mean(qRMS3{ns}).^(1/q1(nq));
        Fq4(nq,ns)=mean(qRMS4{ns}).^(1/q1(nq));
        Fq5(nq,ns)=mean(qRMS5{ns}).^(1/q1(nq));
    end
end
for nq=1:length(q1),
    Ch1 = polyfit(log2(scale1),log2(Fq1(nq,:)),1);
    Hq1(nq) = Ch1(1);
    RegLine1(nq,1:length(scale1)) = polyval(Ch1,log2(scale1));
    
    Ch2 = polyfit(log2(scale1),log2(Fq2(nq,:)),1);
    Hq2(nq) = Ch2(1);
    RegLine2(nq,1:length(scale1)) = polyval(Ch2,log2(scale1));

    Ch3 = polyfit(log2(scale1),log2(Fq3(nq,:)),1);
    Hq3(nq) = Ch3(1);
    RegLine3(nq,1:length(scale1)) = polyval(Ch3,log2(scale1));
    
    Ch4 = polyfit(log2(scale1),log2(Fq4(nq,:)),1);
    Hq4(nq) = Ch4(1);
    RegLine4(nq,1:length(scale1)) = polyval(Ch4,log2(scale1));
    
    Ch5 = polyfit(log2(scale1),log2(Fq5(nq,:)),1);
    Hq5(nq) = Ch5(1); 
    RegLine5(nq,1:length(scale1)) = polyval(Ch5,log2(scale1));
end
if isempty(find(q1==0, 1))==0,
    qzero=find(q1==0);
    Hq1(qzero)=(Hq1(qzero-1)+Hq1(qzero+1))/2;
    Hq2(qzero)=(Hq2(qzero-1)+Hq2(qzero+1))/2;
    Hq3(qzero)=(Hq3(qzero-1)+Hq3(qzero+1))/2;
    Hq4(qzero)=(Hq4(qzero-1)+Hq4(qzero+1))/2;
    Hq5(qzero)=(Hq5(qzero-1)+Hq5(qzero+1))/2;
end
tq1 = Hq1.*q1-1;
tq2 = Hq2.*q1-1;
tq3 = Hq3.*q1-1;
tq4 = Hq4.*q1-1;
tq5 = Hq5.*q1-1;

hq1 = diff(tq1)./(q1(2)-q1(1));
Dq1 = (q1(1:end-1).*hq1)-tq1(1:end-1); 
hq2 = diff(tq2)./(q1(2)-q1(1));
Dq2 = (q1(1:end-1).*hq2)-tq2(1:end-1); 
hq3 = diff(tq3)./(q1(2)-q1(1));
Dq3 = (q1(1:end-1).*hq3)-tq3(1:end-1); 
hq4 = diff(tq4)./(q1(2)-q1(1));
Dq4 = (q1(1:end-1).*hq4)-tq4(1:end-1);
hq5 = diff(tq5)./(q1(2)-q1(1));
Dq5 = (q1(1:end-1).*hq5)-tq5(1:end-1); 

subplot(3,2,1), h1 = plot(hq1,Dq1);
set(h1,'linewidth',1.2);
ylabel('f(alpha)');
xlabel('alpha');
title('New South Wales')
%axis tight

subplot(3,2,2), h2 = plot(hq2,Dq2);
set(h2,'linewidth',1.2);
ylabel('f(alpha)');
xlabel('alpha');
title('Queensland')
%axis tight
subplot(3,2,3), h3 = plot(hq3,Dq3);
set(h3,'linewidth',1.2);
ylabel('f(alpha)');
xlabel('alpha');
title('South Australia')
%axis tight
subplot(3,2,4), h4 = plot(hq4,Dq4);
set(h4,'linewidth',1.2);
%ylabel('D(q)');
%xlabel('h(q)');
ylabel('f(alpha)');
xlabel('alpha');
title('Tasmania')
%axis tight
subplot(3,2,5), h5 = plot(hq5,Dq5);
set(h5,'linewidth',1.2);
ylabel('f(alpha)');
xlabel('alpha');
title('Victoria')

NSW_data = [hq1' Dq1'];
Quee_data = [hq2' Dq2'];
SA_data = [hq3' Dq3'];
Tas_data = [hq4' Dq4'];
Vic_data = [hq5' Dq5'];
xlswrite('multi_arc_data.xls',NSW_data,1);
xlswrite('multi_arc_data.xls',Quee_data,2);
xlswrite('multi_arc_data.xls',SA_data,3);
xlswrite('multi_arc_data.xls',Tas_data,4);
xlswrite('multi_arc_data.xls',Vic_data,5);
%axis tight

saveas(gcf,'fig11.eps')
saveas(gcf,'fig11.jpeg')

figure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% second figure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%%%%%%%%%%%%%


X2=q1;
YMatrix6=[Hq1;Hq2;Hq3;Hq4;Hq5];


pplot4 = plot(X2,YMatrix6,'LineWidth',2);
set(pplot4(1),'Color',[0 0 1],'DisplayName','New South Wales');
set(pplot4(2),'Color',[1 0 0],'DisplayName','Queensland');
set(pplot4(3),'Color',[0 0.749 0.749],'DisplayName','South Australia');
set(pplot4(3),'Color',[0 0 0.749],'DisplayName','Tasmania');
set(pplot4(3),'Color',[0 1 0],'DisplayName','Victoria');



% Create xlabel
xlabel('q-order','FontSize',13);

% Create ylabel
ylabel('H(q)','FontSize',13);

% Create legend
legend('New South Wales','Queensland','South Australia','Tasmania','Victoria','Location','bestoutside');

saveas(gcf,'fig22.jpeg')

