function insample_elect
warning off
%electricity returns - We load the returns
data = xlsread('elec_bernd_sea.xls',1);
dataa = xlsread('elec_bernd_sea.xls',2);
% State NSW
data1 = data(:,1);
dataa1 = dataa(:,1);
% State QLD
data2 = data(:,2);
dataa2 = dataa(:,2);
% State SA
data3 = data(:,3);
dataa3 = dataa(:,3);
% State TAS
data4 = data(:,4);
dataa4 = dataa(:,4);
% State VIC
data5 = data(:,5);
dataa5 = dataa(:,5);


%%% Hurst index for returns
[H1,~] = Hurstdfa(data1);
[H2,~] = Hurstdfa(data2);
[H3,~] = Hurstdfa(data3);
[H4,~] = Hurstdfa(data4);
[H5,~] = Hurstdfa(data5);
H1_rr = [H1;H2;H3;H4;H5];


%%% Hurst index for realized variance
[H1,~] = Hurstdfa(dataa1);
[H2,~] = Hurstdfa(dataa2);
[H3,~] = Hurstdfa(dataa3);
[H4,~] = Hurstdfa(dataa4);
[H5,~] = Hurstdfa(dataa5);
H1_rr = [H1;H2;H3;H4;H5];



%%%% Standard deviations from the structural break
%%NSW
sd_NSW1 = std(data1(1:1401));
sd_NSW2 = std(data1(1402:1514));
sd_NSW3 = std(data1(1515:3776));


%%QLD
sd_QLD1 = std(data2(1:1507));
sd_QLD2 = std(data2(1508:3239));
sd_QLD3 = std(data2(3240:3366));
sd_QLD4 = std(data2(3367:3679));
sd_QLD5 = std(data2(3680:3740));
sd_QLD6 = std(data2(3741:3776));

%%SA
sd_SA1 = std(data3(1:1502));
sd_SA2 = std(data3(1503:3776));

%%TAS
sd_TAS1 = std(data4(1:1401));
sd_TAS2 = std(data4(1402:1514));
sd_TAS3 = std(data4(1515:3776));

%%VIC
sd_VIC1 = std(data5(1:1573));
sd_VIC2 = std(data5(1574:3776));



T_r = [length(data1); length(data2);length(data3);length(data4);length(data5)];
Min_r = [min(data1); min(data2);min(data3);min(data4);min(data5)];
Max_r = [max(data1); max(data2);max(data3);max(data4);max(data5)];
mean_r = [mean(data1); mean(data2);mean(data3);mean(data4);mean(data5)];
std_r = [std(data1); std(data2);std(data3);std(data4);std(data5)];
sk_r = [skewness(data1); skewness(data2);skewness(data3);skewness(data4);skewness(data5)];
ku_r = [kurtosis(data1); kurtosis(data2);kurtosis(data3);kurtosis(data4);kurtosis(data5)];



%%% Hurst index
[H1,~] = Hurstdfa(data1);
[H2,~] = Hurstdfa(data2);
[H3,~] = Hurstdfa(data3);
[H4,~] = Hurstdfa(data4);
[H5,~] = Hurstdfa(data5);

H1_r = [H1;H2;H3;H4;H5];

[H11,~] = Hurstdfa(data1.^2);
[H21,~] = Hurstdfa(data2.^2);
[H31,~] = Hurstdfa(data3.^2);
[H41,~] = Hurstdfa(data4.^2);
[H51,~] = Hurstdfa(data5.^2);
H2_r = [H11;H21;H31;H41;H51];



%%% Tail index
tailindex1 = tailtest(data1);
tailindex2 = tailtest(data2);
tailindex3 = tailtest(data3);
tailindex4 = tailtest(data4);
tailindex5 = tailtest(data5);
tailindex_r = [tailindex1;tailindex2;tailindex3;tailindex4;tailindex5];



%%% ADF test for unit root
[~,pValue1,stat1,~,~] = adftest(data1);
[~,pValue2,stat2,~,~] = adftest(data2);
[~,pValue3,stat3,~,~] = adftest(data3);
[~,pValue4,stat4,~,~] = adftest(data4);
[~,pValue5,stat5,~,~] = adftest(data5);
statadf_r = [stat1;stat2;stat3;stat4;stat5];
pValue_adf = [pValue1;pValue2;pValue3;pValue4;pValue5];



%%% Jarque Bera test for normality
[~,p1,jbstat1,~] = jbtest(data1);
[~,p2,jbstat2,~] = jbtest(data2);
[~,p3,jbstat3,~] = jbtest(data3);
[~,p4,jbstat4,~] = jbtest(data4);
[~,p5,jbstat5,~] = jbtest(data5);

statjb_r = [jbstat1;jbstat2;jbstat3;jbstat4;jbstat5];
pValue_jb = [p1;p2;p3;p4;p5];



%%% Test for no autocorrelation
[~,pValue1,stat1] = lbqtest(data1,'Lags',8);
[~,pValue2,stat2] = lbqtest(data2,'Lags',8);
[~,pValue3,stat3] = lbqtest(data3,'Lags',8);
[~,pValue4,stat4] = lbqtest(data4,'Lags',8);
[~,pValue5,stat5] = lbqtest(data5,'Lags',8);


q_test =[stat1 stat2 stat3 stat4 stat5 ;pValue1 pValue2 pValue3 pValue4 pValue5];


%%% Engle's test for heteroscedasticity
[~,pValues1,sstat1,~] = archtest(data1);
[~,pValues2,sstat2,~] = archtest(data2);
[~,pValues3,sstat3,~] = archtest(data3);
[~,pValues4,sstat4,~] = archtest(data4);
[~,pValues5,sstat5,~] = archtest(data5);

arch_test =[sstat1 sstat2 sstat3 sstat4 sstat5 ;pValues1 pValues2 pValues3 pValues4 pValues5];


%%%%%%%%%%%%%%%%%%%%% End