function y=for_aparch
clear
addpath('./STARFIMA');
 data = xlsread('elec_bernd_sea.xls',1);
% data extraction
% NSW
     y = data(:,1); 
     T = length(y);
     T1 = length(1402:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     
     forecast_ap = zeros(T1-h,h);
     for t=1:T1-h
         data1 = y(t:T-T1+t);
         lag1 = lagmatrix(data1,1);
         resid = lstar(data1,lag1,length(data1),1,3);


    n = length(resid);
   [parameters, ~, ht, ~, ~, ~, ~] = aparch(resid, 1, 1, 1, 'NORMAL');
   
   parap = parameters';

   % forecast horizons
   result = zeros(h,1);
   result(1) = (parap(1) + parap(2)*(abs(resid(n)) - parap(3)*resid(n))^(parap(5)) + parap(4)*(sqrt(ht(n)))^(parap(5)))^(2/parap(5)); % volatility forecast for 1-month horizon
   resultt(1) = (parap(1) + parap(2)*(abs(resid(n)) - parap(3)*resid(n))^(parap(5)) + parap(4)*(sqrt(ht(n)))^(parap(5)));
   ct = (1/sqrt(2*pi))*parap(2)*((1+parap(3))^(parap(5))+(1-parap(3))^(parap(5)))*(2^((parap(5)-1)/2))*gamma((parap(5)+1)/2);
   sig = (parap(1)/(1- ct- parap(4)));

% volatility forecasts for 2 days .... horizon 
 for j=2:h
	 result(j,1) = (sig + ((ct + parap(4))^(j-1)).*(resultt(1) - sig))^(2/parap(5));
 end;

  forecast_ap(t,:) = result';
     end

    xlswrite('Eforecasts_aparch_rev.xls',forecast_ap,1,'A1'); 

% QLD
     y = data(:,2);   
     T = length(y);
     T1 = length(1508:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     forecast_ap = zeros(T1-h,h);
     for t=1:T1-h
         data2 = y(t:T-T1+t);
         lag2 = lagmatrix(data2,1);
         resid = lstar(data2,lag2,length(data2),1,2);
         %model = arima(6,0,0);
         %EstMdl = estimate(model,data2);
         %resid = infer(EstMdl,data2);         
    n = length(resid);
   [parameters, ~, ht, ~, ~, ~, ~] = aparch(resid, 1, 1, 1, 'NORMAL');
   
   parap = parameters';

   % forecast horizons
   result = zeros(h,1);
   result(1) = (parap(1) + parap(2)*(abs(resid(n)) - parap(3)*resid(n))^(parap(5)) + parap(4)*(sqrt(ht(n)))^(parap(5)))^(2/parap(5)); % volatility forecast for 1-month horizon
   resultt(1) = (parap(1) + parap(2)*(abs(resid(n)) - parap(3)*resid(n))^(parap(5)) + parap(4)*(sqrt(ht(n)))^(parap(5)));
   ct = (1/sqrt(2*pi))*parap(2)*((1+parap(3))^(parap(5))+(1-parap(3))^(parap(5)))*(2^((parap(5)-1)/2))*gamma((parap(5)+1)/2);
   sig = (parap(1)/(1- ct- parap(4)));

% volatility forecasts for 2 days .... horizon 
 for j=2:h
	 result(j,1) = (sig + ((ct + parap(4))^(j-1)).*(resultt(1) - sig))^(2/parap(5));
 end;

  forecast_ap(t,:) = result';
     end
    xlswrite('Eforecasts_aparch_rev.xls',forecast_ap,2,'A1'); 

 % SA

     y = data(:,3);
     
     T = length(y);
     T1 = length(1503:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     forecast_ap = zeros(T1-h,h);
     for t=1:T1-h
         data3 = y(t:T-T1+t);
         lag3 = lagmatrix(data3,1);
         resid = lstar(data3,lag3,length(data3),1,2);
        
    n = length(resid);
   [parameters, ~, ht, ~, ~, ~, ~] = aparch(resid, 1, 1, 1, 'NORMAL');
   
   parap = parameters';

   % forecast horizons
   result = zeros(h,1);
   result(1) = (parap(1) + parap(2)*(abs(resid(n)) - parap(3)*resid(n))^(parap(5)) + parap(4)*(sqrt(ht(n)))^(parap(5)))^(2/parap(5)); % volatility forecast for 1-month horizon
   resultt(1) = (parap(1) + parap(2)*(abs(resid(n)) - parap(3)*resid(n))^(parap(5)) + parap(4)*(sqrt(ht(n)))^(parap(5)));
   ct = (1/sqrt(2*pi))*parap(2)*((1+parap(3))^(parap(5))+(1-parap(3))^(parap(5)))*(2^((parap(5)-1)/2))*gamma((parap(5)+1)/2);
   sig = (parap(1)/(1- ct- parap(4)));

% volatility forecasts for 2 month .... horizon 
 for j=2:h
	 result(j,1) = (sig + ((ct + parap(4))^(j-1)).*(resultt(1) - sig))^(2/parap(5));
 end;

  forecast_ap(t,:) = result';
     end
    xlswrite('Eforecasts_aparch_rev.xls',forecast_ap,3,'A1'); 

%TAS
     y = data(:,4);
     T = length(y);
     T1 = length(1402:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     forecast_ap = zeros(T1-h,h);
     for t=1:T1-h
         data4 = y(t:T-T1+t);
         lag4 = lagmatrix(data4,1);
         resid = lstar(data4,lag4,length(data4),1,2);
        
    n = length(resid);
   [parameters, ~, ht, ~, ~, ~, ~] = aparch(resid, 1, 1, 1, 'NORMAL');
   
   parap = parameters';

   % forecast horizons
   result = zeros(h,1);
   result(1) = (parap(1) + parap(2)*(abs(resid(n)) - parap(3)*resid(n))^(parap(5)) + parap(4)*(sqrt(ht(n)))^(parap(5)))^(2/parap(5)); % volatility forecast for 1-month horizon
   resultt(1) = (parap(1) + parap(2)*(abs(resid(n)) - parap(3)*resid(n))^(parap(5)) + parap(4)*(sqrt(ht(n)))^(parap(5)));
   ct = (1/sqrt(2*pi))*parap(2)*((1+parap(3))^(parap(5))+(1-parap(3))^(parap(5)))*(2^((parap(5)-1)/2))*gamma((parap(5)+1)/2);
   sig = (parap(1)/(1- ct- parap(4)));

% volatility forecasts for 2 days .... horizon 
 for j=2:h
	 result(j,1) = (sig + ((ct + parap(4))^(j-1)).*(resultt(1) - sig))^(2/parap(5));
 end;

  forecast_ap(t,:) = result';
     end
    xlswrite('Eforecasts_aparch_rev.xls',forecast_ap,4,'A1'); 

%VIC
     y = data(:,5);
     T = length(y);
     T1 = length(1574:T); % out-of-sample size
     h = 20; % forecasting horizons 20 days
     forecast_ap = zeros(T1-h,h);
     for t=1:T1-h
         data5 = y(t:T-T1+t);
         lag5 = lagmatrix(data5,1);
         resid = lstar(data5,lag5,length(data5),1,2);
        
    n = length(resid);
   [parameters, ~, ht, ~, ~, ~, ~] = aparch(resid, 1, 1, 1, 'NORMAL');
   
   parap = parameters';

   % forecast horizons
   result = zeros(h,1);
   result(1) = (parap(1) + parap(2)*(abs(resid(n)) - parap(3)*resid(n))^(parap(5)) + parap(4)*(sqrt(ht(n)))^(parap(5)))^(2/parap(5)); % volatility forecast for 1-month horizon
   resultt(1) = (parap(1) + parap(2)*(abs(resid(n)) - parap(3)*resid(n))^(parap(5)) + parap(4)*(sqrt(ht(n)))^(parap(5)));
   ct = (1/sqrt(2*pi))*parap(2)*((1+parap(3))^(parap(5))+(1-parap(3))^(parap(5)))*(2^((parap(5)-1)/2))*gamma((parap(5)+1)/2);
   sig = (parap(1)/(1- ct- parap(4)));

% volatility forecasts for 2 month .... horizon 
 for j=2:h
	 result(j,1) = (sig + ((ct + parap(4))^(j-1)).*(resultt(1) - sig))^(2/parap(5));
 end;

  forecast_ap(t,:) = result';
     end
    xlswrite('Eforecasts_aparch_rev.xls',forecast_ap,5,'A1'); 

