************************************************************************
//This program estimates the pooled quantile regressions reported in:
//E. Martínez-García. 2018. 
//“Modeling Time-Variation Over the Business Cycle (1960-2017): An International Perspective.” 
//
//For any questions/comments, contact the authors at:
//
//Enrique Martínez-García (Federal Reserve Bank of Dallas and SMU): emg.economics@gmail.com
************************************************************************


* 1. House-keeping
set more off
clear
set scheme s1color 

* 2. Import data
*local path "C:\filepath\filedir"  //set your own local path
local path "D:\RESEARCH\2017.INTERNATIONAL.BUSINESS.CYCLES\Submission.Draft.(Globalization)_vFINAL\FINAL_CODE.DATA\Table3_Figure6"  //set your own local path
cd "`path'"
import excel Table3_Figure5-6.xls, sheet("RegressionData") firstrow

*define the median and interquartile (iqr) range of the variables
tabstat RealGDPGrowthVolatility, s(median) by(Dateid)
egen RealGDPGrowthVolatilityMedian=median(RealGDPGrowthVolatility), by(Dateid)
tabstat RealGDPGrowthVolatility, s(iqr) by(Dateid)
egen RealGDPGrowthVolatilityIQR=iqr(RealGDPGrowthVolatility), by(Dateid)

tabstat GDPDeflatorVolatility, s(median) by(Dateid)
egen GDPDeflatorVolatilityMedian=median(GDPDeflatorVolatility), by(Dateid)
tabstat GDPDeflatorVolatility, s(iqr) by(Dateid)
egen GDPDeflatorVolatilityIQR=iqr(GDPDeflatorVolatility), by(Dateid)

tabstat RealGDPGrowthPersistence, s(median) by(Dateid)
egen RealGDPGrowthPersistenceMedian=median(RealGDPGrowthPersistence), by(Dateid)
tabstat RealGDPGrowthPersistence, s(iqr) by(Dateid)
egen RealGDPGrowthPersistenceIQR=iqr(RealGDPGrowthPersistence), by(Dateid)

tabstat GDPDeflatorPersistence, s(median) by(Dateid)
egen GDPDeflatorPersistenceMedian=median(GDPDeflatorPersistence), by(Dateid)
tabstat GDPDeflatorPersistence, s(iqr) by(Dateid)
egen GDPDeflatorPersistenceIQR=iqr(GDPDeflatorPersistence), by(Dateid)

tabstat ImportShareAdjusted, s(median) by(Dateid)
egen ImportShareAdjustedMedian=median(ImportShareAdjusted), by(Dateid)
tabstat ImportShareAdjusted, s(iqr) by(Dateid)
egen ImportShareAdjustedIQR=iqr(ImportShareAdjusted), by(Dateid)

gen SquaredImportShareAdjustedMedian=ImportShareAdjustedMedian*ImportShareAdjustedMedian/100

* 3. Main model specifications (for the median and the interquartile range)
*reg RealGDPGrowthVolatilityMedian ImportShareAdjustedMedian SquaredImportShareAdjustedMedian ImportShareAdjustedIQR c.ImportShareAdjustedIQR#c.ImportShareAdjustedIQR dummy70s if CountryUS==1, vce(robust)
*reg RealGDPGrowthVolatilityMedian ImportShareAdjustedMedian SquaredImportShareAdjustedMedian ImportShareAdjustedIQR c.ImportShareAdjustedIQR#c.ImportShareAdjustedIQR dummy70s if CountryUS==1, vce(robust)
reg RealGDPGrowthVolatilityMedian ImportShareAdjustedMedian SquaredImportShareAdjustedMedian dummy70s if CountryUS==1, vce(robust)
reg RealGDPGrowthVolatilityIQR ImportShareAdjustedMedian SquaredImportShareAdjustedMedian dummy70s if CountryUS==1, vce(robust)

*reg GDPDeflatorVolatilityMedian ImportShareAdjustedMedian SquaredImportShareAdjustedMedian ImportShareAdjustedIQR c.ImportShareAdjustedIQR#c.ImportShareAdjustedIQR dummy70s if CountryUS==1, vce(robust)
*reg GDPDeflatorVolatilityIQR ImportShareAdjustedMedian SquaredImportShareAdjustedMedian ImportShareAdjustedIQR c.ImportShareAdjustedIQR#c.ImportShareAdjustedIQR dummy70s if CountryUS==1, vce(robust)
reg GDPDeflatorVolatilityMedian ImportShareAdjustedMedian SquaredImportShareAdjustedMedian dummy70s if CountryUS==1, vce(robust)
reg GDPDeflatorVolatilityIQR ImportShareAdjustedMedian SquaredImportShareAdjustedMedian dummy70s if CountryUS==1, vce(robust)

*reg RealGDPGrowthPersistenceMedian ImportShareAdjustedMedian SquaredImportShareAdjustedMedian ImportShareAdjustedIQR c.ImportShareAdjustedIQR#c.ImportShareAdjustedIQR dummy70s if CountryUS==1, vce(robust)
*reg RealGDPGrowthPersistenceIQR ImportShareAdjustedMedian SquaredImportShareAdjustedMedian ImportShareAdjustedIQR c.ImportShareAdjustedIQR#c.ImportShareAdjustedIQR dummy70s if CountryUS==1, vce(robust)
reg RealGDPGrowthPersistenceMedian ImportShareAdjustedMedian SquaredImportShareAdjustedMedian dummy70s if CountryUS==1, vce(robust)
reg RealGDPGrowthPersistenceIQR ImportShareAdjustedMedian SquaredImportShareAdjustedMedian dummy70s if CountryUS==1, vce(robust)

*reg GDPDeflatorPersistenceMedian ImportShareAdjustedMedian SquaredImportShareAdjustedMedian ImportShareAdjustedIQR c.ImportShareAdjustedIQR#c.ImportShareAdjustedIQR dummy70s if CountryUS==1, vce(robust)
*reg GDPDeflatorPersistenceIQR ImportShareAdjustedMedian SquaredImportShareAdjustedMedian ImportShareAdjustedIQR c.ImportShareAdjustedIQR#c.ImportShareAdjustedIQR dummy70s if CountryUS==1, vce(robust)
reg GDPDeflatorPersistenceMedian ImportShareAdjustedMedian SquaredImportShareAdjustedMedian dummy70s if CountryUS==1, vce(robust)
reg GDPDeflatorPersistenceIQR ImportShareAdjustedMedian SquaredImportShareAdjustedMedian dummy70s if CountryUS==1, vce(robust)

* Including 4-quarter lags in the specification as an instrument
gen ImportShareAdjustedMedianLag4=ImportShareAdjustedMedian[_n-4]
gen SqImportShareAdjustedMedianLag4=SquaredImportShareAdjustedMedian[_n-4]
reg RealGDPGrowthVolatilityMedian ImportShareAdjustedMedianLag4 SqImportShareAdjustedMedianLag4 dummy70s if CountryUS==1, vce(robust)
reg RealGDPGrowthVolatilityIQR ImportShareAdjustedMedianLag4 SqImportShareAdjustedMedianLag4 dummy70s if CountryUS==1, vce(robust)
reg GDPDeflatorVolatilityMedian ImportShareAdjustedMedianLag4 SqImportShareAdjustedMedianLag4 dummy70s if CountryUS==1, vce(robust)
reg GDPDeflatorVolatilityIQR ImportShareAdjustedMedianLag4 SqImportShareAdjustedMedianLag4 dummy70s if CountryUS==1, vce(robust)
reg RealGDPGrowthPersistenceMedian ImportShareAdjustedMedianLag4 SqImportShareAdjustedMedianLag4 dummy70s if CountryUS==1, vce(robust)
reg RealGDPGrowthPersistenceIQR ImportShareAdjustedMedianLag4 SqImportShareAdjustedMedianLag4 dummy70s if CountryUS==1, vce(robust)
reg GDPDeflatorPersistenceMedian ImportShareAdjustedMedianLag4 SqImportShareAdjustedMedianLag4 dummy70s if CountryUS==1, vce(robust)
reg GDPDeflatorPersistenceIQR ImportShareAdjustedMedianLag4 SqImportShareAdjustedMedianLag4 dummy70s if CountryUS==1, vce(robust)


* 4. Other model specifications (Quantile Regressions)
* With sqreg we estimate all the effects simultaneously for the median as well as for the upper bound and lower bound of the interquartile range for the dependent variable
* References: https://www.stata.com/manuals13/rqreg.pdf, https://kb.iu.edu/d/arrs

*** The dataset includes country fixed effects, but we can generate time dummies here too:
**tabulate Dateid, gen(dummyDate)

* Real GDP Growth Volatility (Median)
set seed 1001
*sqreg RealGDPGrowthVolatility ImportShareAdjusted SquaredImportShareAdjusted, q(.25 .5 .75) reps(100)
*sqreg RealGDPGrowthVolatility ImportShareAdjusted SquaredImportShareAdjusted Countryid, q(.25 .5 .75) reps(100)
*sqreg RealGDPGrowthVolatility ImportShareAdjusted SquaredImportShareAdjusted CountryUS CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .5 .75) reps(100)
sqreg RealGDPGrowthVolatility ImportShareAdjusted SquaredImportShareAdjusted CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .5 .75) reps(100)
**set matsize 2000
**sqreg RealGDPGrowthVolatility ImportShareAdjusted SquaredImportShareAdjusted dummyDate1 dummyDate2 dummyDate3 dummyDate4 dummyDate5 dummyDate6 dummyDate7 dummyDate8 dummyDate9 dummyDate10 dummyDate11 dummyDate12 dummyDate13 dummyDate14 dummyDate15 dummyDate16 dummyDate17 dummyDate18 dummyDate19 dummyDate20 dummyDate21 dummyDate22 dummyDate23 dummyDate24 dummyDate25 dummyDate26 dummyDate27 dummyDate28 dummyDate29 dummyDate30 dummyDate31 dummyDate32 dummyDate33 dummyDate34 dummyDate35 dummyDate36 dummyDate37 dummyDate38 dummyDate39 dummyDate40 dummyDate41 dummyDate42 dummyDate43 dummyDate44 dummyDate45 dummyDate46 dummyDate47 dummyDate48 dummyDate49 dummyDate50 dummyDate51 dummyDate52 dummyDate53 dummyDate54 dummyDate55 dummyDate56 dummyDate57 dummyDate58 dummyDate59 dummyDate60 dummyDate61 dummyDate62 dummyDate63 dummyDate64 dummyDate65 dummyDate66 dummyDate67 dummyDate68 dummyDate69 dummyDate70 dummyDate71 dummyDate72 dummyDate73 dummyDate74 dummyDate75 dummyDate76 dummyDate77 dummyDate78 dummyDate79 dummyDate80 dummyDate81 dummyDate82 dummyDate83 dummyDate84 dummyDate85 dummyDate86 dummyDate87 dummyDate88 dummyDate89 dummyDate90 dummyDate91 dummyDate92 dummyDate93 dummyDate94 dummyDate95 dummyDate96 dummyDate97 dummyDate98 dummyDate99 dummyDate100 dummyDate101 dummyDate102 dummyDate103 dummyDate104 dummyDate105 dummyDate106 dummyDate107 dummyDate108 dummyDate109 dummyDate110 dummyDate111 dummyDate112 dummyDate113 dummyDate114 dummyDate115 dummyDate116 dummyDate117 dummyDate118 dummyDate119 dummyDate120 dummyDate121 dummyDate122 dummyDate123 dummyDate124 dummyDate125 dummyDate126 dummyDate127 dummyDate128 dummyDate129 dummyDate130 dummyDate131 dummyDate132 dummyDate133 dummyDate134 dummyDate135 dummyDate136 dummyDate137 dummyDate138 dummyDate139 dummyDate140 dummyDate141 dummyDate142 dummyDate143 dummyDate144 dummyDate145 dummyDate146 dummyDate147 dummyDate148 dummyDate149 dummyDate150 dummyDate151 dummyDate152 dummyDate153 dummyDate154 dummyDate155 dummyDate156 dummyDate157 dummyDate158 dummyDate159 dummyDate160 dummyDate161 dummyDate162 dummyDate163 dummyDate164 dummyDate165 dummyDate166 dummyDate167 dummyDate168 dummyDate169 dummyDate170 dummyDate171 dummyDate172 dummyDate173 dummyDate174 dummyDate175 dummyDate176 dummyDate177 dummyDate178 dummyDate179 dummyDate180 dummyDate181 dummyDate182 dummyDate183 dummyDate184 dummyDate185 dummyDate186 dummyDate187 dummyDate188 dummyDate189 dummyDate190 dummyDate191 dummyDate192 dummyDate193 dummyDate194 dummyDate195 dummyDate196 dummyDate197 dummyDate198 dummyDate199 dummyDate200 dummyDate201 dummyDate202 dummyDate203 dummyDate204 dummyDate205 dummyDate206 dummyDate207 dummyDate208 dummyDate209 dummyDate210 dummyDate211 dummyDate212 dummyDate213 dummyDate214 dummyDate215 dummyDate216 dummyDate217 dummyDate218 dummyDate219 dummyDate220 dummyDate221 dummyDate222 dummyDate223 dummyDate224 dummyDate225 dummyDate226 dummyDate227 dummyDate228 dummyDate229 dummyDate230 dummyDate231 dummyDate232, q(.25 .5 .75) reps(100)
*** the sample size is too small to estimate the model with time fixed effects

* Real GDP Growth Volatility (Dispersion through the interquartile range)
set seed 1001
*iqreg RealGDPGrowthVolatility ImportShareAdjusted SquaredImportShareAdjusted, q(.25 .75) reps(100) nolog
*iqreg RealGDPGrowthVolatility ImportShareAdjusted SquaredImportShareAdjusted Countryid, q(.25 .75) reps(100) nolog
*iqreg RealGDPGrowthVolatility ImportShareAdjusted SquaredImportShareAdjusted CountryUS CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .75) reps(100) nolog
iqreg RealGDPGrowthVolatility ImportShareAdjusted SquaredImportShareAdjusted CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .75) reps(100) nolog

* Inflation Volatility (Median)
set seed 1001
*sqreg GDPDeflatorVolatility ImportShareAdjusted SquaredImportShareAdjusted, q(.25 .5 .75) reps(100)
*sqreg GDPDeflatorVolatility ImportShareAdjusted SquaredImportShareAdjusted Countryid, q(.25 .5 .75) reps(100)
*sqreg GDPDeflatorVolatility ImportShareAdjusted SquaredImportShareAdjusted CountryUS CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .5 .75) reps(100)
sqreg GDPDeflatorVolatility ImportShareAdjusted SquaredImportShareAdjusted CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .5 .75) reps(100)
* Inflation Volatility (Dispersion through the interquartile range)
set seed 1001
*iqreg GDPDeflatorVolatility ImportShareAdjusted SquaredImportShareAdjusted, q(.25 .75) reps(100) nolog
*iqreg GDPDeflatorVolatility ImportShareAdjusted SquaredImportShareAdjusted Countryid, q(.25 .75) reps(100) nolog
*iqreg GDPDeflatorVolatility ImportShareAdjusted SquaredImportShareAdjusted CountryUS CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .75) reps(100) nolog
iqreg GDPDeflatorVolatility ImportShareAdjusted SquaredImportShareAdjusted CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .75) reps(100) nolog

* Real GDP Growth Persistence (Median)
set seed 1001
*sqreg RealGDPGrowthPersistence ImportShareAdjusted SquaredImportShareAdjusted, q(.25 .5 .75) reps(100)
*sqreg RealGDPGrowthPersistence ImportShareAdjusted SquaredImportShareAdjusted Countryid, q(.25 .5 .75) reps(100)
*sqreg RealGDPGrowthPersistence ImportShareAdjusted SquaredImportShareAdjusted CountryUS CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .5 .75) reps(100)
sqreg RealGDPGrowthPersistence ImportShareAdjusted SquaredImportShareAdjusted CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .5 .75) reps(100)
* Real GDP Growth Persistance (Dispersion through the interquartile range)
set seed 1001
*iqreg RealGDPGrowthPersistence ImportShareAdjusted SquaredImportShareAdjusted, q(.25 .75) reps(100) nolog
*iqreg RealGDPGrowthPersistence ImportShareAdjusted SquaredImportShareAdjusted Countryid, q(.25 .75) reps(100) nolog
*iqreg RealGDPGrowthPersistence ImportShareAdjusted SquaredImportShareAdjusted CountryUS CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .75) reps(100) nolog
iqreg RealGDPGrowthPersistence ImportShareAdjusted SquaredImportShareAdjusted CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .75) reps(100) nolog

* Inflation Persistence (Median)
set seed 1001
*sqreg GDPDeflatorPersistence ImportShareAdjusted SquaredImportShareAdjusted, q(.25 .5 .75) reps(100)
*sqreg GDPDeflatorPersistence ImportShareAdjusted SquaredImportShareAdjusted Countryid, q(.25 .5 .75) reps(100)
*sqreg GDPDeflatorPersistence ImportShareAdjusted SquaredImportShareAdjusted CountryUS CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .5 .75) reps(100)
sqreg GDPDeflatorPersistence ImportShareAdjusted SquaredImportShareAdjusted CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .5 .75) reps(100)
* Inflation Persistence (Dispersion through the interquartile range)
set seed 1001
*iqreg GDPDeflatorPersistence ImportShareAdjusted SquaredImportShareAdjusted, q(.25 .75) reps(100) nolog
*iqreg GDPDeflatorPersistence ImportShareAdjusted SquaredImportShareAdjusted Countryid, q(.25 .75) reps(100) nolog
*iqreg GDPDeflatorPersistence ImportShareAdjusted SquaredImportShareAdjusted CountryUS CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .75) reps(100) nolog
iqreg GDPDeflatorPersistence ImportShareAdjusted SquaredImportShareAdjusted CountryUK CountryFR CountryDE CountryIT CountryCA CountryJP CountrySP, q(.25 .75) reps(100) nolog

