/*
************************************************************************
** This program estimates the TVP model where the log-volatility follows a random walk 
** whose innovations are a mixture-of-normal distributions:
** Modeling Time-Variation Over the Business Cycle (1960-2017): An International Perspective. 
** E. Martnez-Garca. 2018. 
**
** Adapted by the author from the Gauss codes provided in:
** Stock, James H. and Mark W. Watson (2003): Has the Business Cycle Changed and Why?, in NBER Macroeconomics Annual 
** 2002, Vol. 17, Mark Gertler and Kenneth Rogoff (eds.), MIT Press.
** 
** For any questions/comments on the code, contact the author at:
** 
** Enrique Martnez-Garca (Federal Reserve Bank of Dallas): emg.economics@gmail.com
************************************************************************
*/

/* compute autocovariances for 
   y(t) = phi(1)*y(t-1) + ...+ phi(p)y(t-p) + e(t)
   
   input:
        phi = AR coefficient vector (phi(1)|phi(2)|...|phi(p))
        vare = variance of e
        nacv = number of autocovariances desired
   output:
        acv = nacv+1 x 1 vector with variance and NACV autocovariances
*/

proc(1) = yulewalk(phi,vare,nacv);

local nar, tmp, i, tmp2, f, fi, acv;

nar=rows(phi);
tmp=zeros(nar+1,2*nar+1);
for i (0,nar,1);
 tmp[i+1,nar+2-i:2*nar+1-i]=phi';
endfor;
tmp2=zeros(nar+1,nar+1);
tmp2[.,1]=tmp[.,nar+1];
for i (1,nar,1);
 tmp2[.,1+i] = tmp[.,nar+1-i]+tmp[.,nar+1+i];
endfor;
f=eye(nar+1)-tmp2;
fi=inv(f);
acv=vare*fi[.,1];
if nacv .> nar;
 i = nar; do while i <= nacv;
  tmp=(rev(acv[rows(acv)-nar+1:rows(acv)]))'phi;
  acv=acv|tmp;
 i=i+1; endo;
endif;
acv=acv[1:1+nacv];

retp(acv);
endp;
