/*
************************************************************************
** This program estimates the TVP model where the log-volatility follows a random walk 
** whose innovations are a mixture-of-normal distributions:
** Modeling Time-Variation Over the Business Cycle (1960-2017): An International Perspective. 
** E. Martnez-Garca. 2018. 
**
** Adapted by the author from the Gauss codes provided in:
** Stock, James H. and Mark W. Watson (2003): Has the Business Cycle Changed and Why?, in NBER Macroeconomics Annual 
** 2002, Vol. 17, Mark Gertler and Kenneth Rogoff (eds.), MIT Press.
** 
** For any questions/comments on the code, contact the author at:
** 
** Enrique Martnez-Garca (Federal Reserve Bank of Dallas): emg.economics@gmail.com
************************************************************************
*/

/* udatain.prc
   This proc reads in data from file sy. It eliminates data in y when data is missing.
   Input:
         sy = string with file name for series y
         missc = missing value code
         tobs = total number of obs in series
   Output
          y = series y output
*/

proc(1)=udatain(sy,missc,tobs);
local y, iy, ii;
load y[tobs,1]=^sy;
y=miss(y,missc);    @ -- Convert to GAUSS Missing Value Code -- @
retp(y);
endp;
