#include <oxstd.h>

garchPOS::garchPOS(const s_file_label,i_var_number)
{

	decl data,load_mat,vn,first_obs,last_obs,i_l1,i_l2,i_l3;


	//// loading dataset
	
	load_mat=loadmat(s_file_label~sprint(".xlsx"), &vn);
	
	if (load_mat==0)
	{
		println ("WARNING! failed to open data file ", s_file_label);
	}
	m_s_FLabel=s_file_label~"_"~vn[i_var_number];
	first_obs=load_mat[0][i_var_number];
	last_obs=load_mat[1][i_var_number];
		
	m_sDataLabel=vn[i_var_number]~sprint(last_obs-first_obs);
	m_mData=load_mat[11+first_obs:9+last_obs][i_var_number];

	m_d_Y0=<0>;

	m_iT=sizer(m_mData);

	m_v_SSum=<0,0,0,0,0>';

	m_mAllData=m_d_Y0|m_mData;  
	
	m_d_apha_known=0;
	m_d_ni_known=250;
	m_d_e0_known=0;
	m_d_h0_known=0;
	m_d_ni_max=250;

	m_i_kernel_mode=0;
	
	println("===========  THE DATA  ===========");
	println("Analyzing ", m_sDataLabel);
	println("First modelled observation: ", m_mData[0][]);
	println("Last observation: ", m_mData[m_iT-1][]);
	println("No of modelled observations: ", m_iT);
	println("initial condition y0: ", m_d_Y0);
	println("==================================");	

	m_i_pred_mult=20;
	m_iBasicCycle=250000+2;
	m_iNumCycles=1;
	m_iNRsc=-16665;
	m_d_lim_corr_ht=0.99999;

	m_qmat=<0.005,0.01,0.02,0.03,0.04,0.05,0.06,0.07,0.075,0.08,0.09,0.1,0.15,0.2>;
	m_qmat=m_qmat~(reversec((1-m_qmat)')');
	
	
	m_d_delta_PriorPrec=1;
	m_d_delta_PriorDF=2;
	m_d_alpha0_PriorA=1;
	m_d_alpha0_PriorB=1/200;
	m_d_lambda_PriorPrec=1;
	m_d_lambda_PriorDF=2;
	m_d_ni_PriorA=1;
	m_d_ni_PriorB=1/10;
	m_d_alpha00_PriorPrec=1;
	m_d_alpha00_PriorDF=3;
	m_d_e0_PriorPrec=0.1;
	m_d_e0_PriorDF=2;
	m_d_h0_PriorA=1;
	m_d_h0_PriorB=1/200;
	m_d_gamma_PriorPrec=1;
	m_d_gamma_PriorDF=1;
	
	m_i_e0_mode=0;
	m_i_h0_mode=1; 				
	m_i_GJR_mode=1;				
	m_i_GARCH_mode=1;
	m_i_ni_par=2;				
	m_i_ni_mode=0;				
	m_i_alpha_mode=1;			
	m_i_eta_par=0;				
	m_i_inMean_mode=2;	//2!

	m_i_AR_lags=1;
	m_i_PredHor=5;
	m_b_Pred=0;
	m_b_PredES=1;
	
	m_d_apha_known=0;
	m_d_ni_known=250;
	m_d_e0_known=0;
	m_d_h0_known=1;
	m_d_ni_min=2.001;
	m_d_PhiLTrunc=3*M_PI/15000;
	m_d_PhiRTrunc=0.025;

	m_m_Real_Obs=ones(m_i_PredHor,1)*M_NAN;

	if ((m_i_PredHor>0)&&(sizer(load_mat[][i_var_number])>(9+last_obs)))
	{
		
		if (sizer(load_mat[][i_var_number])>(9+last_obs+m_i_PredHor))
		{
			
			m_m_Real_Obs=load_mat[10+last_obs:9+last_obs+m_i_PredHor][i_var_number];
		}
		else
		{
			m_m_Real_Obs=load_mat[10+last_obs:][i_var_number];
		}

		println(m_m_Real_Obs);
	}

	
	
	m_i_NF=2;
	
	if (m_i_NF>0)
	{
		m_m_Freq_Config=zeros(2,m_i_NF);
		m_m_Freq_Config[0][]=<1,2>;//,1,1>;
		m_m_Freq_Config[1][]=<3,3>;//3,2>;
		m_av_Common_Amplitudes=new array [m_i_NF];
		m_av_Common_Amplitudes[0]=<2>;//,5>;
		m_av_Common_Amplitudes[1]=<4,5>;
//		m_av_Common_Amplitudes[2]=<5>;
//		m_av_Common_Amplitudes[3]=<5>;
		
		m_m_Amplitude_Config=zeros(sumr(m_m_Freq_Config[0][]),m_i_NF);
		m_m_AC=zeros(sumr(m_m_Freq_Config[0][]),4);
		
		m_m_Cycle_Config=zeros(5,sizer(m_m_Amplitude_Config));
		

		i_l3=0;

			
		for (i_l1=0;i_l1<max(m_m_Freq_Config[0][]);i_l1++)
		{

			for (i_l2=0;i_l2<m_i_NF;i_l2++)
			{
				
				if (m_m_Freq_Config[0][i_l2]>i_l1)
				{
					m_m_Amplitude_Config[i_l3][i_l2]=1;
					m_m_Cycle_Config[(m_av_Common_Amplitudes[i_l2])[0][i_l1]-1][i_l3]=1;
					m_m_AC[i_l3][0]=i_l2+1;
					m_m_AC[i_l3][1]=m_m_Freq_Config[1][i_l2];
					
					i_l3++;
				}
			
			}
						
		}

		m_m_scale_amp=<0.15,1.5,1.5,3,3>';
		
		
		m_m_AC[0][3]=m_m_AC[0][1]-1;		

		m_ik1=sizer(m_m_AC);
		
		for (i_l1=1;i_l1<m_ik1;i_l1++)
		{
			m_m_AC[i_l1][2]=m_m_AC[i_l1-1][3]+1;
			m_m_AC[i_l1][3]=m_m_AC[i_l1-1][3]+m_m_AC[i_l1][1];		
		}

		println(m_m_Amplitude_Config);
		println(m_m_Cycle_Config);
		println(m_m_AC);

		m_mXr=new array [m_i_NF];
		
		for (i_l1=0;i_l1<m_i_NF;i_l1++)
		{
			m_mXr[i_l1]=range(0,m_iT+m_i_PredHor,1)';

			for (i_l2=1;i_l2<m_m_AC[i_l1][1];i_l2++)
			{
				m_mXr[i_l1]=m_mXr[i_l1]~range(0,m_iT+m_i_PredHor,1)';
			}

		}
			
	}
	/*
	m_m_Mat_sel=unit(m_iT)[0][];
	i_l2=0;

	for (i_l1=1;i_l1<m_iT;i_l1++)
	{
		if (i_l2==100)
		{
			m_m_Mat_sel=m_m_Mat_sel|(unit(m_iT)[i_l1][]);
			i_l2=0;

		}

		i_l2++;
	}
	m_m_Mat_sel=zeros(sizer(m_m_Mat_sel),1)~m_m_Mat_sel;
	*/
}

garchPOS::posterior_kernel(const vP, const adFunc, const avScore, const amHessian)
{

	decl delta_, rho_, alpha0_, alpha1_, beta1_, alpha2_, lambda1_, eta_, ni10_, ni20_, alpha00_, eps0_,h0_,
		 prior_logKer,logLik,gamma_s_,gamma_c_,phi_,i_obs,mv_amp,b_seas_,c0_,
		 cor_l,cor_s,p_ni1,p_ni2,p_alpha,p_scale,p_loc,p_ht,
		 mT1,mT2,mTPAR,mTPAR_2,mTPAR_3,m_cut_ni,m_z_ni,m_sel,ct_bar,v_exc,
		 c1,c2,c3,n_gam,c_p1,c_p2,c_p3,c_p4,m_Tquant,m_T_a1,m_T_a2,m_T_a3,m_T_a4;

	m_cut_ni=(0.01+m_d_ni_max)*ones(m_iT+m_i_PredHor+1,2);
	mv_amp=<1>;
	v_exc=zeros(1,3);
	mT2=zeros(m_iT+m_i_PredHor+1,5);
	mTPAR=mT2;
	mTPAR_2=zeros(m_iT+m_i_PredHor+1,5);
	mTPAR_3=zeros(m_iT+m_i_PredHor+1,5);
	
	prior_logKer=0;
	logLik=0;
	c1=5;

	
	if (m_i_Est_Mode==0)
	{
	//===============================================

		if (m_i_NF>0)
		{
			m_i_iParBasic_Num=4+m_v_SSum[0]+m_v_SSum[1]+2*m_i_AR_lags+m_i_h0_mode+m_i_GJR_mode+m_i_ni_par+m_i_alpha_mode+m_i_eta_par+(m_i_inMean_mode>0)+sumc(m_m_Freq_Config[1][]')+2*sumc(m_m_Amplitude_Config*m_m_Freq_Config[1][]');
		}
		else
		{
			m_i_iParBasic_Num=4+m_v_SSum[0]+m_v_SSum[1]+2*m_i_AR_lags+m_i_h0_mode+m_i_GJR_mode+m_i_ni_par+m_i_alpha_mode+m_i_eta_par+(m_i_inMean_mode>0);
		}

		m_sel=zeros(4+m_v_SSum[0]+m_v_SSum[1]+2*m_i_AR_lags+m_i_h0_mode+m_i_GJR_mode+m_i_ni_par+m_i_alpha_mode+m_i_eta_par+(m_i_inMean_mode>0),11);
		ct_bar=ones(1,m_v_SSum[0]+m_v_SSum[1]+4+2*m_i_AR_lags)~m_i_GJR_mode~(m_i_inMean_mode>0);

		if (m_i_ni_par==2)
		{
			ct_bar=ct_bar~<1,1>;
		}
		else
		{
			if (m_i_ni_par==1)
			{
				ct_bar=ct_bar~<1,0>;
			}
			else
			{
				ct_bar=ct_bar~<0,0>;
			}

		}

		ct_bar=ct_bar~m_i_alpha_mode~m_i_h0_mode;
		c2=0;
		
		for (c1=0;c1<11;c1++)
		{
			if (ct_bar[0][c1]==1)
			{
			m_sel[c2][c1]=1;
			c2++;
			}

		}

		if (m_i_NF>0)
		{

			for (c1=0;c1<sizer(m_m_Amplitude_Config);c1++)
			{
				for (c2=0;c2<sizec(m_m_Amplitude_Config);c2++)
				{
					if(m_m_Amplitude_Config[c1][c2]==1)
					{
						for(c3=0;c3<5;c3++)
						{
							if (m_m_Cycle_Config[c3][c1]==1)
							{
								mv_amp=mv_amp|(ones(m_m_Freq_Config[1][c2],1)*m_m_scale_amp[c3][0]);

							}
						}
					}				
				}
			}

		mv_amp=mv_amp[1:][];
		mv_amp=mv_amp|mv_amp;

				
		m_m_sPar_Groups=zeros(2+m_i_NF,9);
		m_m_sPar_Groups[0][0]=4+m_v_SSum[0]+m_v_SSum[1]+2*m_i_AR_lags+m_i_h0_mode+m_i_GJR_mode+m_i_ni_par+m_i_alpha_mode+m_i_eta_par+(m_i_inMean_mode>0);
		m_m_sPar_Groups[1][0]=2*sumc(m_m_Amplitude_Config*m_m_Freq_Config[1][]');
		

		m_m_sPar_Groups[0][1]=0;
		m_m_sPar_Groups[1][1]=m_m_sPar_Groups[0][0];


		m_m_sPar_Groups[0][2]=m_m_sPar_Groups[0][0]-1;
		m_m_sPar_Groups[1][2]=m_m_sPar_Groups[0][0]+m_m_sPar_Groups[1][0]-1;

		m_m_sPar_Groups[0][3]=1;
		m_m_sPar_Groups[1][3]=1;

		m_m_sPar_Groups[0][4]=0;
		m_m_sPar_Groups[1][4]=0;

		m_m_sPar_Groups[0][5]=0.002;
		m_m_sPar_Groups[1][5]=0.005;
	
		m_m_sPar_Groups[0][6]=0.005;
		m_m_sPar_Groups[1][6]=0.01;
	
		m_m_sPar_Groups[0][7]=0.1;
		m_m_sPar_Groups[1][7]=0.1;
	
		m_m_sPar_Groups[0][8]=0.25;
		m_m_sPar_Groups[1][8]=0.2;


		for (c1=0;c1<m_i_NF;c1++)
		{
		

			m_m_sPar_Groups[2+c1][0]=m_m_Freq_Config[1][c1];
			m_m_sPar_Groups[2+c1][1]=sumc(m_m_sPar_Groups[:2+c1-1][0]);
			m_m_sPar_Groups[2+c1][2]=sumc(m_m_sPar_Groups[:2+c1][0])-1;		
			m_m_sPar_Groups[2+c1][3]=1;
			m_m_sPar_Groups[2+c1][4]=0;
			m_m_sPar_Groups[2+c1][5]=0.015;
			m_m_sPar_Groups[2+c1][6]=0.05;
			m_m_sPar_Groups[2+c1][7]=0.05;
			m_m_sPar_Groups[2+c1][8]=0.25;



		}

		
		
		}

		else
		{
			m_m_sPar_Groups=zeros(1,9);
			m_m_sPar_Groups[0][0]=4+m_v_SSum[0]+m_v_SSum[1]+2*m_i_AR_lags+m_i_h0_mode+m_i_GJR_mode+m_i_ni_par+m_i_alpha_mode+m_i_eta_par+(m_i_inMean_mode>0);
			m_m_sPar_Groups[0][1]=0;
			m_m_sPar_Groups[0][2]=m_m_sPar_Groups[0][0]-1;
			m_m_sPar_Groups[0][3]=1;
			m_m_sPar_Groups[0][4]=1;
			m_m_sPar_Groups[0][5]=0.05;
			m_m_sPar_Groups[0][6]=0.1;
			m_m_sPar_Groups[0][7]=0.1;
			m_m_sPar_Groups[0][8]=0.2;

		}
				
		m_am_Draw_Cvm = new array [sizer(m_m_sPar_Groups)];
		m_am_Draw_Cvm2 = new array [sizer(m_m_sPar_Groups)];
		
		for (c1=0;c1<sizer(m_m_sPar_Groups);c1++)
		{
			if (m_m_sPar_Groups[c1][4]==1)
			{
				m_am_Draw_Cvm[c1]=loadmat("drawcvm"~sprint(c1)~".xlsx");
//				m_am_Draw_Cvm[c1]=m_sel*m_am_Draw_Cvm[c1]*m_sel';
				m_am_Draw_Cvm[c1]=choleski(m_am_Draw_Cvm[c1]);
			}
			else
			{
				if (c1==1)
				{
					m_am_Draw_Cvm[c1]=diag(mv_amp);
				}
				
				else
				{
					m_am_Draw_Cvm[c1]=unit(m_m_sPar_Groups[c1][0]);
				}
			}
		}


		for (c1=0;c1<sizer(m_m_sPar_Groups);c1++)
		{

			if (loadmat("cvm_s"~sprint(c1)~".xlsx")==0)
			{
				m_am_Draw_Cvm2[c1]=m_am_Draw_Cvm[c1];
			}
			else
			{
				m_am_Draw_Cvm2[c1]=loadmat("cvm_s"~sprint(c1)~".xlsx");
			}
			
		}
	
		m_m_iPar_Groups=m_m_sPar_Groups;
		println(m_m_sPar_Groups);

		m_as_probLabels=new array [(m_i_inMean_mode>0)+(m_i_ni_par==2)+m_i_GJR_mode+m_i_alpha_mode+1];

		if (m_i_NF>0)
		{
			m_as_addPar_Labels=new array [3+m_i_GJR_mode+(m_i_ni_par==2)+sumr(m_m_Freq_Config[1][])];
		}
		else
		{
			m_as_addPar_Labels=new array [3+m_i_GJR_mode+(m_i_ni_par==2)];
		}
		m_as_probLabels[0]="(a1+a2)/2+b1 > 1";
		m_as_addPar_Labels[0]="(a1+a2)/2+b1";
		m_as_addPar_Labels[1]="a0/[1-(a1+a2)/2-b1]";
		m_as_addPar_Labels[2]="[a0/(1-(a1+a2)/2-b1)]^0.5";
		
		c1=1;



		if (m_i_GJR_mode>0)
		{
			m_as_probLabels[c1]="alpha1 <= alpha2";
			m_as_addPar_Labels[2+c1]="alpha1/alpha2";
			c1++;
		}

		if (m_i_inMean_mode>0)
		{
			m_as_probLabels[c1]="lambda1 <= 0";
			c1++;
		}
		
		if (m_i_ni_par==2)
		{
			m_as_probLabels[c1]="ni1 >= ni2";
			m_as_addPar_Labels[2+c1-(m_i_inMean_mode>0)]="ni2/ni1";
			c1++;
		}

		if (m_i_alpha_mode==1)
		{
			m_as_probLabels[c1]="a00 < 0.5";
			c1++;
		}

		if (m_i_NF>0)
		{
			for (c1=0;c1<sumr(m_m_Freq_Config[1][]);c1++)
			{
				 m_as_addPar_Labels[2+(m_i_GJR_mode>0)+(m_i_inMean_mode>0)+(m_i_ni_par==2)+c1]="per_"~sprint(c1+1);
			}
		}
		m_as_iPar_Labels=new array [m_i_iParBasic_Num];
		m_as_iTPar_Labels=new array [5];


		m_as_iTPar_Labels[0]="f_e(t)";
		m_as_iTPar_Labels[1]="exp(f_v(t))";
		m_as_iTPar_Labels[2]="alpha (t)";
		m_as_iTPar_Labels[3]="ni1 (t)";
		m_as_iTPar_Labels[4]="ni2 (t)";
/*		m_as_iTPar_Labels[5]="[exp(f_v(t))]^0.5";
		m_as_iTPar_Labels[6]="ht";
		m_as_iTPar_Labels[7]="ht^0.5";
		m_as_iTPar_Labels[8]="mi (t)";
		m_as_iTPar_Labels[9]="ht*exp(f_v(t))";
		m_as_iTPar_Labels[10]="[ht*exp(f_v(t))]^0.5";
		m_as_iTPar_Labels[11]="[a0/(1-(a1+a2)/2-b1)*exp(f_v(t))]";
		m_as_iTPar_Labels[12]="[a0/(1-(a1+a2)/2-b1)*exp(f_v(t))]^0.5";
*/		

		
		c1=0;
		m_v_ParStart=0;
		
		
		for (c2=0;c2<m_i_AR_lags;c2++)
		{
			m_as_iPar_Labels[c1]="rho_"~sprint(c2+1);
			m_v_ParStart=m_v_ParStart|<0.001>;
			c1++;
		}


		for (c2=0;c2<m_i_AR_lags;c2++)
		{
			m_as_iPar_Labels[c1]="ini_"~sprint(c2+1);
			m_v_ParStart=m_v_ParStart|<0>;
			c1++;
		}

		m_v_ParStart=m_v_ParStart|<0.04>;

		m_v_ParStart=m_v_ParStart[1:][];
		
		m_as_iPar_Labels[c1]="delta";
		c1++;		

		m_v_ParStart=m_v_ParStart|log(0.005);
		m_as_iPar_Labels[c1]="alpha0";
		c1++;
		
		for (c2=0;c2<5;c2++)
		{

			for (c3=0;c3<m_v_SSum[c2];c3++)
			{
				m_as_iPar_Labels[c1]="b_se_"~sprint(c2)~"_"~sprint(c3+1);
				m_v_ParStart=m_v_ParStart|<0>;
				c1++;
			}
		}

		m_v_ParStart=m_v_ParStart|(log((0.03)/(1-0.03)));
		m_as_iPar_Labels[c1]="alpha1";
		c1++;

		m_v_ParStart=m_v_ParStart|(log((0.9)/(1-0.9)));
 		m_as_iPar_Labels[c1]="beta1";
		c1++;

		if (m_i_GJR_mode==1)
		{
			m_as_iPar_Labels[c1]="alpha1+";
			m_as_iPar_Labels[c1-2]="alpha1-";
			c1++;
			m_v_ParStart=m_v_ParStart|(log((0.03)/(1-0.03)));
		}
	

		if (m_i_inMean_mode>0)
		{
			m_as_iPar_Labels[c1]="lambda1";
			m_v_ParStart=m_v_ParStart|<0.001>;
			c1++;
		}

		if (m_i_eta_par>0)
		{
			for (c2=0;c2<m_i_eta_par;c2++)
			{
				m_as_iPar_Labels[c1]="eta"~sprint(c2);
				c1++;
			}
		}

		if (m_i_ni_par>0)
		{
			if (m_i_ni_par==1)
			{
				switch_single (m_i_ni_mode)
				{
				
				case 0:
				m_as_iPar_Labels[c1]="ni1=ni2";
				m_v_ParStart=m_v_ParStart|(log(5-m_d_ni_min));

				case 1:
				ni20_=vP[c1][0];
				m_as_iPar_Labels[c1]="ni2";
				ni10_=m_d_ni_known;
				m_v_ParStart=m_v_ParStart|(log(5-m_d_ni_min));

				case 2:
				ni10_=vP[c1][0];
				m_as_iPar_Labels[c1]="ni1";
				m_v_ParStart=m_v_ParStart|(log(5-m_d_ni_min));

				}
				c1=c1+1;
			
			}
			else
			{
				m_as_iPar_Labels[c1]="ni1";
				m_as_iPar_Labels[c1+1]="ni2";
				m_v_ParStart=m_v_ParStart|(log(5-m_d_ni_min));
				m_v_ParStart=m_v_ParStart|(log(5-m_d_ni_min));
				c1=c1+2;
			}
		}


		if (m_i_alpha_mode==1)
		{
			m_as_iPar_Labels[c1]="a00";
			m_v_ParStart=m_v_ParStart|tan((0.51-0.5)*M_PI);
			c1++;
		}

		if (m_i_h0_mode==1)
		{
		   	m_as_iPar_Labels[c1]="h0";
			m_v_ParStart=m_v_ParStart|(log(0.8));
		   	c1++;
		}

		if (m_i_NF>0)
		{
			
			c3=sumc(m_m_Amplitude_Config*m_m_Freq_Config[1][]');

			for (c2=0;c2<c3;c2++)
			{
				m_as_iPar_Labels[c1]="gamma_s"~sprint(c2);
				m_v_ParStart=m_v_ParStart|<0>;
				c1++;
			}

			for (c2=0;c2<c3;c2++)
			{
				m_as_iPar_Labels[c1]="gamma_c"~sprint(c2);
				m_v_ParStart=m_v_ParStart|<0>;
				c1++;
			}

			
			for (c2=0;c2<sumr(m_m_Freq_Config[1][]);c2++)
			{
				m_as_iPar_Labels[c1]="phi"~sprint(c2);
				m_v_ParStart=m_v_ParStart|<-5>;
				c1++;
			}
		
		}

		
	//================================================
	//configuration
	//m_as_iTPar_Labels
	//m_as_iPar_Labels
	//m_m_sPar_Groups
	//m_m_iPar_Groups

	adFunc[0]=1;
	
	return !ismissing(adFunc[0]);

	
	}
	else
	{
		if (m_i_AR_lags>0)
		{
			rho_=   vP[:m_i_AR_lags-1][0];
		
			eps0_=	vP[m_i_AR_lags:2*m_i_AR_lags-1][0];
			prior_logKer=prior_logKer-(m_d_e0_PriorDF+m_i_AR_lags)/2*log(1+1/m_d_e0_PriorDF*m_d_e0_PriorPrec*(eps0_'eps0_));
			prior_logKer=prior_logKer+sumc(rho_);
			rho_=exp(rho_);
			prior_logKer=prior_logKer-2*sumc(log(rho_+1))+sumc((floor(0.5*(range(0,m_i_AR_lags-1,1))')).*(log(1-((rho_-1)./(rho_+1)).^2)))+sumc(((0.5+floor(range(1,(m_i_AR_lags+1)/2,0.5)')).==(range(1,(m_i_AR_lags+1)/2,0.5)')).*log(1-((rho_-1)./(rho_+1))));
			rho_=(rho_-1)./(rho_+1);
			rho_=transformation_from_pcorr(rho_);
			m_m_iPar=eps0_'~rho_';			
			
		
		}
		
		c1=2*m_i_AR_lags;

		delta_= vP[c1][0];c1++;
		alpha0_=vP[c1][0];c1++;
		prior_logKer=prior_logKer
		-(m_d_delta_PriorDF+1)/2*log(1+1/m_d_delta_PriorDF*m_d_delta_PriorPrec*(delta_)^2)
		+m_d_alpha0_PriorA*alpha0_-m_d_alpha0_PriorB*exp(alpha0_);		

		alpha0_=exp(alpha0_);

		m_m_iPar=m_m_iPar~delta_~alpha0_;
		
		if (max(m_v_SSum)>0)
		{
			b_seas_=new array [5];

			for (c2=0;c2<5;c2++)
			{
				 if (m_v_SSum[c2]>0)
				 {

					 b_seas_[c2]=vP[c1:c1+m_v_SSum[c2]-1][0];
					 prior_logKer=prior_logKer-(m_d_gamma_PriorDF+m_v_SSum[c2])/2*log(1+1/m_d_gamma_PriorDF*m_d_gamma_PriorPrec*(b_seas_[c2]'b_seas_[c2]));
					 c1=c1+m_v_SSum[c2];
					 m_m_iPar=m_m_iPar~b_seas_[c2]';
				 }
			}
	   }

		if (m_i_GARCH_mode>0)
		{

			alpha1_=vP[c1][0];c1++;
			beta1_ =vP[c1][0];c1++;
	
			prior_logKer=prior_logKer
			
			+alpha1_-2*log(1+exp(alpha1_))
			+beta1_-2*log(1+exp(beta1_));


			alpha1_=(exp(alpha1_))/(1+exp(alpha1_));
			beta1_=(exp(beta1_))/(1+exp(beta1_));

			m_m_iPar=m_m_iPar~alpha1_~beta1_;
		
			if (m_i_GJR_mode==1)
			{
				alpha2_=vP[c1][0];
				prior_logKer=prior_logKer+alpha2_-2*log(1+exp(alpha2_));
				alpha2_=(exp(alpha2_))/(1+exp(alpha2_));
				m_m_iPar=m_m_iPar~alpha2_;
				c1++;
			
			}
			else
			{
				alpha2_=alpha1_;
			}
		

			m_v_Probs=(((alpha2_+alpha1_)/2+beta1_)>1)~(!(alpha1_>alpha2_));
			m_v_AddPars=(alpha2_+alpha1_)/2+beta1_;

			if (((alpha2_+alpha1_)/2+beta1_)>m_d_lim_corr_ht)
			{
				m_b_instab_ind=1;
				m_v_AddPars=m_v_AddPars~ranu(1,2);
			}
			else
			{
				m_b_instab_ind=0;
				m_v_AddPars=m_v_AddPars~alpha0_/(1-(alpha2_+alpha1_)/2-beta1_)~(alpha0_/(1-(alpha2_+alpha1_)/2-beta1_))^0.5;
			}
		
			if (m_i_GJR_mode==1)
			{
				m_v_AddPars=m_v_AddPars~alpha1_/alpha2_;
			}

			if (m_i_h0_mode==1)
			{
				h0_=vP[c1][0];
				prior_logKer=prior_logKer+m_d_h0_PriorA*h0_-m_d_h0_PriorB*exp(h0_);
				h0_=exp(h0_);
				m_m_iPar=m_m_iPar~h0_;
				c1++;
			}
			else
			{
			   h0_=m_d_h0_known;
			}

		}
		else
		{
			alpha1_=0;
			alpha2_=0;
			beta1_=0;
		}

		
		if (m_i_inMean_mode>0)
		{
			lambda1_=vP[c1][0];
			prior_logKer=prior_logKer-(m_d_lambda_PriorDF+1)/2*log(1+1/m_d_lambda_PriorDF*m_d_lambda_PriorPrec*(lambda1_)^2);
			m_m_iPar=m_m_iPar~lambda1_;
			c1++;
			m_v_Probs=m_v_Probs~(!(lambda1_>0));
		}
		else
		{
			lambda1_=0;
		}

		if (m_i_eta_par>0)
		{
			eta_=vP[c1:c1+m_i_eta_par-1][0];
			//PRIOR FOR ETA
			//TRANSFORMATION FOR ETA
			c1=c1+m_i_eta_par;
		}

		if (m_i_ni_par>0)
		{
			if (m_i_ni_par==1)
			{
				switch_single (m_i_ni_mode)
				{
				
				case 0:
				ni10_=vP[c1][0];
				ni20_=vP[c1][0];
				prior_logKer=prior_logKer
				+m_d_ni_PriorA*ni10_-m_d_ni_PriorB*exp(ni10_);
				ni10_=exp(ni10_);
				ni20_=exp(ni20_);
				m_m_iPar=m_m_iPar~(ni20_+m_d_ni_min);
				
				case 1:
				ni20_=vP[c1][0];
				ni10_=m_d_ni_known;

				prior_logKer=prior_logKer
				+m_d_ni_PriorA*ni20_-m_d_ni_PriorB*exp(ni20_);

				ni20_=exp(ni20_);
				m_m_iPar=m_m_iPar~(ni20_+m_d_ni_min);
				case 2:
				ni10_=vP[c1][0];
				ni20_=m_d_ni_known;
				
				prior_logKer=prior_logKer
				+m_d_ni_PriorA*ni10_-m_d_ni_PriorB*exp(ni10_);
				ni10_=exp(ni10_);
				m_m_iPar=m_m_iPar~(ni10_+m_d_ni_min);
				
				}
				c1=c1+1;
			
			}
			else
			{
				ni10_=vP[c1][0];
				ni20_=vP[c1+1][0];
				prior_logKer=prior_logKer
				+m_d_ni_PriorA*ni10_-m_d_ni_PriorB*exp(ni10_)
				+m_d_ni_PriorA*ni20_-m_d_ni_PriorB*exp(ni20_);
				ni10_=exp(ni10_);
				ni20_=exp(ni20_);

				m_m_iPar=m_m_iPar~(ni10_+m_d_ni_min)~(ni20_+m_d_ni_min);
									
				m_v_Probs=m_v_Probs~(!((m_d_ni_min+ni20_)>(m_d_ni_min+ni10_)));
				m_v_AddPars=m_v_AddPars~(m_d_ni_min+ni20_)/(m_d_ni_min+ni10_);
				
				c1=c1+2;
			}
		}
		else
		{
			ni10_=m_d_ni_known;
			ni20_=m_d_ni_known;
		}

		if (m_i_alpha_mode==1)
		{
			alpha00_=vP[c1][0];
			prior_logKer=prior_logKer-(m_d_alpha00_PriorDF+1)/2*log(1+1/m_d_alpha00_PriorDF*m_d_alpha00_PriorPrec*(alpha00_)^2);
			c1++;
			m_m_iPar=m_m_iPar~(0.5+atan(alpha00_)/M_PI);
			m_v_Probs=m_v_Probs~(alpha00_<0);
		}
		else
		{
			alpha00_=0;
		}


		if (m_i_NF>0)
		{
			mT1=zeros(m_iT+m_i_PredHor+1,m_ik1);
			phi_=new array [m_i_NF];
			n_gam=(m_m_Amplitude_Config*m_m_Freq_Config[1][]');
			gamma_s_=vP[c1:c1+sumc(n_gam)-1][0];
			c1=c1+sumc(n_gam);
			gamma_c_=vP[c1:c1+sumc(n_gam)-1][0];
			c1=c1+sumc(n_gam);

			prior_logKer=prior_logKer
			-(m_d_gamma_PriorDF+sumc(n_gam))/2*log(1+1/m_d_gamma_PriorDF*m_d_gamma_PriorPrec*(gamma_s_'gamma_s_))
			-(m_d_gamma_PriorDF+sumc(n_gam))/2*log(1+1/m_d_gamma_PriorDF*m_d_gamma_PriorPrec*(gamma_c_'gamma_c_));

			m_m_iPar=m_m_iPar~gamma_s_'~gamma_c_';
			
			for (c2=0;c2<m_i_NF;c2++)
			{

				phi_[c2]=vP[c1:c1+m_m_Freq_Config[1][c2]-1][0];

				if ((maxc(phi_[c2])>25)||(minc(phi_[c2])<-500))
				{
					for (c3=0;c3<sizer(phi_[c2]);c3++)
					{
						if ((phi_[c2])[c3][0]>25)
						{
							println("phi corrected ", (phi_[c2])[c3][0]);
							(phi_[c2])[c3][0]=25;
							v_exc[0][0]=v_exc[0][0]+1;
						}
						if ((phi_[c2])[c3][0]<-500)
						{
							println("phi corrected ", (phi_[c2])[c3][0]);
							(phi_[c2])[c3][0]=-500;
							v_exc[0][0]=v_exc[0][0]+1;
						}

				
					}
				}



				phi_[c2]=exp(phi_[c2]);
				phi_[c2]=phi_[c2]/(1+sumc(phi_[c2]));
		
				prior_logKer=prior_logKer+sumc(log(phi_[c2]))+log(1-sumc(phi_[c2]));

				phi_[c2]=((lower(ones(m_m_Freq_Config[1][c2],m_m_Freq_Config[1][c2])))*phi_[c2])*(m_d_PhiRTrunc-m_d_PhiLTrunc)+m_d_PhiLTrunc;
				c1=c1+m_m_Freq_Config[1][c2];
				m_m_iPar=m_m_iPar~phi_[c2]';

				m_v_AddPars=m_v_AddPars~(2*M_PI/251)*((phi_[c2]').^-1);
			}


			for (c2=0;c2<m_ik1;c2++)
			{
				mT1[][c2]=sin(m_mXr[m_m_AC[c2][0]-1].*(phi_[m_m_AC[c2][0]-1]'))*(gamma_s_[m_m_AC[c2][2]:m_m_AC[c2][3]][]);
				mT1[][c2]=mT1[][c2]+cos(m_mXr[m_m_AC[c2][0]-1].*(phi_[m_m_AC[c2][0]-1]'))*(gamma_c_[m_m_AC[c2][2]:m_m_AC[c2][3]][]);
			}

			mT2=mT1*(m_m_Cycle_Config');
			mTPAR=mT2;
			
		}

		if (m_i_NF>0)
		{
			mTPAR[][1]=exp(mT2[][1]);
			mTPAR[][2]=0.5+atan(mT2[][2]+alpha00_)/M_PI;
			mTPAR[][3]=m_d_ni_min+ni10_*exp(mT2[][3]);
			mTPAR[][4]=m_d_ni_min+ni20_*exp(mT2[][4]);
	

			m_z_ni=mTPAR[][3:4].>m_cut_ni;
			mTPAR[][3:4]=(m_z_ni.!=1).*mTPAR[][3:4]+m_z_ni*m_d_ni_max;
	
			mTPAR_2[][0:1]=M_PI^-0.5*gammafact((mTPAR[][3:4]+1)/2)./(gammafact(mTPAR[][3:4]/2).*(mTPAR[][3:4].^0.5)); 
			mTPAR_2[][2]=mTPAR[][2].*mTPAR_2[][0];
			mTPAR_2[][3]=(1-mTPAR[][2]).*mTPAR_2[][1];
			mTPAR_2[][0]=mTPAR_2[][2]+mTPAR_2[][3]; //B t
			mTPAR_2[][1]=mTPAR_2[][2]./mTPAR_2[][0];  //a* t
			mTPAR_2[][2]=4*mTPAR_2[][0].*(-(mTPAR_2[][1].^2).*mTPAR[][3]./(mTPAR[][3]-1)+((1-mTPAR_2[][1]).^2).*mTPAR[][4]./(mTPAR[][4]-1)); //c t
			mTPAR_2[][3]=(4*(
			(mTPAR[][2].*(mTPAR_2[][1].^2).*mTPAR[][3]./(mTPAR[][3]-2)+((1-mTPAR[][2]).*((1-mTPAR_2[][1]).^2)).*mTPAR[][4]./(mTPAR[][4]-2))
			)-mTPAR_2[][2].^2).^0.5;	// dt
			mTPAR_2[][4]=-mTPAR_2[][2]./mTPAR_2[][3];	//mt

		}
		else
		{

			mTPAR[0][1]=exp(mT2[0][1]);
			mTPAR[0][2]=0.5+atan(mT2[0][2]+alpha00_)/M_PI;
			mTPAR[0][3]=m_d_ni_min+ni10_*exp(mT2[0][3]);
			mTPAR[0][4]=m_d_ni_min+ni20_*exp(mT2[0][4]);

			m_z_ni=mTPAR[0][3:4].>m_cut_ni;
			mTPAR[0][3:4]=(m_z_ni.!=1).*mTPAR[0][3:4]+m_z_ni*m_d_ni_max;

			mTPAR=ones(sizer(mTPAR),1).*mTPAR[0][];
			
			mTPAR_2[0][0:1]=M_PI^-0.5*gammafact((mTPAR[0][3:4]+1)/2)./(gammafact(mTPAR[0][3:4]/2).*(mTPAR[0][3:4].^0.5)); 
			mTPAR_2[0][2]=mTPAR[0][2].*mTPAR_2[0][0];
			mTPAR_2[0][3]=(1-mTPAR[0][2]).*mTPAR_2[0][1];
			mTPAR_2[0][0]=mTPAR_2[0][2]+mTPAR_2[0][3]; //B t
			mTPAR_2[0][1]=mTPAR_2[0][2]./mTPAR_2[0][0];  //a* t
			mTPAR_2[0][2]=4*mTPAR_2[0][0].*(-(mTPAR_2[0][1].^2).*mTPAR[0][3]./(mTPAR[0][3]-1)+((1-mTPAR_2[0][1]).^2).*mTPAR[0][4]./(mTPAR[0][4]-1)); //c t
			mTPAR_2[0][3]=(4*(
			(mTPAR[0][2].*(mTPAR_2[0][1].^2).*mTPAR[0][3]./(mTPAR[0][3]-2)+((1-mTPAR[0][2]).*((1-mTPAR_2[0][1]).^2)).*mTPAR[0][4]./(mTPAR[0][4]-2))
			)-mTPAR_2[0][2].^2).^0.5;	// dt
			mTPAR_2[0][4]=-mTPAR_2[0][2]./mTPAR_2[0][3];	//mt

			mTPAR_2=ones(sizer(mTPAR_2),1).*mTPAR_2[0][];

		}


		mTPAR_3[0][0]=h0_;
		c0_=eps0_';
		
		c_p1=(h0_)^0.5;
		c_p2=(mTPAR[0][1])^0.5;
		
		switch_single(m_i_inMean_mode)
		{
			case 0:
			mTPAR_3[0][1]=delta_;
			case 1:
			mTPAR_3[0][1]=delta_+lambda1_*c_p1+mTPAR[0][0];
			case 2:
			mTPAR_3[0][1]=delta_+lambda1_*c_p1*c_p2+mTPAR[0][0];
 		}

		mTPAR_3[0][2]=eps0_[0][0];
		
		if (m_i_AR_lags>1)
		{
			mTPAR_3[0][2]=mTPAR_3[0][2]-eps0_[1:][0]'rho_[:m_i_AR_lags-2][];
		}
	
		
		mTPAR_3[0][3]=mTPAR_3[0][2]/c_p2;

		logLik=0;
		
		for (i_obs=1;i_obs<(m_iT+1);i_obs++)
		{

			//ht
			if (mTPAR_3[i_obs-1][2]<0)
			{
				mTPAR_3[i_obs][0]=alpha0_+alpha1_*(mTPAR_3[i_obs-1][3])^2+beta1_*mTPAR_3[i_obs-1][0];
			}
			else
			{
				mTPAR_3[i_obs][0]=alpha0_+alpha2_*(mTPAR_3[i_obs-1][3])^2+beta1_*mTPAR_3[i_obs-1][0];
			}

			if (mTPAR_3[i_obs][0]>(10^250))
			{
				mTPAR_3[i_obs][0]=10^250;
				if (v_exc[0][1]==0)
				{
					v_exc[0][1]=1;
				}

			}
		
			c_p1=(mTPAR_3[i_obs][0])^0.5;		 //sqrt ht
			c_p2=(mTPAR[i_obs][1])^0.5;			 //sqrt (exp(fv(t)))
			
			//miu t
			switch_single(m_i_inMean_mode)
			{
				case 0:
				mTPAR_3[i_obs][1]=delta_;

				case 1:
				mTPAR_3[i_obs][1]=delta_+lambda1_*c_p1+mTPAR[i_obs][0];

				case 2:
				mTPAR_3[i_obs][1]=delta_+lambda1_*c_p1*c_p2+mTPAR[i_obs][0];
	 		}
			//epsilon t
	
			mTPAR_3[i_obs][2]=m_mAllData[i_obs][]-mTPAR_3[i_obs][1]-c0_*rho_;
			
			if (m_i_AR_lags>1)
			{
				c0_[0][1:m_i_AR_lags-1]=c0_[0][0:m_i_AR_lags-2];
			}
			c0_[0][0]=m_mAllData[i_obs][]-mTPAR_3[i_obs][1];
			//ksi t
			mTPAR_3[i_obs][3]=mTPAR_3[i_obs][2]/c_p2;

			c_p3=c_p1*c_p2*mTPAR_2[i_obs][4];

			
			if (mTPAR_3[i_obs][2]<c_p3)
			{
				logLik=logLik+
				log(mTPAR_2[i_obs][0])+log(mTPAR_2[i_obs][3])-log(c_p1)-log(c_p2)
				-(mTPAR[i_obs][3]+1)/2*
				log(1+(mTPAR_3[i_obs][2]*mTPAR_2[i_obs][3]/(c_p1*c_p2)+mTPAR_2[i_obs][2])^2/(mTPAR[i_obs][3]*(2*mTPAR_2[i_obs][1])^2));
				
			}
			else
			{
				logLik=logLik+
				log(mTPAR_2[i_obs][0])+log(mTPAR_2[i_obs][3])-log(c_p1)-log(c_p2)
				-(mTPAR[i_obs][4]+1)/2*
				log(1+(mTPAR_3[i_obs][2]*mTPAR_2[i_obs][3]/(c_p1*c_p2)+mTPAR_2[i_obs][2])^2/(mTPAR[i_obs][4]*(2*(1-mTPAR_2[i_obs][1]))^2));

			}
				
		}

		if (m_b_Pred>0)
		{

			m_m_PrParH=mTPAR[m_iT+1:m_iT+m_i_PredHor][]~mTPAR_2[m_iT+1:m_iT+m_i_PredHor][1]~mTPAR_2[m_iT+1:m_iT+m_i_PredHor][4]~(mTPAR_2[m_iT+1:m_iT+m_i_PredHor][3].^-1);

		
			if (mTPAR_3[m_iT][2]<0)
			{
				p_ht=alpha0_+alpha1_*(mTPAR_3[m_iT][3])^2+beta1_*mTPAR_3[m_iT][0];
			}
			else
			{
				p_ht=alpha0_+alpha2_*(mTPAR_3[m_iT][3])^2+beta1_*mTPAR_3[m_iT][0];
			}


			//p_loc=p_loc+c0_*rho_;
					  
			m_m_PrPar=delta_~alpha0_~alpha1_~alpha2_~beta1_~lambda1_~p_ht~c0_~rho_';
		
		}

		
		m_m_iTPar=zeros(ceil((sizer(mTPAR)-1)/100),5);

		c2=0;

		for (c1=1;c1<sizer(mTPAR);c1=c1+100)
		{
			m_m_iTPar[c2][]=mTPAR[c1][];
			c2++;
		}	

		switch_single(m_i_kernel_mode)
		{
			case 0:
			adFunc[0]=logLik+prior_logKer;

			case 1:
			adFunc[0]=logLik;
			
			case 2:
			adFunc[0]=prior_logKer;			
			
		}
	
	
	m_m_iPar=m_m_iPar';
	m_d_Logl=logLik;
	m_d_LogPr=prior_logKer;
	m_v_Exceptions=v_exc;

	return !ismissing(adFunc[0]);		

	}

}

garchPOS::set_spec()
{
}

garchPOS::estimate()
{
	decl aa,par_start,par_cand,max_start,max_cand,bfgs_max,t1,
		 i_lcgen,i_lcbas,theta_curr,theta_cand,logPOS_curr,logPOS_cand,log_ratio,logl_curr,logl_max,
		 p_mean,p_cvm,ipar_curr,predp_curr,itpar_curr,exc_curr,prob_curr,predpH_curr,adpar_curr,ip_res,add_par_res,sp_res,sp_hist,ip_hist,acc_count,his_pom,mq_pom,
		 iT_par_mean,iT_par_stdev,nrest,as_nam,as_namT,m_prob,add_par_hist,ad_par_mean,ad_par_stdev,exc_count,instab_count,curr_instab_ind,
		 logl_max_par,pos_max,pos_max_par,ip_ml,ip_mp,ip_pe,ap_mp,ap_ml,ap_pe,acc_ind,acc_sum,pred_mat,pred_quant,pr_ksi,pr_ht,pr_c0,
		 i_l1,i_l2,i_l3,i_count,mp1,mp2,pr_eps,pred_pom,pred_es,pred_ess,pred_ind,pred_hist,res_agg,res_pred, mat_sel,p_st,cvd,pred_mean,pred_cvm,pred_count;

	println("===========  THE MODEL  ===========");
	println("Analyzing ", m_sDataLabel);
	println("First observation: ", m_mData[0][]);
	println("Last observation: ", m_mData[m_iT-1][]);
	println("No of observations: ", m_iT);
	println("===================================");	

	res_agg=m_iT;
	

	if (m_i_PredHor>0)
	{
		if (m_b_PredES==1)
		{
			pred_mat=zeros(m_i_pred_mult*m_iNumCycles*m_iBasicCycle,m_i_PredHor);
		}
		else
		{
			pred_mat=zeros(floor(m_i_pred_mult*m_iBasicCycle/10),m_i_PredHor);
		}

		
		pred_mean=zeros(1,m_i_PredHor);
		pred_cvm=zeros(m_i_PredHor,m_i_PredHor);
		pred_ind=0;
		predp_curr=0;
	}


	acc_count=0;

	
	instab_count=0;
	nrest=0;
	i_count=0;

	exc_count=zeros(1,3);

	println("pre0");
	
	m_i_Est_Mode=0;
	par_start=zeros(10,1);
	posterior_kernel(par_start,&max_start,0,0);
	m_i_Est_Mode=1;

	acc_ind=zeros(8,sizer(m_m_sPar_Groups));
	acc_sum=acc_ind;


	
//	ip_res=zeros(m_iBasicCycle,m_i_iParBasic_Num);
//	sp_res=zeros(m_iBasicCycle,m_i_iParBasic_Num);
//	add_par_res=zeros(m_iBasicCycle,sizeof(m_as_addPar_Labels));
	
	m_prob=zeros(1,sizeof(m_as_probLabels));
	
//	ip_hist=new array [m_i_iParBasic_Num];
//	sp_hist=new array [m_i_iParBasic_Num];

//	add_par_hist=new array [sizeof(m_as_addPar_Labels)];
	
/*	for(i_l1=0;i_l1<m_i_iParBasic_Num;i_l1++)
	{
		ip_hist[i_l1]=new histo2d(1);
		ip_hist[i_l1].set_buffer(m_iBasicCycle-1);

		sp_hist[i_l1]=new histo2d(1);
		sp_hist[i_l1].set_buffer(m_iBasicCycle-1);

	}  

	for(i_l1=0;i_l1<sizeof(m_as_addPar_Labels);i_l1++)
	{
		add_par_hist[i_l1]=new histo2d(1);
		add_par_hist[i_l1].set_buffer(m_iBasicCycle-1);
	}  */
	
	p_mean=new array [2];
	p_cvm=new array [2];

	ad_par_mean=zeros(1,sizeof(m_as_addPar_Labels));
	ad_par_stdev=zeros(1,sizeof(m_as_addPar_Labels));
	
	p_mean[0]=zeros(1,m_i_iParBasic_Num);
	p_cvm[0]=zeros(m_i_iParBasic_Num,m_i_iParBasic_Num);

	p_mean[1]=zeros(1,m_i_iParBasic_Num);
	p_cvm[1]=zeros(m_i_iParBasic_Num,m_i_iParBasic_Num);
	
	par_start=m_v_ParStart;
	println("pre");
	posterior_kernel(par_start,&max_start,0,0);

	if (m_i_PredHor>0)
	{
		pred_hist=new array [m_i_PredHor];

		
		for (i_l1=0;i_l1<m_i_PredHor;i_l1++)
		{
			pred_hist[i_l1]=new histo2d(1);
			pred_hist[i_l1].set_buffer(floor(m_iBasicCycle/30));
		}
	}
	
	p_st=loadmat("theta_max.xlsx");

	if (p_st==0)
	{
	
	
		for(i_l1=0;i_l1<10000;i_l1++)
		{
			par_cand=par_start+0.1*rant(m_i_iParBasic_Num,1,2);
			posterior_kernel(par_cand,&max_cand,0,0);
	
			if (max_cand>max_start)
			{
				par_start=par_cand;
				max_start=max_cand;
			}
		}

		posterior_kernel(par_start,&max_start,0,0);
	
		MaxControl(1000,0);
		MaxControlEps(1e-4, 5e-3);

	
		bfgs_max=MaxBFGS(posterior_kernel, &par_start, &max_start, 0, TRUE);

	}
	else
	{
		println("loaded");
		par_start=p_st;

	}

//	bfgs_max=MaxBFGS(posterior_kernel, &par_start, &max_start, 0, TRUE);
	
	posterior_kernel(par_start,&max_start,0,0);

//	savemat("theta_max.xlsx",par_start);
	
	logPOS_curr=max_start;
	pos_max=max_start;
	pos_max_par=par_start;
	theta_curr=par_start;
	ipar_curr=m_m_iPar;
	itpar_curr=m_m_iTPar;
	prob_curr=m_v_Probs;
	adpar_curr=m_v_AddPars;
	curr_instab_ind=m_b_instab_ind;
	logl_curr=m_d_Logl;
	logl_max=logl_curr;
	logl_max_par=theta_curr;
	exc_curr=m_v_Exceptions;
	
	theta_cand=0*theta_curr;
	iT_par_mean=0*m_m_iTPar;
	iT_par_stdev=0*m_m_iTPar;

	if (m_i_PredHor>0)
	{											 
		m_b_Pred=1;
		pred_count=0;
	}

//	println(m_as_iPar_Labels);
	
	t1=timer();
	
	for (i_lcgen=0;i_lcgen<m_iNumCycles;i_lcgen++)
	{
		for (i_lcbas=0;i_lcbas<m_iBasicCycle;i_lcbas++)
		{
			acc_ind=zeros(8,sizer(m_m_sPar_Groups));


			if (ranu(1,1)>0.5)
			{
				for (i_l1=0;i_l1<sizer(m_m_sPar_Groups);i_l1++)
				{
				
					switch_single (int(4*ranu(1,1)))
					{
					   case 0:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][5])*m_am_Draw_Cvm[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,2);
						acc_ind[0][i_l1]=1;
					   case 1:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][6])*0.6*m_am_Draw_Cvm[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,2);
						acc_ind[1][i_l1]=1;
					   case 2:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][7])*m_am_Draw_Cvm2[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,3);
						acc_ind[2][i_l1]=1;
					   case 3:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][8])*m_am_Draw_Cvm2[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,3);
						acc_ind[3][i_l1]=1;
					}
				}
			}
			else
			{
				for (i_l1=0;i_l1<sizer(m_m_sPar_Groups);i_l1++)
				{
				
					switch_single (int(4*ranu(1,1)))
					{
					   case 0:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][5])*10*m_am_Draw_Cvm2[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,2);
						acc_ind[4][i_l1]=1;
					   case 1:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][6])*2*m_am_Draw_Cvm2[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,2);
						acc_ind[5][i_l1]=1;
					   case 2:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][7])*0.05*m_am_Draw_Cvm2[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,2);
						acc_ind[6][i_l1]=1;
					   case 3:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][8])*0.2*m_am_Draw_Cvm2[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,3);
						acc_ind[7][i_l1]=1;
					}
				}
			}
			posterior_kernel(theta_cand,&logPOS_cand,0,0);
			log_ratio=exp(logPOS_cand-logPOS_curr);

			if (ranu(1,1)<log_ratio)
			{

				theta_curr=theta_cand;
				logPOS_curr=logPOS_cand;
				ipar_curr=m_m_iPar;
				itpar_curr=m_m_iTPar;
				prob_curr=m_v_Probs;
				adpar_curr=m_v_AddPars;

				if (m_i_PredHor>0)
				{
				predp_curr=m_m_PrPar;
				predpH_curr=m_m_PrParH;
				}
				
				logl_curr=m_d_Logl;
				exc_curr=m_v_Exceptions;
				curr_instab_ind=m_b_instab_ind;

				acc_sum=acc_sum+acc_ind;
				acc_count++;
				
				if (logl_curr>logl_max)
				{
					logl_max=logl_curr;
					logl_max_par=theta_curr;
				}
	
				if (pos_max>logPOS_curr)
				{
					pos_max=logPOS_curr;
					pos_max_par=theta_curr;
				}
	
			}

			if ((m_i_PredHor>0)&&(acc_count>10))
			{
//							m_m_PrPar=cor_l~cor_s~p_loc~p_scale~mTPAR[m_iT][2]~mTPAR[m_iT][3]~mTPAR[m_iT][4];


				pr_eps=zeros(m_i_pred_mult,m_i_PredHor);
				pr_ksi=pr_eps;
				pr_ht=ones(m_i_pred_mult,m_i_PredHor);
				pr_c0=ones(m_i_pred_mult,m_i_AR_lags);
				
				for (i_l1=0;i_l1<m_i_PredHor;i_l1++)
				{


					mp1=zeros(m_i_pred_mult,2);

					
					mp1[][0]=cabs(rant(m_i_pred_mult,1,predpH_curr[i_l1][3])')';
					mp1[][1]=cabs(rant(m_i_pred_mult,1,predpH_curr[i_l1][4])')';
					mp2=ranu(m_i_pred_mult,1);
					pr_eps[][i_l1]=predpH_curr[i_l1][5]*mp1[][0].*((((mp2-predpH_curr[i_l1][2]).>0)-((mp2-predpH_curr[i_l1][2]).<0))-1)+(1-predpH_curr[i_l1][5])*mp1[][1].*((((mp2-predpH_curr[i_l1][2]).>0)-((mp2-predpH_curr[i_l1][2]).<0))+1);
		
					pr_eps[][i_l1]=pr_eps[][i_l1]*predpH_curr[i_l1][7]+predpH_curr[i_l1][6];


			   	}
				//predp_curr
				//m_m_PrPar=delta_~alpha0_~alpha1_~alpha2_~beta1_~lambda1_~p_ht~c0_~rho_';
				pr_ht[][0]=pr_ht[][0]*predp_curr[0][6];
				pr_c0=pr_c0.*predp_curr[0][7:7+m_i_AR_lags-1];
				
				for (i_l1=0;i_l1<m_i_PredHor;i_l1++)
				{
					
					pr_eps[][i_l1]=pr_eps[][i_l1].*(pr_ht[][i_l1].^0.5);
					pr_ksi[][i_l1]=pr_eps[][i_l1];
					pr_eps[][i_l1]=pr_eps[][i_l1]*(predpH_curr[i_l1][1]^0.5);
					pr_eps[][i_l1]=pr_eps[][i_l1]+pr_c0*predp_curr[0][7+m_i_AR_lags:7+2*m_i_AR_lags-1]';

					if (m_i_AR_lags>1)
					{
						pr_c0[][1:]=pr_c0[][0:m_i_AR_lags-2];
					}

					pr_c0[][0]=pr_eps[][i_l1];
					
					switch_single(m_i_inMean_mode)
					{
						case 0:
						pr_eps[][i_l1]=pr_eps[][i_l1]+predp_curr[0][0];

						case 1:
						pr_eps[][i_l1]=pr_eps[][i_l1]+predp_curr[0][0]+predp_curr[0][5]*(pr_ht[][i_l1].^0.5)+predpH_curr[i_l1][0];

						case 2:
						pr_eps[][i_l1]=pr_eps[][i_l1]+predp_curr[0][0]+predp_curr[0][5]*(pr_ht[][i_l1]*predpH_curr[i_l1][1]).^0.5+predpH_curr[i_l1][0];
		 			}

					if (i_l1<(m_i_PredHor-1))
					{
						pr_ht[][i_l1+1]=pr_ht[][i_l1+1]*predp_curr[0][1]+predp_curr[0][4]*pr_ht[][i_l1]+predp_curr[0][2]*((pr_ksi[][i_l1].*(pr_ksi[][i_l1].<0)).^2)+predp_curr[0][3]*((pr_ksi[][i_l1].*(pr_ksi[][i_l1].>0)).^2);

					}
								
									
			   	}

				pred_mean=pred_mean+sumc(pr_eps);
				pred_cvm=pred_cvm+sumc(pr_eps.^2);
				
				pred_mat[pred_ind:pred_ind+m_i_pred_mult-1][]=pr_eps;
				pred_ind=pred_ind+m_i_pred_mult;											   
				pred_count=pred_count+m_i_pred_mult;
				
				if (m_b_PredES==0)
				{
					if ((pred_ind+m_i_pred_mult)>sizer(pred_mat))
					{

						for (i_l1=0;i_l1<m_i_PredHor;i_l1++)
						{
							pred_hist[i_l1].append_data(pred_mat[:pred_ind-1][i_l1]);
					
						}

						pred_ind=0;
					} 
				}
				
			}

			
			instab_count=instab_count+curr_instab_ind;
			exc_count=exc_count+exc_curr;
			p_mean[0]=p_mean[0]+theta_curr';
			p_cvm[0]=p_cvm[0]+theta_curr*theta_curr';

			p_mean[1]=p_mean[1]+ipar_curr';
			p_cvm[1]=p_cvm[1]+ipar_curr*ipar_curr';
			m_prob=m_prob+prob_curr;
			
			i_count++;

	//		ip_res[i_lcbas][]=ipar_curr';
	//		sp_res[i_lcbas][]=theta_curr';
	//		add_par_res[i_lcbas][]=adpar_curr;
			
			iT_par_mean=iT_par_mean+itpar_curr;
	//		iT_par_stdev=iT_par_stdev+itpar_curr.^2;

			ad_par_mean=ad_par_mean+adpar_curr;
			ad_par_stdev=ad_par_stdev+adpar_curr.^2;
			
			nrest=nrest+exp(-logl_curr+m_iNRsc);
			
		}
		println("acc", acc_count);
	//	savemat("acc_summary.xlsx",(acc_sum/acc_count)~(acc_count/i_count));
		

	}


	if (m_b_PredES==1)
	{
		pred_mat=pred_mat[:pred_ind-1][];
	
		for (i_l1=0;i_l1<m_i_PredHor;i_l1++)
		{
			pred_hist[i_l1].append_data(pred_mat[][i_l1]);
		
		}

		for (i_l2=0;i_l2<m_i_PredHor;i_l2++)
		{
			pred_quant=0;
			pred_es=0;
	
	
			pred_pom=(pred_mat[][i_l2].<m_m_Real_Obs[i_l2][]);


			//pred_mat[][i_l1]=sortr(pred_mat[][i_l1]); //po co?
			
			pred_quant=loadmat("pred_quant_H"~sprint(i_l2+1)~".xlsx");
	
			if (pred_quant==0)
			{
				pred_quant=<0>~m_qmat;
			}

	
			pred_quant=(m_iT~(quantilec(pred_mat[][i_l2],m_qmat)'))|pred_quant;
			savemat("pred_quant_H"~sprint(i_l2+1)~".xlsx",pred_quant);

			pred_es=loadmat("pred_es_H"~sprint(i_l2+1)~".xlsx");

			if (pred_es==0)
			{
				pred_es=<0>~m_qmat;
			}
	
			pred_ess=zeros(1,sizec(m_qmat));
	
			for (i_l1=0;i_l1<sizec(m_qmat);i_l1++)
			{
				if (m_qmat[0][i_l1]<0.5)
				{
					pred_pom=pred_mat[][i_l2].<(pred_quant[0][i_l1+1]);
				}
				else
				{
					pred_pom=pred_mat[][i_l2].>(pred_quant[0][i_l1+1]);
				}
				
				pred_ess[0][i_l1]=sumc(pred_mat[][i_l2].*pred_pom)/sumc(pred_pom);

	  		}

			pred_ess=m_iT~pred_ess;
			savemat("pred_es_H"~sprint(i_l2+1)~".xlsx",(pred_ess)|(pred_es));
		}
	}
	
	print("TIME: ", (timer() - t1), "\n");

	if (m_i_PredHor>0)
	{
		pred_mean=pred_mean/pred_count;
		pred_cvm=pred_cvm/pred_count-pred_mean'pred_mean;

		res_pred=zeros(m_i_PredHor,228);
		
		for (i_l1=0;i_l1<m_i_PredHor;i_l1++)
		{
			i_l3=0;
			res_pred[i_l1][i_l3]=1+i_l1;i_l3++;
			res_pred[i_l1][i_l3]=m_iT;i_l3++;
			res_pred[i_l1][i_l3]=m_mAllData[m_iT][0];i_l3++;
			res_pred[i_l1][i_l3]=pred_mean[0][i_l1];i_l3++;
			res_pred[i_l1][i_l3]=(pred_cvm[i_l1][i_l1])^0.5;i_l3++;
			res_pred[i_l1][i_l3]=pred_hist[i_l1].get_quantile(0.5);i_l3++;
			res_pred[i_l1][i_l3:i_l3+1]=(pred_hist[i_l1].get_mode()~zeros(1,2-sizec(pred_hist[i_l1].get_mode())));i_l3=i_l3+2;

			res_pred[i_l1][i_l3]=<1111>;i_l3++;
			res_pred[i_l1][i_l3]=m_m_Real_Obs[i_l1][0];i_l3++;

			if (m_m_Real_Obs[i_l1][0]!=M_NAN)
			{
				res_pred[i_l1][i_l3]=pred_hist[i_l1].get_density(m_m_Real_Obs[i_l1][0]);i_l3++;
				res_pred[i_l1][i_l3]=pred_hist[i_l1].get_cdf(m_m_Real_Obs[i_l1][0]);i_l3++;
				res_pred[i_l1][i_l3]=pred_hist[i_l1].get_rps(m_m_Real_Obs[i_l1][0]);i_l3++;
				res_pred[i_l1][i_l3]=acc_count/i_count;i_l3++;
				res_pred[i_l1][i_l3]=m_i_pred_mult;i_l3++;
				res_pred[i_l1][i_l3]=acc_count;i_l3++;
						
			}
			else
			{
				res_pred[i_l1][i_l3]=M_NAN;i_l3++;
				res_pred[i_l1][i_l3]=M_NAN;i_l3++;
				res_pred[i_l1][i_l3]=M_NAN;i_l3++;
				res_pred[i_l1][i_l3]=acc_count/i_count;i_l3++;
				res_pred[i_l1][i_l3]=m_i_pred_mult;i_l3++;
				res_pred[i_l1][i_l3]=acc_count;i_l3++;
			}

			res_pred[i_l1][i_l3]=<2222>;i_l3++;

			for (i_l2=0;i_l2<39;i_l2++)
			{
				res_pred[i_l1][i_l3]=0.025*(i_l2+1);
				res_pred[i_l1][i_l3+1]=pred_hist[i_l1].get_quantile(0.025*(i_l2+1));
				i_l3=i_l3+2;
			}

			res_pred[i_l1][i_l3]=<3333>;i_l3++;

			res_pred[i_l1][i_l3]=0.99;
			i_l3++;
			pred_pom=pred_hist[i_l1].get_hpd(0.99);
			res_pred[i_l1][i_l3:i_l3+6]=(pred_pom')~zeros(1,7-sizer(pred_pom));
			i_l3=i_l3+7;

			
			for (i_l2=0;i_l2<15;i_l2++)
			{
				res_pred[i_l1][i_l3]=1-0.05*(i_l2+1);
				i_l3++;
				pred_pom=pred_hist[i_l1].get_hpd(1-0.05*(i_l2+1));
				res_pred[i_l1][i_l3:i_l3+6]=(pred_pom')~zeros(1,7-sizer(pred_pom));
				i_l3=i_l3+7;
			}

			pred_pom=loadmat(m_s_FLabel~"_L"~sprint(m_i_AR_lags)~"_pred_H"~sprint(i_l1+1)~".xlsx");

			if (pred_pom==0)
			{
				savemat(m_s_FLabel~"_L"~sprint(m_i_AR_lags)~"_pred_H"~sprint(i_l1+1)~".xlsx",res_pred[i_l1][]);
			}
			else
			{
				savemat(m_s_FLabel~"_L"~sprint(m_i_AR_lags)~"_pred_H"~sprint(i_l1+1)~".xlsx",res_pred[i_l1][]|pred_pom);
			}

		}

	}


	p_mean[0]=p_mean[0]/i_count;
	p_mean[1]=p_mean[1]/i_count;

	p_cvm[0]=p_cvm[0]/i_count-p_mean[0]'p_mean[0];
	p_cvm[1]=p_cvm[1]/i_count-p_mean[1]'p_mean[1];

		
	iT_par_mean=iT_par_mean/i_count;

	for (i_l1=0;i_l1<sizer(m_m_sPar_Groups);i_l1++)
	{
	   	savemat("cvm_s"~sprint(i_l1)~".xlsx", choleski((p_cvm[0])[(m_m_sPar_Groups[i_l1][1]):(m_m_sPar_Groups[i_l1][2])][(m_m_sPar_Groups[i_l1][1]):(m_m_sPar_Groups[i_l1][2])]));
	}

	for (i_l1=0;i_l1<sizer(m_m_sPar_Groups);i_l1++)
	{
	   	savemat("cvm_c"~sprint(i_l1)~".xlsx", ((p_cvm[0])[(m_m_sPar_Groups[i_l1][1]):(m_m_sPar_Groups[i_l1][2])][(m_m_sPar_Groups[i_l1][1]):(m_m_sPar_Groups[i_l1][2])]));
	}

	ad_par_mean=ad_par_mean/i_count;
	ad_par_stdev=ad_par_stdev/i_count-ad_par_mean.^2;
	ad_par_stdev=ad_par_stdev.^0.5;

	savemat(sprint(m_iT)~"post_es.xlsx",	 (p_mean[1]~ad_par_mean)|((diagonal(p_cvm[1])).^0.5~ad_par_stdev),m_as_iPar_Labels|m_as_addPar_Labels);
	
	savemat(sprint(m_iT)~"acc_summary.xlsx",(acc_sum/acc_count)~(acc_count/i_count));
	
//	savemat(sprint(m_iT)~"m1.xlsx", p_mean[0]);
	savemat(sprint(m_iT)~"m2.xlsx", p_mean[1]);	
//	savemat(sprint(m_iT)~"cvm1.xlsx", p_cvm[0]);
	
	savemat(sprint(m_iT)~"cvm_ip.xlsx", p_cvm[1],m_as_iPar_Labels);

	savemat(sprint(m_iT)~"add_par_res.xlsx",ad_par_mean|ad_par_stdev,m_as_addPar_Labels);

	savemat(sprint(m_iT)~"probs.xlsx",(m_prob/i_count)~m_prob,m_as_probLabels~m_as_probLabels);
	
	println(sprint(m_iT)~"acceptance ratio:  ", acc_count/i_count);

	println(sprint(m_iT)~"Log10 NR  ", log10(i_count)-log10(nrest)+m_iNRsc*log10(exp(1)));
	savemat(sprint(m_iT)~"_NR.xlsx",(log10(i_count)-log10(nrest)+m_iNRsc*log10(exp(1)))~(acc_count/i_count));

//	println("LogL max  ", logl_max);
//	savemat("Logl_max.xlsx",logl_max);

	println("WARNING: instability prob: ", instab_count/i_count);
	println("instability limit: ", m_d_lim_corr_ht);
	println("WARNING: exceptions: ", exc_count);
	println("WARNING: frac of exc: ", exc_count/i_count);

	savemat("instab_report.xlsx", instab_count~(instab_count/i_count)~m_d_lim_corr_ht);
	savemat(sprint(m_iT)~"excp.xlsx", exc_count~exc_count/i_count);
	// histograms for interpretable parameters

//	mq_pom=zeros(201,m_i_iParBasic_Num+1);
	as_nam=new array [m_i_iParBasic_Num+1];
	/*
	for(i_l1=0;i_l1<m_i_iParBasic_Num;i_l1++)
	{
		
		his_pom=ip_hist[i_l1].get_histo1d(100,0.01);
		DrawHistogram(i_l1,his_pom[][1]',his_pom[1][0],his_pom[2][0]-his_pom[1][0]);
		DrawTitle(i_l1, m_as_iPar_Labels[i_l1]);

		as_nam[i_l1+1]=m_as_iPar_Labels[i_l1];
		
		for(i_l2=0;i_l2<199;i_l2++)
		{
			mq_pom[i_l2][i_l1+1]=ip_hist[i_l1].get_quantile((1+i_l2)/200);
		}
	}

	for(i_l2=0;i_l2<201;i_l2++)
	{
		mq_pom[i_l2][0]=(1+i_l2)/200;
	}
	
	SaveDrawWindow("hist_ip.ps");
	SaveDrawWindow("hist_ip.eps");
	CloseDrawWindow();
	 
	as_nam[0]="quantile";
	savemat("mq.xlsx",mq_pom, as_nam);
	*/

	//posterior mode
//	bfgs_max=MaxBFGS(posterior_kernel, &pos_max_par, &pos_max, 0, TRUE);
	posterior_kernel(pos_max_par,&pos_max,0,0);
	
	ip_mp=m_m_iPar;
	ap_mp=m_v_AddPars;
  	/*
	
	//maximum likelihood
	m_i_kernel_mode=1;
	bfgs_max=MaxBFGS(posterior_kernel, &logl_max_par, &logl_max, 0, TRUE);

	
	m_i_kernel_mode=0;

	println("LogL max  ", logl_max);
	savemat(sprint(m_iT)~"Logl_max.xlsx",logl_max);
	
	//log posterior kernel at maximum likelihood

	posterior_kernel(logl_max_par,&logPOS_curr,0,0);

	savemat(m_s_FLabel~"maxp_par"~sprint(".xlsx"),logl_max_par);

	ip_ml=m_m_iPar;
	ap_ml=m_v_AddPars;
	 	*/
	
	//log posterior kernel at posterior mean
	theta_cand=p_mean[0]';
	posterior_kernel(theta_cand,&logPOS_cand,0,0);
	ip_pe=m_m_iPar;
	ap_pe=m_v_AddPars;
	
	as_nam[0]="log post kernel";
	// histograms for statistical parameters

//	mq_pom=(pos_max~(pos_max_par')~(ip_mp')~ap_mp)|(logPOS_cand~p_mean[0]~(ip_pe')~ap_pe);
	
//	savemat(sprint(m_iT)~"point_est.xlsx",mq_pom, as_nam~m_as_iPar_Labels~m_as_addPar_Labels);
			  


	pred_pom=loadmat(m_s_FLabel~"_post_mode"~sprint(".xlsx"));

	mq_pom=m_iT~(pos_max~(pos_max_par')~(ip_mp')~ap_mp);
	
	if (pred_pom==0)
	{
		savemat(m_s_FLabel~"_post_mode"~sprint(".xlsx"),mq_pom, {"T"}~as_nam~m_as_iPar_Labels~m_as_addPar_Labels);
	}
	else
	{
		savemat(m_s_FLabel~"_post_mode"~sprint(".xlsx"),mq_pom|pred_pom, {"T"}~as_nam~m_as_iPar_Labels~m_as_addPar_Labels);
	}


	pred_pom=loadmat(m_s_FLabel~"_post_expect"~sprint(".xlsx"));

	mq_pom=m_iT~(logPOS_cand~p_mean[0]~(ip_pe')~ap_pe);
	
	if (pred_pom==0)
	{
		savemat(m_s_FLabel~"_post_expect"~sprint(".xlsx"),mq_pom, {"T"}~as_nam~m_as_iPar_Labels~m_as_addPar_Labels);
	}
	else
	{
		savemat(m_s_FLabel~"_post_expect"~sprint(".xlsx"),mq_pom|pred_pom, {"T"}~as_nam~m_as_iPar_Labels~m_as_addPar_Labels);
	}

	savemat("theta_max.xlsx",pos_max_par);


	for (i_l1=0;i_l1<5;i_l1++)
	{

		pred_pom=loadmat(m_s_FLabel~"_Tpar_expect_"~m_as_iTPar_Labels[i_l1]~sprint(".xlsx"));

	
		if (pred_pom==0)
		{
			savemat(m_s_FLabel~"_Tpar_expect_"~m_as_iTPar_Labels[i_l1]~sprint(".xlsx"),m_iT~(iT_par_mean[][i_l1]'),{"T"}~m_as_iTPar_Labels[i_l1]);
		}
		else
		{
			savemat(m_s_FLabel~"_Tpar_expect_"~m_as_iTPar_Labels[i_l1]~sprint(".xlsx"),(m_iT~(iT_par_mean[][i_l1]'))|pred_pom, {"T"}~m_as_iTPar_Labels[i_l1]);
		}
	} 
	
	
	delete pred_hist;
}



garchPOS::transformation_from_pcorr(const part_corr)
{

// provides transformation from partial correlations (parameters from (-1,1) range) to AR or MA parameters satisfying stationarity/invertibility conditions
decl m_A,l1;

if (sizec(part_corr)>1)
{
println("WARNING: wrong dimension in transformation_from_pcorr");
}

m_A=diag(part_corr);

if (sizer(part_corr)>1)
{
	m_A[0][1]=m_A[0][0]-m_A[0][0]*m_A[1][1];

	if (sizer(part_corr)>2)
	{
		for (l1=2;l1<sizer(part_corr);l1++)
		{

			m_A[:l1-1][l1]=m_A[:l1-1][l1-1]-m_A[l1][l1]*reversec(m_A[:l1-1][l1-1]);
		
		}
	
	}

}

return(m_A[][sizer(part_corr)-1]);

}
