

//---------------------------------------------
// histo2d:: constructor
//---------------------------------------------

histo2d::histo2d(const i_Hist_dim)
{
	m_iIter=0;
	m_m2dData=<>;

	m_iBuffer_size=99999;
	m_iBuffer_count=0;       	 	//a within-buffer counter
	m_sOutputLabel =sprint("");
	m_mData_buffer = zeros(1,1);
	m_dLeftTailQuantile = 0.0005;
	m_dRightTailQuantile =0.0005;
	m_vLeft_tail_obs=zeros(10000,1);
	m_vRight_tail_obs=zeros(10000,1);
	m_iLT_index=0;
	m_iRT_index=0;
	m_vTCount=zeros(6,2);
	m_vTCount[1][0:1]=<.>~<.>;
	m_bTailsProcessed=0;
	
	m_dAxis_min = zeros(1,i_Hist_dim);
	m_dAxis_step = zeros(1,i_Hist_dim);
	m_dAxis_ref = zeros(1,i_Hist_dim); 
	m_b_smooth_histogram=0;
	m_iHist_Nbars=5000;
	m_mDens=<.>;
}


//---------------------------------------------
// histo2d:: provides data input	
// return:
// -1 wrong format (wrong number of columns)
//  2 output unchanged (added less data than free buffer size)
//  1 output updated (added more data than free buffer size)
//---------------------------------------------

histo2d::append_data(const mData_Added)
{
	decl iBuf_cycle, iWithin_buffer_cycle,buffer_copy;

	m_bTailsProcessed=0;
	
	if ((sizec(m_m2dData)==0)&&(m_iIter==0))
	{
		m_mData_buffer=zeros(m_iBuffer_size,sizec(m_dAxis_step));
			
	}

	if (sizec(mData_Added)!=sizec(m_dAxis_min)) return(-1);

	m_iIter+=sizer(mData_Added);		
		
	if ((sizer(mData_Added)+m_iBuffer_count)>=sizer(m_mData_buffer))
	{

	
		for	(iBuf_cycle=1;iBuf_cycle<(floor((sizer(mData_Added)-(m_iBuffer_size-m_iBuffer_count))/m_iBuffer_size)+2);iBuf_cycle++)
		{
		m_mData_buffer[m_iBuffer_count*(iBuf_cycle==1):][] =
		mData_Added[   (m_iBuffer_size-m_iBuffer_count)*(iBuf_cycle!=1)+(iBuf_cycle>1)*(iBuf_cycle-2)*m_iBuffer_size:
					(m_iBuffer_size-m_iBuffer_count)+(iBuf_cycle-1)*m_iBuffer_size-1][];//!!!!

			//initialization of the histogram storage structure

			if 	(m_dAxis_step[0][0]==0)
			{

				m_dAxis_min=quantilec(m_mData_buffer, m_dLeftTailQuantile);
				m_dAxis_step=quantilec(m_mData_buffer, (1-m_dRightTailQuantile));
			
				
				if (sizec(m_dAxis_step)==2)
				{
				m_dAxis_ref=(m_dAxis_step-m_dAxis_min)./40;
				}
				else
				{
				m_dAxis_ref=(m_dAxis_step-m_dAxis_min)./10000;
				
				if ( (m_dAxis_min-min(m_mData_buffer))< (0.5)*(m_dAxis_step-m_dAxis_min) ) m_dAxis_min=min(m_mData_buffer);
				
				}
				
 				m_dAxis_step=sortc(10^<-8:8>'|5*10^<-8:8>')[-1+sumc((sortc(10^<-8:8>'|5*10^<-8:8>')./m_dAxis_ref.<=1))][]';

				m_dAxis_min=(((round(m_dAxis_min./m_dAxis_step))-100^(1/sizec(m_dAxis_ref))).*m_dAxis_step);
				//println(m_dAxis_step);
				//println(m_dAxis_min);

				
				
				m_dAxis_ref=minc(
				1.2*(ceil( (quantilec(m_mData_buffer,(1-m_dRightTailQuantile))-m_dAxis_min)./m_dAxis_step))
				|
				1.1*(ceil( (maxc(m_mData_buffer)-m_dAxis_min)./m_dAxis_step))
				);
				//println(m_dAxis_ref);
				//println(maxc(m_mData_buffer));
				if (sizec(m_dAxis_step)==2)
				{
					m_m2dData=zeros(m_dAxis_ref[][0],m_dAxis_ref[][1]);
					println("create md");
				}
				else
				{
					m_m2dData=zeros(m_dAxis_ref,1);
				//	println("create md");
				}
			
				
			}


			if (m_vTCount[1][0]==<.>)
			{
				m_vTCount[1][0]=minc(m_mData_buffer);
				m_vTCount[1][1]=maxc(m_mData_buffer);
			}
			else
			{
				if (minc(m_mData_buffer)<m_vTCount[1][0])
				{
					m_vTCount[1][0]=minc(m_mData_buffer);
				}

				if (maxc(m_mData_buffer)<m_vTCount[1][1])
				{
					m_vTCount[1][1]=maxc(m_mData_buffer);
				}
			
			}
			
			buffer_copy=m_mData_buffer;	

			m_mData_buffer=floor((m_mData_buffer-m_dAxis_min)./m_dAxis_step); //??

			   for (iWithin_buffer_cycle=0;iWithin_buffer_cycle<m_iBuffer_size;iWithin_buffer_cycle++)
			{
				if (sizec(m_dAxis_step)==1)
				{
					if (m_mData_buffer[iWithin_buffer_cycle][0]<0)
					{
						m_m2dData[0][0]++;
						m_vLeft_tail_obs[m_iLT_index][0]=buffer_copy[iWithin_buffer_cycle];
						m_iLT_index++;
						if (m_iLT_index==sizer(m_vLeft_tail_obs))
						{
							m_vLeft_tail_obs=m_vLeft_tail_obs|zeros(1000,1);
						}
					
					}
					else
					{
						if (m_mData_buffer[iWithin_buffer_cycle][0]>=sizer(m_m2dData))
						{
							m_m2dData[sizer(m_m2dData)-1][0]++;

							m_vRight_tail_obs[m_iRT_index][0]=buffer_copy[iWithin_buffer_cycle];
							m_iRT_index++;
							if (m_iRT_index==sizer(m_vRight_tail_obs))
							{
								m_vRight_tail_obs=m_vRight_tail_obs|zeros(1000,1);
							}
					
						
						}
						else
						{
						m_m2dData[(m_mData_buffer[iWithin_buffer_cycle][0])][0]++;
						}
					}
				}
				else if	(sizec(m_dAxis_step)==2)
				{																									 
				//	if (max(  ceil(fabs(m_mData_buffer[iWithin_buffer_cycle][] - m_dAxis_ref/2)) .>= (m_dAxis_ref/2)  ))
				//	{
				   	if (m_mData_buffer[iWithin_buffer_cycle][0]<0) m_mData_buffer[iWithin_buffer_cycle][0]=0;
					if (m_mData_buffer[iWithin_buffer_cycle][1]<0) m_mData_buffer[iWithin_buffer_cycle][1]=0;
					if (m_mData_buffer[iWithin_buffer_cycle][0]>(sizer(m_m2dData)-1)) m_mData_buffer[iWithin_buffer_cycle][0]=sizer(m_m2dData)-1;
					if (m_mData_buffer[iWithin_buffer_cycle][1]>(sizec(m_m2dData)-1)) m_mData_buffer[iWithin_buffer_cycle][1]=sizec(m_m2dData)-1;
						
				//	}
					 
					m_m2dData[(m_mData_buffer[iWithin_buffer_cycle][0])][(m_mData_buffer[iWithin_buffer_cycle][1])]++;
							
				}
				
			}
		
		}
		
		if (imod(sizer(mData_Added)+m_iBuffer_count,sizer(m_mData_buffer))==0)
		{
			m_iBuffer_count=0;
		}
		else
		{
			m_iBuffer_count=sizer(mData_Added)-(m_iBuffer_size-m_iBuffer_count)-(iBuf_cycle-2)*m_iBuffer_size;
			m_mData_buffer[:m_iBuffer_count-1][]=mData_Added[sizer(mData_Added)-m_iBuffer_count:][];
		}
		return(1);//??
	}
	else
	{
		//println(m_iBuffer_count);
		m_mData_buffer[m_iBuffer_count:m_iBuffer_count+sizer(mData_Added)-1][]=mData_Added;
		m_iBuffer_count+=sizer(mData_Added);
	
		return(2);
	}

}

//---------------------------------------------
// histo2d::  get_step() returns step length
//---------------------------------------------

histo2d::get_step_l()
{
return(m_dAxis_step);
}

//---------------------------------------------
// histo2d::  get_min_a() returns 
//---------------------------------------------

histo2d::get_min_a()
{
return(m_dAxis_min);
}

//---------------------------------------------
// histo2d::  returns approximate mode
//---------------------------------------------
histo2d::get_mode()
{
	decl histg,bsmooth,m1,mode;

	bsmooth=m_b_smooth_histogram;
	m_b_smooth_histogram=1;
	histg=this.get_histo1d(m_iHist_Nbars,m_dLeftTailQuantile);
	m_b_smooth_histogram=bsmooth;

	if (sizec(m_dAxis_step)!=1) return(<.>);

	mode=limits(histg[1:sizer(histg)-2][1]);
	mode=histg[1+mode[3][0]][0]~histg[1+mode[3][0]][1];

	return(mode);
   
//return ();
//return(limits(m_m2dData[1:sizer(m_m2dData)-2][])[3][].*m_dAxis_step+m_dAxis_min+m_dAxis_step);
}


//---------------------------------------------
// histo2d::  set buffer size (default 10000)
//---------------------------------------------
histo2d::set_buffer(const iNewBufferSize)
{
	m_iBuffer_size=iNewBufferSize;
}

//---------------------------------------------
// histo2d::  set buffer size (default 10000)
//---------------------------------------------

histo2d::get_part_histo1d(const i_dLowBd, const i_dUppBd)
{

if (sizec(m_dAxis_step)!=1) return(<.>);

return(range(i_dLowBd,i_dUppBd,m_dAxis_step)'~m_m2dData[(i_dLowBd-m_dAxis_min)./m_dAxis_step:(i_dUppBd-m_dAxis_min)./m_dAxis_step][]);


return(m_m2dData);
}

//---------------------------------------------
// histo2d::  set buffer size (default 10000)
//---------------------------------------------
histo2d::get_output()
{
return(m_m2dData'/get_real_iter());
}

//---------------------------------------------
// histo2d::  set_label
//---------------------------------------------
histo2d::set_label(const s_newL)
{

m_sOutputLabel=s_newL;
return(1);

}


//---------------------------------------------
// histo2d::  store_output
//---------------------------------------------
histo2d::store_output()
{
	if (m_sOutputLabel!=sprint(""))
	{
	savemat(sprint("HISTD_",m_sOutputLabel)~"_"~sprint(".mat"),(/*m_dAxis_step|m_dAxis_min|*/m_m2dData));
	}
	else return(-1);
	
return(1);
}

//---------------------------------------------
// histo2d::  restore_output
//---------------------------------------------
histo2d::restore_output(const sLbl1)
{
	decl aa1;
	
	if (m_sOutputLabel!=sprint(""))
	{
	aa1=loadmat(sprint("HISTD_",m_sOutputLabel)~"_"~sprint(".mat"));
	println(aa1[0][]);
	println(aa1[1][]);
	println(aa1[2][]);
	}
	else return(-1);

return(1);
}


//---------------------------------------------
// histo2d::  set buffer size (default 10000)
//---------------------------------------------



histo2d::get_axis(const i_axid)
{
decl m_dAxis, iRes;

m_dAxis=m_dAxis_min[0][i_axid-1]+range(-1,m_dAxis_ref[0][i_axid-1]-2)'*m_dAxis_step[0][i_axid-1];
m_dAxis[0][0]=-.Inf;

	if (m_dAxis_step[0][0]==0)
	{
	return(-1);
	}
	else
	{
	return(m_dAxis);
	}
}

//---------------------------------------------
// histo2d::  set buffer size (default 10000)
//---------------------------------------------



histo2d::get_real_iter()
{
return(floor(m_iIter/m_iBuffer_size)*m_iBuffer_size);
}


histo2d::get_quantile(const i_dQt)
{
if (sizec(m_dAxis_step)!=1) return (<.>);
if ((i_dQt<0)||(i_dQt>1)) return (<.>);

decl i_loopsearch=0, i_qt=0, i_Qtres;
i_Qtres=i_dQt*sumc(m_m2dData);
	while (i_qt<=i_Qtres)
	{
	i_qt=i_qt+m_m2dData[i_loopsearch][0];
	i_loopsearch++;
	}
	
return(m_dAxis_min+m_dAxis_step*(i_loopsearch-1));
}


histo2d::get_hpd(const d_cl)
{
	decl clevel,m1,m2,m3,cm,c,l1;

	if ((d_cl<0)||(d_cl>1))
	{
		return(M_NAN);
	}
	
	if (m_bTailsProcessed==0)
	{
		this.process_tails();
	}

	m1=m_mDens[1:][2]-m_mDens[:sizer(m_mDens)-2][2];
	m1=m1.*m_mDens[:sizer(m_mDens)-2][3];
	m2=m_mDens[:sizer(m_mDens)-2][3];
	c=maxc(m2);
	l1=1;
	m3=m2.>(c*l1/101);
		
	while(sumc(m3.*m1)>d_cl)
	{
		l1++;
		m3=m2.>(c*l1/101);
	}

	if (sumc(m3.*m1)==d_cl)
	{


	}
	else
	{
		c=(c*l1/101);
		l1=1001;
		m3=m2.>(c*l1/1001);

		while(sumc(m3.*m1)<d_cl)
		{
			l1--;
			m3=m2.>(c*l1/1001);
		}
	}

	c=1;
	cm=<1>;
	
	for (l1=0;l1<sizer(m3);l1++)
	{

		if (m3[l1][0]==c)
		{
			cm=cm|m_mDens[l1][1];
			c=(!c);
		}


	}

	if (sizer(cm)>1)
	{
	cm=cm[1:][];

	if (sizer(cm)>6)
	{
		cm=cm[:5][]|M_NAN;
	}

	return(cm);
	}
	else
	{

		savemat("mdens.xlsx", m_mDens);
		savemat("m1.xlsx", m1);
		savemat("m2.xlsx", m2);
		savemat("m3.xlsx", m3);
					
		return(<M_NAN,M_NAN>');
	}
	
}

//---------------------------------------------
// histo2d::get_histo1d  get histogram for one-dimensional variable
//---------------------------------------------

histo2d::get_histo1d(const i_iBarNum, const i_dTailProb)
{


if ((i_dTailProb<(max(m_dLeftTailQuantile~m_dRightTailQuantile)))||(i_dTailProb>0.5)) return(<.>);
if (sizec(m_dAxis_step)!=1) return(<.>);

decl i_begn_in=0, i_end_in=sizer(m_m2dData)-1, i_iMultp, m_dOutpHis, i_iSumLoop, i_iIter=1, m_dB0;

while (m_m2dData[i_begn_in][0]==0)	i_begn_in++;
while (m_m2dData[i_end_in][0]==0)	i_end_in--;


if(m_m2dData[0][0]==0)
	{
	m_dB0=0;
	}
else
	{
	i_begn_in=floor((this.get_quantile(i_dTailProb)-m_dAxis_min)/m_dAxis_step);

	if (i_begn_in<1)
		{
		i_begn_in=1;
		}

	m_dB0=sumc(m_m2dData[:i_begn_in-1][]);
	}

if(m_m2dData[sizer(m_m2dData)-1][0]==0)
	{
		i_end_in=floor((this.get_quantile(1-i_dTailProb)-m_dAxis_min)/m_dAxis_step);
	}
else
	{
		i_end_in=floor((this.get_quantile(1-i_dTailProb)-m_dAxis_min)/m_dAxis_step);

		if (i_end_in>(sizer(m_m2dData)-2))
		{
			i_end_in=sizer(m_m2dData)-2;
		}
	}			  

	i_iMultp=floor((i_end_in-i_begn_in+1)/i_iBarNum);

	m_dOutpHis=zeros(floor((i_end_in-i_begn_in+1)/i_iMultp)+2,2);
	

	m_vTCount[4][0]=i_begn_in-1;
	
for (i_iSumLoop=i_begn_in;i_iSumLoop<(i_end_in-i_iMultp+2);i_iSumLoop=i_iSumLoop+i_iMultp)

	{
		m_dOutpHis[i_iIter][1]=sumc(m_m2dData[i_iSumLoop:i_iSumLoop+i_iMultp-1][]);
		i_iIter++;
	}
	m_vTCount[4][1]=i_iSumLoop;
	
	m_dOutpHis[sizer(m_dOutpHis)-1][1]=sumc(m_m2dData[i_iSumLoop:][]);
	m_dOutpHis[0][1]=m_dB0;
	m_dOutpHis[0][0]=<-.Inf>;
	m_dOutpHis[1][0]=m_dAxis_min+m_dAxis_step*(i_begn_in)*(i_begn_in!=0);
	m_dOutpHis[2:sizer(m_dOutpHis)-1][0]=range(m_dOutpHis[1][0]+i_iMultp*m_dAxis_step,m_dOutpHis[1][0]+i_iMultp*i_iIter*m_dAxis_step,i_iMultp*m_dAxis_step)';

	m_vTCount[0][0]=sumc(m_dOutpHis[][1]);
	m_vTCount[2][0]=m_dOutpHis[0][1];
	m_vTCount[2][1]=m_dOutpHis[sizer(m_dOutpHis)-1][1];

	m_vTCount[3][0]=m_iLT_index;
	m_vTCount[3][1]=m_iRT_index;
	
	if (m_b_smooth_histogram==1)
	{
		m_dOutpHis[2:sizer(m_dOutpHis)-2][1]=spline(m_dOutpHis[1:sizer(m_dOutpHis)-2][1],0,0);
	}
	
	m_dOutpHis[][1]=m_dOutpHis[][1]/(sumc(m_dOutpHis[][1])*(m_dOutpHis[2][0]-m_dOutpHis[1][0]));
	
	
 
return(m_dOutpHis/*[][1]',m_dAxis_min+m_dAxis_step*i_begn_in,i_iMultp*m_dAxis_step*/);	
}

//---------------------------------------------
// histo2d::get_density  get value of pdf at arg
//---------------------------------------------

histo2d::get_density(const d_arg)
{

	decl m1,m2,c,dnsv,imin,imax;

	if (m_bTailsProcessed==0)
	{
		this.process_tails();
	}

	if ((d_arg<m_mDens[0][1])||(d_arg>m_mDens[sizer(m_mDens)-2][1]))
	{
		return(0);
	}

	m1=m_mDens[:sizer(m_mDens)-2][1].<d_arg;

	imin=sumc(m1)-2;
	imax=sumc(m1)+2;

	if (imin<0)
	{
		imin=0;
	}

	if (imax>(sizer(m_mDens)-2))
	{
		imax=sizer(m_mDens)-2;
	}

	m2=m_mDens[imin:sumc(m1)-1][:3];
	c=sizer(m2);
	m2=m2|(M_NAN~d_arg~M_NAN~M_NAN);
	
	if (m_mDens[sumc(m1)][1]==d_arg)
	{
	dnsv=m_mDens[sumc(m1)][3];

	}
	else
	{
		if (m_mDens[sumc(m1)][1]==d_arg)
		{
		m2=m2|m_mDens[sumc(m1)+1:imax][:3];
		}
		else
		{
			m2=m2|m_mDens[sumc(m1):imax][:3];
		}
	
	m1=spline(m2[][3],m2[][1],0);

	dnsv=m1[c][0];
	}
	/*
	dnsv=m_mDens[sumc(m1)-1][2];
	dnsv=dnsv+
	(d_arg-m_mDens[sumc(m1)-1][1])/(m_mDens[sumc(m1)][1]-m_mDens[sumc(m1)-1][1])*
	(m_mDens[sumc(m1)][2]-m_mDens[sumc(m1)-1][2]);
	*/
	
	//dnsv=histg[sumc(m1)][1]+(histg[sumc(m1)+1][1]-histg[sumc(m1)][1])*((d_arg-histg[sumc(m1)][0])/(histg[2][0]-histg[1][0]));
	//savemat("md.xlsx",m_m2dData);
	return(dnsv);
}

histo2d::get_rps(const d_arg)
{

decl m1,m2,c,dnsv,imin,imax;

	if (m_bTailsProcessed==0)
	{
		this.process_tails();
	}

	if ((d_arg<m_mDens[0][2])||(d_arg>m_mDens[sizer(m_mDens)-1][2]))
	{
		return(<.>);
	}

	m1=m_mDens[:sizer(m_mDens)-2][1].<d_arg;

	imin=sumc(m1)-2;
	imax=sumc(m1)+2;

	if (imin<0)
	{
		imin=0;
	}

	if (imax>(sizer(m_mDens)-2))
	{
		imax=sizer(m_mDens)-2;
	}

	m2=m_mDens[imin:sumc(m1)-1][1]~m_mDens[imin:sumc(m1)-1][5:6];
	c=sizer(m2);
	m2=m2|(d_arg~M_NAN~M_NAN);
	
	if (m_mDens[sumc(m1)][1]==d_arg)
	{
	dnsv=m_mDens[sumc(m1)][1]+m_mDens[sumc(m1)+1][2];
	//dop
	}
	else
	{
		if (m_mDens[sumc(m1)][1]==d_arg)
		{
					m2=m2|m_mDens[sumc(m1)+1:imax][1]~m_mDens[sumc(m1)+1:imax][5:6];
		}
		else
		{		 
			m2=m2|m_mDens[sumc(m1):imax][1]~m_mDens[sumc(m1):imax][5:6];
		}
	
	m1=spline(m2[][1],m2[][0],0)~spline(m2[][2],m2[][0],0);

	dnsv=m1[c][0]+m1[c][1];
	}
	/*
	dnsv=m_mDens[sumc(m1)-1][2];
	dnsv=dnsv+
	(d_arg-m_mDens[sumc(m1)-1][1])/(m_mDens[sumc(m1)][1]-m_mDens[sumc(m1)-1][1])*
	(m_mDens[sumc(m1)][2]-m_mDens[sumc(m1)-1][2]);
	*/
	
	//dnsv=histg[sumc(m1)][1]+(histg[sumc(m1)+1][1]-histg[sumc(m1)][1])*((d_arg-histg[sumc(m1)][0])/(histg[2][0]-histg[1][0]));
	//savemat("md.xlsx",m_m2dData);
	return(dnsv);
}

histo2d::get_cdf(const d_arg)
{

decl m1,m2,c,dnsv,imin,imax;

	if (m_bTailsProcessed==0)
	{
		this.process_tails();
	}

	if (d_arg<m_mDens[0][2])
	{
		return(0);
	}

	if (d_arg>m_mDens[sizer(m_mDens)-1][2])
	{
		return(1);
	}
	
	m1=m_mDens[:sizer(m_mDens)-2][1].<d_arg;

	imin=sumc(m1)-2;
	imax=sumc(m1)+2;

	if (imin<0)
	{
		imin=0;
	}

	if (imax>(sizer(m_mDens)-2))
	{
		imax=sizer(m_mDens)-2;
	}

	m2=m_mDens[imin:sumc(m1)-1][1]~m_mDens[imin:sumc(m1)-1][4];
	c=sizer(m2);
	m2=m2|(d_arg~M_NAN);
	
	if (m_mDens[sumc(m1)][1]==d_arg)
	{
	dnsv=m_mDens[sumc(m1)][1]+m_mDens[sumc(m1)+1][4];
	//dop
	}
	else
	{
		if (m_mDens[sumc(m1)][1]==d_arg)
		{
					m2=m2|m_mDens[sumc(m1)+1:imax][1]~m_mDens[sumc(m1)+1:imax][4];
		}
		else
		{		 
			m2=m2|m_mDens[sumc(m1):imax][1]~m_mDens[sumc(m1):imax][4];
		}
	
	m1=spline(m2[][1],m2[][0],0);

	dnsv=m1[c][0];
	}
	/*
	dnsv=m_mDens[sumc(m1)-1][2];
	dnsv=dnsv+
	(d_arg-m_mDens[sumc(m1)-1][1])/(m_mDens[sumc(m1)][1]-m_mDens[sumc(m1)-1][1])*
	(m_mDens[sumc(m1)][2]-m_mDens[sumc(m1)-1][2]);
	*/
	
	//dnsv=histg[sumc(m1)][1]+(histg[sumc(m1)+1][1]-histg[sumc(m1)][1])*((d_arg-histg[sumc(m1)][0])/(histg[2][0]-histg[1][0]));
	//savemat("md.xlsx",m_m2dData);
	return(dnsv);
}

histo2d::process_tails()
{
	decl b,q,histg,bsmooth,l1,l2,u1,u2,u3,u4,stp,dnsv,mLT1,mLT2,mRT1,mRT2,fmult,cstep,m_tmp,t1,mdens;
	
	fmult=6;
	bsmooth=m_b_smooth_histogram;
	m_b_smooth_histogram=0;

	histg=this.get_histo1d(m_iHist_Nbars,m_dLeftTailQuantile);

/*	savemat("hhg.xlsx",histg);
	savemat("md.xlsx", m_m2dData);
	savemat("tails.xlsx", m_vLeft_tail_obs~m_vRight_tail_obs);
	println("m_vTCount", m_vTCount);
*/	
	m_b_smooth_histogram=bsmooth;

	m_iLT_bars=floor(sumr(m_vTCount[2][])*m_iHist_Nbars/(m_vTCount[0][0]-sumr(m_vTCount[2][])))*50;

	
	m_iRT_bars=floor(m_vTCount[2][1]/sumr(m_vTCount[2][])*m_iLT_bars);
	m_iLT_bars=floor(m_vTCount[2][0]/sumr(m_vTCount[2][])*m_iLT_bars);

	
	mLT1=floor((m_vTCount[2][0]-m_vTCount[3][0])/m_vTCount[2][0]*m_iLT_bars);

	if (mLT1>0)
	{
		mLT1=zeros(3,mLT1+1);
	}
	else
	{
		mLT1=<.>;
	}

	mLT2=(m_iLT_bars-floor((m_vTCount[2][0]-m_vTCount[3][0])/m_vTCount[2][0]*m_iLT_bars))*4;

	if ((mLT2>0)&&(m_iLT_index>0))
	{
		mLT2=zeros(3,mLT2+1);
	}
	else
	{
		mLT2=<.>;
	}

	mRT1=floor((m_vTCount[2][1]-m_vTCount[3][1])/m_vTCount[2][1]*m_iRT_bars);

	if (mRT1>0)
	{
		mRT1=zeros(3,mRT1+1);
	}
	else
	{
		mRT1=<.>;
	}

	mRT2=(m_iRT_bars-floor((m_vTCount[2][1]-m_vTCount[3][1])/m_vTCount[2][1]*m_iRT_bars))*4;

	if ((mRT2>0)&&(m_iRT_index>0))
	{
		mRT2=zeros(3,mRT2+1);
	}
	else
	{
		mRT2=<.>;
	}
	
/*	println("LT2:. ", sizec(mLT2));
	println("RT2:. ", sizec(mRT2));
		
	println("LT1:. ", sizec(mLT1));
	println("RT1:. ", sizec(mRT1));
  */

	if (sizer(mLT1)>1)
	{

		mLT1=sizec(mLT1);
		
		m_tmp=<0>|<0>|<0>|histg[1][0];

		u3=histg[1][0];

		cstep=((mLT1-1)^2)/fmult+(mLT1-1)/2+((mLT1-1)^2)/2;
		cstep=(m_vTCount[2][0]-m_vTCount[3][0])/cstep;
				
		stp=floor(
		(mLT1-1)*cstep/fmult+(mLT1-1)*cstep
		);

	
		l2=0;
		u2=0;
		u1=0;
		l1=0;
		u4=M_NAN;
		
		while ((m_vTCount[4][0]-l2)>0)
		{
			u1=m_m2dData[(m_vTCount[4][0]-l2)][];
			u2=0;
			u3=u3-m_dAxis_step;

			if (m_m2dData[(m_vTCount[4][1]-l2)][]>0)
			{
				u4=u3;
			}
			
			l2++;
			
			if (u1>stp)
			{
			}
			else
			{

				while ((u1+m_m2dData[(m_vTCount[4][0]-l2)][]<stp)&&(((m_vTCount[4][0]-l2)>1)))
				{
		   			u1=u1+m_m2dData[(m_vTCount[4][0]-l2)][];
				
					u3=u3-m_dAxis_step;

					if (m_m2dData[(m_vTCount[4][1]-l2)][]>0)
					{
						u4=u3;
					}
						l2++;
					//println(stp);
				}
				u3=u3-m_dAxis_step;
				u1=u1+m_m2dData[(m_vTCount[4][0]-l2)][];

				if (m_m2dData[(m_vTCount[4][1]-l2)][]>0)
				{
					u4=u3;
				}
				
				l2++;
			}

			m_tmp=(<0>|<0>|u1|u3)~m_tmp;
			
			if ((m_vTCount[4][0]-l2)==0)
			{
				l1=l1+(mLT1);
				m_tmp[3][0]=u4;

				if (u1==0)
				{
				m_tmp=m_tmp[][1:sizec(m_tmp)-1];
				}
			}

		stp=floor(
		(mLT1-1)*cstep/fmult+(mLT1-1)*cstep-l1*1.05*cstep
		);

		if (stp<5)
		{
			stp=5;
		}

		l1++;	
			
		}
		mLT1=m_tmp;

		for (l1=0;l1<sizec(mLT1)-1;l1++)
		{
			mLT1[1][l1]=(mLT1[3][l1]+mLT1[3][l1+1])/2;
			mLT1[0][l1]=(mLT1[3][l1+1]-mLT1[3][l1]);
			mLT1[0][l1]=mLT1[2][l1]/(m_vTCount[0][0]*mLT1[0][l1]);
		}

		for (l1=0;l1<sizec(mLT1)-1;l1++)
		{
//		mLT1[3][l1]=denskernel(mLT1[1][l1],sprint("g"));
		}
																				 
		savemat("l_1.xlsx",mLT1);
	}

	if (sizer(mRT1)>1)
	{

		mRT1=sizec(mRT1);
		
		m_tmp=<0>|<0>|<0>|histg[sizer(histg)-1][0];

		//mLT1[2][sizec(mLT1)-1]=histg[1][0];
		u3=histg[sizer(histg)-1][0];
			
		cstep=((mRT1-1)^2)/fmult+(mRT1-1)/2+((mRT1-1)^2)/2;
		cstep=(m_vTCount[2][1]-m_vTCount[3][1])/cstep;
				
		stp=floor(
		(mRT1-1)*cstep/fmult+(mRT1-1)*cstep
		);

	
		l2=0;
		u2=0;
		u1=0;
		l1=0;
		u4=M_NAN;

		
		while ((m_vTCount[4][1]+l2)<(sizer(m_m2dData)-2))
		{
			u1=m_m2dData[(m_vTCount[4][1]+l2)][];
			u2=0;
			u3=u3+m_dAxis_step;

			if (m_m2dData[(m_vTCount[4][1]+l2)][]>0)
			{
			u4=u3;
			}
			
			l2++;
			
			if (u1>stp)
			{
			}
			else
			{

				while ((u1+m_m2dData[(m_vTCount[4][1]+l2)][]<stp)&&(((m_vTCount[4][1]+l2)<(sizer(m_m2dData)-2))))
				{
		   			u1=u1+m_m2dData[(m_vTCount[4][1]+l2)][];
					u3=u3+m_dAxis_step;

					if (m_m2dData[(m_vTCount[4][1]+l2)][]>0)

					{
						u4=u3;
					}
					l2++;
					
	
				}
				u3=u3+m_dAxis_step;
				u1=u1+m_m2dData[(m_vTCount[4][1]+l2)][];

				if (m_m2dData[(m_vTCount[4][1]+l2)][]>0)
				{
					u4=u3;
				}
				
				l2++;
			}

			m_tmp=m_tmp~(<0>|<0>|u1|u3);
			
			if ((m_vTCount[4][1]+l2)==(sizer(m_m2dData)-1))
			{
				l1=l1+(mRT1);
									
				m_tmp[3][sizec(m_tmp)-1]=u4;
				
				if (u1==0)
				{
				m_tmp=m_tmp[][0:sizec(m_tmp)-2];
				}
			}

		stp=floor(
		(mRT1-1)*cstep/fmult+(mRT1-1)*cstep-l1*1.05*cstep
		);

		if (stp<5)
		{
			stp=5;
		}

		l1++;	
			
		}
		mRT1=m_tmp;

		for (l1=1;l1<sizec(mRT1);l1++)
		{
			mRT1[1][l1]=(mRT1[3][l1-1]+mRT1[3][l1])/2;
			mRT1[0][l1]=(mRT1[3][l1]-mRT1[3][l1-1]);
			mRT1[0][l1]=mRT1[2][l1]/(m_vTCount[0][0]*mRT1[0][l1]);
		}


		for (l1=1;l1<sizec(mRT1);l1++)
		{
//			mRT1[3][l1]=denskernel(mRT1[1][l1],sprint("g"));
		}


		
		savemat("r_1.xlsx",mRT1);
	}

	if (sizer(mRT2)>1)
	{
		mRT2=sizec(mRT2)-2;
	//	println("RT@@",mRT2);
		if (sizer(mRT1)>1)
		{
			m_tmp=<0>|<0>|<0>|mRT1[3][sizec(mRT1)-1];
		}
		else
		{
			m_tmp=<0>|<0>|<0>|histg[sizer(histg)-1][0];
		}
		
		t1=m_vRight_tail_obs[:m_iRT_index-1][0];
		t1=sortc(t1);
		
		cstep=(sizer(t1)/(mRT2^2/2+mRT2/2+mRT2/fmult));


		stp=floor(cstep*mRT2*(1/fmult+1));
		
		l2=0;
		l1=0;
		u1=0;
		u2=0;
		
		while(l2<(sizer(t1)))
		{
			u1=u1+t1[l2][0];
			l1++;

			if (l1==stp)
			{

				m_tmp=m_tmp~(<0>|<0>|l1|t1[l2][0]);

				u2++;
				
				stp=floor(cstep*mRT2*(1/fmult+1)-u2*cstep*1.33);
				if (stp<5)
				{
					stp=5;
				}
			 	l1=0;			
			}
			l2++;
			
		}

		if (l1>0)
		{
			m_tmp=m_tmp~(<0>|<0>|l1|t1[sizer(t1)-1][0]);
		}
	
		mRT2=m_tmp;

		for (l1=1;l1<sizec(mRT2);l1++)
		{
			mRT2[1][l1]=(mRT2[3][l1-1]+mRT2[3][l1])/2;
			mRT2[0][l1]=(mRT2[3][l1]-mRT2[3][l1-1]);
			mRT2[0][l1]=mRT2[2][l1]/(m_vTCount[0][0]*mRT2[0][l1]);
		}

		for (l1=1;l1<sizec(mRT2);l1++)
		{
//		mRT2[3][l1]=denskernel(mRT2[1][l1],sprint("g"));
		}

		savemat("r_2.xlsx", mRT2);
	}
	
	if (sizer(mLT2)>1)
	{
		mLT2=sizec(mLT2)-2;
	//	println("LT@@",mLT2);

		if (sizer(mLT1)>1)
		{
			m_tmp=<0>|<0>|<0>|mLT1[3][0];
		}
		else
		{
			m_tmp=<0>|<0>|<0>|histg[1][0];
		}
		t1=m_vLeft_tail_obs[:m_iLT_index-1][0];
		t1=reversec(sortc(t1));

		cstep=(sizer(t1)/(mLT2^2/2+mLT2/2+mLT2/fmult));


		stp=floor(cstep*mLT2*(1/fmult+1));
		
		l2=0;
		l1=0;
		u1=0;
		u2=0;
		
		while(l2<(sizer(t1)))
		{
			u1=u1+t1[l2][0];
			l1++;

			if (l1==stp)
			{

				m_tmp=(<0>|<0>|l1|t1[l2][0])~m_tmp;

				u2++;
				
				stp=floor(cstep*mLT2*(1/fmult+1)-u2*cstep*1.33);
				if (stp<5)
				{
					stp=5;
				}
			 	l1=0;			
			}
			l2++;
			
		}

		if (l1>0)
		{
			m_tmp=(<0>|<0>|l1|t1[sizer(t1)-1][0])~m_tmp;
		}
	
		mLT2=m_tmp;

		for (l1=0;l1<(sizec(mLT2)-1);l1++)
		{
			mLT2[1][l1]=(mLT2[3][l1]+mLT2[3][l1+1])/2;
			mLT2[0][l1]=(mLT2[3][l1+1]-mLT2[3][l1]);
			mLT2[0][l1]=mLT2[2][l1]/(m_vTCount[0][0]*mLT2[0][l1]);
		}
		for (l1=0;l1<(sizec(mLT2)-1);l1++)
		{
//		mLT2[3][l1]=denskernel(mLT2[1][l1],sprint("g"));
		}
	
	savemat("l_2.xlsx",mLT2);
	}
	mdens=<1>~<1>~<1>;

	if (sizer(mLT2)>1)
	{
		mdens=mdens|(mLT2[:1][:sizec(mLT2)-2]'~mLT2[3][:sizec(mLT2)-2]');
	}

	if ((sizer(mLT1)>1)&&(sizec(mLT1)>1))
	{
		mdens=mdens|(mLT1[:1][:sizec(mLT1)-2]'~mLT1[3][:sizec(mLT1)-2]');
	}

	m_tmp=histg[1:sizer(histg)-2][0]+histg[2:sizer(histg)-1][0];
	m_tmp=m_tmp/2;
	m_tmp=histg[1:sizer(histg)-2][1]~m_tmp~histg[1:sizer(histg)-2][0];
	
	mdens=mdens|m_tmp;
	
	if ((sizer(mRT1)>1)&&(sizec(mRT1)>1))
	{
		mdens=mdens|(mRT1[:1][1:]'~mRT1[3][0:sizec(mRT1)-2]');
	}
	else
	{
		mdens=mdens|(zeros(1,2)~histg[sizer(histg)-1][0]);
		
	}

	if (sizer(mRT2)>1)
	{
		mdens=mdens|((mRT2[:1][1:]'|zeros(1,2))~mRT2[3][]');
	}
	mdens=mdens[1:][];

	if ((minc(mdens[:sizer(mdens)-2][0]))>0)
	{
		mdens=mdens~(exp(spline(log(mdens[:sizer(mdens)-2][0]),mdens[:sizer(mdens)-2][1],0))|<0>);
	}
	else
	{
		mdens=mdens~((spline((mdens[:sizer(mdens)-2][0]).^0.5,mdens[:sizer(mdens)-2][1],0).^2)|<0>);
	}

	mdens=mdens~zeros(sizer(mdens),3);
	
	mdens[0][4]=(mdens[1][2]-mdens[0][2])*mdens[0][3];
	
	for (l1=1;l1<sizer(mdens)-1;l1++)
	{
  		mdens[l1][4]=mdens[l1-1][4]+(mdens[l1+1][2]-mdens[l1][2])*mdens[l1][3];

	}

	mdens[][3]=mdens[][3]./mdens[sizer(mdens)-2][4];
	mdens[0][4]=(mdens[1][2]-mdens[0][2])*mdens[0][3];
	mdens[0][5]=(mdens[1][2]-mdens[0][2])*mdens[0][4];
	mdens[0][6]=(mdens[1][2]-mdens[0][2])*(1-mdens[0][4]);
	
	for (l1=1;l1<sizer(mdens)-1;l1++)
	{
  		mdens[l1][4]=mdens[l1-1][4]+(mdens[l1+1][2]-mdens[l1][2])*mdens[l1][3];
		mdens[l1][5]=mdens[l1-1][5]+(mdens[l1+1][2]-mdens[l1][2])*mdens[l1][4]^2;
		mdens[l1][6]=(mdens[l1+1][2]-mdens[l1][2])*(1-mdens[l1][4])^2;
	}

	for (l1=sizer(mdens)-2;l1>-1;l1=l1-1)
	{
		mdens[l1][6]=mdens[l1][6]+mdens[l1+1][6];
	}
	
	m_mDens=mdens;
	m_bTailsProcessed=1;
	
return(m_iLT_bars);
		
}