#include <oxstd.h>

garchPOS::garchPOS(const s_file_label,i_var_number)
{

	decl data,load_mat,vn,first_obs,last_obs,i_l1,i_l2,i_l3;


	//// loading dataset
	
	load_mat=loadmat(s_file_label~sprint(".xls"), &vn);
	
	if (load_mat==0)
	{
		println ("WARNING! failed to open data file ", s_file_label);
	}
	
	first_obs=load_mat[0][i_var_number];
	last_obs=load_mat[1][i_var_number];
		
	m_sDataLabel=vn[i_var_number]~sprint(last_obs-first_obs);
	m_mData=load_mat[11+first_obs:9+last_obs][i_var_number];
	m_d_Y0=load_mat[10+first_obs][i_var_number];
	m_iT=sizer(m_mData);

	m_mAllData=m_d_Y0|m_mData;  
	
	m_d_apha_known=0;
	m_d_ni_known=250;
	m_d_e0_known=0;
	m_d_h0_known=0;
	m_d_ni_max=250;

	m_i_kernel_mode=0;
	
	println("===========  THE DATA  ===========");
	println("Analyzing ", m_sDataLabel);
	println("First modelled observation: ", m_mData[0][]);
	println("Last observation: ", m_mData[m_iT-1][]);
	println("No of modelled observations: ", m_iT);
	println("initial condition y0: ", m_d_Y0);
	println("==================================");	

	m_i_FIni=1000;
	m_m_ini_eps=loadmat("initial.xls",&vn);

	m_iBasicCycle=250000+2;
	m_iNumCycles=1;
	m_iNRsc=-16665;
	m_d_lim_corr_ht=0.99999;
	m_b_get_quantiles=1;
	
	m_d_delta_PriorPrec=1;
	m_d_delta_PriorDF=2;
	m_d_rho_min=-1;
	m_d_rho_max=1;
	m_d_alpha0_PriorA=1;
	m_d_alpha0_PriorB=1/200;
	m_d_lambda_PriorPrec=1;
	m_d_lambda_PriorDF=2;
	m_d_ni_PriorA=1;
	m_d_ni_PriorB=1/10;
	m_d_alpha00_PriorPrec=1;
	m_d_alpha00_PriorDF=3;
	m_d_e0_PriorPrec=0.1;
	m_d_e0_PriorDF=2;
	m_d_h0_PriorA=1;
	m_d_h0_PriorB=1/200;
	m_d_gamma_PriorPrec=1;
	m_d_gamma_PriorDF=1;
	
	m_i_e0_mode=0;
	m_i_h0_mode=0; 				
	m_i_GJR_mode=0;
	m_i_FIGARCH_mode=1;
	m_i_ni_par=2;				
	m_i_ni_mode=0;				
	m_i_alpha_mode=1;			
	m_i_eta_par=0;				
	m_i_inMean_mode=2;	//2!

	m_d_apha_known=0;
	m_d_ni_known=250;
	m_d_e0_known=0;
	m_d_h0_known=1;
	m_d_ni_min=2.001;
	m_d_PhiLTrunc=3*M_PI/m_iT;
	m_d_PhiRTrunc=0.025;

	println("PI L", m_d_PhiLTrunc);
	println("PI R", m_d_PhiRTrunc);
	
	m_v_cd_quantiles=<0.001,0.005,0.01,0.05,0.1>;
	m_v_cd_quantiles=m_v_cd_quantiles~(<1>-m_v_cd_quantiles);
	println(m_v_cd_quantiles);
	m_i_NF=1;

	
	if (m_i_NF>0)
	{
		m_m_Freq_Config=zeros(2,m_i_NF);
		m_m_Freq_Config[0][]=<1>;//,1,1>;
		m_m_Freq_Config[1][]=<4>;//3,2>;
		m_av_Common_Amplitudes=new array [m_i_NF];
		m_av_Common_Amplitudes[0]=<2>;//,5>;
//		m_av_Common_Amplitudes[1]=<4>;
//		m_av_Common_Amplitudes[2]=<5>;
//		m_av_Common_Amplitudes[3]=<5>;
		
		m_m_Amplitude_Config=zeros(sumr(m_m_Freq_Config[0][]),m_i_NF);
		m_m_AC=zeros(sumr(m_m_Freq_Config[0][]),4);
		
		m_m_Cycle_Config=zeros(5,sizer(m_m_Amplitude_Config));
		

		i_l3=0;

			
		for (i_l1=0;i_l1<max(m_m_Freq_Config[0][]);i_l1++)
		{

			for (i_l2=0;i_l2<m_i_NF;i_l2++)
			{
				
				if (m_m_Freq_Config[0][i_l2]>i_l1)
				{
					m_m_Amplitude_Config[i_l3][i_l2]=1;
					m_m_Cycle_Config[(m_av_Common_Amplitudes[i_l2])[0][i_l1]-1][i_l3]=1;
					m_m_AC[i_l3][0]=i_l2+1;
					m_m_AC[i_l3][1]=m_m_Freq_Config[1][i_l2];
					
					i_l3++;
				}
			
			}
						
		}

		m_m_scale_amp=<0.15,1,1,2,2>';
		
		
		
		m_m_AC[0][3]=m_m_AC[0][1]-1;		

		m_ik1=sizer(m_m_AC);
		
		for (i_l1=1;i_l1<m_ik1;i_l1++)
		{
			m_m_AC[i_l1][2]=m_m_AC[i_l1-1][3]+1;
			m_m_AC[i_l1][3]=m_m_AC[i_l1-1][3]+m_m_AC[i_l1][1];		
		}

		println(m_m_Amplitude_Config);
		println(m_m_Cycle_Config);
		println(m_m_AC);

		m_mXr=new array [m_i_NF];
		
		for (i_l1=0;i_l1<m_i_NF;i_l1++)
		{
			m_mXr[i_l1]=range(0,m_iT,1)';

			for (i_l2=1;i_l2<m_m_AC[i_l1][1];i_l2++)
			{
				m_mXr[i_l1]=m_mXr[i_l1]~range(0,m_iT,1)';
			}

		}
			
	}
	
}

garchPOS::posterior_kernel(const vP, const adFunc, const avScore, const amHessian)
{

	decl delta_, rho_, alpha0_, alpha1_, beta1_, alpha2_, lambda1_, eta_, ni10_, ni20_, alpha00_, eps0_,h0_,
		 prior_logKer,logLik,gamma_s_,gamma_c_,phi_,i_obs,mv_amp,d_,fi1_,
		 mT1,mT2,mTPAR,mTPAR_2,mTPAR_3,m_cut_ni,m_z_ni,m_sel,ct_bar,v_exc,h_eps_,
		 c1,c2,c3,n_gam,c_p1,c_p2,c_p3,c_p4,m_Tquant,m_T_a1,m_T_a2,m_T_a3,m_T_a4,m_FP,l_1,min_flag_;

		 
	if (m_i_FIGARCH_mode==1)
	{
		m_FP=zeros(m_i_FIni,3);
		h_eps_=reversec(m_m_ini_eps);
		h_eps_=h_eps_[][1];
		h_eps_=h_eps_.^2;
	}
		
	m_cut_ni=(0.01+m_d_ni_max)*ones(m_iT+1,2);
	mv_amp=<1>;
	v_exc=zeros(1,3);
	mT2=zeros(m_iT+1,5);
	mTPAR=mT2;
	mTPAR_2=zeros(m_iT+1,5);
	mTPAR_3=zeros(m_iT+1,5);
	
	prior_logKer=0;
	logLik=0;
	c1=5;

	
	if (m_i_Est_Mode==0)
	{
	//===============================================

		if (m_i_NF>0)
		{
			m_i_iParBasic_Num=5+m_i_e0_mode+m_i_h0_mode+m_i_FIGARCH_mode+m_i_GJR_mode+m_i_ni_par+m_i_alpha_mode+m_i_eta_par+(m_i_inMean_mode>0)+sumc(m_m_Freq_Config[1][]')+2*sumc(m_m_Amplitude_Config*m_m_Freq_Config[1][]');
		}
		else
		{
			m_i_iParBasic_Num=5+m_i_e0_mode+m_i_h0_mode+m_i_GJR_mode+m_i_FIGARCH_mode+m_i_ni_par+m_i_alpha_mode+m_i_eta_par+(m_i_inMean_mode>0);
		}

		m_sel=zeros(5+m_i_e0_mode+m_i_h0_mode+m_i_GJR_mode+m_i_FIGARCH_mode+m_i_ni_par+m_i_alpha_mode+m_i_eta_par+(m_i_inMean_mode>0),11);

		if (m_i_FIGARCH_mode==0)
		{
			ct_bar=ones(1,5)~m_i_GJR_mode~(m_i_inMean_mode>0);
		}
		else
		{
			ct_bar=ones(1,5)~m_i_FIGARCH_mode~(m_i_inMean_mode>0);
		}

		
		if (m_i_ni_par==2)
		{
			ct_bar=ct_bar~<1,1>;
		}
		else
		{
			if (m_i_ni_par==1)
			{
				ct_bar=ct_bar~<1,0>;
			}
			else
			{
				ct_bar=ct_bar~<0,0>;
			}

		}

		ct_bar=ct_bar~m_i_alpha_mode~m_i_h0_mode;
		c2=0;
		
		for (c1=0;c1<11;c1++)
		{
			if (ct_bar[0][c1]==1)
			{
			m_sel[c2][c1]=1;
			c2++;
			}

		}

		if (m_i_NF>0)
		{

			for (c1=0;c1<sizer(m_m_Amplitude_Config);c1++)
			{
				for (c2=0;c2<sizec(m_m_Amplitude_Config);c2++)
				{
					if(m_m_Amplitude_Config[c1][c2]==1)
					{
						for(c3=0;c3<5;c3++)
						{
							if (m_m_Cycle_Config[c3][c1]==1)
							{
								mv_amp=mv_amp|(ones(m_m_Freq_Config[1][c2],1)*m_m_scale_amp[c3][0]);

							}
						}
					}				
				}
			}

			mv_amp=mv_amp[1:][];
			mv_amp=mv_amp|mv_amp;

				
			m_m_sPar_Groups=zeros(2+m_i_NF,9);
			m_m_sPar_Groups[0][0]=5+m_i_e0_mode+m_i_h0_mode+m_i_GJR_mode+m_i_FIGARCH_mode+m_i_ni_par+m_i_alpha_mode+m_i_eta_par+(m_i_inMean_mode>0);
			m_m_sPar_Groups[1][0]=2*sumc(m_m_Amplitude_Config*m_m_Freq_Config[1][]');
		

			m_m_sPar_Groups[0][1]=0;
			m_m_sPar_Groups[1][1]=m_m_sPar_Groups[0][0];


			m_m_sPar_Groups[0][2]=m_m_sPar_Groups[0][0]-1;
			m_m_sPar_Groups[1][2]=m_m_sPar_Groups[0][0]+m_m_sPar_Groups[1][0]-1;

			m_m_sPar_Groups[0][3]=1;
			m_m_sPar_Groups[1][3]=1;

			m_m_sPar_Groups[0][4]=1;
			m_m_sPar_Groups[1][4]=0;

			m_m_sPar_Groups[0][5]=0.05;
			m_m_sPar_Groups[1][5]=0.001;
	
			m_m_sPar_Groups[0][6]=0.1;
			m_m_sPar_Groups[1][6]=0.005;
	
			m_m_sPar_Groups[0][7]=0.1;
			m_m_sPar_Groups[1][7]=0.01;
	
			m_m_sPar_Groups[0][8]=0.2;
			m_m_sPar_Groups[1][8]=0.05;


			for (c1=0;c1<m_i_NF;c1++)
			{
		

				m_m_sPar_Groups[2+c1][0]=m_m_Freq_Config[1][c1];
				m_m_sPar_Groups[2+c1][1]=sumc(m_m_sPar_Groups[:2+c1-1][0]);
				m_m_sPar_Groups[2+c1][2]=sumc(m_m_sPar_Groups[:2+c1][0])-1;		
				m_m_sPar_Groups[2+c1][3]=1;
				m_m_sPar_Groups[2+c1][4]=0;
				m_m_sPar_Groups[2+c1][5]=0.001;
				m_m_sPar_Groups[2+c1][6]=0.01;
				m_m_sPar_Groups[2+c1][7]=0.025;
				m_m_sPar_Groups[2+c1][8]=0.4;

			}

			println(m_m_sPar_Groups);
		
		}

		else
		{
			m_m_sPar_Groups=zeros(1,9);
			m_m_sPar_Groups[0][0]=5+m_i_e0_mode+m_i_h0_mode+m_i_GJR_mode+m_i_FIGARCH_mode+m_i_ni_par+m_i_alpha_mode+m_i_eta_par+(m_i_inMean_mode>0);
			m_m_sPar_Groups[0][1]=0;
			m_m_sPar_Groups[0][2]=m_m_sPar_Groups[0][0]-1;
			m_m_sPar_Groups[0][3]=1;
			m_m_sPar_Groups[0][4]=1;
			m_m_sPar_Groups[0][5]=0.05;
			m_m_sPar_Groups[0][6]=0.1;
			m_m_sPar_Groups[0][7]=0.1;
			m_m_sPar_Groups[0][8]=0.5;
		}
				
		m_am_Draw_Cvm = new array [sizer(m_m_sPar_Groups)];

		for (c1=0;c1<sizer(m_m_sPar_Groups);c1++)
		{
			if (m_m_sPar_Groups[c1][4]==1)
			{
				m_am_Draw_Cvm[c1]=loadmat("drawcvm"~sprint(c1)~".xlsx");
				m_am_Draw_Cvm[c1]=m_sel*m_am_Draw_Cvm[c1]*m_sel';
				m_am_Draw_Cvm[c1]=choleski(m_am_Draw_Cvm[c1]);
			}
			else
			{
				if (c1==1)
				{
					m_am_Draw_Cvm[c1]=diag(mv_amp);
				}
				
				else
				{
					m_am_Draw_Cvm[c1]=unit(m_m_sPar_Groups[c1][0]);
				}
			}
		}

		
		m_m_iPar_Groups=m_m_sPar_Groups;


		m_as_probLabels=new array [(m_i_inMean_mode>0)+(m_i_ni_par==2)+m_i_GJR_mode+m_i_FIGARCH_mode+(m_i_FIGARCH_mode==0)*m_i_alpha_mode+1];

		if (m_i_NF>0)
		{
			m_as_addPar_Labels=new array [3+m_i_GJR_mode+m_i_FIGARCH_mode+(m_i_ni_par==2)+sumr(m_m_Freq_Config[1][])];
		}
		else
		{
			m_as_addPar_Labels=new array [3+m_i_GJR_mode+m_i_FIGARCH_mode+(m_i_ni_par==2)];				
		}
		m_as_probLabels[0]="(a1+a2)/2+b1 > 1";
		m_as_addPar_Labels[0]="(a1+a2)/2+b1";
		m_as_addPar_Labels[1]="a0/[1-(a1+a2)/2-b1]";
		m_as_addPar_Labels[2]="[a0/(1-(a1+a2)/2-b1)]^0.5";
		
		c1=1;

		if (m_i_GJR_mode>0)
		{
			m_as_probLabels[c1]="alpha1 <= alpha2";
			m_as_addPar_Labels[2+c1]="alpha1/alpha2";
			c1++;
		}

		if (m_i_FIGARCH_mode==0)
		{
			//PRZEROBIC!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
			m_as_probLabels[c1]="alpha1 <= alpha2";
			m_as_addPar_Labels[2+c1]="alpha1/alpha2";
			c1++;
		}

		if (m_i_inMean_mode>0)
		{
			m_as_probLabels[c1]="lambda1 <= 0";
			c1++;
		}
		
		if (m_i_ni_par==2)
		{
			m_as_probLabels[c1]="ni1 >= ni2";
			m_as_addPar_Labels[2+c1-(m_i_inMean_mode>0)]="ni2/ni1";
			c1++;
		}

		if (m_i_alpha_mode==1)
		{
			m_as_probLabels[c1]="a00 < 0.5";
			c1++;
		}

		if (m_i_NF>0)
		{
			for (c1=0;c1<sumr(m_m_Freq_Config[1][]);c1++)
			{
				 m_as_addPar_Labels[2+(m_i_GJR_mode>0)+(m_i_FIGARCH_mode>0)+(m_i_inMean_mode>0)+(m_i_ni_par==2)+c1]="per_"~sprint(c1+1);
			}
		}
		m_as_iPar_Labels=new array [m_i_iParBasic_Num];
		m_as_iTHPar_Labels=new array[4+(m_i_inMean_mode>0)];

		m_as_iTHPar_Labels[0] = "ni1,t";
		m_as_iTHPar_Labels[1] = "ni2,t";
		m_as_iTHPar_Labels[2] = "[a0/(1-(a1+a2)/2-b1)*exp(f_v(t))]";
		m_as_iTHPar_Labels[3] = "[a0/(1-(a1+a2)/2-b1)*exp(f_v(t))]^0.5";

		if (m_i_inMean_mode>0)
		{
			m_as_iTHPar_Labels[4]="lambda * [exp(f_v(t))]^0.5";
		}

		
		m_as_iTPar_Labels=new array [14+2*(m_i_inMean_mode>0)+m_b_get_quantiles*2.5*sizec(m_v_cd_quantiles)];


		m_as_iTPar_Labels[0]="f_e(t)";
		m_as_iTPar_Labels[1]="exp(f_v(t))";
		m_as_iTPar_Labels[2]="alpha (t)";
		m_as_iTPar_Labels[3]="ni1 (t)";
		m_as_iTPar_Labels[4]="ni2 (t)";
		m_as_iTPar_Labels[5]="[exp(f_v(t))]^0.5";
		m_as_iTPar_Labels[6]="ht";
		m_as_iTPar_Labels[7]="ht^0.5";
		m_as_iTPar_Labels[8]="mi (t)";
		m_as_iTPar_Labels[9]="ht*exp(f_v(t))";
		m_as_iTPar_Labels[10]="[ht*exp(f_v(t))]^0.5";
		m_as_iTPar_Labels[11]="[a0/(1-(a1+a2)/2-b1)*exp(f_v(t))]";
		m_as_iTPar_Labels[12]="[a0/(1-(a1+a2)/2-b1)*exp(f_v(t))]^0.5";
		m_as_iTPar_Labels[13]="I min ni > 4";

		if (m_i_inMean_mode>0)
		{
			m_as_iTPar_Labels[14]="lambda * [exp(f_v(t)]^0.5";
			m_as_iTPar_Labels[15]="lambda * ht^0.5 * [exp(f_v(t)]^0.5";

		}
				
		if (m_b_get_quantiles>0)
		{
			for (c1=0;c1<sizec(m_v_cd_quantiles);c1++)
			{
				m_as_iTPar_Labels[14+2*(m_i_inMean_mode>0)+c1]="qcd_s_"~sprint(m_v_cd_quantiles[0][c1]);
			}

			for (c1=sizec(m_v_cd_quantiles);c1<2*sizec(m_v_cd_quantiles);c1++)
			{
				m_as_iTPar_Labels[14+2*(m_i_inMean_mode>0)+c1]="qcd_"~sprint(m_v_cd_quantiles[0][c1-sizec(m_v_cd_quantiles)]);
			}

			for (c1=2*sizec(m_v_cd_quantiles);c1<2.5*sizec(m_v_cd_quantiles);c1++)
			{
				m_as_iTPar_Labels[14+2*(m_i_inMean_mode>0)+c1]="qqr"~sprint(m_v_cd_quantiles[0][c1-2*sizec(m_v_cd_quantiles)])~" / "~sprint(m_v_cd_quantiles[0][c1-1.5*sizec(m_v_cd_quantiles)]);
			}

		}
				
		m_v_ParStart=zeros(5,1);

		m_v_ParStart[0][0]=0.04;
		m_v_ParStart[1][0]=log((0.15-m_d_rho_min)/(m_d_rho_max-0.15));
		m_v_ParStart[2][0]=log(0.005);
		m_v_ParStart[3][0]=log((0.03)/(1-0.03));
		m_v_ParStart[4][0]=log((0.9)/(1-0.9));
		
		m_as_iPar_Labels[0]="delta";
		m_as_iPar_Labels[1]="rho";
		m_as_iPar_Labels[2]="alpha0";
		m_as_iPar_Labels[3]="alpha1";
		m_as_iPar_Labels[4]="beta1";

		//PRIORS
		c1=5;
		if (m_i_GJR_mode==1)
		{
			m_as_iPar_Labels[c1]="alpha1+";
			m_as_iPar_Labels[3]="alpha1-";
			c1++;
			m_v_ParStart=m_v_ParStart|(log((0.03)/(1-0.03)));
		}

		if (m_i_FIGARCH_mode==1)
		{
			m_as_iPar_Labels[c1]="d";
			m_as_iPar_Labels[3]="fi1";
			
			c1++;
			m_v_ParStart=m_v_ParStart|(log((0.03)/(1-0.03)));
		}

		if (m_i_inMean_mode>0)
		{
			m_as_iPar_Labels[c1]="lambda1";
			m_v_ParStart=m_v_ParStart|<0.001>;
			c1++;
		}

		if (m_i_eta_par>0)
		{
			for (c2=0;c2<m_i_eta_par;c2++)
			{
				m_as_iPar_Labels[c1]="eta"~sprint(c2);
				c1++;
			}
		}

		if (m_i_ni_par>0)
		{
			if (m_i_ni_par==1)
			{
				switch_single (m_i_ni_mode)
				{
				
				case 0:
				m_as_iPar_Labels[c1]="ni1=ni2";
				m_v_ParStart=m_v_ParStart|(log(5-m_d_ni_min));

				case 1:
				ni20_=vP[c1][0];
				m_as_iPar_Labels[c1]="ni2";
				ni10_=m_d_ni_known;
				m_v_ParStart=m_v_ParStart|(log(5-m_d_ni_min));

				case 2:
				ni10_=vP[c1][0];
				m_as_iPar_Labels[c1]="ni1";
				m_v_ParStart=m_v_ParStart|(log(5-m_d_ni_min));

				}
				c1=c1+1;
			
			}
			else
			{
				m_as_iPar_Labels[c1]="ni1";
				m_as_iPar_Labels[c1+1]="ni2";
				m_v_ParStart=m_v_ParStart|(log(5-m_d_ni_min));
				m_v_ParStart=m_v_ParStart|(log(5-m_d_ni_min));
				c1=c1+2;
			}
		}


		if (m_i_alpha_mode==1)
		{
			m_as_iPar_Labels[c1]="a00";
			m_v_ParStart=m_v_ParStart|tan((0.51-0.5)*M_PI);
			c1++;
		}

		if (m_i_e0_mode==1)
		{
			m_as_iPar_Labels[c1]="eps0";
			m_v_ParStart=m_v_ParStart|<0>;
		   	c1++;
		}

		if (m_i_h0_mode==1)
		{
		   	m_as_iPar_Labels[c1]="h0";
			m_v_ParStart=m_v_ParStart|(log(0.8));
		   	c1++;
		}

		if (m_i_NF>0)
		{
			
			c3=sumc(m_m_Amplitude_Config*m_m_Freq_Config[1][]');

			for (c2=0;c2<c3;c2++)
			{
				m_as_iPar_Labels[c1]="gamma_s"~sprint(c2);
				m_v_ParStart=m_v_ParStart|<0>;
				c1++;
			}

			for (c2=0;c2<c3;c2++)
			{
				m_as_iPar_Labels[c1]="gamma_c"~sprint(c2);
				m_v_ParStart=m_v_ParStart|<0>;
				c1++;
			}

			
			for (c2=0;c2<sumr(m_m_Freq_Config[1][]);c2++)
			{
				m_as_iPar_Labels[c1]="phi"~sprint(c2);
				m_v_ParStart=m_v_ParStart|<-5>;
				c1++;
			}
		
		}

		
	//================================================
	//configuration
	//m_as_iTPar_Labels
	//m_as_iPar_Labels
	//m_m_sPar_Groups
	//m_m_iPar_Groups

	adFunc[0]=1;
	
	return !ismissing(adFunc[0]);

	
	}
	else
	{
//		m_Tquant=ones(m_iT+1,sizec(m_v_cd_quantiles)).*m_v_cd_quantiles;
		
		delta_= vP[0][0];
		rho_=   vP[1][0];
		alpha0_=vP[2][0];
		alpha1_=vP[3][0];
		beta1_ =vP[4][0];

		if (m_i_FIGARCH_mode==1)
		{
			fi1_=vP[3][0];

		}
		else
		{
			alpha1_=vP[3][0];
		}
		
		prior_logKer=prior_logKer
		-(m_d_delta_PriorDF+1)/2*log(1+1/m_d_delta_PriorDF*m_d_delta_PriorPrec*(delta_)^2)
		+rho_-2*log(1+exp(rho_))
		+m_d_alpha0_PriorA*alpha0_-m_d_alpha0_PriorB*exp(alpha0_)
		+beta1_-2*log(1+exp(beta1_));
		//PRIORS prior_logKer
		rho_=(m_d_rho_max*exp(rho_)+m_d_rho_min)/(1+exp(rho_));
		alpha0_=exp(alpha0_);
		
		if (m_i_FIGARCH_mode==1)
		{
			prior_logKer=prior_logKer+fi1_-2*log(1+exp(fi1_));
			fi1_=(exp(fi1_)-1)/(1+exp(fi1_));
			beta1_=(exp(beta1_)-1)/(1+exp(beta1_));
		}
		else
		{
			prior_logKer=prior_logKer+alpha1_-2*log(1+exp(alpha1_));
			alpha1_=(exp(alpha1_))/(1+exp(alpha1_));
			beta1_=(exp(beta1_))/(1+exp(beta1_));
		
		}
		m_m_iPar=delta_~rho_~alpha0_~alpha1_~beta1_;

		if (m_i_FIGARCH_mode==1)
		{

			d_=vP[c1][0];
			prior_logKer=prior_logKer+d_-2*log(1+exp(d_));
			d_=(exp(d_))/(1+exp(d_));
			m_m_iPar=m_m_iPar~d_;
			c1++;
			m_v_Probs=(beta1_<0);
			m_v_AddPars=d_;
			// f   g   psi
			min_flag_=0;
			
			m_FP[0][0]=-d_;
			m_FP[0][1]=-d_;
			m_FP[0][2]=d_+fi1_-beta1_;

			if (m_FP[0][2]<0)
			{
				min_flag_=1;
			}
			
			for(l_1=1;l_1<m_i_FIni;l_1++)
			{
				m_FP[l_1][0]=(l_1-d_)/(l_1+1);
				m_FP[l_1][1]=m_FP[l_1-1][1]*m_FP[l_1][0];
				m_FP[l_1][2]=beta1_*m_FP[l_1-1][2]+(m_FP[l_1][0]-fi1_)*(-m_FP[l_1-1][1]);
				if (m_FP[l_1][2]<0)
				{
					min_flag_=1;
					
				}
						   
			}

			if (min_flag_==0)
			{
				m_v_AddPars=m_FP[0:4][2]';
			}
			else
			{
				m_v_AddPars=-ranu(1,5);
			}
			
			m_b_instab_ind=0;
		}
		else
		{
			if (m_i_GJR_mode==1)
			{
				alpha2_=vP[c1][0];
				prior_logKer=prior_logKer+alpha2_-2*log(1+exp(alpha2_));
				alpha2_=(exp(alpha2_))/(1+exp(alpha2_));
				m_m_iPar=m_m_iPar~alpha2_;
				c1++;
			
			}
			else
			{
				alpha2_=alpha1_;
			}

			m_v_Probs=(((alpha2_+alpha1_)/2+beta1_)>1)~(!(alpha1_>alpha2_));
			m_v_AddPars=(alpha2_+alpha1_)/2+beta1_;

			if (((alpha2_+alpha1_)/2+beta1_)>m_d_lim_corr_ht)
			{
				m_b_instab_ind=1;
				m_v_AddPars=m_v_AddPars~ranu(1,2);
			}
			else
			{
				m_b_instab_ind=0;
				m_v_AddPars=m_v_AddPars~alpha0_/(1-(alpha2_+alpha1_)/2-beta1_)~(alpha0_/(1-(alpha2_+alpha1_)/2-beta1_))^0.5;
			}
			
			if (m_i_GJR_mode==1)
			{
				m_v_AddPars=m_v_AddPars~alpha1_/alpha2_;
			}
			
		}

		if (m_i_inMean_mode>0)
		{
			lambda1_=vP[c1][0];
			prior_logKer=prior_logKer-(m_d_lambda_PriorDF+1)/2*log(1+1/m_d_lambda_PriorDF*m_d_lambda_PriorPrec*(lambda1_)^2);
			m_m_iPar=m_m_iPar~lambda1_;
			c1++;
			m_v_Probs=m_v_Probs~(!(lambda1_>0));
		}

		if (m_i_eta_par>0)
		{
			eta_=vP[c1:c1+m_i_eta_par-1][0];
			//PRIOR FOR ETA
			//TRANSFORMATION FOR ETA
			c1=c1+m_i_eta_par;
		}

		if (m_i_ni_par>0)
		{
			if (m_i_ni_par==1)
			{
				switch_single (m_i_ni_mode)
				{
				
				case 0:
				ni10_=vP[c1][0];
				ni20_=vP[c1][0];
				prior_logKer=prior_logKer
				+m_d_ni_PriorA*ni10_-m_d_ni_PriorB*exp(ni10_);
				ni10_=exp(ni10_);
				ni20_=exp(ni20_);
				m_m_iPar=m_m_iPar~(ni20_+m_d_ni_min);
				
				case 1:
				ni20_=vP[c1][0];
				ni10_=m_d_ni_known;

				prior_logKer=prior_logKer
				+m_d_ni_PriorA*ni20_-m_d_ni_PriorB*exp(ni20_);

				ni20_=exp(ni20_);
				m_m_iPar=m_m_iPar~(ni20_+m_d_ni_min);
				case 2:
				ni10_=vP[c1][0];
				ni20_=m_d_ni_known;
				
				prior_logKer=prior_logKer
				+m_d_ni_PriorA*ni10_-m_d_ni_PriorB*exp(ni10_);
				ni10_=exp(ni10_);
				m_m_iPar=m_m_iPar~(ni10_+m_d_ni_min);
				
				}
				c1=c1+1;
			
			}
			else
			{
				ni10_=vP[c1][0];
				ni20_=vP[c1+1][0];
				prior_logKer=prior_logKer
				+m_d_ni_PriorA*ni10_-m_d_ni_PriorB*exp(ni10_)
				+m_d_ni_PriorA*ni20_-m_d_ni_PriorB*exp(ni20_);
				ni10_=exp(ni10_);
				ni20_=exp(ni20_);

				m_m_iPar=m_m_iPar~(ni10_+m_d_ni_min)~(ni20_+m_d_ni_min);
									
				m_v_Probs=m_v_Probs~(!((m_d_ni_min+ni20_)>(m_d_ni_min+ni10_)));
				if (m_i_FIGARCH_mode==0)
				{
					m_v_AddPars=m_v_AddPars~(m_d_ni_min+ni20_)/(m_d_ni_min+ni10_);
				}
				c1=c1+2;
			}
		}
		else
		{
			ni10_=m_d_ni_known;
			ni20_=m_d_ni_known;
		}

		if (m_i_alpha_mode==1)
		{
			alpha00_=vP[c1][0];
			prior_logKer=prior_logKer-(m_d_alpha00_PriorDF+1)/2*log(1+1/m_d_alpha00_PriorDF*m_d_alpha00_PriorPrec*(alpha00_)^2);
			c1++;
			m_m_iPar=m_m_iPar~(0.5+atan(alpha00_)/M_PI);
			m_v_Probs=m_v_Probs~(alpha00_<0);
		}
		else
		{
			alpha00_=0;
		}

		if (m_i_e0_mode==1)
		{
		   eps0_=vP[c1][0];
		   prior_logKer=prior_logKer-(m_d_e0_PriorDF+1)/2*log(1+1/m_d_e0_PriorDF*m_d_e0_PriorPrec*(eps0_)^2);
		   m_m_iPar=m_m_iPar~eps0_;
		   c1++;
		}
		else
		{
		   eps0_=m_d_e0_known;
		}

		if (m_i_h0_mode==1)
		{
		   h0_=vP[c1][0];
		   prior_logKer=prior_logKer+m_d_h0_PriorA*h0_-m_d_h0_PriorB*exp(h0_);
		   h0_=exp(h0_);
		   m_m_iPar=m_m_iPar~h0_;
		   c1++;
		}
		else
		{
		   h0_=m_d_h0_known;
		}

		if (m_i_NF>0)
		{
			mT1=zeros(m_iT+1,m_ik1);
			phi_=new array [m_i_NF];
			n_gam=(m_m_Amplitude_Config*m_m_Freq_Config[1][]');
			gamma_s_=vP[c1:c1+sumc(n_gam)-1][0];
			c1=c1+sumc(n_gam);
			gamma_c_=vP[c1:c1+sumc(n_gam)-1][0];
			c1=c1+sumc(n_gam);

			prior_logKer=prior_logKer
			-(m_d_gamma_PriorDF+sumc(n_gam))/2*log(1+1/m_d_gamma_PriorDF*m_d_gamma_PriorPrec*(gamma_s_'gamma_s_))
			-(m_d_gamma_PriorDF+sumc(n_gam))/2*log(1+1/m_d_gamma_PriorDF*m_d_gamma_PriorPrec*(gamma_c_'gamma_c_));

			m_m_iPar=m_m_iPar~gamma_s_'~gamma_c_';
			
			for (c2=0;c2<m_i_NF;c2++)
			{

				phi_[c2]=vP[c1:c1+m_m_Freq_Config[1][c2]-1][0];

				if ((maxc(phi_[c2])>25)||(minc(phi_[c2])<-500))
				{
					for (c3=0;c3<sizer(phi_[c2]);c3++)
					{
						if ((phi_[c2])[c3][0]>25)
						{
							println("phi corrected ", (phi_[c2])[c3][0]);
							(phi_[c2])[c3][0]=25;
							v_exc[0][0]=v_exc[0][0]+1;
						}
						if ((phi_[c2])[c3][0]<-500)
						{
							println("phi corrected ", (phi_[c2])[c3][0]);
							(phi_[c2])[c3][0]=-500;
							v_exc[0][0]=v_exc[0][0]+1;
						}

				
					}
				}



				phi_[c2]=exp(phi_[c2]);
				phi_[c2]=phi_[c2]/(1+sumc(phi_[c2]));
		
				prior_logKer=prior_logKer+sumc(log(phi_[c2]))+log(1-sumc(phi_[c2]));

				phi_[c2]=((lower(ones(m_m_Freq_Config[1][c2],m_m_Freq_Config[1][c2])))*phi_[c2])*(m_d_PhiRTrunc-m_d_PhiLTrunc)+m_d_PhiLTrunc;
				c1=c1+m_m_Freq_Config[1][c2];
				m_m_iPar=m_m_iPar~phi_[c2]';

				m_v_AddPars=m_v_AddPars~(2*M_PI/251)*((phi_[c2]').^-1);
			}


			for (c2=0;c2<m_ik1;c2++)
			{
				mT1[][c2]=sin(m_mXr[m_m_AC[c2][0]-1].*(phi_[m_m_AC[c2][0]-1]'))*(gamma_s_[m_m_AC[c2][2]:m_m_AC[c2][3]][]);
				mT1[][c2]=mT1[][c2]+cos(m_mXr[m_m_AC[c2][0]-1].*(phi_[m_m_AC[c2][0]-1]'))*(gamma_c_[m_m_AC[c2][2]:m_m_AC[c2][3]][]);
			}

			mT2=mT1*(m_m_Cycle_Config');
			mTPAR=mT2;
			
		}

		if (m_i_NF>0)
		{
			mTPAR[][1]=exp(mT2[][1]);
			mTPAR[][2]=0.5+atan(mT2[][2]+alpha00_)/M_PI;
			mTPAR[][3]=m_d_ni_min+ni10_*exp(mT2[][3]);
			mTPAR[][4]=m_d_ni_min+ni20_*exp(mT2[][4]);
	

			m_z_ni=mTPAR[][3:4].>m_cut_ni;
			mTPAR[][3:4]=(m_z_ni.!=1).*mTPAR[][3:4]+m_z_ni*m_d_ni_max;
	
			mTPAR_2[][0:1]=M_PI^-0.5*gammafact((mTPAR[][3:4]+1)/2)./(gammafact(mTPAR[][3:4]/2).*(mTPAR[][3:4].^0.5)); 
			mTPAR_2[][2]=mTPAR[][2].*mTPAR_2[][0];
			mTPAR_2[][3]=(1-mTPAR[][2]).*mTPAR_2[][1];
			mTPAR_2[][0]=mTPAR_2[][2]+mTPAR_2[][3]; //B t
			mTPAR_2[][1]=mTPAR_2[][2]./mTPAR_2[][0];  //a* t
			mTPAR_2[][2]=4*mTPAR_2[][0].*(-(mTPAR_2[][1].^2).*mTPAR[][3]./(mTPAR[][3]-1)+((1-mTPAR_2[][1]).^2).*mTPAR[][4]./(mTPAR[][4]-1)); //c t
			mTPAR_2[][3]=(4*(
			(mTPAR[][2].*(mTPAR_2[][1].^2).*mTPAR[][3]./(mTPAR[][3]-2)+((1-mTPAR[][2]).*((1-mTPAR_2[][1]).^2)).*mTPAR[][4]./(mTPAR[][4]-2))
			)-mTPAR_2[][2].^2).^0.5;	// dt
			mTPAR_2[][4]=-mTPAR_2[][2]./mTPAR_2[][3];	//mt

		}
		else
		{

			mTPAR[0][1]=exp(mT2[0][1]);
			mTPAR[0][2]=0.5+atan(mT2[0][2]+alpha00_)/M_PI;
			mTPAR[0][3]=m_d_ni_min+ni10_*exp(mT2[0][3]);
			mTPAR[0][4]=m_d_ni_min+ni20_*exp(mT2[0][4]);

			m_z_ni=mTPAR[0][3:4].>m_cut_ni;
			mTPAR[0][3:4]=(m_z_ni.!=1).*mTPAR[0][3:4]+m_z_ni*m_d_ni_max;

			mTPAR=ones(sizer(mTPAR),1).*mTPAR[0][];
			
			mTPAR_2[0][0:1]=M_PI^-0.5*gammafact((mTPAR[0][3:4]+1)/2)./(gammafact(mTPAR[0][3:4]/2).*(mTPAR[0][3:4].^0.5)); 
			mTPAR_2[0][2]=mTPAR[0][2].*mTPAR_2[0][0];
			mTPAR_2[0][3]=(1-mTPAR[0][2]).*mTPAR_2[0][1];
			mTPAR_2[0][0]=mTPAR_2[0][2]+mTPAR_2[0][3]; //B t
			mTPAR_2[0][1]=mTPAR_2[0][2]./mTPAR_2[0][0];  //a* t
			mTPAR_2[0][2]=4*mTPAR_2[0][0].*(-(mTPAR_2[0][1].^2).*mTPAR[0][3]./(mTPAR[0][3]-1)+((1-mTPAR_2[0][1]).^2).*mTPAR[0][4]./(mTPAR[0][4]-1)); //c t
			mTPAR_2[0][3]=(4*(
			(mTPAR[0][2].*(mTPAR_2[0][1].^2).*mTPAR[0][3]./(mTPAR[0][3]-2)+((1-mTPAR[0][2]).*((1-mTPAR_2[0][1]).^2)).*mTPAR[0][4]./(mTPAR[0][4]-2))
			)-mTPAR_2[0][2].^2).^0.5;	// dt
			mTPAR_2[0][4]=-mTPAR_2[0][2]./mTPAR_2[0][3];	//mt

			mTPAR_2=ones(sizer(mTPAR_2),1).*mTPAR_2[0][];

		}


		if (m_b_get_quantiles>0)
		{

			m_T_a1=ones(m_iT+1,1).*m_v_cd_quantiles; //[p]
			m_T_a2=ones(1,sizec(m_v_cd_quantiles))**mTPAR[][2]; //[a]
			m_T_a3=(m_T_a1.<m_T_a2);		//[p<a]
			m_T_a4=!m_T_a3;					//[p>=a]

			m_Tquant=zeros(m_iT+1,2*sizec(m_v_cd_quantiles));

			m_Tquant[][:sizec(m_v_cd_quantiles)-1]=0.5*m_T_a3.*m_T_a1./m_T_a2+0.5*m_T_a4;
			m_Tquant[][sizec(m_v_cd_quantiles):]=0.5*m_T_a4.*((  m_T_a1+ones(m_iT+1,sizec(m_v_cd_quantiles))-2*m_T_a2)./(ones(m_iT+1,sizec(m_v_cd_quantiles))-m_T_a2))+0.5*m_T_a3;
			
			m_Tquant[][:sizec(m_v_cd_quantiles)-1]=2*quant(m_Tquant[][:sizec(m_v_cd_quantiles)-1],ones(1,sizec(m_v_cd_quantiles)).*mTPAR[][3]).*mTPAR_2[][1];
			m_Tquant[][sizec(m_v_cd_quantiles):]=2*quant(m_Tquant[][sizec(m_v_cd_quantiles):],ones(1,sizec(m_v_cd_quantiles)).*mTPAR[][4]).*(1-mTPAR_2[][1]);
			
			
			m_Tquant=m_Tquant[][:sizec(m_v_cd_quantiles)-1]+m_Tquant[][sizec(m_v_cd_quantiles):];
			m_Tquant=m_Tquant./(mTPAR_2[][3])+mTPAR_2[][4];

		}


		mTPAR_3[0][0]=h0_;

		c_p1=(h0_)^0.5;
		c_p2=(mTPAR[0][1])^0.5;
		
		switch_single(m_i_inMean_mode)
		{
			case 0:
			mTPAR_3[0][1]=delta_;
			case 1:
			mTPAR_3[0][1]=delta_+lambda1_*c_p1+mTPAR[0][0];
			case 2:
			mTPAR_3[0][1]=delta_+lambda1_*c_p1*c_p2+mTPAR[0][0];
 		}

		mTPAR_3[0][2]=eps0_;
		mTPAR_3[0][3]=eps0_/c_p2;

		logLik=0;
		
		for (i_obs=1;i_obs<(m_iT+1);i_obs++)
		{

			//ht
			if (m_i_FIGARCH_mode==0)
			{
				if (mTPAR_3[i_obs-1][2]<0)
				{
					mTPAR_3[i_obs][0]=alpha0_+alpha1_*(mTPAR_3[i_obs-1][3])^2+beta1_*mTPAR_3[i_obs-1][0];
				}
				else
				{
					mTPAR_3[i_obs][0]=alpha0_+alpha2_*(mTPAR_3[i_obs-1][3])^2+beta1_*mTPAR_3[i_obs-1][0];
				}
			}
		   	else
			{
				if (min_flag_==1)
				{
					mTPAR_3[i_obs][0]=1000*(1+d_)^2+2000*(1+beta1_)^2+3000*(1+fi1_)^2;
		//			println(mTPAR_3[i_obs][0]);
				}
				else
				{
					h_eps_[1:999][0]=h_eps_[0:998][0];
				//	println(mTPAR_3[i_obs-1][]);
					h_eps_[0][0]=(mTPAR_3[i_obs-1][3])^2;

				//	println(h_eps_[:10][0]);
					mTPAR_3[i_obs][0]=alpha0_+h_eps_'*m_FP[][2];
				}
				
			}

			
			if (mTPAR_3[i_obs][0]>(10^250))
			{
				mTPAR_3[i_obs][0]=10^250;
				if (v_exc[0][1]==0)
				{
					v_exc[0][1]=1;
				}

			}
		
			c_p1=(mTPAR_3[i_obs][0])^0.5;		 //sqrt ht
			c_p2=(mTPAR[i_obs][1])^0.5;			 //sqrt (exp(fv(t)))
			
			//miu t
			switch_single(m_i_inMean_mode)
			{
				case 0:
				mTPAR_3[i_obs][1]=delta_;

				case 1:
				mTPAR_3[i_obs][1]=delta_+lambda1_*c_p1+mTPAR[i_obs][0];

				case 2:
				mTPAR_3[i_obs][1]=delta_+lambda1_*c_p1*c_p2+mTPAR[i_obs][0];
	 		}
			//epsilon t
			mTPAR_3[i_obs][2]=m_mAllData[i_obs][]-mTPAR_3[i_obs][1]-rho_*(m_mAllData[i_obs-1][]-mTPAR_3[i_obs-1][1]);
			
			//ksi t
			mTPAR_3[i_obs][3]=mTPAR_3[i_obs][2]/c_p2;

			c_p3=c_p1*c_p2*mTPAR_2[i_obs][4];

			
			if (mTPAR_3[i_obs][2]<c_p3)
			{
				logLik=logLik+
				log(mTPAR_2[i_obs][0])+log(mTPAR_2[i_obs][3])-log(c_p1)-log(c_p2)
				-(mTPAR[i_obs][3]+1)/2*
				log(1+(mTPAR_3[i_obs][2]*mTPAR_2[i_obs][3]/(c_p1*c_p2)+mTPAR_2[i_obs][2])^2/(mTPAR[i_obs][3]*(2*mTPAR_2[i_obs][1])^2));
				
			}
			else
			{
				logLik=logLik+
				log(mTPAR_2[i_obs][0])+log(mTPAR_2[i_obs][3])-log(c_p1)-log(c_p2)
				-(mTPAR[i_obs][4]+1)/2*
				log(1+(mTPAR_3[i_obs][2]*mTPAR_2[i_obs][3]/(c_p1*c_p2)+mTPAR_2[i_obs][2])^2/(mTPAR[i_obs][4]*(2*(1-mTPAR_2[i_obs][1]))^2));

			}
				
		}


		if (m_b_get_quantiles>0)
		{
			if (m_i_FIGARCH_mode==0)
			{
			
				if (((alpha2_+alpha1_)/2+beta1_)>m_d_lim_corr_ht)
				{
					mTPAR_3[][0]=ranu(sizer(mTPAR_3),1);
				}
			
			}
			m_m_iTPar=mTPAR[1:][]~mTPAR[1:][1].^0.5~mTPAR_3[1:][0]~(mTPAR_3[1:][0].^0.5)~mTPAR_3[1:][1]~mTPAR_3[1:][0].*mTPAR[1:][1]~(mTPAR_3[1:][0].*mTPAR[1:][1]).^0.5~m_v_AddPars[0][1]*mTPAR[1:][1]~(m_v_AddPars[0][1]*mTPAR[1:][1]).^0.5~((mTPAR[1:][3].>4).*(mTPAR[1:][4].>4));

			if (m_i_inMean_mode>0)
			{
				m_m_iTPar=m_m_iTPar~(lambda1_*(mTPAR[1:][1].^0.5))~(lambda1_*(mTPAR_3[1:][0].*mTPAR[1:][1]).^0.5);
			}

			

			m_m_iTHPar=zeros(ceil((sizer(m_m_iTPar)-1)/100),5);

			c2=0;

			for (c1=1;c1<sizer(m_m_iTPar);c1=c1+100)
			{
				m_m_iTHPar[c2][0:3]=m_m_iTPar[c1][3:4]~m_m_iTPar[c1][11:12];

				if (m_i_inMean_mode>0)
				{
					m_m_iTHPar[c2][4]=m_m_iTPar[c1][14];
				}

				c2++;
				
			}	
			
			m_m_iTPar=m_m_iTPar~m_Tquant[1:][]~m_Tquant[1:][].*m_m_iTPar[][5].*m_m_iTPar[][7];
			m_m_iTPar=m_m_iTPar~(m_Tquant[1:][0:(sizec(m_Tquant)/2)-1]./m_Tquant[1:][(sizec(m_Tquant)/2):]);
		}

		//println(min_flag_, "  ", logLik);


		if (min_flag_==1)
		{
			prior_logKer=prior_logKer-100000;
		}
		
		switch_single(m_i_kernel_mode)
		{
			case 0:
			adFunc[0]=logLik+prior_logKer;

			case 1:
			adFunc[0]=logLik;
			
			case 2:
			adFunc[0]=prior_logKer;			
			
		}
	
	
	m_m_iPar=m_m_iPar';
	m_d_Logl=logLik;
	m_d_LogPr=prior_logKer;
	m_v_Exceptions=v_exc;

	return !ismissing(adFunc[0]);		

	}

}

garchPOS::set_spec()
{
}

garchPOS::estimate()
{
	decl aa,par_start,par_cand,max_start,max_cand,bfgs_max,
		 i_lcgen,i_lcbas,theta_curr,theta_cand,logPOS_curr,logPOS_cand,log_ratio,logl_curr,logl_max,
		 p_mean,p_cvm,ipar_curr,itpar_curr,ithpar_curr,exc_curr,prob_curr,adpar_curr,ip_res,add_par_res,sp_res,sp_hist,ip_hist,acc_count,his_pom,mq_pom,
		 iT_par_mean,iT_par_stdev,nrest,as_nam,as_namT,m_prob,add_par_hist,ad_par_mean,ad_par_stdev,exc_count,instab_count,curr_instab_ind,
		 logl_max_par,pos_max,pos_max_par,ip_ml,ip_mp,ip_pe,ap_mp,ap_ml,ap_pe,acc_ind,acc_sum,ithp_res,ithp_hist0,ithp_hist1,ithp_hist2,ithp_hist3,ithp_hist4,
		 i_l1,i_l2,i_l3,i_count,ithp_count,m_res_h;

	println("===========  THE MODEL  ===========");
	println("Analyzing ", m_sDataLabel);
	println("First observation: ", m_mData[0][]);
	println("Last observation: ", m_mData[m_iT-1][]);
	println("No of observations: ", m_iT);
	println("===================================");	

	acc_count=0;
	ithp_count=0;
	
	ithp_res=new array [5];

	instab_count=0;
	nrest=0;
	i_count=0;

	exc_count=zeros(1,3);
	
	m_i_Est_Mode=0;
	par_start=zeros(10,1);
	posterior_kernel(par_start,&max_start,0,0);
	m_i_Est_Mode=1;

	acc_ind=zeros(8,sizer(m_m_sPar_Groups));
	acc_sum=acc_ind;
	
	ip_res=zeros(m_iBasicCycle,m_i_iParBasic_Num);
	sp_res=zeros(m_iBasicCycle,m_i_iParBasic_Num);
	add_par_res=zeros(m_iBasicCycle,sizeof(m_as_addPar_Labels));
	
	m_prob=zeros(1,sizeof(m_as_probLabels));
	
	ip_hist=new array [m_i_iParBasic_Num];
	sp_hist=new array [m_i_iParBasic_Num];

	add_par_hist=new array [sizeof(m_as_addPar_Labels)];
	
	for(i_l1=0;i_l1<m_i_iParBasic_Num;i_l1++)
	{
		ip_hist[i_l1]=new histo2d(1);
		ip_hist[i_l1].set_buffer(m_iBasicCycle-1);

		sp_hist[i_l1]=new histo2d(1);
		sp_hist[i_l1].set_buffer(m_iBasicCycle-1);

	}

	for(i_l1=0;i_l1<sizeof(m_as_addPar_Labels);i_l1++)
	{
		add_par_hist[i_l1]=new histo2d(1);
		add_par_hist[i_l1].set_buffer(m_iBasicCycle-1);
	}
	
	p_mean=new array [2];
	p_cvm=new array [2];

	ad_par_mean=zeros(1,sizeof(m_as_addPar_Labels));
	ad_par_stdev=zeros(1,sizeof(m_as_addPar_Labels));
	
	p_mean[0]=zeros(1,m_i_iParBasic_Num);
	p_cvm[0]=zeros(m_i_iParBasic_Num,m_i_iParBasic_Num);

	p_mean[1]=zeros(1,m_i_iParBasic_Num);
	p_cvm[1]=zeros(m_i_iParBasic_Num,m_i_iParBasic_Num);
	
	par_start=m_v_ParStart;
//	par_start[sizer(par_start)-1][]=-250;

	par_start=loadmat("m1.xlsx");
	par_start=par_start';
	
	posterior_kernel(par_start,&max_start,0,0);

	
	for (i_l1=0;i_l1<4;i_l1++)
	{
		ithp_res[i_l1]=zeros(1000,sizer(m_m_iTHPar));
	}

	if (m_i_inMean_mode>0)
	{
		ithp_res[4]=zeros(1000,sizer(m_m_iTHPar));
	}

	ithp_hist0= new array [sizer(m_m_iTHPar)];
	ithp_hist1= new array [sizer(m_m_iTHPar)];
	ithp_hist2= new array [sizer(m_m_iTHPar)];
	ithp_hist3= new array [sizer(m_m_iTHPar)];

	if (m_i_inMean_mode>0)
	{
		ithp_hist4= new array [sizer(m_m_iTHPar)];
	}
	
	for (i_l1=0;i_l1<sizer(m_m_iTHPar);i_l1++)
	{

		ithp_hist0[i_l1]=new histo2d(1);
		ithp_hist0[i_l1].set_buffer(39900);
		ithp_hist1[i_l1]=new histo2d(1);
		ithp_hist1[i_l1].set_buffer(39900);
		ithp_hist2[i_l1]=new histo2d(1);
		ithp_hist2[i_l1].set_buffer(39900);
		ithp_hist3[i_l1]=new histo2d(1);
		ithp_hist3[i_l1].set_buffer(39900);
		
		if (m_i_inMean_mode>0)
		{
			ithp_hist4[i_l1]=new histo2d(1);
			ithp_hist4[i_l1].set_buffer(39900);
		}
	}
	
	println(max_start);
	println(m_m_iPar);
	println(m_as_probLabels);
	println(m_as_addPar_Labels);

	m_b_get_quantiles=0;
	
	for(i_l1=0;i_l1<1000;i_l1++)
	{
		par_cand=par_start+0.1*rant(m_i_iParBasic_Num,1,2);
		posterior_kernel(par_cand,&max_cand,0,0);
	
		if (max_cand>max_start)
		{
			par_start=par_cand;
			max_start=max_cand;
		}
	}
	
	posterior_kernel(par_start,&max_start,0,0);
	println("cvms");
	println(m_am_Draw_Cvm);
	println(m_m_iPar);
	
	MaxControl(1000,0);
	MaxControlEps(1e-4, 5e-3);

	
	bfgs_max=MaxBFGS(posterior_kernel, &par_start, &max_start, 0, TRUE);



	m_b_get_quantiles=1;
	posterior_kernel(par_start,&max_start,0,0);

	logPOS_curr=max_start;
	pos_max=max_start;
	pos_max_par=par_start;
	theta_curr=par_start;
	ipar_curr=m_m_iPar;
	itpar_curr=m_m_iTPar;
	ithpar_curr=m_m_iTHPar;
	prob_curr=m_v_Probs;
	adpar_curr=m_v_AddPars;
	curr_instab_ind=m_b_instab_ind;
	logl_curr=m_d_Logl;
	logl_max=logl_curr;
	logl_max_par=theta_curr;
	exc_curr=m_v_Exceptions;
	
	theta_cand=0*theta_curr;
	iT_par_mean=0*m_m_iTPar;
	iT_par_stdev=0*m_m_iTPar;

	m_b_get_quantiles=0;
	
	for (i_lcgen=0;i_lcgen<m_iNumCycles;i_lcgen++)
	{
		for (i_lcbas=0;i_lcbas<m_iBasicCycle;i_lcbas++)
		{
			acc_ind=zeros(8,sizer(m_m_sPar_Groups));
			
			if (ranu(1,1)>0.5)
			{
				for (i_l1=0;i_l1<sizer(m_m_sPar_Groups);i_l1++)
				{
				
					switch_single (int(4*ranu(1,1)))
					{
					   case 0:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][5])*m_am_Draw_Cvm[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,2);
						acc_ind[0][i_l1]=1;
					   case 1:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][6])*m_am_Draw_Cvm[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,2);
						acc_ind[1][i_l1]=1;
					   case 2:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][7])*m_am_Draw_Cvm[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,3);
						acc_ind[2][i_l1]=1;
					   case 3:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][8])*m_am_Draw_Cvm[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,3);
						acc_ind[3][i_l1]=1;
					}
				}	
			}
			else
			{
				for (i_l1=0;i_l1<sizer(m_m_sPar_Groups);i_l1++)
				{
					switch_single (int(4*ranu(1,1)))
					{
					   case 0:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][5])*m_am_Draw_Cvm[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,2);
						acc_ind[4][i_l1]=1;
					   case 1:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][6])*m_am_Draw_Cvm[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,2);
						acc_ind[5][i_l1]=1;
					   case 2:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][7])*0.5*m_am_Draw_Cvm[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,3);
						acc_ind[6][i_l1]=1;
					   case 3:
						theta_cand[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]=theta_curr[m_m_sPar_Groups[i_l1][1]:m_m_sPar_Groups[i_l1][2]]+m_m_sPar_Groups[i_l1][3]*(m_m_sPar_Groups[i_l1][8])*0.1*m_am_Draw_Cvm[i_l1]*rant(m_m_sPar_Groups[i_l1][0],1,9);
						acc_ind[7][i_l1]=1;
					}
				}
				
			}

			posterior_kernel(theta_cand,&logPOS_cand,0,0);
			log_ratio=exp(logPOS_cand-logPOS_curr);

			if (ranu(1,1)<log_ratio)
			{
				m_b_get_quantiles=1;
				posterior_kernel(theta_cand,&logPOS_cand,0,0);
				m_b_get_quantiles=0;

				theta_curr=theta_cand;
				logPOS_curr=logPOS_cand;
				ipar_curr=m_m_iPar;
				itpar_curr=m_m_iTPar;
				ithpar_curr=m_m_iTHPar;
				prob_curr=m_v_Probs;
				adpar_curr=m_v_AddPars;
				
				logl_curr=m_d_Logl;
				exc_curr=m_v_Exceptions;
				curr_instab_ind=m_b_instab_ind;

				acc_sum=acc_sum+acc_ind;
				acc_count++;
				
				if (logl_curr>logl_max)
				{
					logl_max=logl_curr;
					logl_max_par=theta_curr;
				}
	
				if (pos_max>logPOS_curr)
				{
					pos_max=logPOS_curr;
					pos_max_par=theta_curr;
				}
	
			}

			instab_count=instab_count+curr_instab_ind;
			exc_count=exc_count+exc_curr;
			p_mean[0]=p_mean[0]+theta_curr';
			p_cvm[0]=p_cvm[0]+theta_curr*theta_curr';

			p_mean[1]=p_mean[1]+ipar_curr';
			p_cvm[1]=p_cvm[1]+ipar_curr*ipar_curr';
			m_prob=m_prob+prob_curr;
			
			i_count++;

			ip_res[i_lcbas][]=ipar_curr';
			sp_res[i_lcbas][]=theta_curr';
			add_par_res[i_lcbas][]=adpar_curr;
			
			//println(add_par_res[i_lcbas][]);

			iT_par_mean=iT_par_mean+itpar_curr;
			iT_par_stdev=iT_par_stdev+itpar_curr.^2;

			ad_par_mean=ad_par_mean+(adpar_curr~ranu(1,sizec(ad_par_mean)-sizec(adpar_curr)));
			ad_par_stdev=ad_par_stdev+(adpar_curr~ranu(1,sizec(ad_par_mean)-sizec(adpar_curr))).^2;
			
			nrest=nrest+exp(-logl_curr+m_iNRsc);

			for (i_l1=0;i_l1<4;i_l1++)
			{
				ithp_res[i_l1][ithp_count][]=ithpar_curr[][i_l1]';
			}

			if (m_i_inMean_mode>0)
			{
				ithp_res[4][ithp_count][]=ithpar_curr[][4]';
			}
						
			ithp_count=ithp_count+1;
			
			if (ithp_count==1000)
			{
				for (i_l2=0;i_l2<sizer(ithpar_curr);i_l2++)
				{
					ithp_hist0[i_l2].append_data(ithp_res[0][][i_l2]);
					ithp_hist1[i_l2].append_data(ithp_res[1][][i_l2]);
					ithp_hist2[i_l2].append_data(ithp_res[2][][i_l2]);
					ithp_hist3[i_l2].append_data(ithp_res[3][][i_l2]);

					if (m_i_inMean_mode>0)
					{
						ithp_hist4[i_l2].append_data(ithp_res[4][][i_l2]);
	
					}

				}

				println("lc", i_lcbas);
				ithp_count=0;
			}

			
		}
		println("acc", acc_count);
		savemat("acc_summary.xlsx",(acc_sum/acc_count)~(acc_count/i_count));
		
		for(i_l1=0;i_l1<m_i_iParBasic_Num;i_l1++)
		{
			println(m_as_iPar_Labels[i_l1]);
			println(moments(ip_res[][i_l1]));
			ip_hist[i_l1].append_data(ip_res[][i_l1]);
			sp_hist[i_l1].append_data(sp_res[][i_l1]);
		}
		
		for(i_l1=0;i_l1<sizec(ad_par_mean);i_l1++)
		{
			add_par_hist[i_l1].append_data(add_par_res[][i_l1]);
		}
		
		ip_res=zeros(m_iBasicCycle,m_i_iParBasic_Num);
		sp_res=zeros(m_iBasicCycle,m_i_iParBasic_Num);
		add_par_res=zeros(m_iBasicCycle,sizeof(m_as_addPar_Labels));
	}


	// posterior mean/cvmatrix for interpretable/statistical parameters
	
	p_mean[0]=p_mean[0]/i_count;
	p_mean[1]=p_mean[1]/i_count;

	p_cvm[0]=p_cvm[0]/i_count-p_mean[0]'p_mean[0];
	p_cvm[1]=p_cvm[1]/i_count-p_mean[1]'p_mean[1];

	savemat("m1.xlsx", p_mean[0]);
	savemat("m2.xlsx", p_mean[1]);	
	savemat("cvm1.xlsx", p_cvm[0]);
	savemat("cvm_ip.xlsx", p_cvm[1],m_as_iPar_Labels);
	
	iT_par_mean=iT_par_mean/i_count;
	iT_par_stdev=iT_par_stdev/i_count-iT_par_mean.^2;
	iT_par_stdev=iT_par_stdev.^0.5;

	ad_par_mean=ad_par_mean/i_count;
	ad_par_stdev=ad_par_stdev/i_count-ad_par_mean.^2;
	ad_par_stdev=ad_par_stdev.^0.5;

	savemat("post_es.xlsx",	 (p_mean[1]~ad_par_mean)|((diagonal(p_cvm[1])).^0.5~ad_par_stdev),m_as_iPar_Labels|m_as_addPar_Labels);


	
	savemat("acc_summary.xlsx",(acc_sum/acc_count)~(acc_count/i_count));
	

	savemat("add_par_res.xlsx",ad_par_mean|ad_par_stdev,m_as_addPar_Labels);
	
	as_namT=new array [sizec(iT_par_mean)];

	for (i_l1=0;i_l1<sizec(iT_par_mean);i_l1++)
	{
		as_namT[i_l1]="E{ "~m_as_iTPar_Labels[i_l1]~" |y}";
	}
	savemat("iTpar_exp.xlsx", iT_par_mean,as_namT);

	for (i_l1=0;i_l1<sizec(iT_par_mean);i_l1++)
	{
		as_namT[i_l1]="D{ "~m_as_iTPar_Labels[i_l1]~" |y}";
	}

	savemat("iTpar_stdev.xlsx", iT_par_stdev, as_namT);
		
	savemat("probs.xlsx",(m_prob/i_count)~m_prob,m_as_probLabels~m_as_probLabels);
	
	println("acceptance ratio:  ", acc_count/i_count);

	println("Log10 NR  ", log10(i_count)-log10(nrest)+m_iNRsc*log10(exp(1)));
	savemat("_NR.xlsx",(log10(i_count)-log10(nrest)+m_iNRsc*log10(exp(1)))~(acc_count/i_count));

//	println("LogL max  ", logl_max);
//	savemat("Logl_max.xlsx",logl_max);

	println("WARNING: instability prob: ", instab_count/i_count);
	println("instability limit: ", m_d_lim_corr_ht);
	println("WARNING: exceptions: ", exc_count);
	println("WARNING: frac of exc: ", exc_count/i_count);

	savemat("instab_report.xlsx", instab_count~(instab_count/i_count)~m_d_lim_corr_ht);
	savemat("excp.xlsx", exc_count~exc_count/i_count);
	// histograms for interpretable parameters

	mq_pom=zeros(201,m_i_iParBasic_Num+1);
	as_nam=new array [m_i_iParBasic_Num+1];
	
	for(i_l1=0;i_l1<m_i_iParBasic_Num;i_l1++)
	{
		
		his_pom=ip_hist[i_l1].get_histo1d(100,0.01);
		DrawHistogram(i_l1,his_pom[][1]',his_pom[1][0],his_pom[2][0]-his_pom[1][0]);
		DrawTitle(i_l1, m_as_iPar_Labels[i_l1]);

		as_nam[i_l1+1]=m_as_iPar_Labels[i_l1];
		
		for(i_l2=0;i_l2<199;i_l2++)
		{
			mq_pom[i_l2][i_l1+1]=ip_hist[i_l1].get_quantile((1+i_l2)/200);
		}
	}

	for(i_l2=0;i_l2<201;i_l2++)
	{
		mq_pom[i_l2][0]=(1+i_l2)/200;
	}
	
	SaveDrawWindow("hist_ip.ps");
	SaveDrawWindow("hist_ip.eps");
	CloseDrawWindow();
	
	as_nam[0]="quantile";
	savemat("mq.xlsx",mq_pom, as_nam);


	//posterior mode
	bfgs_max=MaxBFGS(posterior_kernel, &pos_max_par, &pos_max, 0, TRUE);
	posterior_kernel(pos_max_par,&pos_max,0,0);
	
	ip_mp=m_m_iPar;
	ap_mp=m_v_AddPars;

	
	//maximum likelihood
	m_i_kernel_mode=1;
	bfgs_max=MaxBFGS(posterior_kernel, &logl_max_par, &logl_max, 0, TRUE);

	
	m_i_kernel_mode=0;

	println("LogL max  ", logl_max);
	savemat("Logl_max.xlsx",logl_max);
	
	//log posterior kernel at maximum likelihood
	posterior_kernel(logl_max_par,&logPOS_curr,0,0);
	ip_ml=m_m_iPar;
	ap_ml=m_v_AddPars;

	
	//log posterior kernel at posterior mean
	theta_cand=p_mean[0]';
	posterior_kernel(theta_cand,&logPOS_cand,0,0);
	ip_pe=m_m_iPar;
	ap_pe=m_v_AddPars;
	
	as_nam[0]="log post kernel";
	// histograms for statistical parameters

	mq_pom=(pos_max~(pos_max_par')~(ip_mp')~ap_mp)|(logPOS_curr~(logl_max_par')~(ip_ml')~ap_ml)|(logPOS_cand~p_mean[0]~(ip_pe')~ap_pe);
	
	savemat("point_est.xlsx",mq_pom, as_nam~m_as_iPar_Labels~m_as_addPar_Labels);
	
	for(i_l1=0;i_l1<m_i_iParBasic_Num;i_l1++)
	{
		his_pom=sp_hist[i_l1].get_histo1d(100,0.01);
		DrawHistogram(i_l1,his_pom[][1]',his_pom[1][0],his_pom[2][0]-his_pom[1][0]);
		DrawTitle(i_l1, m_as_iPar_Labels[i_l1]);
	}

	SaveDrawWindow("hist_sp.ps");
	SaveDrawWindow("hist_sp.eps");
	CloseDrawWindow();
	
	mq_pom=zeros(201,sizec(ad_par_mean)+1);
	as_nam=new array [sizec(ad_par_mean)+1];
	
	for(i_l1=0;i_l1<sizec(ad_par_mean);i_l1++)
	{
		his_pom=add_par_hist[i_l1].get_histo1d(100,0.01);
		DrawHistogram(i_l1,his_pom[][1]',his_pom[1][0],his_pom[2][0]-his_pom[1][0]);
		DrawTitle(i_l1, m_as_addPar_Labels[i_l1]);

		as_nam[i_l1+1]=m_as_addPar_Labels[i_l1];
		
		for(i_l2=0;i_l2<199;i_l2++)
		{
			mq_pom[i_l2][i_l1+1]=add_par_hist[i_l1].get_quantile((1+i_l2)/200);
		}
		
	}

	for(i_l2=0;i_l2<201;i_l2++)
	{
		mq_pom[i_l2][0]=(1+i_l2)/200;
	}
		
	as_nam[0]="quantile";
	savemat("mq_add.xlsx",mq_pom, as_nam);
		
	SaveDrawWindow("hist_add.ps");
	SaveDrawWindow("hist_add.eps");
	CloseDrawWindow();		  

		m_res_h=zeros(1,10);
	
	for (i_l1=0;i_l1<sizer(m_m_iTHPar);i_l1++)
	{
		m_res_h=m_res_h|(<0.05>~ithp_hist0[i_l1].get_quantile(0.05)~<0.1>~ithp_hist0[i_l1].get_quantile(0.1)~<0.125>~ithp_hist0[i_l1].get_quantile(0.125)~<0.2>~ithp_hist0[i_l1].get_quantile(0.2)~<0.25>~ithp_hist0[i_l1].get_quantile(0.25)~<0.5>~ithp_hist0[i_l1].get_quantile(0.5)~<0.75>~ithp_hist0[i_l1].get_quantile(0.75)~<0.8>~ithp_hist0[i_l1].get_quantile(0.8)~<0.875>~ithp_hist0[i_l1].get_quantile(0.875)~<0.9>~ithp_hist0[i_l1].get_quantile(0.9)~<0.95>~ithp_hist0[i_l1].get_quantile(0.95)~<111>~ithp_hist0[i_l1].get_mode()~<30>~(ithp_hist0[i_l1].get_hpd(0.3)'~(zeros(1,8-sizer(ithp_hist0[i_l1].get_hpd(0.3)))))~<50>~(ithp_hist0[i_l1].get_hpd(0.5)'~(zeros(1,8-sizer(ithp_hist0[i_l1].get_hpd(0.5)))))~<60>~(ithp_hist0[i_l1].get_hpd(0.6)'~(zeros(1,8-sizer(ithp_hist0[i_l1].get_hpd(0.6)))))~<75>~(ithp_hist0[i_l1].get_hpd(0.75)'~(zeros(1,8-sizer(ithp_hist0[i_l1].get_hpd(0.75)))))~<90>~(ithp_hist0[i_l1].get_hpd(0.9)'~(zeros(1,8-sizer(ithp_hist0[i_l1].get_hpd(0.9))))));
		delete ithp_hist0[i_l1];
 	}
																																						  
	savemat("thres_ni1.xlsx",m_res_h);

	m_res_h=zeros(1,10);

	for (i_l1=0;i_l1<sizer(m_m_iTHPar);i_l1++)
	{
		m_res_h=m_res_h|(<0.05>~ithp_hist1[i_l1].get_quantile(0.05)~<0.1>~ithp_hist1[i_l1].get_quantile(0.1)~<0.125>~ithp_hist1[i_l1].get_quantile(0.125)~<0.2>~ithp_hist1[i_l1].get_quantile(0.2)~<0.25>~ithp_hist1[i_l1].get_quantile(0.25)~<0.5>~ithp_hist1[i_l1].get_quantile(0.5)~<0.75>~ithp_hist1[i_l1].get_quantile(0.75)~<0.8>~ithp_hist1[i_l1].get_quantile(0.8)~<0.875>~ithp_hist1[i_l1].get_quantile(0.875)~<0.9>~ithp_hist1[i_l1].get_quantile(0.9)~<0.95>~ithp_hist1[i_l1].get_quantile(0.95)~<111>~ithp_hist1[i_l1].get_mode()~<30>~(ithp_hist1[i_l1].get_hpd(0.3)'~(zeros(1,8-sizer(ithp_hist1[i_l1].get_hpd(0.3)))))~<50>~(ithp_hist1[i_l1].get_hpd(0.5)'~(zeros(1,8-sizer(ithp_hist1[i_l1].get_hpd(0.5)))))~<60>~(ithp_hist1[i_l1].get_hpd(0.6)'~(zeros(1,8-sizer(ithp_hist1[i_l1].get_hpd(0.6)))))~<75>~(ithp_hist1[i_l1].get_hpd(0.75)'~(zeros(1,8-sizer(ithp_hist1[i_l1].get_hpd(0.75)))))~<90>~(ithp_hist1[i_l1].get_hpd(0.9)'~(zeros(1,8-sizer(ithp_hist1[i_l1].get_hpd(0.9))))));
		delete ithp_hist1[i_l1];
	}

	savemat("thres_ni2.xlsx",m_res_h);

	m_res_h=zeros(1,10);
	
	for (i_l1=0;i_l1<sizer(m_m_iTHPar);i_l1++)
	{
		m_res_h=m_res_h|(<0.05>~ithp_hist2[i_l1].get_quantile(0.05)~<0.1>~ithp_hist2[i_l1].get_quantile(0.1)~<0.125>~ithp_hist2[i_l1].get_quantile(0.125)~<0.2>~ithp_hist2[i_l1].get_quantile(0.2)~<0.25>~ithp_hist2[i_l1].get_quantile(0.25)~<0.5>~ithp_hist2[i_l1].get_quantile(0.5)~<0.75>~ithp_hist2[i_l1].get_quantile(0.75)~<0.8>~ithp_hist2[i_l1].get_quantile(0.8)~<0.875>~ithp_hist2[i_l1].get_quantile(0.875)~<0.9>~ithp_hist2[i_l1].get_quantile(0.9)~<0.95>~ithp_hist2[i_l1].get_quantile(0.95)~<111>~ithp_hist2[i_l1].get_mode()~<30>~(ithp_hist2[i_l1].get_hpd(0.3)'~(zeros(1,8-sizer(ithp_hist2[i_l1].get_hpd(0.3)))))~<50>~(ithp_hist2[i_l1].get_hpd(0.5)'~(zeros(1,8-sizer(ithp_hist2[i_l1].get_hpd(0.5)))))~<60>~(ithp_hist2[i_l1].get_hpd(0.6)'~(zeros(1,8-sizer(ithp_hist2[i_l1].get_hpd(0.6)))))~<75>~(ithp_hist2[i_l1].get_hpd(0.75)'~(zeros(1,8-sizer(ithp_hist2[i_l1].get_hpd(0.75)))))~<90>~(ithp_hist2[i_l1].get_hpd(0.9)'~(zeros(1,8-sizer(ithp_hist2[i_l1].get_hpd(0.9))))));
		delete ithp_hist2[i_l1];
	}

	savemat("thres_ucv.xlsx",m_res_h);

	m_res_h=zeros(1,10);
	
	for (i_l1=0;i_l1<sizer(m_m_iTHPar);i_l1++)
	{
		m_res_h=m_res_h|(<0.05>~ithp_hist3[i_l1].get_quantile(0.05)~<0.1>~ithp_hist3[i_l1].get_quantile(0.1)~<0.125>~ithp_hist3[i_l1].get_quantile(0.125)~<0.2>~ithp_hist3[i_l1].get_quantile(0.2)~<0.25>~ithp_hist3[i_l1].get_quantile(0.25)~<0.5>~ithp_hist3[i_l1].get_quantile(0.5)~<0.75>~ithp_hist3[i_l1].get_quantile(0.75)~<0.8>~ithp_hist3[i_l1].get_quantile(0.8)~<0.875>~ithp_hist3[i_l1].get_quantile(0.875)~<0.9>~ithp_hist3[i_l1].get_quantile(0.9)~<0.95>~ithp_hist3[i_l1].get_quantile(0.95)~<111>~ithp_hist3[i_l1].get_mode()~<30>~(ithp_hist3[i_l1].get_hpd(0.3)'~(zeros(1,8-sizer(ithp_hist3[i_l1].get_hpd(0.3)))))~<50>~(ithp_hist3[i_l1].get_hpd(0.5)'~(zeros(1,8-sizer(ithp_hist3[i_l1].get_hpd(0.5)))))~<60>~(ithp_hist3[i_l1].get_hpd(0.6)'~(zeros(1,8-sizer(ithp_hist3[i_l1].get_hpd(0.6)))))~<75>~(ithp_hist3[i_l1].get_hpd(0.75)'~(zeros(1,8-sizer(ithp_hist3[i_l1].get_hpd(0.75)))))~<90>~(ithp_hist3[i_l1].get_hpd(0.9)'~(zeros(1,8-sizer(ithp_hist3[i_l1].get_hpd(0.9))))));
		delete ithp_hist3[i_l1];
	}

	savemat("thres_ucd.xlsx",m_res_h);

	m_res_h=zeros(1,10);
	
	if (m_i_inMean_mode>0)
	{
		for (i_l1=0;i_l1<sizer(m_m_iTHPar);i_l1++)
		{
			m_res_h=m_res_h|(<0.05>~ithp_hist4[i_l1].get_quantile(0.05)~<0.1>~ithp_hist4[i_l1].get_quantile(0.1)~<0.125>~ithp_hist4[i_l1].get_quantile(0.125)~<0.2>~ithp_hist4[i_l1].get_quantile(0.2)~<0.25>~ithp_hist4[i_l1].get_quantile(0.25)~<0.5>~ithp_hist4[i_l1].get_quantile(0.5)~<0.75>~ithp_hist4[i_l1].get_quantile(0.75)~<0.8>~ithp_hist4[i_l1].get_quantile(0.8)~<0.875>~ithp_hist4[i_l1].get_quantile(0.875)~<0.9>~ithp_hist4[i_l1].get_quantile(0.9)~<0.95>~ithp_hist4[i_l1].get_quantile(0.95)~<111>~ithp_hist4[i_l1].get_mode()~<30>~(ithp_hist4[i_l1].get_hpd(0.3)'~(zeros(1,8-sizer(ithp_hist4[i_l1].get_hpd(0.3)))))~<50>~(ithp_hist4[i_l1].get_hpd(0.5)'~(zeros(1,8-sizer(ithp_hist4[i_l1].get_hpd(0.5)))))~<60>~(ithp_hist4[i_l1].get_hpd(0.6)'~(zeros(1,8-sizer(ithp_hist4[i_l1].get_hpd(0.6)))))~<75>~(ithp_hist4[i_l1].get_hpd(0.75)'~(zeros(1,8-sizer(ithp_hist4[i_l1].get_hpd(0.75)))))~<90>~(ithp_hist4[i_l1].get_hpd(0.9)'~(zeros(1,8-sizer(ithp_hist4[i_l1].get_hpd(0.9))))));
			delete ithp_hist4[i_l1];
		}

		savemat("thres_inm.xlsx",m_res_h);

	}
	
}



