
%% Persistence polynomial Sieve Bootstrap

%% Screen Flushing
echo off
clc
clear

%% Fix the generator
state=3248306;
rand('state',state);
randn('state',state);

%% Entering the Bootstrap numerous delays and max length:
bs=input('Enter the number of bootstrap sample:');   % number of bootstrapt samples
p=input('number of maxsimum lags(for example:-4):');       % number of maxsimum lags

%% Dongu zamanini sifirlayalim.
donguZamani=0;

%% Read the data set 
X = xlsread('resid.xls');
[T,N]=size(X);
M=T;
%% Data 1. 
DX=diff(X);

%% The selection of the appropriate model
model=input('Enter the test (1 for ucar_omay test, 2 for IPS test):');

%% The average torque values relating to the appropriate model
if model==1
    moment1=-1.6300338;
    moment2=0.72405396;
else
    moment1=-1.5328908;
    moment2=0.69554092;
end

%% Separately determining the length of the delay and the estimation process for the data relating to the original model using each country
for i=1:N
    x=X(:,i);
    dx=DX(:,i);
    if model==1
        for t=1:T
            x1(t,1)=x(t)*x(t)*x(t); 
        end
    else
            x1=x;
    end
    x1lag=lagmatrix(x1,1); 
    
    % p=0 SIC values for the calculation of the
        W=[ones(T-1,1) x1lag(2:T)];
        alfa=inv(W'*W)*(W'*dx(1:T-1));
        epsilon=dx(1:T-1)-W*alfa;
        llhood(1)=-(T-1)/2*(1+log(2*pi)+log(epsilon'*epsilon/(T-1)));
        sic(1)=-2*(llhood(1)/(T-1));     
    % p=>1 SIC values for the calculation of
    for j=p:-1
        dxlag=lagmatrix(dx,(1:-j));
        W=[ones(T-1+j,1) x1lag(-j+2:T) dxlag(-j+1:T-1,:)];
        alfa=inv(W'*W)*(W'*dx(-j+1:T-1)); 
        epsilon=dx(-j+1:T-1)-W*alfa;
        llhood(-j)=-(T-1+j)/2*(1+log(2*pi)+log(epsilon'*epsilon/(T-1+j)));
        sic(-j+1)=-2*(llhood(-j)/(T-1+j))+(-j)*log(T-1+j)/(T-1+j);        
    end
      
    % p (lag order)is chosen via SIC
    enk=sic(1);
    for j=1:-p+1;
        if sic(j)<=enk;
            enk=sic(j);
            enkno=j-1; 
        end
    end
    sbcno(i,1)=enkno;
    dxlag=lagmatrix(dx,(1:enkno));
    % The original unit root equation y(t-1)'calcluation of tvalue:
    W=[ones(T-1-enkno,1) x1lag(enkno+2:T) dxlag(enkno+1:T-1,:)];
    alfa=inv(W'*W)*(W'*dx(enkno+1:T-1)); 
    epsilon=dx(enkno+1:T-1)-W*alfa;
    SSR=epsilon'*epsilon;
    sigmakare=SSR/(T-1-enkno-(enkno+2));
    var_cov=inv(W'*W)*sigmakare;
    tvalue(i)=alfa(2)/(var_cov(2,2))^0.5;
    clear W alfa epsilon SSR sigmakare var_cov x dx
end

%% tbar statistics obtained from original data
tbar=mean(tvalue);
zbar=sqrt(N)*(tbar-moment1)/sqrt(moment2);

%% Sieve Bootstarp Step2
for i=1:N
    [n,m]=size(DX); % n=zaman boyutu, m=birey says
    clear m
    sbc=sbcno(i,1);
    dxlag=lagmatrix(DX(:,i),(1:sbc));
    if sbc==0
      W=[ones(n-sbc,1)];
    else
      W=[ones(n-sbc,1) dxlag(sbc+1:n,:)];
    end
    alfa=inv(W'*W)*(W'*DX(sbc+1:n,i));
    epsilon=DX(sbc+1:n,i)-W*alfa;
    epsilon1(1:n-sbc,i)=epsilon;
    clear epsilon W
    alfa1(1:1+sbc,i)=alfa;
    clear alfa  
end
clear enkno

%% Step 2' den elde edilen artklarn zaman boyutunda ortalamadan karlmas
pmax=max(sbcno);
epsilontilda=epsilon1-[kron(ones(n-pmax,1),mean(epsilon1(1:n-pmax,:)));zeros(pmax,N)];

%% Step 3: Bootstrap hatalarn retilmesi
for s=1:bs;
    tic
    clear epsboot 
    star=unidrnd(n-pmax,n+M,1);
    for j=1:n+M
        epsboot(j,:)=epsilontilda(star(j,1),:);
    end
    
%% Step 4:  Generate stationary dy*(t) 
    for i=1:N
      sbc=sbcno(i,1);
        if sbc==0
            for t=1:n+M
                dxstar(t,i)=alfa1(1,i)+ epsboot(t,i);
            end
        elseif sbc==1
            dxstar(1,i)=alfa1(1,i)+ epsboot(1,i);
                for t=2:n+M
                    W=[1 dxstar(t-1,i)];
                    dxstar(t,i)=W*alfa1(1:2,i)+ epsboot(t,i);
                end
        else
              dxstar(1,i)=alfa1(1,i)+ epsboot(1,i);
            % t<=sbc for dy(t)values of calculations
            for t=2:sbc
                for j=2:t;
                    XY1(j-1)=dxstar(t-j+1,i);
                end
                    dxstar(t,i)=alfa1(1,i)+ XY1(1:t-1)*alfa1(2:t,i)+epsboot(t,i);
            end
            % t>sbc for dy(t)values of calculations
            for t=sbc+1:n+M
                for m=1:sbc
                    XY3(m)=dxstar(t-m,i);
                end
                dxstar(t,i)=alfa1(1,i)+ XY3(1:sbc)*alfa1(2:1+sbc,i)+epsboot(t,i); 
            end
        end
    end
    
%% Step 4: Duraan olmayan TxN boyutlu xstar matrisinin elde edilmesi 
    xstar=cumsum(dxstar(M+1:n+M,:));
    dxstar=diff(xstar); 

%% xstar matrix estimated using the process of governing according to the model
    for i=1:N
      sbc=sbcno(i,1);
      [n,m]=size(xstar);
      clear m
      % Selection of appropriate model 
        if model==1
            for t=1:n
                xstar1(t,1)=xstar(t,i)*xstar(t,i)*xstar(t,i);
            end
        else
            xstar1=xstar(:,i);
        end
         
        xstarlag=lagmatrix(xstar1,1);
        dxstarlag=lagmatrix(dxstar(:,i),(1:sbc));
        
    if sbc==0
       W=[ones(n-1,1) xstarlag(2:n)];
    else
       W=[ones(n-sbc-1,1) xstarlag(sbc+2:n) dxstarlag(sbc+1:n-1,:)];
    end

    alfa=inv(W'*W)*(W'*dxstar(sbc+1:n-1,i));
    epsilon=dxstar(sbc+1:n-1,i)-W*alfa;
    SSR=epsilon'*epsilon;
    sigmakare=SSR/(n-(2+sbc));
    var_cov=inv(W'*W)*sigmakare;
    tvalue1(i)=alfa(2)/sqrt(var_cov(2,2));
    clear alfa epsilon SSR sigmakare var_cov
    end
    tbar1(s,1)=mean(tvalue1);
    zbar1(s,1)=sqrt(N)*(tbar1(s,1)-moment1)/sqrt(moment2);
    %%the last 100 trials in total cycle calculates'm short of time.
    donguZamani=donguZamani+toc;
    
    %%My short that calculates the estimated time
    if mod(s,2500)==0 && s~=bs
        clc;
        'Deneme no:'
        s
        'Kalan tahmini sre (dakika):'
        ((donguZamani/2500)*(bs-s))/60
        donguZamani=0;
    end    
end

%% Bootstrap test statistic sralanmas and 5% of the value of obtaining a critical value:     
   tbarBoot=sort(tbar1);
   zbarBoot=sort(zbar1);
%% tbar istatistiine ilikin p deerlerini bulduran ksm.
p_value1=0;
pBuldu=0;
if tbar<=tbarBoot(1,1)
    pBuldu=1;
    p_value1=0;
    else if tbar>=tbarBoot(bs,1)
            pBuldu=1;
            p_value1=1;
        end
end    
for j=2:bs
    if pBuldu==0
        if tbarBoot(j-1,1)<=tbar && tbar<tbarBoot(j,1)
            pBuldu=1;
            p_value1=(j-1)/bs;
        end
    end
end
clear pBuldu

%% zbar istatistiine ilikin p deerlerini bulduran ksm.
p_value2=0;
pBuldu=0;
if zbar<=zbarBoot(1,1)
    pBuldu=1;
    p_value2=0;
    else if zbar>=zbarBoot(bs,1)
            pBuldu=1;
            p_value2=1;
    end
end

for j=2:bs
    if pBuldu==0
        if zbarBoot(j-1,1)<=zbar && zbar<zbarBoot(j,1)
            pBuldu=1;
            p_value2=(j-1)/bs;
        end
    end
end

%% Istatistikleri ve bootstrap p degerlerini ekrana yazdir
'tbar:'
tbar
'p value for tbar statistics:'
p_value1    
'zbar:'
zbar 
'p value for zbar statistics'
p_value2    

