rm(list=ls())

library(GeneralizedHyperbolic)
library(mvtnorm)



chain <- function(P){

	pi <- matrix(1/3,3,1)

	states <- matrix(0, Tsize, 1)

	dart <- runif(1)

	if (dart <= pi[1]){
		states[1] <- 1
	} else if ( (pi[1] < dart) & (dart < (pi[1] + pi[2])) ){
		 states[1] <- 2
	}  else states[1] <- 3

	for (t in 2:Tsize){
		dart <- runif(1)
		i <- states[t-1]

		if (dart <= P[i,1]){
			states[t] <- 1
		} else if ( (P[i,1] < dart) & (dart < (P[i,1] + P[i,2])) ){
			 states[t] <- 2
		}  else states[t] <- 3

	}
	return(states)
}



check_stationarity <- function(phis){
	phi1 <- phis[1]
	phi2 <- phis[2]
	phi3 <- phis[3]
	flag <- 0
	if ((phi2 + phi1+	phi3  < 1) & (phi2 - phi1 < 1) &(	phi3 -phi2<1)& (abs(phi2) < 1)& (abs(phi3) < 1)) flag <- 1
	return(flag)
}



check <- function(u,alpha){
	ans <-  u*( alpha- (u < 0) )
	return(ans)
}



filter <- function(pars,y){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi[1]  <- pars[5]
	phi[2]  <- pars[6]
  	phi[3]  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3


	ps0 <- matrix(0,3,1)

	ps11 <- matrix(0,3,3)

	ps2 <- array(0,dim=c(3,3,3,3))
	fva <- array(0,dim=c(3,3,3,3))


	f <- matrix(0,Tsize)

	filterprob <- matrix(0,Tsize,2)

	filterprob[1,1] <- pi1; filterprob[1,2] <- pi2;

	ps11[1,1] <- pi1*P[1,1];   ps11[1,2] <- pi1*P[1,2]; ps11[1,3] <- pi1*P[1,3]
	ps11[2,1] <- pi2*P[2,1];   ps11[2,2] <- pi2*P[2,2]; ps11[2,3] <- pi2*P[2,3]
	ps11[3,1] <- pi3*P[3,1];   ps11[3,2] <- pi3*P[3,2]; ps11[3,3] <- pi3*P[3,3]

  	ps1 <- array(ps11[1,1],c(3,3,3))

	for (k in 1:2){
		ps0[k] <- ps11[1,k] + ps11[2,k] + ps11[3,k]
	}

	filterprob[2,1] <- ps0[1]; filterprob[2,2] <- ps0[2]


        
	for (t in 4:Tsize){
	 for (si in 1:3) {
		for (i in 1:3){
			for (j in 1:3){
				for (k in 1:3){
					ps2[si,i,j,k] <- ps1[si,i,j] * P[j,k]
					er <- ( y[t] - mu[k] - phi[1]*(y[t-1] - mu[j]) - phi[2]*(y[t-2]- mu[i]) - phi[3]*(y[t-3]- mu[si]) )/sigma
					pdf <- Alpha * (1-Alpha) * exp( -check(er,Alpha) ) /sigma
					fva[si,i,j,k] <- pdf * ps2[si,i,j,k]
				}
			}
		}
		}
		f[t] <- 0
		for (si in 1:3) {
			for (i in 1:3){
				for (j in 1:3){
					for (k in 1:3){
						f[t] <- f[t] + fva[si,i,j,k]
					}
				}
			}
		}
		for (i in 1:3){
			for (j in 1:3){
				for (k in 1:3){
					for (si in 1:3) {
						ps2[si,i,j,k] <- fva[si,i,j,k]/f[t]
					}
				}
			}
		}

		for (i in 1:3){
			for (j in 1:3){
				for (k in 1:3){
					ps1[i,j,k] <- ps2[1,i,j,k] + ps2[2,i,j,k]	+ + ps2[3,i,j,k]
				}
			}
		}
		for (j in 1:3){
			for (k in 1:3){
				ps11[j,k] <- ps1[1,j,k] + ps1[2,j,k] + ps1[3,j,k]
			}
		}
		for (k in 1:3){
			ps0[k] <- ps11[1,k] + ps11[2,k] + ps11[3,k]
		}

		filterprob[t,1] <- ps0[1]; filterprob[t,2] <- ps0[2]
	}
	return(filterprob)
}



gen_bin3 <- function(p){
	dart <- runif(1)
	if (dart <= p[1]){
		state <- 1
	} else if ( (p[1] < dart) & (dart <= (p[1] + p[2])) ){
		 state <- 2
	}  else state <- 3
	return(state)
}



gen_s_singlemove  <- function(pars,y,states){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states

	# Case 1

	S[1] <- gen_bin3(c(pi1,pi2))

	t <- 2
	g1 <- P[S[t-1],1] * P[1,S[t+1]]
	g2 <- P[S[t-1],2] * P[2,S[t+1]]
	g3 <- P[S[t-1],3] * P[3,S[t+1]]

	p1 <- g1 /  ( g1 + g2 + g3)
	p2 <- g2 /  ( g1 + g2 + g3)

	S[t] <- gen_bin3(c(p1,p2))


	for (t in 3:(Tsize-2)){

		# Case 2
		e1 <- ( y[t]    - mu[1]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
		f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

		e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[1] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
		f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

		e3 <- ( y[t+2] - mu[S[t+2]] - phi1*( y[t+1] - mu[S[t+1]] )     - phi2*( y[t]   - mu[1])- phi3*( y[t-1] - mu[S[t-1]] ))/sigma
		f3 <- exp(-check(e3)) * Alpha * (1-Alpha) /sigma

		g1 <- P[S[t-1],1] * P[1,S[t+1]] * f1 * f2 * f3

		##

		e1 <- ( y[t]    - mu[2]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
		f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

		e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[2] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
		f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

		e3 <- ( y[t+2] - mu[S[t+2]] - phi1*( y[t+1] - mu[S[t+1]] )     - phi2*( y[t]   - mu[2]      )-  phi3*( y[t-1] - mu[S[t-1]] ))/sigma
		f3 <- exp(-check(e3)) * Alpha * (1-Alpha) /sigma


		g2 <- P[S[t-1],2] * P[2,S[t+1]] * f1 * f2 * f3

		##

		e1 <- ( y[t]    - mu[3]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
		f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

		e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[3] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
		f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

		e3 <- ( y[t+2] - mu[S[t+2]] - phi1*( y[t+1] - mu[S[t+1]] )     - phi2*( y[t]   - mu[3]      )-  phi3*( y[t-1] - mu[S[t-1]] ))/sigma
		f3 <- exp(-check(e3)) * Alpha * (1-Alpha) /sigma

		g3 <- P[S[t-1],3] * P[3,S[t+1]] * f1 * f2 * f3

		p1 <- g1 /  ( g1 + g2 + g3)
		p2 <- g2 /  ( g1 + g2 + g3)

		S[t] <- gen_bin3(c(p1,p2))

	}

	# Case 3
	t <- Tsize-1


	e1 <- ( y[t]    - mu[1]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[1] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
	f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

	g1 <- P[S[t-1],1] * P[1,S[t+1]] * f1 * f2

	##

	e1 <- ( y[t]    - mu[2]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[2] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
	f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

	g2 <- P[S[t-1],2] * P[2,S[t+1]] * f1 * f2

	##

	e1 <- ( y[t]    - mu[3]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[3] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
	f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

	g3 <- P[S[t-1],3] * P[3,S[t+1]] * f1 * f2


	p1 <- g1 /  ( g1 + g2 + g3)
	p2 <- g2 /  ( g1 + g2 + g3)

	S[t] <- gen_bin3(c(p1,p2))


	t <- Tsize

	e1 <- ( y[t]    - mu[1]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	g1 <- P[S[t-1],1] * f1

	##

	e1 <- ( y[t]    - mu[2]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	g2 <- P[S[t-1],2] * f1

	##

	e1 <- ( y[t]    - mu[3]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	g3 <- P[S[t-1],3] * f1


	p1 <- g1 /  ( g1 + g2 + g3)
	p2 <- g2 /  ( g1 + g2 + g3)

	S[t] <- gen_bin3(c(p1,p2))

	return(S)
}



gen_s_multimove <- function(pars,y){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	s_t <- matrix(0,Tsize,1)
	flt_pr <- filter(pars,y)
	s_t[Tsize] <- gen_bin3(flt_pr[Tsize,])
	for (t in (Tsize-1):1){
		if (s_t[t+1] == 1){
			p1 <- ( P[1,1]*flt_pr[t,1] )/	( P[1,1]*flt_pr[t,1] + P[2,1]*flt_pr[t,2] + P[3,1]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
			p2 <- ( P[2,1]*flt_pr[t,2] )/	( P[1,1]*flt_pr[t,1] + P[2,1]*flt_pr[t,2] + P[3,1]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
		}
		if (s_t[t+1] == 2){
			p1 <- ( P[1,2]*flt_pr[t,1] )/	( P[1,2]*flt_pr[t,1] + P[2,2]*flt_pr[t,2] + P[3,2]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
			p2 <- ( P[2,2]*flt_pr[t,2] )/	( P[1,2]*flt_pr[t,1] + P[2,2]*flt_pr[t,2] + P[3,2]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
		}
		if (s_t[t+1] == 3){
			p1 <- ( P[1,3]*flt_pr[t,1] )/	( P[1,3]*flt_pr[t,1] + P[2,3]*flt_pr[t,2] + P[3,3]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
			p2 <- ( P[2,3]*flt_pr[t,2] )/	( P[1,3]*flt_pr[t,1] + P[2,3]*flt_pr[t,2] + P[3,3]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
		}
		s_t[t] <- gen_bin3(c(p1,p2))
	}
	return(s_t)
}



count_switches <- function(states){
	counts <- matrix(0,3,3)
	for (t in 2:Tsize){
		counts[ states[t-1],states[t] ] <- counts[ states[t-1],states[t] ] + 1
	}
	return(counts)
}



gen_P <- function(states,alphas){		# Sample Dirichlet distribution
	counts <- count_switches(states)
	P <- matrix(0,3,3)
	for (i in 1:3){
		y <- matrix(0,3,1)
		for (j in 1:3){
			y[j] <- rgamma(1,alphas[i,j] + counts[i,j])
		}
		P[i,] <- y/sum(y)
	}
	return(P)
}



gen_v <- function(pars,y, states){


	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10];  p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states

	vtil <- matrix(0,Tsize,1)

	vtil[1:2] <- rexp(2,sigma)

	for (t in 4:Tsize){
		deltahat2 <-  (y[t] - mu[S[t]] - phi1*(y[t-1] - mu[S[t-1]]) - phi2*(y[t-2] - mu[S[t-2]]) - phi3*(y[t-3] - mu[S[t-3]])   )^2 /(sigma*Tau^2)
		
		if (deltahat2 == 0) deltahat2 <- 1e-8		
		
		gammahat2 <-  2/sigma + Theta^2/(sigma*Tau^2)

		vtil[t] <- rgig(1,param=c(chi=deltahat2,psi=gammahat2,lambda=0.5))
	}
	return(vtil)
}



gen_sigma <- function(pars,y,states,v){


	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10];  p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states

	v1 <- v0 + 3*(Tsize-2)

    ss <-  sum(2*v[4:Tsize] +  (y[4:Tsize] - mu[S[4:Tsize]] - phi1*(y[3:(Tsize-1)] - mu[S[3:(Tsize-1)]])  - phi2*(y[2:(Tsize-2)] - mu[S[2:(Tsize-2)]]) - phi3*(y[1:(Tsize-3)] - mu[S[1:(Tsize-3)]])  - Theta*v[4:Tsize])^2/(v[4:Tsize]*Tau^2))

	delta1 <- delta0 + ss

	c <- rgamma(n=1,shape=v1/2,rate=delta1/2)

	sig2_F <- 1/c

	return(sig2_F)
}



gen_mu <- function(pars, y, states, v){
	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10];  p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states

	S1star <- (states[4:Tsize]==1) - phi1*(states[3:(Tsize-1)]==1) - phi2*(states[2:(Tsize-2)]==1) - phi3*(states[1:(Tsize-3)]==1)
	S2star <- (states[4:Tsize]==2) - phi1*(states[3:(Tsize-1)]==2) - phi2*(states[2:(Tsize-2)]==2) - phi3*(states[1:(Tsize-3)]==2)
	S3star <- (states[4:Tsize]==3) - phi1*(states[3:(Tsize-1)]==3) - phi2*(states[2:(Tsize-2)]==3) - phi3*(states[1:(Tsize-3)]==3)

	S1star <- S1star/sqrt(v[4:Tsize])
	S2star <- S2star/sqrt(v[4:Tsize])
	S3star <- S3star/sqrt(v[4:Tsize])


	ystar <- y[4:Tsize] - phi1*y[3:(Tsize-1)] - phi2*y[2:(Tsize-2)] - phi3*y[1:(Tsize-3)]
	ystar <- (ystar - Theta*v[4:Tsize])/sqrt(v[4:Tsize])

	Sstar <- cbind(S1star,S2star,S3star)

	A1 <- solve( A0inv + t(Sstar) %*% Sstar/(sigma*Tau^2)  )

	a1 <- A1 %*% (A0inv %*% a0 + t(Sstar) %*% ystar /(sigma*Tau^2)  )

	C <- chol(A1)

	mu_post <- a1 + t(C) %*% rnorm(3)

	while ( (mu_post[2] < mu_post[1] ) | (mu_post[3] < mu_post[2]) )  mu_post <- a1 + t(C) %*% rnorm(3)

	return(mu_post)
}



gen_phi <- function(pars, y, states, v){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states

	ystar <- y[4:Tsize] - mu[states[4:Tsize]]
	ystar <- (ystar - Theta*v[4:Tsize])/sqrt(v[4:Tsize])

	Xstar <- cbind((y[3:(Tsize-1)] - mu[states[3:(Tsize-1)]])/sqrt(v[4:Tsize]) , (y[2:(Tsize-2)] - mu[states[2:(Tsize-2)]])/sqrt(v[4:Tsize]), (y[1:(Tsize-3)] - mu[states[1:(Tsize-3)]])/sqrt(v[4:Tsize]) )

	B1 <- solve( B0inv + t(Xstar) %*% Xstar/(sigma*Tau^2)  )

	b1 <- B1 %*% (B0inv %*% b0 + t(Xstar) %*% ystar /(sigma*Tau^2)  )

	C <- chol(B1)

	phi_post <- b1 + t(C)%*%rnorm(3)

	while (check_stationarity(phi_post) == 0)  phi_post <- b1 + t(C)%*%rnorm(3)

	return(phi_post)
}









rirq <- read.table("QuarterlyRealInterestRate.txt",head=T)

st <- which(rirq[,1]=="4/1/1947" )
en <- which(rirq[,1]=="4/1/2015")
y <- rirq[st:en,2]

Tsize <- length(y)

dev.new()
plot(ts(y))
 

Tsize <- length(y)








## Read in results from previous quantile level (denoted here as "Alpha")

inputs <- scan("outputfile.txt")

previousAlpha <- inputs[1]

muhat <- inputs[2:4]
phihat <- inputs[6:8]
stateshat <- inputs[15:length(inputs)]


previous_quantiles <- muhat[stateshat[4:Tsize]] + phihat[1]*( y[3:(Tsize-1)] - muhat[ stateshat[3:(Tsize-1)] ]  ) 
      											+ phihat[2]*( y[2:(Tsize-2)] - muhat[ stateshat[2:(Tsize-2)] ]  ) 
      											+ phihat[3]*( y[1:(Tsize-3)] - muhat[ stateshat[1:(Tsize-3)] ]  )

## New quantile level 

Alpha <- 0.4

Theta <- (1-2*Alpha)/(Alpha*(1-Alpha))
Tau <- sqrt(  2/( Alpha*(1-Alpha) )  )


###

p11 <- inputs[9];  	p12 <- inputs[12];	  
p21 <- inputs[10]; 	p22 <- inputs[13];	  
p31 <- inputs[11]; 	p32 <- inputs[14];  	  


mu <- c(-1.5, 1.3, 4)


Mus <- matrix(0, 3, 1)
for (i in 1:3){
	Mus[i] <- mu[i] + qnorm(Alpha)			
}


a0 <- matrix(0,3,1)
a0 <- Mus


A0 <- diag(3)/25
A0inv <- solve(A0)



b0 <- c(0,0, 0)
B0 <- diag(3)/25
B0inv <- solve(B0)



v0 <- 0.1
delta0 <- 0.1


alphas <- matrix(0.1,3,3)




burnin <- 500
N <- 2000

NN <- burnin + N





Phis <- matrix(0, 3, 1) 
Sigma <- 1

pars0 <- rbind(Mus,Sigma,Phis,p11,p21,p31,p12,p22,p32)


pars00 <- pars0


pars1 <- matrix(0, NN, 13+Tsize+Tsize)
yhat1 <- matrix(0, NN, Tsize) 



singlemove <- 0  # 1 for single move
multimove  <- 1  # 1 for multi move


screenout <- matrix(0,8,2)

screenout[1,1] <- "Draw #"
screenout[2,1] <- "mu 1"
screenout[3,1] <- "mu 2"
screenout[4,1] <- "mu 3"
screenout[5,1] <- "sigma"
screenout[6,1] <- "phi 1"
screenout[7,1] <- "phi 2"
screenout[8,1] <- "phi 3"


for (i in 1:NN){
	
	statestil <- stateshat

	pars1[i,(13+1):(13+Tsize)] <- statestil
		
	pars0[8:13] <-  inputs[9:14]
	
	vtil <- gen_v(pars0,y,statestil)
		
	pars1[i,(13+Tsize+1):(13+Tsize+Tsize)] <- vtil
	
	sigmatil <- gen_sigma(pars0,y,statestil,vtil)

	pars0[4] <- sigmatil

	mutil  <- gen_mu(pars0,y,statestil,vtil)		
	
	phitil <- pars0[5:7]
												
	new_quantiles <- mutil[statestil[4:Tsize]] 	+ phitil[1]*( y[3:(Tsize-1)] - mutil[ statestil[3:(Tsize-1)] ]  )  
               									+ phitil[2]*( y[2:(Tsize-2)] - mutil[ statestil[2:(Tsize-2)] ]  )
                								+ phitil[3]*( y[1:(Tsize-3)] - mutil[ statestil[1:(Tsize-3)] ]  )
	
	ans <- FALSE	

	if ( Alpha < previousAlpha ){	
		if (sum(new_quantiles < previous_quantiles) == length(previous_quantiles) ) ans <- TRUE			
	}
	if ( Alpha > previousAlpha ){	
		if (sum(new_quantiles > previous_quantiles) == length(previous_quantiles) ) ans <- TRUE			
	}
				
	while ( ans == FALSE )  {    	# Monotonicity constraints

		mutil  <- gen_mu(pars0,y,statestil,vtil)		

		new_quantiles <-  mutil[statestil[4:Tsize]] + phitil[1]*( y[3:(Tsize-1)] - mutil[ statestil[3:(Tsize-1)] ]  )  
               										+ phitil[2]*( y[2:(Tsize-2)] - mutil[ statestil[2:(Tsize-2)] ]  )
                									+ phitil[3]*( y[1:(Tsize-3)] - mutil[ statestil[1:(Tsize-3)] ]  )
	
		if ( Alpha < previousAlpha ){	
			if (sum(new_quantiles < previous_quantiles) == length(previous_quantiles) ) ans <- TRUE				
		}

		if ( Alpha > previousAlpha ){	
			if (sum(new_quantiles > previous_quantiles) == length(previous_quantiles) ) ans <- TRUE			
		}
	} 

	pars0[1:3] <- mutil
		
	phitil <- gen_phi(pars0,y,statestil,vtil)
												
	new_quantiles <- mutil[statestil[4:Tsize]] 	+ phitil[1]*( y[3:(Tsize-1)] - mutil[ statestil[3:(Tsize-1)] ]  )  
               									+ phitil[2]*( y[2:(Tsize-2)] - mutil[ statestil[2:(Tsize-2)] ]  )
                								+ phitil[3]*( y[1:(Tsize-3)] - mutil[ statestil[1:(Tsize-3)] ]  )
	
	ans <- FALSE	

	if ( Alpha < previousAlpha ){	
		if (sum(new_quantiles < previous_quantiles) == length(previous_quantiles) ) ans <- TRUE			
	}
	if ( Alpha > previousAlpha ){	
		if (sum(new_quantiles > previous_quantiles) == length(previous_quantiles) ) ans <- TRUE			
	}


	while ( ans == FALSE )  {    	# Monotonicity constraints

		phitil <- gen_phi(pars0,y,statestil,vtil)	

		new_quantiles <-  mutil[statestil[4:Tsize]] + phitil[1]*( y[3:(Tsize-1)] - mutil[ statestil[3:(Tsize-1)] ]  )  
               										+ phitil[2]*( y[2:(Tsize-2)] - mutil[ statestil[2:(Tsize-2)] ]  )
                									+ phitil[3]*( y[1:(Tsize-3)] - mutil[ statestil[1:(Tsize-3)] ]  )
	
		if ( Alpha < previousAlpha ){	
			if (sum(new_quantiles < previous_quantiles) == length(previous_quantiles) ) ans <- TRUE				
		}

		if ( Alpha > previousAlpha ){	
			if (sum(new_quantiles > previous_quantiles) == length(previous_quantiles) ) ans <- TRUE			
		}
	} 

	pars0[5:7] <- phitil

	pars1[i, 1:13] <- pars0
			
	yhat1[i, 4:Tsize] <- new_quantiles
	
	screenout[1,2] <- i
	screenout[2,2] <- round(mutil[1], digits=4)
	screenout[3,2] <- round(mutil[2], digits=4)	
	screenout[4,2] <- round(mutil[3], digits=4)	
	screenout[5,2] <- round(sigmatil, digits=4)	
	screenout[6,2] <- round(phitil[1], digits=4)
	screenout[7,2] <- round(phitil[2], digits=4)	
	screenout[8,2] <- round(phitil[3], digits=4)	

	print(screenout)	
	
}



parshat <- matrix(0,13,1)

parshat <- apply(pars1[(burnin+1):NN,1:13],2,mean)
	

print("Constrained parameter estimates")
show(parshat)


muhat <- parshat[1:3]
phihat <- parshat[5:7]
new_quantiles <-  muhat[statestil[4:Tsize]] + phihat[1]*( y[3:(Tsize-1)] - muhat[ statestil[3:(Tsize-1)] ]  )  
               								+ phihat[2]*( y[2:(Tsize-2)] - muhat[ statestil[2:(Tsize-2)] ]  )
                							+ phihat[3]*( y[1:(Tsize-3)] - muhat[ statestil[1:(Tsize-3)] ]  )


dev.new()
plot(ts(y[4:Tsize]))
lines(previous_quantiles,col="red")
lines(new_quantiles,col="blue")



## Save quantile level, parameter estimates, and state classification to output file

write(c( Alpha, parshat, stateshat), file="outputfile.txt")

 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 