rm(list=ls())

library(GeneralizedHyperbolic)
library(mvtnorm)



chain <- function(P){

	pi <- matrix(1/3,3,1)

	states <- matrix(0, Tsize, 1)

	dart <- runif(1)

	if (dart <= pi[1]){
		states[1] <- 1
	} else if ( (pi[1] < dart) & (dart < (pi[1] + pi[2])) ){
		 states[1] <- 2
	}  else states[1] <- 3

	for (t in 2:Tsize){
		dart <- runif(1)
		i <- states[t-1]

		if (dart <= P[i,1]){
			states[t] <- 1
		} else if ( (P[i,1] < dart) & (dart < (P[i,1] + P[i,2])) ){
			 states[t] <- 2
		}  else states[t] <- 3

	}
	return(states)
}



check_stationarity <- function(phis){
	phi1 <- phis[1]
	phi2 <- phis[2]
	phi3 <- phis[3]
	flag <- 0
	if ((phi2 + phi1+	phi3  < 1) & (phi2 - phi1 < 1) &(	phi3 -phi2<1)& (abs(phi2) < 1)& (abs(phi3) < 1)) flag <- 1
	return(flag)
}



check <- function(u,alpha){
	ans <-  u*( alpha- (u < 0) )
	return(ans)
}



filter <- function(pars,y){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi[1]  <- pars[5]
	phi[2]  <- pars[6]
  	phi[3]  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3


	ps0 <- matrix(0,3,1)

	ps11 <- matrix(0,3,3)

	ps2 <- array(0,dim=c(3,3,3,3))
	fva <- array(0,dim=c(3,3,3,3))


	f <- matrix(0,Tsize)

	filterprob <- matrix(0,Tsize,2)

	filterprob[1,1] <- pi1; filterprob[1,2] <- pi2;

	ps11[1,1] <- pi1*P[1,1];   ps11[1,2] <- pi1*P[1,2]; ps11[1,3] <- pi1*P[1,3]
	ps11[2,1] <- pi2*P[2,1];   ps11[2,2] <- pi2*P[2,2]; ps11[2,3] <- pi2*P[2,3]
	ps11[3,1] <- pi3*P[3,1];   ps11[3,2] <- pi3*P[3,2]; ps11[3,3] <- pi3*P[3,3]

  	ps1 <- array(ps11[1,1],c(3,3,3))

	for (k in 1:2){
		ps0[k] <- ps11[1,k] + ps11[2,k] + ps11[3,k]
	}

	filterprob[2,1] <- ps0[1]; filterprob[2,2] <- ps0[2]


        
	for (t in 4:Tsize){
		for (si in 1:3) {
			for (i in 1:3){
				for (j in 1:3){
					for (k in 1:3){
						ps2[si,i,j,k] <- ps1[si,i,j] * P[j,k]
						er <- ( y[t] - mu[k] - phi[1]*(y[t-1] - mu[j]) - phi[2]*(y[t-2]- mu[i]) - phi[3]*(y[t-3]- mu[si]) )/sigma
						pdf <- Alpha * (1-Alpha) * exp( -check(er,Alpha) ) /sigma
						fva[si,i,j,k] <- pdf * ps2[si,i,j,k]
					}
				}
			}
		}
		f[t] <- 0
		for (si in 1:3) {
			for (i in 1:3){
				for (j in 1:3){
					for (k in 1:3){
						f[t] <- f[t] + fva[si,i,j,k]
					}
				}
			}
		}
		for (i in 1:3){
			for (j in 1:3){
				for (k in 1:3){
					for (si in 1:3) {
						ps2[si,i,j,k] <- fva[si,i,j,k]/f[t]
					}
				}
			}
		}

		for (i in 1:3){
			for (j in 1:3){
				for (k in 1:3){
					ps1[i,j,k] <- ps2[1,i,j,k] + ps2[2,i,j,k]	+ + ps2[3,i,j,k]
				}
			}
		}
		for (j in 1:3){
			for (k in 1:3){
				ps11[j,k] <- ps1[1,j,k] + ps1[2,j,k] + ps1[3,j,k]
			}
		}
		for (k in 1:3){
			ps0[k] <- ps11[1,k] + ps11[2,k] + ps11[3,k]
		}

		filterprob[t,1] <- ps0[1]; filterprob[t,2] <- ps0[2]
	}
	return(filterprob)
}



gen_bin3 <- function(p){
	dart <- runif(1)
	if (dart <= p[1]){
		state <- 1
	} else if ( (p[1] < dart) & (dart <= (p[1] + p[2])) ){
		 state <- 2
	}  else state <- 3
	return(state)
}



gen_s_singlemove  <- function(pars,y,states){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states

	# Case 1

	S[1] <- gen_bin3(c(pi1,pi2))

	t <- 2
	g1 <- P[S[t-1],1] * P[1,S[t+1]]
	g2 <- P[S[t-1],2] * P[2,S[t+1]]
	g3 <- P[S[t-1],3] * P[3,S[t+1]]

	p1 <- g1 /  ( g1 + g2 + g3)
	p2 <- g2 /  ( g1 + g2 + g3)

	S[t] <- gen_bin3(c(p1,p2))


	for (t in 3:(Tsize-2)){

		# Case 2
		e1 <- ( y[t]    - mu[1]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
		f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

		e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[1] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
		f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

		e3 <- ( y[t+2] - mu[S[t+2]] - phi1*( y[t+1] - mu[S[t+1]] )     - phi2*( y[t]   - mu[1])- phi3*( y[t-1] - mu[S[t-1]] ))/sigma
		f3 <- exp(-check(e3)) * Alpha * (1-Alpha) /sigma

		g1 <- P[S[t-1],1] * P[1,S[t+1]] * f1 * f2 * f3

		##

		e1 <- ( y[t]    - mu[2]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
		f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

		e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[2] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
		f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

		e3 <- ( y[t+2] - mu[S[t+2]] - phi1*( y[t+1] - mu[S[t+1]] )     - phi2*( y[t]   - mu[2]      )-  phi3*( y[t-1] - mu[S[t-1]] ))/sigma
		f3 <- exp(-check(e3)) * Alpha * (1-Alpha) /sigma


		g2 <- P[S[t-1],2] * P[2,S[t+1]] * f1 * f2 * f3

		##

		e1 <- ( y[t]    - mu[3]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
		f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

		e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[3] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
		f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

		e3 <- ( y[t+2] - mu[S[t+2]] - phi1*( y[t+1] - mu[S[t+1]] )     - phi2*( y[t]   - mu[3]      )-  phi3*( y[t-1] - mu[S[t-1]] ))/sigma
		f3 <- exp(-check(e3)) * Alpha * (1-Alpha) /sigma

		g3 <- P[S[t-1],3] * P[3,S[t+1]] * f1 * f2 * f3

		p1 <- g1 /  ( g1 + g2 + g3)
		p2 <- g2 /  ( g1 + g2 + g3)

		S[t] <- gen_bin3(c(p1,p2))

	}

	# Case 3
	t <- Tsize-1


	e1 <- ( y[t]    - mu[1]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[1] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
	f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

	g1 <- P[S[t-1],1] * P[1,S[t+1]] * f1 * f2

	##

	e1 <- ( y[t]    - mu[2]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[2] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
	f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

	g2 <- P[S[t-1],2] * P[2,S[t+1]] * f1 * f2

	##

	e1 <- ( y[t]    - mu[3]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	e2 <- ( y[t+1] - mu[S[t+1]] - phi1*( y[t]   - mu[3] )       - phi2*( y[t-1] - mu[S[t-1]] )-  phi3*( y[t-2] - mu[S[t-2]] ))/sigma
	f2 <- exp(-check(e2)) * Alpha * (1-Alpha) /sigma

	g3 <- P[S[t-1],3] * P[3,S[t+1]] * f1 * f2


	p1 <- g1 /  ( g1 + g2 + g3)
	p2 <- g2 /  ( g1 + g2 + g3)

	S[t] <- gen_bin3(c(p1,p2))


	t <- Tsize

	e1 <- ( y[t]    - mu[1]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	g1 <- P[S[t-1],1] * f1

	##

	e1 <- ( y[t]    - mu[2]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	g2 <- P[S[t-1],2] * f1

	##

	e1 <- ( y[t]    - mu[3]     - phi1*( y[t-1] - mu[S[t-1]] ) -  phi2*( y[t-2] - mu[S[t-2]] )-  phi3*( y[t-3] - mu[S[t-3]] ))/sigma
	f1 <- exp(-check(e1)) * Alpha * (1-Alpha) /sigma

	g3 <- P[S[t-1],3] * f1


	p1 <- g1 /  ( g1 + g2 + g3)
	p2 <- g2 /  ( g1 + g2 + g3)

	S[t] <- gen_bin3(c(p1,p2))

	return(S)
}



gen_s_multimove <- function(pars,y){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	s_t <- matrix(0,Tsize,1)
	flt_pr <- filter(pars,y)
	s_t[Tsize] <- gen_bin3(flt_pr[Tsize,])
	for (t in (Tsize-1):1){
		if (s_t[t+1] == 1){
			p1 <- ( P[1,1]*flt_pr[t,1] )/	( P[1,1]*flt_pr[t,1] + P[2,1]*flt_pr[t,2] + P[3,1]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
			p2 <- ( P[2,1]*flt_pr[t,2] )/	( P[1,1]*flt_pr[t,1] + P[2,1]*flt_pr[t,2] + P[3,1]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
		}
		if (s_t[t+1] == 2){
			p1 <- ( P[1,2]*flt_pr[t,1] )/	( P[1,2]*flt_pr[t,1] + P[2,2]*flt_pr[t,2] + P[3,2]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
			p2 <- ( P[2,2]*flt_pr[t,2] )/	( P[1,2]*flt_pr[t,1] + P[2,2]*flt_pr[t,2] + P[3,2]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
		}
		if (s_t[t+1] == 3){
			p1 <- ( P[1,3]*flt_pr[t,1] )/	( P[1,3]*flt_pr[t,1] + P[2,3]*flt_pr[t,2] + P[3,3]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
			p2 <- ( P[2,3]*flt_pr[t,2] )/	( P[1,3]*flt_pr[t,1] + P[2,3]*flt_pr[t,2] + P[3,3]*(1-flt_pr[t,1]-flt_pr[t,2] ) )
		}
		s_t[t] <- gen_bin3(c(p1,p2))
	}
	return(s_t)
}



count_switches <- function(states){
	counts <- matrix(0,3,3)
	for (t in 2:Tsize){
		counts[ states[t-1],states[t] ] <- counts[ states[t-1],states[t] ] + 1
	}
	return(counts)
}



gen_P <- function(states,alphas){		# Sample Dirichlet distribution
	counts <- count_switches(states)
	P <- matrix(0,3,3)
	for (i in 1:3){
		y <- matrix(0,3,1)
		for (j in 1:3){
			y[j] <- rgamma(1,alphas[i,j] + counts[i,j])
		}
		P[i,] <- y/sum(y)
	}
	return(P)
}



gen_v <- function(pars,y, states){
	
	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10];  p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states

	vtil <- matrix(0,Tsize,1)

	vtil[1:2] <- rexp(2,sigma)

	for (t in 4:Tsize){

		deltahat2 <-  (y[t] - mu[S[t]] - phi1*(y[t-1] - mu[S[t-1]]) - phi2*(y[t-2] - mu[S[t-2]]) - phi3*(y[t-3] - mu[S[t-3]])   )^2 /(sigma*Tau^2)
		
		if (deltahat2 == 0) deltahat2 <- 1e-8
		
		gammahat2 <-  2/sigma + Theta^2/(sigma*Tau^2)

		vtil[t] <- rgig(1,param=c(chi=deltahat2,psi=gammahat2,lambda=0.5))
		
	}
	return(vtil)
}



gen_sigma <- function(pars,y,states,v){


	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states

	v1 <- v0 + 3*(Tsize-2)

    ss <-  sum(2*v[4:Tsize] +  (y[4:Tsize] - mu[S[4:Tsize]] - phi1*(y[3:(Tsize-1)] - mu[S[3:(Tsize-1)]])  - phi2*(y[2:(Tsize-2)] - mu[S[2:(Tsize-2)]]) - phi3*(y[1:(Tsize-3)] - mu[S[1:(Tsize-3)]])  - Theta*v[4:Tsize])^2/(v[4:Tsize]*Tau^2))

	delta1 <- delta0 + ss

	c <- rgamma(n=1,shape=v1/2,rate=delta1/2)

	sig2_F <- 1/c

	return(sig2_F)
}



gen_mu <- function(pars, y, states, v){
	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10];  p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states

	S1star <- (states[4:Tsize]==1) - phi1*(states[3:(Tsize-1)]==1) - phi2*(states[2:(Tsize-2)]==1) - phi3*(states[1:(Tsize-3)]==1)
	S2star <- (states[4:Tsize]==2) - phi1*(states[3:(Tsize-1)]==2) - phi2*(states[2:(Tsize-2)]==2) - phi3*(states[1:(Tsize-3)]==2)
	S3star <- (states[4:Tsize]==3) - phi1*(states[3:(Tsize-1)]==3) - phi2*(states[2:(Tsize-2)]==3) - phi3*(states[1:(Tsize-3)]==3)

	S1star <- S1star/sqrt(v[4:Tsize])
	S2star <- S2star/sqrt(v[4:Tsize])
	S3star <- S3star/sqrt(v[4:Tsize])


	ystar <- y[4:Tsize] - phi1*y[3:(Tsize-1)] - phi2*y[2:(Tsize-2)] - phi3*y[1:(Tsize-3)]
	ystar <- (ystar - Theta*v[4:Tsize])/sqrt(v[4:Tsize])

	Sstar <- cbind(S1star,S2star,S3star)

	A1 <- solve( A0inv + t(Sstar) %*% Sstar/(sigma*Tau^2)  )

	a1 <- A1 %*% (A0inv %*% a0 + t(Sstar) %*% ystar /(sigma*Tau^2)  )

	C <- chol(A1)

	mu_post <- a1 + t(C) %*% rnorm(3)

	while ( (mu_post[2] < mu_post[1] ) | (mu_post[3] < mu_post[2]) )  mu_post <- a1 + t(C) %*% rnorm(3)

	return(mu_post)
}



gen_phi <- function(pars, y, states, v){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13]; 	p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states

	ystar <- y[4:Tsize] - mu[states[4:Tsize]]
	ystar <- (ystar - Theta*v[4:Tsize])/sqrt(v[4:Tsize])

	Xstar <- cbind((y[3:(Tsize-1)] - mu[states[3:(Tsize-1)]])/sqrt(v[4:Tsize]) , (y[2:(Tsize-2)] - mu[states[2:(Tsize-2)]])/sqrt(v[4:Tsize]), (y[1:(Tsize-3)] - mu[states[1:(Tsize-3)]])/sqrt(v[4:Tsize]) )

	B1 <- solve( B0inv + t(Xstar) %*% Xstar/(sigma*Tau^2)  )

	b1 <- B1 %*% (B0inv %*% b0 + t(Xstar) %*% ystar /(sigma*Tau^2)  )

	C <- chol(B1)

	phi_post <- b1 + t(C)%*%rnorm(3)

	while (check_stationarity(phi_post) == 0)  phi_post <- b1 + t(C)%*%rnorm(3)

	return(phi_post)
}









rirq <- read.table("QuarterlyRealInterestRate.txt",head=T)

st <- which(rirq[,1]=="4/1/1947" )
en <- which(rirq[,1]=="4/1/2015")
y<-rirq[st:en,2]

Tsize <- length(y)


#### Quantile level (denoted here as "Alpha")

Alpha <- 0.5


Theta <- (1-2*Alpha)/(Alpha*(1-Alpha))
Tau <- sqrt(  2/( Alpha*(1-Alpha) )  )



P <- matrix(0,3,3)



p11 <- 0.95;  	p12 <- 0.01;	  p13 <- 1-p11-p12
p21 <- 0.01; 	p22 <- 0.95;	  p23 <- 1-p21-p22
p31 <- 0.01; 	p32 <- 0.01 ;  	  p33 <- 1-p31-p32


P[1,] <- c(p11, p12, p13)
P[2,] <- c(p21, p22, p23)
P[3,] <- c(p31, p32, p33)



mu <- c(-1.5, 1.3, 4)


Mus <- matrix(0, 3, 1)
for (i in 1:3){
	Mus[i] <- mu[i] + qnorm(Alpha)
}


a0 <- matrix(0,3,1)
a0 <- Mus


A0 <- diag(3)/25
A0inv <- solve(A0)



b0 <- c(0, 0,0)
B0 <- diag(3)/25
B0inv <- solve(B0)



v0 <- 0.1
delta0 <- 0.1


alphas <- matrix(0.1,3,3)




burnin <- 500
N <- 2000

NN <- burnin + N





Phis <- matrix(0, 3, 1)
Sigma <- 1

pars0 <- rbind(Mus,Sigma,Phis,p11,p21,p31,p12,p22,p32)


pars00 <- pars0


pars1 <- matrix(0, NN, 13+Tsize+Tsize)
yhat1 <- matrix(0, NN, Tsize)



singlemove <- 0  # 1 for single move
multimove  <- 1  # 1 for multi move


statestil <- chain(P)


screenout <- matrix(0,14,2)

screenout[1,1] <- "Draw #"
screenout[2,1] <- "mu 1"
screenout[3,1] <- "mu 2"
screenout[4,1] <- "mu 3"
screenout[5,1] <- "sigma"
screenout[6,1] <- "phi 1"
screenout[7,1] <- "phi 2"
screenout[8,1] <- "phi 3"

screenout[9,1]  <- "p11"
screenout[10,1] <- "p21"
screenout[11,1] <- "p31"
screenout[12,1] <- "p12"
screenout[13,1] <- "p22"
screenout[14,1] <- "p32"


for (i in 1:NN){

	if (singlemove == 1 ) statestil <- gen_s_singlemove(pars0,y,statestil)
	if (multimove == 1 )  statestil <- gen_s_multimove(pars0,y)

	while ((sum(statestil == 1) < 5) | (sum(statestil == 2) < 5) | (sum(statestil == 3) < 5)) {
		if (singlemove == 1 ) statestil <- gen_s_singlemove(pars0,y,statestil)
		if (multimove == 1 )  statestil <- gen_s_multimove(pars0,y)
	}


	pars1[i,(13+1):(13+Tsize)] <- statestil
	
	Ptil <- gen_P(statestil,alphas)	
	
	pars0[8:13] <-  Ptil[1:6]
	
	vtil <- gen_v(pars0,y,statestil)
		
	pars1[i,(13+Tsize+1):(13+Tsize+Tsize)] <- vtil
	
	sigmatil <- gen_sigma(pars0,y,statestil,vtil)

	pars0[4] <- sigmatil

	mutil  <- gen_mu(pars0,y,statestil,vtil)		
	
	pars0[1:3] <- mutil
	
	phitil <- gen_phi(pars0,y,statestil,vtil)
					
	pars0[5:7] <- phitil
							
	pars1[i, 1:13] <- pars0


	new_quantiles <- mutil[statestil[4:Tsize]] 	+ phitil[1]*( y[3:(Tsize-1)] - mutil[ statestil[3:(Tsize-1)] ]  )  
              									+ phitil[2]*( y[2:(Tsize-2)] - mutil[ statestil[2:(Tsize-2)] ]  )
              									+ phitil[3]*( y[1:(Tsize-3)] - mutil[ statestil[1:(Tsize-3)] ]  )
		
	yhat1[i, 4:Tsize] <- new_quantiles
	

	screenout[1,2] <- i
	screenout[2,2] <- round(mutil[1], digits=4)
	screenout[3,2] <- round(mutil[2], digits=4)	
	screenout[4,2] <- round(mutil[3], digits=4)	
	screenout[5,2] <- round(sigmatil, digits=4)	
	screenout[6,2] <- round(phitil[1], digits=4)
	screenout[7,2] <- round(phitil[2], digits=4)	
	screenout[8,2] <- round(phitil[3], digits=4)	

	screenout[9,2]  <- round(Ptil[1], digits=4)	
	screenout[10,2] <- round(Ptil[2], digits=4)	
	screenout[11,2] <- round(Ptil[3], digits=4)	
	screenout[12,2] <- round(Ptil[4], digits=4)	
	screenout[13,2] <- round(Ptil[5], digits=4)	
	screenout[14,2] <- round(Ptil[6], digits=4)	


	print(screenout)	

	
}




parshat <- matrix(0,13,1)
yhat <- matrix(0,Tsize,1)

parshat <- apply(pars1[(burnin+1):NN,1:13],2,mean)

yhat <- apply(yhat1[(burnin+1):NN,],2,mean)

print("Parameter estimates")
show(parshat)


stateshat <- matrix(0,Tsize,1)
stateshat <- apply(pars1[(burnin+1):NN,(13+1):(13+Tsize)],2,mean)



quantstates <- stateshat


## Classification of states

pS <- matrix(0,3,Tsize)

temp <- pars1[(burnin+1):NN,(13+1):(13+Tsize)]


for (t in 1:Tsize){
	for (i in 1:3){
		pS[i,t] <- mean(temp[,t]==i)
	}
	quantstates[t] <- which.max(pS[,t])
}

par(mfrow=c(2,1))
plot(ts(stateshat,start=c(1947,1),freq=4))

plot(ts( quantstates,start=c(1947,1),freq=4))




## Save quantile level, parameter estimates, and state classification to output file

write(c( Alpha, parshat, quantstates), file="outputfile.txt")







#####################################################################################################################
#####################################################################################################################
#####################################################################################################################
#####################               						  #######################################################
##################### Computation of the marginal likelihood  #######################################################
#####################               						  #######################################################
#####################################################################################################################
#####################################################################################################################
#####################################################################################################################



log_Dirichlet <- function(x,alphas){
	lc <- lgamma(sum(alphas)) - sum(lgamma(alphas))
	lfd <- sum( (alphas-1)*log(x) ) + lc
	return(lfd)
}



log_inverted_Gamma <- function(x, alpha, beta){
	fig <- alpha*log(beta) - lgamma(alpha)
	fig <- fig + (alpha+1)*log(1/x)
	fig <- fig - beta/x
	return(fig)
}



log_like <- function(pars,y){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	ps0 <- matrix(0,3,1)

	ps11 <- matrix(0,3,3)

	ps2 <- array(0,dim=c(3,3,3,3))
	fva <- array(0,dim=c(3,3,3,3))


	f <- matrix(0,Tsize)

	filterprob <- matrix(0,Tsize,2)

	filterprob[1,1] <- pi1; filterprob[1,2] <- pi2;

	ps11[1,1] <- pi1*P[1,1];   ps11[1,2] <- pi1*P[1,2]; ps11[1,3] <- pi1*P[1,3]
	ps11[2,1] <- pi2*P[2,1];   ps11[2,2] <- pi2*P[2,2]; ps11[2,3] <- pi2*P[2,3]
	ps11[3,1] <- pi3*P[3,1];   ps11[3,2] <- pi3*P[3,2]; ps11[3,3] <- pi3*P[3,3]

  	ps1 <- array(ps11[1,1],c(3,3,3))

	for (k in 1:2){
		ps0[k] <- ps11[1,k] + ps11[2,k] + ps11[3,k]
	}

	filterprob[2,1] <- ps0[1]; filterprob[2,2] <- ps0[2]

	flike <- 0
        
  	for (t in 4:Tsize){
	 for (si in 1:3) {
		for (i in 1:3){
			for (j in 1:3){
				for (k in 1:3){
					ps2[si,i,j,k] <- ps1[si,i,j] * P[j,k]
					er <- ( y[t] - mu[k] - phi[1]*(y[t-1] - mu[j]) - phi[2]*(y[t-2]- mu[i]) - phi[3]*(y[t-3]- mu[si]) )/sigma
					pdf <- Alpha * (1-Alpha) * exp( -check(er,Alpha) ) /sigma
					fva[si,i,j,k] <- pdf * ps2[si,i,j,k]
				}
			}
		}
		}
		f[t] <- 0
		for (si in 1:3) {
			for (i in 1:3){
				for (j in 1:3){
					for (k in 1:3){
						f[t] <- f[t] + fva[si,i,j,k]
					}
				}
			}
		}
		flike <- flike + log(f[t])
		for (i in 1:3){
			for (j in 1:3){
				for (k in 1:3){
					 for (si in 1:3) {
						ps2[si,i,j,k] <- fva[si,i,j,k]/f[t]
				}
			}
		}
		}

		for (i in 1:3){
			for (j in 1:3){
				for (k in 1:3){
					ps1[i,j,k] <- ps2[1,i,j,k] + ps2[2,i,j,k] + ps2[3,i,j,k]
				}
			}
		}
		for (j in 1:3){
			for (k in 1:3){
				ps11[j,k] <- ps1[1,j,k] + ps1[2,j,k] + ps1[3,j,k]
			}
		}
		for (k in 1:3){
			ps0[k] <- ps11[1,k] + ps11[2,k] + ps11[3,k]
		}

		filterprob[t,1] <- ps0[1]; filterprob[t,2] <- ps0[2]
	}

	return(flike)
}


log_prior <- function(pars){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	lp1 <- log_Dirichlet( P[1,], alphas[1,] )  + log_Dirichlet( P[2,], alphas[2,]  )  + log_Dirichlet( P[3,], alphas[3,]  )

	lp2 <- log( dmvnorm(t(mu), mean=a0, sigma=A0 ) )

	lp3 <- log( dmvnorm(c(phi1,phi2, phi3), mean=b0, sigma=B0 ) )

	lp4 <- log_inverted_Gamma(sigma, v0/2, delta0/2 )

	lp <- lp1 + lp2 + lp3 + lp4
	return(lp)
}


log_post_mu <- function(pars, y, states, v){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states


	S1star <- (states[4:Tsize]==1) - phi1*(states[3:(Tsize-1)]==1) - phi2*(states[2:(Tsize-2)]==1) - phi3*(states[1:(Tsize-3)]==1)
	S2star <- (states[4:Tsize]==2) - phi1*(states[3:(Tsize-1)]==2) - phi2*(states[2:(Tsize-2)]==2) - phi3*(states[1:(Tsize-3)]==2)
	S3star <- (states[4:Tsize]==3) - phi1*(states[3:(Tsize-1)]==3) - phi2*(states[2:(Tsize-2)]==3)  - phi3*(states[1:(Tsize-3)]==3)

	S1star <- S1star/sqrt(v[4:Tsize])
	S2star <- S2star/sqrt(v[4:Tsize])
	S3star <- S3star/sqrt(v[4:Tsize])

	ystar <- y[4:Tsize] - phi1*y[3:(Tsize-1)] - phi2*y[2:(Tsize-2)] - phi3*y[1:(Tsize-3)]
	ystar <- (ystar - Theta*v[4:Tsize])/sqrt(v[4:Tsize])

	Sstar <- cbind(S1star,S2star,S3star)

	A1 <- solve( A0inv + t(Sstar) %*% Sstar/(sigma*Tau^2)  )

	a1 <- A1 %*% (A0inv %*% a0 + t(Sstar) %*% ystar /(sigma*Tau^2)  )

	ans <- log( dmvnorm(t(mu), mean=a1, sigma=A1) )

	return(ans)
}



log_post_sigma <- function(pars,y,states,v){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10]; p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states


	v1 <- v0 + 3*(Tsize-2)

   	ss <-  sum(2*v[4:Tsize] +  (y[4:Tsize] - mu[S[4:Tsize]] - phi1*(y[3:(Tsize-1)] - mu[S[3:(Tsize-1)]])  
   															- phi2*(y[2:(Tsize-2)] - mu[S[2:(Tsize-2)]])
   															- phi3*(y[1:(Tsize-3)] - mu[S[1:(Tsize-3)]])  - Theta*v[4:Tsize])^2/(v[4:Tsize]*Tau^2))

	delta1 <- delta0 + ss

	ans <- log_inverted_Gamma(sigma, v1/2, delta1/2)

	return( ans )
}



log_post_phi <- function(pars, y, states, v){


	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10];  p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	pi1 <- 1/3
	pi2 <- 1/3
	pi3 <- 1/3

	S <- states

	ystar <- y[4:Tsize] - mu[states[4:Tsize]]
	ystar <- (ystar - Theta*v[4:Tsize])/sqrt(v[4:Tsize])

	Xstar <- cbind((y[3:(Tsize-1)] - mu[states[3:(Tsize-1)]])/sqrt(v[4:Tsize]) , (y[2:(Tsize-2)] - mu[states[2:(Tsize-2)]])/sqrt(v[4:Tsize]) , (y[1:(Tsize-3)] - mu[states[1:(Tsize-3)]])/sqrt(v[4:Tsize]))

	B1 <- solve( B0inv + t(Xstar) %*% Xstar/(sigma*Tau^2)  )

	b1 <- B1 %*% (B0inv %*% b0 + t(Xstar) %*% ystar /(sigma*Tau^2)  )

	C <- chol(B1)

	phi_post <- b1 + t(C)%*%rnorm(3)

	ans <-   log( dmvnorm(c(phi[1],phi[2],phi[3]), mean=b1, sigma=B1) )

	return(ans)
}



log_post_P <- function(pars,states){

	mu <- matrix(0,3,1)
	mu[1] <- pars[1]
	mu[2] <- pars[2]
	mu[3] <- pars[3]
	sigma <- pars[4]
	phi <- matrix(0,3,1)
	phi1  <- pars[5]
	phi2  <- pars[6]
  	phi3  <- pars[7]

	P <- matrix(0, 3, 3)

	p11 <- pars[8];  p12 <- pars[11] ;  p13 <- 1-p11-p12
	p21 <- pars[9];  p22 <- pars[12] ;  p23 <- 1-p21-p22
	p31 <- pars[10];  p32 <- pars[13];   p33 <- 1-p31-p32

	P[1,] <- c(p11, p12, p13)
	P[2,] <- c(p21, p22, p23)
	P[3,] <- c(p31, p32, p33)

	counts <- count_switches(states)

	lp <- log_Dirichlet( P[1,], alphas[1,] + counts[1,] )  + log_Dirichlet( P[2,], alphas[2,] + counts[2,]  )  + log_Dirichlet( P[3,], alphas[3,] + counts[3,]  )

	return(lp)
}



mu_ordinate <- 0
for (i in (burnin+1):NN){
	statestil <- pars1[i,(13+1):(13+Tsize)]
	vtil <- pars1[i,(13+Tsize+1):(13+Tsize+Tsize)]
	parstemp <- pars1[i,1:13]
	parstemp[1:3] <- parshat[1:3]
	mu_ordinate <- mu_ordinate + exp( log_post_mu(parstemp, y, statestil, vtil) )
}
mu_ordinate <- mu_ordinate/N


pars2 <- matrix(0, N,13+Tsize+Tsize)
pars0 <- parshat
statestil <- stateshat

for (i in 1:N){

	if (singlemove == 1 ) statestil <- gen_s_singlemove(pars0,y,statestil)
	if (multimove == 1 )  statestil <- gen_s_multimove(pars0,y)

	while ((sum(statestil == 1) < 5) | (sum(statestil == 2) < 5) | (sum(statestil == 3) < 5)) {
		if (singlemove == 1 ) statestil <- gen_s_singlemove(pars0,y,statestil)
		if (multimove == 1 )  statestil <- gen_s_multimove(pars0,y)
	}

	pars2[i,(13+1):(13+Tsize)] <- statestil

	Ptil <- gen_P(statestil,alphas)

	pars0[8:13] <-  Ptil[1:6]

	vtil <- gen_v(pars0,y,statestil)

	pars2[i,(13+Tsize+1):(13+Tsize+Tsize)] <- vtil

	sigmatil <- gen_sigma(pars0,y,statestil,vtil)

	pars0[4] <- sigmatil

	phitil <- gen_phi(pars0,y,statestil,vtil)

	pars0[5:7] <- phitil

	pars2[i,1:13] <- pars0
	print(i)

}


sigma_ordinate <- 0
for (i in 1:N){
	statestil <- pars2[i,(13+1):(13+Tsize)]
	vtil <- pars2[i,(13+Tsize+1):(13+Tsize+Tsize)]
	parstemp <- pars2[i,1:13]
	parstemp[1:4] <- parshat[1:4]
	sigma_ordinate <- sigma_ordinate + exp(log_post_sigma(parstemp, y, statestil, vtil) )
}
sigma_ordinate <- sigma_ordinate/N



pars3 <- matrix(0, N,13+Tsize+Tsize)
pars0 <- parshat
statestil <- stateshat

for (i in 1:N){

	if (singlemove == 1 ) statestil <- gen_s_singlemove(pars0,y,statestil)
	if (multimove == 1 )  statestil <- gen_s_multimove(pars0,y)

	while ((sum(statestil == 1) < 5) | (sum(statestil == 2) < 5) | (sum(statestil == 3) < 5)) {
		if (singlemove == 1 ) statestil <- gen_s_singlemove(pars0,y,statestil)
		if (multimove == 1 )  statestil <- gen_s_multimove(pars0,y)
	}

	pars3[i,(13+1):(13+Tsize)] <- statestil

	Ptil <- gen_P(statestil,alphas)

	pars0[8:13] <-  Ptil[1:6]

	vtil <- gen_v(pars0,y,statestil)

	pars3[i,(13+Tsize+1):(13+Tsize+Tsize)] <- vtil

	phitil <- gen_phi(pars0,y,statestil,vtil)

	pars0[5:7] <- phitil

	pars3[i,1:13] <- pars0
	print(i)

}


phi_ordinate <- 0
for (i in 1:N){
	statestil <- pars3[i,(13+1):(13+Tsize)]
	vtil <- pars3[i,(13+Tsize+1):(13+Tsize+Tsize)]
	parstemp <- pars3[i,1:13]
	parstemp[1:6] <- parshat[1:6]
	phi_ordinate <- phi_ordinate + exp( log_post_phi(parstemp, y, statestil, vtil) )
}
phi_ordinate <- phi_ordinate/N



pars4 <- matrix(0,N,13+Tsize+Tsize)
pars0 <- parshat
statestil <- stateshat

for (i in 1:N){

	if (singlemove == 1 ) statestil <- gen_s_singlemove(pars0,y,statestil)
	if (multimove == 1 )  statestil <- gen_s_multimove(pars0,y)

	while ((sum(statestil == 1) < 5) | (sum(statestil == 2) < 5) | (sum(statestil == 3) < 5)) {
		if (singlemove == 1 ) statestil <- gen_s_singlemove(pars0,y,statestil)
		if (multimove == 1 )  statestil <- gen_s_multimove(pars0,y)
	}

	pars4[i,(13+1):(13+Tsize)] <- statestil

	Ptil <- gen_P(statestil,alphas)

	pars0[8:13] <-  Ptil[1:6]

	vtil <- gen_v(pars0,y,statestil)

	pars4[i,(13+Tsize+1):(13+Tsize+Tsize)] <- vtil

	pars4[i,1:13] <- pars0
	print(i)
}


P_ordinate <- 0
for (i in 1:N){
	statestil <- pars4[i,(13+1):(13+Tsize)]
	vtil <- pars4[i,(13+Tsize+1):(13+Tsize+Tsize)]
	parstemp <- pars4[i,1:13]
	parstemp[1:13] <- parshat[1:13]
	P_ordinate <- P_ordinate + exp( log_post_P(parstemp,statestil) )
}
P_ordinate <- P_ordinate/N




log_marginal_like  <- log_like(parshat,y) + log_prior(parshat) - log(mu_ordinate) - log(sigma_ordinate) - log(phi_ordinate) - log(P_ordinate)

show(log_marginal_like)


