######## Linearity Tests AR(1) ############

source("./R_functions.R");

N=100; # sample size 

script_id=1001;
alpha=0.05*(script_id-1000-1); # ARCH coefficient

## File path and name to save the results

filename1=paste("./power_",script_id,".txt",sep="");

######## Read Critical Values 

cval=read.table(paste("./critval_",script_id,".txt",sep=""),header=T,sep="\t"); 

Rep=1000; # number monte carlo simulations
repet=1000; # number of bootstrap samples for each simulation

# Luukonen et al (1988), Terasvirta (1994), Escribano and Jorda (1999) 

Rluuk=cbind(matrix(0,2,2),diag(1,2));
Rtera=cbind(matrix(0,3,2),diag(1,3));
Rescr=cbind(matrix(0,4,2),diag(1,4));

rluuk=rep(0,2);
rtera=rep(0,3);
rescr=rep(0,4);

wluuk=wtera=wescr=wluuk_hc0=wtera_hc0=wescr_hc0=wluuk_hc2=wtera_hc2=wescr_hc2=wluuk_hc3=wtera_hc3=wescr_hc3=matrix(NA,Rep,2); # F-stat and p-value
pboot_luuk <- pboot_tera <- pboot_escr <- vector();

y=u=0;
sigmay=1;
omega=1-alpha;

for(j in 1:Rep){
  print(j);
  e=rnorm(N,0,1);
  for(i in 2:N){
    sigmay[i]=sqrt(omega+alpha*u[i-1]^2);
    u[i]=e[i]*sigmay[i];	
    y[i]=.3*y[i-1]-.9*y[i-1]*(1-exp(-y[i-1]^2))+u[i];
  }
  ylev=y[-1];
  ylag=y[-N];
  xlin=cbind(1,ylag);
  xluuk=cbind(1,ylag,ylag^2,ylag^3);
  xtera=cbind(1,ylag,ylag^2,ylag^3,ylag^4);
  xescr=cbind(1,ylag,ylag^2,ylag^3,ylag^4,ylag^5);
  

  lr_luuk <- try(ols(x=xluuk,y=ylev),silent=T);
  lr_tera <- try(ols(x=xtera,y=ylev),silent=T);
  lr_escr <- try(ols(x=xescr,y=ylev),silent=T);

  # OLS
  wluuk[j,] <- wald_test(lr_luuk,Rluuk,rluuk); #F statistic and p-value
  wtera[j,] <- wald_test(lr_tera,Rtera,rtera); 
  wescr[j,] <- wald_test(lr_escr,Rescr,rescr); 


  # HCO
  wluuk_hc0[j,] <- wald_test_hc0(lr_luuk,Rluuk,rluuk); 
  wtera_hc0[j,] <- wald_test_hc0(lr_tera,Rtera,rtera); 
  wescr_hc0[j,] <- wald_test_hc0(lr_escr,Rescr,rescr); 


  # HC2
  wluuk_hc2[j,] <- wald_test_hc2(lr_luuk,Rluuk,rluuk); 
  wtera_hc2[j,] <- wald_test_hc2(lr_tera,Rtera,rtera); 
  wescr_hc2[j,] <- wald_test_hc2(lr_escr,Rescr,rescr); 


  # HC3

  wluuk_hc3[j,] <- wald_test_hc3(lr_luuk,Rluuk,rluuk); 
  wtera_hc3[j,] <- wald_test_hc3(lr_tera,Rtera,rtera); 
  wescr_hc3[j,] <- wald_test_hc3(lr_escr,Rescr,rescr); 


  ####################### Wild Bootstrap #############################

  boot_Fluuk <- boot_Ftera <- boot_Fescr <- vector();

  #### Linearity Restriction #####
  restr_lin <- try(ols_fit(x=xlin,y=ylev),silent=T);
  fit_lin <- restr_lin$fit;
  res_lin <- restr_lin$res;
  NRES <- NROW(res_lin);
  i=1;
  t=0;
  while(i <= repet || t==500){
	boot_res <- sample(c(1,-1),size=NRES,replace=T);
	y_lin <- fit_lin+boot_res*res_lin;
		
	boot_luuk <- try(ols(x=xluuk,y=y_lin),silent=T);
	boot_tera <- try(ols(x=xtera,y=y_lin),silent=T);
	boot_escr <- try(ols(x=xescr,y=y_lin),silent=T);

	boot_Fluuk[i] <- wald_test(boot_luuk,Rluuk,rluuk)[1];
	boot_Ftera[i] <- wald_test(boot_tera,Rtera,rtera)[1];  
	boot_Fescr[i] <- wald_test(boot_escr,Rescr,rescr)[1]; 
        if(is.na(boot_Fluuk[i]+boot_Ftera[i]+boot_Fescr[i])==F){
           i=i+1;
        }else{
           t=t+1;
	}
  }
  pboot_luuk[j]=sum(ifelse(boot_Fluuk>wluuk[j,1],1,0))/repet;
  pboot_tera[j]=sum(ifelse(boot_Ftera>wtera[j,1],1,0))/repet;		
  pboot_escr[j]=sum(ifelse(boot_Fescr>wescr[j,1],1,0))/repet;	

}

## Power 

p_luuk_ols=mean(ifelse(wluuk[,1]>=cval[1,1],1,0))
p_tera_ols=mean(ifelse(wtera[,1]>=cval[1,2],1,0))
p_escr_ols=mean(ifelse(wescr[,1]>=cval[1,3],1,0))


p_luuk_hc0=mean(ifelse(wluuk_hc0[,1]>=cval[2,1],1,0))
p_tera_hc0=mean(ifelse(wtera_hc0[,1]>=cval[2,2],1,0))
p_escr_hc0=mean(ifelse(wescr_hc0[,1]>=cval[2,3],1,0))

p_luuk_hc2=mean(ifelse(wluuk_hc2[,1]>=cval[3,1],1,0))
p_tera_hc2=mean(ifelse(wtera_hc2[,1]>=cval[3,2],1,0))
p_escr_hc2=mean(ifelse(wescr_hc2[,1]>=cval[3,3],1,0))

p_luuk_hc3=mean(ifelse(wluuk_hc3[,1]>=cval[4,1],1,0))
p_tera_hc3=mean(ifelse(wtera_hc3[,1]>=cval[4,2],1,0))
p_escr_hc3=mean(ifelse(wescr_hc3[,1]>=cval[4,3],1,0))

p_luuk_wb=mean(ifelse(pboot_luuk<=0.05,1,0));
p_tera_wb=mean(ifelse(pboot_tera<=0.05,1,0));
p_escr_wb=mean(ifelse(pboot_escr<=0.05,1,0));

######## Gathering results ########

#### size

power=rbind(c(p_luuk_ols,p_tera_ols,p_escr_ols),c(p_luuk_hc0,p_tera_hc0,p_escr_hc0),c(p_luuk_hc2,p_tera_hc2,p_escr_hc2),c(p_luuk_hc3,p_tera_hc3,p_escr_hc3),c(p_luuk_wb,p_tera_wb,p_escr_wb));

colnames(power)=c("lst","tera","ej");
rownames(power)=c("ols","hc0","hc2","hc3","wb");

write.table(power,file=filename1,sep="\t",row.names=F);



