
ols <- function(x,y){
	x <- as.matrix(x);
	y <- as.matrix(y);
	nrx <- NROW(x);
	ncx <- NCOL(x);
	q <- qr(x);
	Q <- qr.Q(q);
	b <- as.vector(qr.coef(q,y));
	res <- as.vector(qr.resid(q,y));
	R <- chol2inv(q$qr[1:ncx,1:ncx,drop=F]); #why??? this is inv(x'x)
	vc <- R*sum(res^2/(nrx-ncx));
	hatx <- hat(q,intercept=F);
	# se <- sqrt(diag(vc)); # this is the se of the coefficients
	return(list(b=b,vc=vc,R=R,Q=Q,x=x,hatx=hatx,res=res));
}

ols_fit <- function(x,y){
	x <- as.matrix(x);
	y <- as.vector(y);
	q <- qr(x);
	res <- as.vector(qr.resid(q,y));
	fitted <- y-res;
	return(list(fit=fitted,res=res));
}

ols_coef <- function(x,y){
	x <- as.matrix(x);
	y <- as.vector(y);
	q <- qr(x);
	b <- as.vector(qr.coef(q,y));
	return(b);
}


# THE HCCME
# The input for the hcmat is the list from the ols (Z)

hc0 <- function(Z){
	R <- Z$R;
	x <- Z$x;
	# Z$res^2 this is the diagonal of White omega matrix
	xomegax <- crossprod(x*Z$res^2,x);
	hc_0 <- R%*%xomegax%*%R;
	return(hc_0);
}

hc2 <- function(Z){
	R <- Z$R;
	x <- Z$x;
	# Z$res^2 this is the diagonal of White omega matrix
	xomegax <- crossprod(x*Z$res^2/(1-Z$hatx),x);
	hc_2 <- R%*%xomegax%*%R;
	return(hc_2);
}


hc3 <- function(Z){
	R <- Z$R;
	x <- Z$x;
	# Z$res^2 this is the diagonal of White omega matrix
	xomegax <- crossprod(x*Z$res^2/(1-Z$hatx)^2,x);
	hc_3 <- R%*%xomegax%*%R;
	return(hc_3);
}

############# THE WALD TESTS ###############################################

wald_test <- function(Z,R,r){
	nr <- NROW(R); # number of restrictions
	x <- Z$x;
	nrx <- NROW(x);
	ncx <- NCOL(x);
	vc <- Z$vc;
	b <- Z$b;
	w <- try(crossprod(R%*%b-r,solve(R%*%tcrossprod(vc,R)))%*%(R%*%b-r),silent=T);
	if(attributes(w)!="try-error"){
		F <- w/nr;
		pr <- 1-pf(F,nr,nrx-ncx);
	}else{
		F <- NA;
		pr <- NA;
	}
	return(c(F,pr));
}

wald_test_hc0 <- function(Z,R,r){
	nr <- NROW(R); # number of restrictions
	x <- Z$x;
	nrx <- NROW(x);
	ncx <- NCOL(x);
	vc <- hc0(Z);	
	b <- Z$b;
	w <- try(crossprod(R%*%b-r,solve(R%*%tcrossprod(vc,R)))%*%(R%*%b-r),silent=T);
	if(attributes(w)!="try-error"){
		F <- w/nr;
		pr <- 1-pf(F,nr,nrx-ncx);
	}else{
		F <- NA;
		pr <- NA;
	}
	return(c(F,pr));
}

# HC2

wald_test_hc2 <- function(Z,R,r){
	nr <- NROW(R); # number of restrictions
	x <- Z$x;
	nrx <- NROW(x);
	ncx <- NCOL(x);
	vc <- hc2(Z);	
	b <- Z$b;
	w <- try(crossprod(R%*%b-r,solve(R%*%tcrossprod(vc,R)))%*%(R%*%b-r),silent=T);
	if(attributes(w)!="try-error"){
                F <- w/nr;
                pr <- 1-pf(F,nr,nrx-ncx);
        }else{
                F <- NA;
                pr <- NA;
        }
        return(c(F,pr));
}

# HC3

wald_test_hc3 <- function(Z,R,r){
	nr <- NROW(R); # number of restrictions
	x <- Z$x;
	nrx <- NROW(x);
	ncx <- NCOL(x);
	vc <- hc3(Z);	
	b <- Z$b;
	w <- try(crossprod(R%*%b-r,solve(R%*%tcrossprod(vc,R)))%*%(R%*%b-r),silent=T);
	if(attributes(w)!="try-error"){
		F <- w/nr;
		pr <- 1-pf(F,nr,nrx-ncx);
	}else{
		F <- NA;
		pr <- NA;
	}
	return(c(F,pr));
}

