'Create an undated workfile with 10000 observations; Copy and paste the matrices mat_fmle and mat_fols (which contain the critical values obtained in the size experiment) to this workfile.

tic

!repet=1000	 ' the number of Monte Carlo Samples
!dis=100	' the number of observations to discard


vector(!repet) pols_t ' ols p-values for T test
vector(!repet) pmle_t ' mle p-values for T test
vector(!repet) fols_t ' ols F-stats for T test
vector(!repet) fmle_t ' mle F-stats for T test


matrix(9,3) mat_ols
matrix(9,3) mat_mle
matrix(9,3) mat_fols
matrix(9,3) mat_fmle

for !k=1 to 3

' Setting the sample size
if !k=1 then 
	!n=100
else
if !k=2 then
	!n=500
else
if !k=3 then
	!n=5000
endif
endif
endif

for !j=1 to 9

scalar plin_ols_lst=0
scalar plin_mle_lst=0
scalar plin_ols_t=0
scalar plin_mle_t=0
scalar plin_ols_ej=0
scalar plin_mle_ej=0
' ARCH parameters

scalar alpha=0.05*(!j-1)
scalar omega=1-alpha

smpl 1 1

' Initial Values
series z=nrnd
series h=1
series e=z*@sqrt(h)

series y=0

!i=1
while !i<=!repet

smpl 2 !n+!dis

series z=nrnd
series h=omega+alpha*z(-1)^2*h(-1)
series e=z*@sqrt(h)

series y=.3*y(-1)-.9*y(-1)*(1-exp(-y(-1)^2))+e ' ESTAR(1)


smpl !dis+1 !n+!dis

' Linearity Testing

' OLS Terasvirta
equation eq_t.ls y=c(1)+c(2)*y(-1)+c(3)*y(-1)*y(-1)+c(4)*y(-1)*y(-1)^2+c(5)*y(-1)*y(-1)^3
freeze(tab_t) eq_t.wald c(3)=0,c(4)=0,c(5)=0
pols_t(!i)=@val(tab_t(6,4))
fols_t(!i)=@val(tab_t(6,2))

' MLE Terasvirta
equation eq_t_mle.ARCH(1,0,BACKCAST=0.7,DERIV=AA)  y=c(1)+c(2)*y(-1)+c(3)*y(-1)*y(-1)+c(4)*y(-1)*y(-1)^2+c(5)*y(-1)*y(-1)^3
freeze(tab_t_mle) eq_t_mle.wald c(3)=0,c(4)=0,c(5)=0
pmle_t(!i)=@val(tab_t_mle(6,4))
fmle_t(!i)=@val(tab_t_mle(6,2))

scalar arch7=eq_t_mle.@coefs(7)

if arch7>0 then 'and arch7>0 and arch6>0
	!i=!i+1
endif

delete tab*

wend

' Probability of Rejecting the Null of Linearity

for !i=1 to !repet
	if fols_t(!i) > mat_fols(!j,!k) then
		plin_ols_t=plin_ols_t+1/!repet
	endif
	if fmle_t(!i) > mat_fmle(!j,!k) then
		plin_mle_t=plin_mle_t+1/!repet
	endif
next

'Power

mat_ols(!j,!k)=plin_ols_t
mat_mle(!j,!k)=plin_mle_t

next
next

scalar timer_sec=@toc


