'Create an undated workfile with 10000 observations; Copy and paste the matrices mat_fmle and mat_fols (which contain the critical values obtained in the size experiment) to this workfile.

tic

!repet=1000	 ' the number of Monte Carlo Samples
!dis=100	' the number of observations to discard

vector(!repet) pols_lst ' ols p-values for LST test
vector(!repet) pmle_lst ' mle p-values for LST test

vector(!repet) fols_lst ' ols F-stats for EJ test
vector(!repet) fmle_lst ' mle F-stats for EJ test


matrix(9,3) mat_ols
matrix(9,3) mat_mle
matrix(9,3) mat_fols
matrix(9,3) mat_fmle

for !k=1 to 3

' Setting the sample size
if !k=1 then 
	!n=100
else
if !k=2 then
	!n=500
else
if !k=3 then
	!n=5000
endif
endif
endif
 
for !j=1 to 9 ' We consider 9 values for the ARCH coefficient: 0.00, 0.05, 0.10, ..., 0.40

scalar plin_ols_lst=0
scalar plin_mle_lst=0
scalar plin_ols_t=0
scalar plin_mle_t=0
scalar plin_ols_ej=0
scalar plin_mle_ej=0
' ARCH parameters

scalar alpha=0.05*(!j-1)
scalar omega=1-alpha

smpl 1 1

' Initial Values
series z=nrnd
series h=1
series e=z*@sqrt(h)

series y=0

!i=1
while !i<=!repet

smpl 2 !n+!dis

series z=nrnd
series h=omega+alpha*z(-1)^2*h(-1)
series e=z*@sqrt(h)

series y=.3*y(-1)-.9*y(-1)*(1-exp(-y(-1)^2))+e ' ESTAR(1)


smpl !dis+1 !n+!dis

' Linearity Testing

' OLS Luukonen et al
equation eq_lst.ls y=c(1)+c(2)*y(-1)+c(3)*y(-1)*y(-1)+c(4)*y(-1)*y(-1)^2
freeze(tab_lst) eq_lst.wald c(3)=0,c(4)=0
pols_lst(!i)=@val(tab_lst(6,4))
fols_lst(!i)=@val(tab_lst(6,2))
' MLE Luukonen et al.
equation eq_lst_mle.ARCH(1,0,BACKCAST=0.7,DERIV=AA)  y=c(1)+c(2)*y(-1)+c(3)*y(-1)*y(-1)+c(4)*y(-1)*y(-1)^2+c(5)*y(-1)*y(-1)^3
freeze(tab_lst_mle) eq_lst_mle.wald c(3)=0,c(4)=0
pmle_lst(!i)=@val(tab_lst_mle(6,4))
fmle_lst(!i)=@val(tab_lst_mle(6,2))


scalar arch6=eq_lst_mle.@coefs(6)

if arch6>0 then 
	!i=!i+1
endif

delete tab*

wend

' Probability of Rejecting the Null of Linearity

for !i=1 to !repet
	if fols_lst(!i) > mat_fols(!j,!k) then
		plin_ols_lst=plin_ols_lst+1/!repet
	endif
	if fmle_lst(!i) > mat_fmle(!j,!k) then
		plin_mle_lst=plin_mle_lst+1/!repet
	endif
next

'Power
mat_ols(!j,!k)=plin_ols_lst
mat_mle(!j,!k)=plin_mle_lst

next
next

scalar timer_sec=@toc

