wfcreate(wf=rejrates_ej) u 1 10000

tic

!repet=1000	 ' 1000 the number of Monte Carlo Samples
!dis=100	' the number of observations to discard

vector(!repet) pols_ej ' ols p-values for EJ test
vector(!repet) pmle_ej ' mle p-values for EJ test

vector(!repet) fols_ej ' ols F-stats for EJ test
vector(!repet) fmle_ej ' mle F-stats for EJ test

matrix(9,3) mat_ols
matrix(9,3) mat_mle
matrix(9,3) mat_fols
matrix(9,3) mat_fmle

for !k=1 to 3 

' Setting the sample size
if !k=1 then 
	!n=100
else
if !k=2 then
	!n=500
else
if !k=3 then
	!n=5000
endif
endif
endif

for !j=1 to 9 ' We consider 9 values for the ARCH coefficient: 0.00, 0.05, 0.10, ..., 0.40

scalar plin_ols_lst=0
scalar plin_mle_lst=0
scalar plin_ols_t=0
scalar plin_mle_t=0
scalar plin_ols_ej=0
scalar plin_mle_ej=0
' ARCH parameters

scalar alpha=0.05*(!j-1)
scalar omega=1-alpha

smpl 1 1

' Initial Values
series z=nrnd
series h=1
series e=z*@sqrt(h)

series y=0

!i=1
while !i<=!repet

smpl 2 !n+!dis

series z=nrnd
series h=omega+alpha*z(-1)^2*h(-1)
series e=z*@sqrt(h)

series y=e ' no AR dynamics


smpl !dis+1 !n+!dis

' Linearity Testing

' OLS Escribano and Jorda  & Wald test

equation eq_ej.ls y=c(1)+c(2)*y(-1)+c(3)*y(-1)*y(-1)+c(4)*y(-1)*y(-1)^2+c(5)*y(-1)*y(-1)^3+c(6)*y(-1)*y(-1)^4
freeze(tab_ej) eq_ej.wald c(3)=0,c(4)=0,c(5)=0,c(6)=0
pols_ej(!i)=@val(tab_ej(6,4))
fols_ej(!i)=@val(tab_ej(6,2))

' MLE Escribano and Jorda

equation eq_ej_mle.ARCH(1,0,BACKCAST=0.7,DERIV=AA)  y=c(1)+c(2)*y(-1)+c(3)*y(-1)*y(-1)+c(4)*y(-1)*y(-1)^2+c(5)*y(-1)*y(-1)^3+c(6)*y(-1)*y(-1)^4
freeze(tab_ej_mle) eq_ej_mle.wald c(3)=0,c(4)=0,c(5)=0,c(6)=0
pmle_ej(!i)=@val(tab_ej_mle(6,4))
fmle_ej(!i)=@val(tab_ej_mle(6,2))

scalar arch8=eq_ej_mle.@coefs(8)

if arch8>0 then 
	!i=!i+1
endif

delete tab*

wend

' Probability of Rejecting the Null of Linearity


for !i=1 to !repet
	if pols_ej(!i) <=0.05 then
		plin_ols_ej=plin_ols_ej+1/!repet
	endif
	if pmle_ej(!i) <=0.05 then
		plin_mle_ej=plin_mle_ej+1/!repet
	endif
next

' Size

mat_ols(!j,!k)=plin_ols_ej
mat_mle(!j,!k)=plin_mle_ej

' Critical Values
mat_fols(!j,!k)=@quantile(fols_ej,0.95)
mat_fmle(!j,!k)=@quantile(fmle_ej,0.95)

next
next

scalar timer_sec=@toc


