# CLEAR WORKSPACE
rm(list=ls())

# LOAD PACKAGES
library(dynlm)
library(urca)
library(fracdiff)
library(sandwich)

# SET WORKING DIRECTORY
setwd("C:\\")

# LOAD SCRIPTS
source("bpz.r") # BREAKPOINT ESTIMATORS
source("deltad.r") # FRACTIONAL DIFFERENCING
source("lw.r") # LOCAL WHITTLE ESTIMATOR

# SET LONG MEMORY ESTIMATION BANDWIDTH PARAMETER
m.trunc <- 0.7

# SET TRIMMING PARAMETERS FOR BREAKPOINT ESTIMATION
tau.min <- 0.1
tau.max <- 0.9

# READ DATA FROM DIRECTORY 
dat <- read.table("knvs_data.txt")
dat <- ts(dat,start=c(1978,1),freq=4)
t.dat <- ts(seq(1:dim(dat)[1]),start=c(1978,1),freq=4)
plot.ts(dat)

# BREAKPOINT ESTIMATION
bpz.dat <- matrix(NA,dim(dat)[2],4)
for(i in 1:dim(dat)[2])
{
bpz.dat[i,] <- bpz(x=dat[,i], tau.min=tau.min, tau.max=tau.max)
}

bpz.dat <- cbind(bpz.dat,round(bpz.dat/dim(dat)[1],digits=3))
bpz.dat
t.dat

# MAIN REGRESSION, DISPLAY SUMMARY STATISTICS (R^2)
y.dat <- ts(dat[,1])
x.dat <- ts(dat[,2])
reg.dat  <- dynlm(L(y.dat,-1) ~ x.dat)
summary(reg.dat)
# CRITICAL VALUES ARE PROVIDED IN TABLE 10 IN THE PAPER


# LONG MEMORY ANALYSIS; SAMPLE SPLIT BASED ON LTK ESTIMATOR ONLY FOR INFLATION
bp.x.dat <- bpz(x=x.dat, tau.min=tau.min, tau.max=tau.max)[4]
x.dat1 <- x.dat[1:bp.x.dat]
x.dat2 <- x.dat[I(bp.x.dat+1):length(x.dat)]

# ESTIMATE LONG MEMORY PARAMETERS FOR INTEREST RATE (FULL SAMPLE) AND INFLATION ON SUBSAMPLES
d.y.estim <- nlm(obj0, 0, x = y.dat, b = floor(length(y.dat)^m.trunc))$estimate
d.y.estim
2*sqrt(floor(length(x.dat2)^m.trunc))*(d.y.estim-1)

d.x1.estim <- nlm(obj0, 0, x = x.dat1, b = floor(length(x.dat1)^m.trunc))$estimate
d.x1.estim
2*sqrt(floor(length(x.dat2)^m.trunc))*(d.x1.estim-1)
2*sqrt(floor(length(x.dat2)^m.trunc))*(d.x1.estim-0)

d.x2.estim <- nlm(obj0, 0, x = x.dat2, b = floor(length(x.dat2)^m.trunc))$estimate
d.x2.estim
2*sqrt(floor(length(x.dat2)^m.trunc))*d.x2.estim

# REBALANCE THE SERIES TO INTEGER INTEGRATION
dx.dat1 <- diffseries(x.dat1,-1+d.x1.estim)
dx.dat2 <- diffseries(x.dat2,d.x2.estim) + dx.dat1[length(dx.dat1)] 

dy <- diffseries(y.dat,-1+d.y.estim)
dx <- c(dx.dat1,dx.dat2)
dx <- ts(dx)

# RUN MAIN REGRESSION WITH BALANCED SERIES AND DISPLAY SUMMARY STATISTICS (R^2)
dlin3  <- dynlm(dy ~ L(dx,1))
summary(dlin3)$r.sq
# CRITICAL VALUES ARE PROVIDED IN TABLE 10 IN THE PAPER

