bpz <- function(x, tau.min, tau.max)
{
  T <- length(x)
  tau.length <- floor(tau.max*T) - floor(tau.min*T) + 1
  tau.seq <- seq(floor(tau.min*T),floor(tau.max*T),length=tau.length)
  x.rev <- NA
  ss0 <- NA
  ss1 <- NA
  kba <- NA
  bt <- NA
  bai <- NA
  ltk <- NA
  
  for (s in 1:T)
    {
	  x.rev[s] <- x[T-s+1]
    }
  
  for (i in 1:tau.length)
	{
	  m1 <- mean(x.rev[1:(T - tau.seq[i])])
	  m2 <- mean(x.rev[I((T - tau.seq[i])+1):T])

	  ss0[i] <- sum((x.rev[1:(T - tau.seq[i])] - m1)^2)
	  ss1[i] <- sum((x.rev[I((T - tau.seq[i])+1):T] - m2)^2)

	  kba[i] <- (((tau.seq[i])^(-2))*ss1[i])/(((T-tau.seq[i])^(-1))*ss0[i])
	  bt[i]  <- (((tau.seq[i])^(-2))*ss1[i])/(((T-tau.seq[i])^(-2))*ss0[i])
	  bai[i] <- ss0[i] + ss1[i]
	  ltk[i] <- (((T-tau.seq[i])^(-2))*ss0[i])
	}

	kba.max <- tau.seq[which.max(kba)]
	bt.max <- tau.seq[which.max(bt)]
	bai.min <- tau.seq[which.min(bai)]
	ltk.min <- tau.seq[which.min(ltk)]

  return(cbind(kba.max,bt.max,bai.min,ltk.min)) 
}

