## This program provides the code for experiment 2
## by changing the value of sigma_u, one may get the size or power

###Exp 2  power/size study with mean-shift model 
N=1000;
bnn1=bnn2=stat=NULL;
T1=c(1000,400,200);
alpha1=c(0.45,0.4,0.33,0.3,0.2,0.1);
gama0=10;
sigma_u=0.5;  #size performance if 0
cv=NULL;
pvalue1=pvalue2=pvalue3=matrix(0,ncol=6,nrow=3);
for(i in 1:3){
  for(j in 1:6){
    T_stat=rep(0,N);
    for(t in 1:N){
      T=T1[i];
      alpha=alpha1[j];
      u=sigma_u*rnorm(T);
      x=rep(1,T);   # simulation for mean shift model
      e=rnorm(T);
      beta1=1;
      beta2=2;
      z0=10+rnorm(T);
      z1=z0+u;
      y=beta1*x+(beta2-beta1)*x*(z0>gama0)+e;  ## data generation
      dat=cbind(y,x,z1);
      thre1=thre_me(dat,1,2,3,alpha=alpha,intercept=0)
      T_stat[t]=thre1$me_test[1];
    }
    T_stat1=T_stat[which(T_stat!=0)];
    N1=length(T_stat1);
    print(N1);
    pvalue1[i,j]=sum(T_stat1>qchisq(0.9,2))/N1;
    pvalue2[i,j]=sum(T_stat1>qchisq(0.95,2))/N1;
    pvalue3[i,j]=sum(T_stat1>qchisq(0.99,2))/N1;
  }
}
pvalue=rbind(pvalue1,pvalue2,pvalue3);
write.csv(pvalue,"result/dgp1power_201510a.csv")

################# DGP2
N=1000;
bnn1=bnn2=stat=NULL;
T1=c(1000,400,200);
alpha1=c(0.45,0.4,0.3,0.2,0.1);
gama0=10;
sigma_u=0.5;  #size performance if 0
cv=NULL;
pvalue1=pvalue2=pvalue3=matrix(0,ncol=5,nrow=3);
for(i in 1:3){
  for(j in 1:5){
    bn1=bn2=T_stat=rep(0,N);
    for(t in 1:N){
      T=T1[i];
      alpha=alpha1[j];
      u=sigma_u*rnorm(T);
      x=10*runif(T);
      e=rnorm(T);
      beta1=1;
      beta2=2;
      z0=10+2*rnorm(T);
      z1=z0+u;
      y=beta1*x+(beta2-beta1)*x*(z0>gama0)+0.2*x*e;  ## data generation
      dat=cbind(y,x,z1);
      thre1=thre_me(dat,1,2,3,alpha=alpha,intercept=0)
      T_stat[t]=thre1$me_test[1];
    }
    T_stat1=T_stat[which(T_stat!=0)];
    N1=length(T_stat1);
    pvalue1[i,j]=sum(T_stat1>qchisq(0.9,2))/N1;
    pvalue2[i,j]=sum(T_stat1>qchisq(0.95,2))/N1;
    pvalue3[i,j]=sum(T_stat1>qchisq(0.99,2))/N1;
  }
}

pvalue=rbind(pvalue1,pvalue2,pvalue3);
write.csv(pvalue,"result/dgp2power_201510a.csv")

### Tar(2) case  DGP3
N=1000;
T1=c(1000,400,200);
alpha1=c(0.45,0.4,0.33,0.3,0.2,0.1);
gama0=10;
sigma_u=0.5;  #size performance if 0
cv=NULL;
pvalue1=pvalue2=pvalue3=matrix(0,ncol=6,nrow=3);
for(i in 1:3){
  for(j in 1:6){
    T_stat=rep(0,N);
    for(kk in 1:N){
      T=T1[i];
      tt=10000;
      alpha=alpha1[j];
      u=sigma_u*rnorm(tt);
      e=rnorm(tt);
      z=10+rnorm(tt);
      beta11=0.5;
      beta12=-0.5;
      beta21=0.1;
      beta22=-0.1;
      y=rep(0,tt);
      y[1]=e[1];
      y[2]=e[2];
      for(t in 3:tt){
        y[t]=(beta11*y[t-1]+beta21*y[t-2])*(z[t-1]<=gama0)+(beta12*y[t-1]+beta22*y[t-2])*(z[t-1]>gama0)+e[t];
      }
      y1=y;
      z1=z+u;
      dat=cbind(y1[(10000-T+2):10000],y1[(10000-T+1):9999],y1[(10000-T):9998],z1[(10000-T+1):9999]);
      thre1=thre_me(dat,1,c(2,3),4,alpha=alpha,intercept=0);
      T_stat[kk]=thre1$me_test[1];
    }
    T_stat1=T_stat[which(T_stat>0)];
    N1=length(T_stat1);
    pvalue1[i,j]=sum(T_stat1>qchisq(0.9,4))/N1;
    pvalue2[i,j]=sum(T_stat1>qchisq(0.95,4))/N1;
    pvalue3[i,j]=sum(T_stat1>qchisq(0.99,4))/N1;
  }
}

pvalue=rbind(pvalue1,pvalue2,pvalue3);
write.csv(pvalue,"result/dgp3power_201510.csv")


#DGP4 
N=1000;
bnn1=bnn2=stat=NULL;
T1=c(1000,400,200);
alpha1=c(0.45,0.4,0.33,0.3,0.2,0.1);
gama0=10;
sigma_u=0.5;  #size performance if 0
cv=NULL;
pvalue1=pvalue2=pvalue3=matrix(0,ncol=6,nrow=3);
for(i in 1:3){
  for(j in 1:6){
    bn1=bn2=T_stat=rep(0,N);
    for(t in 1:N){
      T=T1[i];
      alpha=alpha1[j];
      u=sigma_u*rnorm(T);
      x1=10*runif(T);
      z0=10+rnorm(T);
      x2=z1=z0+u;	
      e=rnorm(T);
      beta11=0.5;
      beta12=-0.5;
      beta21=0.1;
      beta22=-0.1;
      y=(beta11*x1+beta21*z0)*(z0<=gama0)+(beta12*x1+beta22*z0)*(z0>gama0)+e;
      dat=cbind(y,x1,x2,z1);
      thre1=thre_me(dat,1,c(2,3),4,alpha=alpha,intercept=0)
      T_stat[t]=thre1$me_test[1];
    }
    T_stat1=T_stat[which(T_stat>0)]; # drop 0 and NA
    N1=length(T_stat1);
    pvalue1[i,j]=sum(T_stat1>qchisq(0.9,4))/N1;
    pvalue2[i,j]=sum(T_stat1>qchisq(0.95,4))/N1;
    pvalue3[i,j]=sum(T_stat1>qchisq(0.99,4))/N1;
  }
}
pvalue=rbind(pvalue1,pvalue2,pvalue3);

write.csv(pvalue,"result/dgp4power_201510.csv")
