#### this file provides the code for experiment 1 to calculate the MSE

######################## DGP1: mean shift model
N=1000;
T=200;
alpha1=c(0.45,0.4,0.33,0.3,0.2,0.1);
mse1=mse2=matrix(0,nrow=6,ncol=2);
gama0=10;
sigma_u=0.5;
for(j in 1:6){
  betas_a=betas_hat=NULL
  T_stat=rep(0,N);
  for(t in 1:N){
    alpha=alpha1[j];
    u=sigma_u*rnorm(T);
    x=rep(1,T);   # simulation for mean shift model
    e=rnorm(T);
    beta1=1;
    beta2=2;
    z0=10+rnorm(T);
    z1=z0+u;
    y=beta1*x+(beta2-beta1)*x*(z0>gama0)+e;  ## data generation
    dat=cbind(y,x,z1);
    thre1=thre_me(dat,1,2,3,alpha=alpha,intercept=0)
    T_stat[t]=thre1$me_test[1];
    betas_a=rbind(betas_a,thre1$betas_a[c(1,3)]);
    betas_hat=rbind(betas_hat,thre1$betas_hat[c(1,3)]);
  }
  cc=which(T_stat!=0);
  N1=length(cc);
  mse1[j,1]=sum((betas_a[cc,1]-1)^2)/N1;
  mse1[j,2]=sum((betas_a[cc,2]-2)^2)/N1;
  
  mse2[j,1]=sum((betas_hat[cc,1]-1)^2)/N1;
  mse2[j,2]=sum((betas_hat[cc,2]-2)^2)/N1;
}
mse=cbind(mse1,mse2);
write.csv(mse,"result/dgp1mse200.csv")

####  DGp2: univariate model
N=1000;
T=200;
alpha1=c(0.45,0.4,0.33,0.3,0.2,0.1);
mse1=mse2=matrix(0,nrow=6,ncol=2);
gama0=10;
sigma_u=0.5;
for(j in 1:6){
  betas_a=betas_hat=NULL;
  T_stat=rep(0,N);
   for(t in 1:N){
 	alpha=alpha1[j];
	u=sigma_u*rnorm(T);
	x=10*runif(T);
	e=rnorm(T);
	beta1=1;
	beta2=2;
	z0=10+rnorm(T);
	z1=z0+u;
	y=beta1*x+(beta2-beta1)*x*(z0>gama0)+0.2*x*e;  ## data generation
      dat=cbind(y,x,z1);
      thre1=thre_me(dat,1,2,3,alpha=alpha,intercept=0)
	T_stat[t]=thre1$me_test[1];
      betas_a=rbind(betas_a,thre1$betas_a[c(1,3)]);
      betas_hat=rbind(betas_hat,thre1$betas_hat[c(1,3)]);
}
cc=which(T_stat!=0);
N1=length(cc);
mse1[j,1]=sum((betas_a[cc,1]-1)^2)/N1;
mse1[j,2]=sum((betas_a[cc,2]-2)^2)/N1;

mse2[j,1]=sum((betas_hat[cc,1]-1)^2)/N1;
mse2[j,2]=sum((betas_hat[cc,2]-2)^2)/N1;
}

mse=cbind(mse1,mse2);
write.csv(mse,"result/dgp2mse200.csv")



###################  DGP3: TAR (2)
N=1000;
T=200;
alpha1=c(0.45,0.4,0.33,0.3,0.2,0.1);
mse1=mse2=matrix(0,nrow=6,ncol=4);
gama0=10;
sigma_u=0.5;
for(j in 1:6){
  T_stat=rep(0,N);
  betas_a=betas_hat=NULL;
   for(kk in 1:N){
 	alpha=alpha1[j];
	tt=10000;
 	alpha=alpha1[j];
	u=sigma_u*rnorm(tt);
	e=rnorm(tt);
      z=10+rnorm(tt);
	beta11=0.5;
	beta12=-0.5;
      beta21=0.1;
      beta22=-0.1;
	y=rep(0,tt);
      y[1]=e[1];
      y[2]=e[2];
      for(t in 3:tt){
	y[t]=(beta11*y[t-1]+beta21*y[t-2])*(z[t-1]<=gama0)+(beta12*y[t-1]+beta22*y[t-2])*(z[t-1]>gama0)+e[t];
          }
    	y1=y;
      z1=z+u;
	dat=cbind(y1[(10000-T+2):10000],y1[(10000-T+1):9999],y1[(10000-T):9998],z1[(10000-T+1):9999]);
	thre1=thre_me(dat,1,c(2,3),4,alpha=alpha,h=1,intercept=0);
	T_stat[kk]=thre1$me_test[1];
      betas_a=rbind(betas_a,as.vector(thre1$betas_a[c(1,2),c(1,3)]));
      betas_hat=rbind(betas_hat,as.vector(thre1$betas_hat[c(1,2),c(1,3)]));

}
cc=which(T_stat!=0);
N1=length(cc);
mse1[j,1]=sum((betas_a[cc,1]-0.5)^2)/N1+sum((betas_a[cc,3]+0.5)^2)/N1
mse1[j,2]=sum((betas_a[cc,2]-0.1)^2)/N1+sum((betas_a[cc,4]+0.1)^2)/N1;
mse2[j,1]=sum((betas_hat[cc,1]-0.5)^2)/N1+sum((betas_hat[cc,3]+0.5)^2)/N1;
mse2[j,2]=sum((betas_hat[cc,2]-0.1)^2)/N1+sum((betas_hat[cc,4]+0.1)^2)/N1;
}

mse=cbind(mse1,mse2);
write.csv(mse,"dgp3mse1000.csv")


#################
#DGP4
N=1000;
T=200;
alpha1=c(0.45,0.4,0.33,0.3,0.2,0.1);
mse1=mse2=matrix(0,nrow=6,ncol=2);
gama0=10;
sigma_u=0.5;
for(j in 1:6){
  betas_a=betas_hat=NULL;
  T_stat=rep(0,N);
  for(t in 1:N){
    alpha=alpha1[j];
    u=sigma_u*rnorm(T);
    x1=10*runif(T);
    z0=10+rnorm(T)+u;
    x2=z1=z0+u;	
    e=rnorm(T);
    #beta1=1;
    #beta2=2;
    beta11=0.5;
    beta12=-0.5;
    beta21=0.1;
    beta22=-0.1;
    y=(beta11*x1+beta21*z0)*(z0<=gama0)+(beta12*x1+beta22*z0)*(z0>gama0)+e;
    dat=cbind(y,x1,x2,z1);
    thre1=thre_me(dat,1,c(2,3),4,alpha=alpha,intercept=0)
    T_stat[t]=thre1$me_test[1];
    betas_a=rbind(betas_a,as.vector(thre1$betas_a[c(1,2),c(1,3)]));
    betas_hat=rbind(betas_hat,as.vector(thre1$betas_hat[c(1,2),c(1,3)]));
  }
  cc=which(T_stat!=0);
  N1=length(cc);
  mse1[j,1]=sum((betas_a[cc,1]-0.5)^2)/N1+sum((betas_a[cc,3]+0.5)^2)/N1
  #mse1[j,2]=sum((betas_a[cc,2]-0.1)^2)/N1;
  mse1[j,2]=sum((betas_a[cc,2]-0.1)^2)/N1+sum((betas_a[cc,4]+0.1)^2)/N1;
  #mse1[j,4]=sum((betas_a[cc,4]+0.1)^2)/N1;
  mse2[j,1]=sum((betas_hat[cc,1]-0.5)^2)/N1+sum((betas_hat[cc,3]+0.5)^2)/N1;
  #mse2[j,2]=sum((betas_hat[cc,2]-0.1)^2)/N1;
  mse2[j,2]=sum((betas_hat[cc,2]-0.1)^2)/N1+sum((betas_hat[cc,4]+0.1)^2)/N1;
  #mse2[j,4]=sum((betas_hat[cc,4]+0.1)^2)/N1;
}
mse=cbind(mse1,mse2);
write.csv(mse,"result/dgp4mse200.csv")





