##R CODES DESCRIPTION:
  
##BiGroupAFT is a R function to conduct bi-level variable selection and estimation in (high dimensional) accelerated failure time models.

##INPUT:
#Y: observed randomly censored outcomes/time-to-event outcomes
#X: matrix of predictors variables  (n x p), n is the sample size and p is the number of predictors
#delta: censoring indicator
#group: group labels for the predictors

##OUTPUT:
#beta_est:estimate of parameters

################ Some required R packages #######################
library(survival);library(splines)
library(bujar);library(grpreg);library(emplik);

################### main function ###########################
BiGroupAFT<-function(Y,X,delta,group)
{
  #estimate coefficients up to a scale constant
  ecdf1 <- ecdf(Y)
  yy <- ecdf1(Y)-mean(ecdf1(Y))
  cvgrp <- cv.grpreg(X, yy, group, penalty="gel",nfolds=3,returnY=FALSE, trace=FALSE)
  beta0<- coef(cvgrp)[-1]
  #recover scale constant
  composite <- X%*%beta0
  lmfit2 <- BJnoint(composite,Y,delta)
  est <-lmfit2$beta
  beta_est <-beta0*est
  return(beta_est)
}
  
################### an illustration example ###########################

##data generation
set.seed(100000)
n=150
p=300
#covarates matrix X;
X = matrix(rnorm(n* p,0,1), ncol = p, nrow = n)
#coefficients;
beta = c(c(1.5,1.5),c(-1,1),c(1,0),c(0,0,0,0),rep(c(0,0,0,0,0),ceiling((p-10)/5)))
#latent response variable Y0;
Y0 = X %*% beta+ 0.2*rnorm(n) 
#censoring variable C;
censor= runif(n,1,6)
#observed response variable Y;
Y = pmin(censor,Y0) 
#censoring indicator variable,1-sum(delta)/n is the censoring proportion;
delta <- as.numeric(Y<censor) 
#specify group structure;
group <-c(c(1,1,2,2,3,3,4,4,4,4),ceiling(1:(p-10)/5)+4)

##coefficient estimation
beta_new<-BiGroupAFT(Y,X,delta,group)
beta_new



  
  