library(ggplot2)
library(scales)
library(cowplot)
theme_set(theme_cowplot())

read.csv("metadata.csv",T) -> lv

yr <- ggplot(lv, aes(x=2017-age, group=age_group, fill=age_group, color=age_group)) + 
	geom_histogram(binwidth=2.5,alpha=0.5,position="identity") + 
	scale_fill_manual(labels=c("post-1985", "pre-1985"), values=hue_pal()(2)) +
	scale_color_manual(labels=c("post-1985", "pre-1985"), values=c("black","#00BFC405")) +
	labs(fill="Birth year", color="Birth year", x="Birth year") +
	geom_hline(yintercept=0, colour="white", size=1)

aoa <- ggplot(lv, aes(x=mand_lag, group=age_group, fill=age_group, color=age_group)) + 
	geom_histogram(binwidth=1,alpha=0.5,position="identity") + 
	scale_fill_manual(labels=c("post-1985", "pre-1985"), values=hue_pal()(2)) +
	scale_color_manual(labels=c("post-1985", "pre-1985"), values=c("black","#00BFC405")) +
	labs(fill="Birth year", color="Birth year", x="Standard - Suzhou AoA (yrs.)") +
	geom_hline(yintercept=0, colour="white", size=1)

sm <- ggplot(lv[lv$ID != "S19",], aes(x=sm, group=age_group, fill=age_group, color=age_group)) + 
	geom_histogram(binwidth=0.1,alpha=0.5,position="identity") + 
	scale_fill_manual(labels=c("post-1985", "pre-1985"), values=hue_pal()(2)) +
	scale_color_manual(labels=c("post-1985", "pre-1985"),  values=c("black","#00BFC405")) +
	labs(fill="Birth year", color="Birth year", x="Suz-Std competency ratio, overall") + xlim(0.5,1.5) +
	geom_hline(yintercept=0, colour="white", size=1)

sm_written <- ggplot(lv[lv$ID != "S19",], aes(x=sm_written, group=age_group, fill=age_group, color=age_group)) + 
	geom_histogram(binwidth=0.1,alpha=0.5,position="identity") + 
	scale_fill_manual(labels=c("post-1985", "pre-1985"), values=hue_pal()(2)) +
	scale_color_manual(labels=c("post-1985", "pre-1985"), values=c("black","#00BFC405")) +
	labs(fill="Birth year", color="Birth year", x="Suz-Std competency ratio, written") + xlim(0.5,1.5) +
	geom_hline(yintercept=0, colour="white", size=1)

sm_verbal <- ggplot(lv[lv$ID != "S19",], aes(x=sm_verbal, group=age_group, fill=age_group, color=age_group)) + 
	geom_histogram(binwidth=0.1, alpha=0.5, position="identity") + 
	scale_fill_manual(labels=c("post-1985", "pre-1985"), values=hue_pal()(2)) +
	scale_color_manual(labels=c("post-1985", "pre-1985"), values=c("black","#00BFC405")) +
	labs(fill="Birth year", color="Birth year", x="Suz-Std competency ratio, verbal") + xlim(0.5,1.5) +
	geom_hline(yintercept=0, colour="white", size=1)

col_one <- plot_grid(
   yr + theme(legend.position="none"),
   aoa,
   labels = c("A", "B"),
   ncol=1,
   align="h",axis="b"
)

col_two <- plot_grid(
	sm_verbal + theme(legend.position="none"),
	sm_written + theme(legend.position="none"),
	ncol=1, labels = c("C","D"),
	align="h",axis="b"
	)

png("myplot2.png", width=200, height=100, units="mm", res = 600)
plot_grid(col_one,col_two,nrow=1)
dev.off()

png("myplot.png", width=100, height=100, units="mm", res = 300)
plot_grid(
   yr + theme(legend.position="none"),
   aoa,
   labels = c("A", "B"),
   ncol=1
)
dev.off()
