library(ggradar)

setwd("")
source("MCMC_BivariateLatentFactorDistributedLagModel.R")
source("MCMC_UnivariateLatentFactorDistributedLagModel.R")
athleteData=read.csv(file="athleteData.csv",header=T)

## UNIVARIATE LATENT FACTOR MODEL ##
set.seed(1)

#This code gets data formatted, choosing columns 5-10 as the ordinal wellness data, columns 3-4 as covariates, 10 days of lagged covariates, and 9 athletes
setupU=setupULFM(athleteData,Ycols=5:10,Xcols=3:4,lagT=10,R=1:9)

#This code runs the MCMC algorithm for 100000 iterations, printing out ever 10000 for status reference, and thins the chain ever 10 iterations to reduce output size
runU=runULFM(data=setupU$data,pars=setupU$pars,priors=setupU$priors,iter=100000,print.out=10000,thin=10)

## BIVARIATE LATENT FACTOR MODEL ##
set.seed(1)

#This code gets data formatted, choosing columns 5-10 as the ordinal wellness data, columns 3-4 as covariates, 10 days of lagged covariates, and 9 athletes
setupB=setupBLFM(athleteData,Ycols=5:10,Xcols=3:4,lagT=10,R=1:9)

#This code runs the MCMC algorithm for 100000 iterations, printing out ever 10000 for status reference, and thins the chain ever 10 iterations to reduce output size
runB=runBLFM(data=setupB$data,pars=setupB$pars,priors=setupB$priors,iter=100000,print.out=10000,thin=10)

#Define burn-in and samples to be used for posterior inference
b=2000
e=10000

#Function to compute 95\% CI
M.CI=function(x){return(quantile(x,c(.025,.975)))}

#Names to assign athletes 1-9, colors, and names of wellness variables
RefAll=c("A","B","C","D","E","F","G","H","I")
refColors=c("#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33")
Zord=c("Z1","Z2","Z3","Z4","Z5","Z6")

#Choice of 4 athletes for simpler comparison figures
Ref4=c(5,6,7,8)

#Compute Relative Importance metrics for star plot 
UAZ=matrix(nrow=6,ncol=9)
WAZ=matrix(nrow=6,ncol=9)
RAZ=matrix(nrow=6,ncol=9)
for(R in 1:9){
	UAZ[,R]=abs(apply(runU$corMat[R,1:6,7,b:e],1,mean))/sum(abs(apply(runU$corMat[R,1:6,7,b:e],1,mean)))
	WAZ[,R]=abs(apply(runB$corMat[R,1:6,7,b:e],1,mean))/sum(abs(apply(runB$corMat[R,1:6,7,b:e],1,mean)))
	RAZ[,R]=abs(apply(runB$corMat[R,1:6,8,b:e],1,mean))/sum(abs(apply(runB$corMat[R,1:6,8,b:e],1,mean)))}
star4U=cbind(RefAll[Ref4],as.data.frame(t(UAZ[,Ref4])))
star4W=cbind(RefAll[Ref4],as.data.frame(t(WAZ[,Ref4])))
star4R=cbind(RefAll[Ref4],as.data.frame(t(RAZ[,Ref4])))
names(star4U)[2:7]=Zord
names(star4W)[2:7]=Zord
names(star4R)[2:7]=Zord


#Figures: Titles of output files correspond to the figures in the text

pdf("Figure4.pdf",width=8.2,height=5)
par(mfrow=c(1,2),mar=c(4.5,4,4,1))
boxplot((runU$alpha.M[b:e,seq(1,20,by=2)]),outline=F,xlab="Lag",ylab=expression(alpha),main="X1")
points(1:10,apply(runU$alpha.M[b:e,seq(1,20,by=2)],2,M.CI)[1,],col=refColors[2],lwd=3)
points(1:10,apply(runU$alpha.M[b:e,seq(1,20,by=2)],2,M.CI)[2,],col=refColors[2],lwd=3)
abline(h=0,col=1,lwd=1)
boxplot((runU$alpha.M[b:e,seq(2,20,by=2)]),outline=F,xlab="Lag",ylab=expression(alpha),main="X2")
points(1:10,apply(runU$alpha.M[b:e,seq(2,20,by=2)],2,M.CI)[1,],col=refColors[2],lwd=3)
points(1:10,apply(runU$alpha.M[b:e,seq(2,20,by=2)],2,M.CI)[2,],col=refColors[2],lwd=3)
abline(h=0,col=1,lwd=1)
dev.off()

pdf("Figure5.pdf",width=16,height=5)
par(mfrow=c(1,4),mar=c(4.5,5,4,1))
for(R in 1:4){
boxplot(t(runU$alpha[Ref4[R],seq(1,20,by=2),b:e]),outline=F,main=paste("Athlete", RefAll[Ref4][R]),xlab="Lag",ylim=c(-.165,.1),cex.main=2,cex.lab=2,cex.axis=1.5,ylab=expression(alpha))
points(1:10,apply(t(runU$alpha[Ref4[R],seq(1,20,by=2),b:e]),2,M.CI)[1,],col=refColors[2],lwd=3)
points(1:10,apply(t(runU$alpha[Ref4[R],seq(1,20,by=2),b:e]),2,M.CI)[2,],col=refColors[2],lwd=3)
abline(h=0,col=1,lwd=1)}
dev.off()

pdf("Figure6.pdf",width=16,height=5)
par(mfrow=c(1,4),mar=c(4.5,5,4,1))
for(R in 1:4){
boxplot(t(runU$alpha[Ref4[R],seq(2,20,by=2),b:e]),outline=F,main=paste("Athlete", RefAll[Ref4][R]),xlab="Lag",ylim=c(-.12,.55),cex.main=2,cex.lab=2,cex.axis=1.5,ylab=expression(alpha))
points(1:10,apply(t(runU$alpha[Ref4[R],seq(2,20,by=2),b:e]),2,M.CI)[1,],col=refColors[2],lwd=3)
points(1:10,apply(t(runU$alpha[Ref4[R],seq(2,20,by=2),b:e]),2,M.CI)[2,],col=refColors[2],lwd=3)
abline(h=0,col=1,lwd=1)}
dev.off()

pdf("Figure8.pdf",width=15,height=3)
par(mfrow=c(1,6),mar=c(4,5,4,1))
for(m in 1:6){
boxplot(t(runU$corMat[Ref4,m,7,b:e]),outline=F,main=Zord[m],xlab="Athlete",ylim=c(-1,1),cex.main=2,cex.lab=2,names=RefAll[Ref4],ylab="Correlation",cex.axis=1)
abline(h=0,lwd=1)}
dev.off()

pdf("Figure9.pdf",width=9,height=6)
par(mar=c(0,0,0,0))
ggradar(star4U,grid.max=1/2,grid.mid=1/4,values.radar=c("0               ","1/4        ","1/2   "),background.circle.colour="white",grid.line.width=.4,gridline.mid.linetype=2,label.gridline.min=T,gridline.mid.colour="grey",gridline.label.offset=c(.2),group.colours=refColors[c(1,2,3,6)],legend.position="bottom",legend.text.size=20,group.point.size=4,group.line.width=1)
dev.off()

pdf("Figure10.pdf",width=15,height=3)
par(mfrow=c(1,6),mar=c(4,5,4,1))
for(m in 1:6){
boxplot(t(runB$corMat[,m,7,b:e]),outline=F,main=Zord[m],xlab="Athlete",ylim=c(-1,1),border=refColors[3],cex.main=2,cex.lab=2,names=RefAll,ylab="Correlation",cex.axis=1)
boxplot(t(runB$corMat[,m,8,b:e]),outline=F,main="",xlab="",add=T,border=refColors[4],names=NA,yaxt="n")
if(m==1){legend("bottomright",legend=c("X1","X2"),col=refColors[3:4],lty=1,cex=2,lwd=2)}
abline(h=0,lwd=1)}
dev.off()

pdf("Figure11Left.pdf",width=9,height=6)
ggradar(star4W,grid.max=.6,grid.mid=.3,values.radar=c("0               ","0.3        ","0.6  "),background.circle.colour="white",grid.line.width=.4,gridline.mid.linetype=2,label.gridline.min=T,gridline.mid.colour="grey",gridline.label.offset=c(.2),group.colours=refColors[c(1,2,3,6)],legend.position="bottom",legend.text.size=20,group.point.size=4,group.line.width=1)
dev.off()

pdf("Figure11Right.pdf",width=9,height=6)
ggradar(star4R,grid.max=1/2,grid.mid=1/4,values.radar=c("0               ","1/4        ","1/2   "),background.circle.colour="white",grid.line.width=.4,gridline.mid.linetype=2,label.gridline.min=T,gridline.mid.colour="grey",gridline.label.offset=c(.2),group.colours=refColors[c(1,2,3,6)],legend.position="bottom",legend.text.size=20,group.point.size=4,group.line.width=1)
dev.off()


pdf("FigureA2.pdf",width=15,height=6)
par(mfrow=c(2,3))
for(m in 1:6){
boxplot(t(runU$corMat[,m,7,b:e]),outline=F,main=Zord[m],xlab="Athlete")
abline(h=0,col=1,lwd=1)}
dev.off()

pdf("FigureA3.pdf",width=10,height=5)
par(mfrow=c(1,1),mar=c(4,5,4,2))
barplot(UAZ,col=refColors,names=RefAll,xlab="",ylab="Relative Importance",xlim=c(0,13),cex.lab=1.25,cex.main=1.25,cex.axis=1.25,cex.names=1.25,main="")
axis(1,at=5.5,tick=F,label="Athlete",line=1.25,cex.axis=1.25)
legend("topright",pch=15,cex=1.25,legend=Zord,col=refColors)
dev.off()



pdf("FigureA4.pdf",width=8.2,height=4)
par(mfrow=c(1,2),mar=c(4.5,4,4,1))
boxplot((runB$alpha.M1[b:e,]),outline=F,xlab="Lag",ylab=expression(alpha),cex.main=1,cex.lab=1,cex.axis=1,main="X1")
points(1:10,apply(runB$alpha.M1[b:e,],2,M.CI)[1,],col=refColors[2],lwd=3)
points(1:10,apply(runB$alpha.M1[b:e,],2,M.CI)[2,],col=refColors[2],lwd=3)
abline(h=0,col=1,lwd=1)
boxplot((runB$alpha.M2[b:e,]),outline=F,xlab="Lag",ylab=expression(alpha),cex.main=1,cex.lab=1,cex.axis=1,main="X2")
points(1:10,apply(runB$alpha.M2[b:e,],2,M.CI)[1,],col=refColors[2],lwd=3)
points(1:10,apply(runB$alpha.M2[b:e,],2,M.CI)[2,],col=refColors[2],lwd=3)
abline(h=0,col=1,lwd=1)
dev.off()

pdf("FigureA5.pdf",width=16,height=5)
par(mfrow=c(1,4),mar=c(4.5,5,4,1))
for(R in 1:4){
boxplot(t(runB$alpha[[Ref4[R]]][1,,b:e]),outline=F,main=paste("Athlete", RefAll[Ref4][R]),xlab="Lag",ylim=c(-.165,.1),cex.main=2,cex.lab=2,cex.axis=1.5,ylab=expression(alpha))
points(1:10,apply(t(runB$alpha[[Ref4[R]]][1,,b:e]),2,M.CI)[1,],col=refColors[2],lwd=3)
points(1:10,apply(t(runB$alpha[[Ref4[R]]][1,,b:e]),2,M.CI)[2,],col=refColors[2],lwd=3)
abline(h=0,col=1,lwd=1)}
dev.off()

pdf("FigureA6.pdf",width=16,height=5)
par(mfrow=c(1,4),mar=c(4.5,5,4,1))
for(R in 1:4){
boxplot(t(runB$alpha[[Ref4[R]]][2,,b:e]),outline=F,main=paste("Athlete", RefAll[Ref4][R]),xlab="Lag",ylim=c(-.12,.55),cex.main=2,cex.lab=2,cex.axis=1.5,ylab=expression(alpha))
points(1:10,apply(t(runB$alpha[[Ref4[R]]][2,,b:e]),2,M.CI)[1,],col=refColors[2],lwd=3)
points(1:10,apply(t(runB$alpha[[Ref4[R]]][2,,b:e]),2,M.CI)[2,],col=refColors[2],lwd=3)
abline(h=0,col=1,lwd=1)}
dev.off()

pdf("FigureA9.pdf",width=15,height=8)
par(mfrow=c(2,3),mar=c(4,6,6,2))
for(m in 1:6){
boxplot(t(runB$corMat[,m,7,b:e]),outline=F,main=Zord[m],xlab="Athlete",ylim=c(-1,1),border=refColors[3],cex.main=2,cex.lab=2,names=RefAll,ylab="Correlation",cex.axis=1)
boxplot(t(runB$corMat[,m,8,b:e]),outline=F,main="",xlab="",add=T,border=refColors[4],names=NA,yaxt="n")
if(m==1){legend("bottomright",legend=c("X1","X2"),col=refColors[3:4],lty=1,cex=2,lwd=2)}
abline(h=0,lwd=1)}
dev.off()

pdf("FigureA10Top.pdf",width=10,height=5)
par(mfrow=c(1,1),mar=c(4,5,4,2))
barplot(WAZ,col=refColors,names=RefAll,xlab="",ylab="Relative Importance",xlim=c(0,13),cex.lab=1.25,cex.main=1.25,cex.axis=1.25,cex.names=1.25,main="")
axis(1,at=5.5,tick=F,label="Athlete",line=1.25,cex.axis=1.25)
legend("topright",pch=15,cex=1.25,legend=Zord,col=refColors)
axis(3,at=5.5,tick=F,label="X1",line=.25,cex.axis=1.25,font=2)
dev.off()

pdf("FigureA10Bottom.pdf",width=10,height=5)
par(mfrow=c(1,1),mar=c(4,5,4,2))
barplot(RAZ,col=refColors,names=RefAll,xlab="",ylab="Relative Importance",xlim=c(0,13),cex.lab=1.25,cex.main=1.25,cex.axis=1.25,cex.names=1.25,main="")
axis(1,at=5.5,tick=F,label="Athlete",line=1.25,cex.axis=1.25)
legend("topright",pch=15,cex=1.25,legend=Zord,col=refColors)
axis(3,at=5.5,tick=F,label="X2",line=.25,cex.axis=1.25,font=2)
dev.off()
