#MCMC algorithm for Latent One Factor Model
library(mvtnorm)
library(truncnorm)
library(MCMCpack)

setupULFM=function(dataAthletes,Ycols,Xcols,lagT,R){

out=list()
out$data=list()
out$data$X=list()
out$data$Z=list()
out$data$n=rep(0,length(R))
out$data$M=length(R)
out$data$m=length(Xcols)
out$data$J=length(Ycols)
out$data$Cuts=list()
out$pars=list()
out$pars$beta=list()
out$pars$Y=list()
out$pars$Zt=list()
out$pars$theta=list()

for(r in 1:length(R)){
data=data.frame(dataAthletes[which(dataAthletes$Athlete==R[r]),])
S=data	
Smat=S[-(1:(lagT-1)),Ycols]
n1=nrow(Smat)
for(l in (lagT-1):0){
	Smat=cbind(Smat,S[(l+(1:n1)),Xcols])}

out$data$Z[[r]]=as.matrix(Smat[,1:out$data$J])
out$data$X[[r]]=as.matrix(Smat[,-(1:out$data$J)])

out$data$n[r]=nrow(out$data$X[[r]])
out$data$p=ncol(out$data$X[[1]])

out$pars$alpha=matrix(0,nrow=out$data$M,ncol=out$data$p)
out$pars$theta[[r]]=matrix(c(rep(-Inf,out$data$J),rep(0,out$data$J),rep(1,out$data$J),rep(2,out$data$J),rep(3,out$data$J),rep(Inf,out$data$J)),nrow=out$data$J)

out$pars$beta[[r]]=matrix(0,ncol=2,nrow=out$data$J)
out$pars$beta[[r]][,2]=1
out$pars$Y[[r]]=out$data$X[[r]]%*%out$pars$alpha[r,]
out$pars$Zt[[r]]=matrix(nrow=out$data$n[r],ncol=out$data$J)
for(j in 1:out$data$J){
out$pars$Zt[[r]][,j]=cbind(rtruncnorm(out$data$n[r],mean=cbind(rep(1,out$data$n[r]),out$pars$Y[[r]])%*%out$pars$beta[[r]][j,],sd=sqrt(.5),a=out$pars$theta[[r]][j,out$data$Z[[r]][,j]],b=out$pars$theta[[r]][j,1+out$data$Z[[r]][,j]]))}
}

out$pars$sig2=rep(.5,out$data$M)
out$pars$alpha.V=rep(1,length=out$data$p)
out$pars$alpha.M=rep(0,length=out$data$p)

out$priors=list()
out$priors$beta.V=10
out$priors$alpha.var=10
out$priors$theta.sd=.01
out$priors$sig2.a=.01
out$priors$sig2.b=.01
out$priors$sig2.Dprior=10
out$priors$sig2.Dprop=1000

return(out)}

alphaULFM=function(data,pars,priors){
for(M in 1:data$M){
B=solve(diag(1/pars$alpha.V)+1/pars$sig2[M]*t(data$X[[M]])%*%data$X[[M]])
A=1/pars$sig2[M]*t(data$X[[M]])%*%c(pars$Y[[M]])+pars$alpha.M/pars$alpha.V
pars$alpha[M,]=c(rmvnorm(1,mean=B%*%A,sigma=B))
}
B=diag(1/((1/priors$alpha.var+data$M*(1/pars$alpha.V))))
A=apply(diag(1/pars$alpha.V)%*%t(pars$alpha),1,sum)
pars$alpha.M=c(rmvnorm(1,mean=B%*%A,sigma=B))
for(P in 1:data$p){
A=priors$sig2.a+data$M/2
B=priors$sig2.b+1/2*sum((pars$alpha[,P]-pars$alpha.M[P])^2)		
pars$alpha.V[P]=c(rinvgamma(1,A,B))}	
return(pars)
}

sig2ULFM=function(data,pars,priors){
for(M in 1:data$M){	
sig2.c=rdirichlet(1,priors$sig2.Dprop*c(pars$sig2[M],1-pars$sig2[M]))[1]
top=0
bot=0
top=sum(dnorm(pars$Y[[M]],data$X[[M]]%*%pars$alpha[M,],sd=sqrt(sig2.c),log=T))
bot=sum(dnorm(pars$Y[[M]],data$X[[M]]%*%pars$alpha[M,],sd=sqrt(pars$sig2[M]),log=T))
for(j in 1:data$J){
top=top+sum(dnorm(pars$Zt[[M]][,j],mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(1-sig2.c),log=T))
bot=bot+sum(dnorm(pars$Zt[[M]][,j],mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(1-pars$sig2[M]),log=T))}
topPrior=log(ddirichlet(c(sig2.c,1-sig2.c),rep(priors$sig2.Dprior,2)))
botPrior=log(ddirichlet(c(pars$sig2[M],1-pars$sig2[M]),rep(priors$sig2.Dprior,2)))
topProp=log(ddirichlet(c(pars$sig2[M],1-pars$sig2[M]),priors$sig2.Dprop*c(sig2.c,1-sig2.c)))
botProp=log(ddirichlet(c(sig2.c,1-sig2.c),priors$sig2.Dprop*c(pars$sig2[M],1-pars$sig2[M])))
mh=top+topProp-bot-botProp+topPrior-botPrior
r=log(runif(1))
if(mh>r){pars$sig2[M]=sig2.c}
}
return(pars)	
}

betaULFM=function(data,pars,priors){
for(M in 1:data$M){	
for(j in 2:data$J){
B=solve(solve(diag(priors$beta.V,2))+1/(1-pars$sig2[M])*t(cbind(rep(1,data$n[M]),pars$Y[[M]]))%*%cbind(rep(1,data$n[M]),pars$Y[[M]]))
A=1/(1-pars$sig2[M])*t(cbind(rep(1,data$n[M]),pars$Y[[M]]))%*%c(pars$Zt[[M]][,j])
pars$beta[[M]][j,]=c(rmvnorm(1,mean=B%*%A,sigma=B))}	
B=solve(solve(priors$beta.V)+1/(1-pars$sig2[M])*data$n[M])
A=1/(1-pars$sig2[M])*sum(pars$Zt[[M]][,1]-pars$beta[[M]][1,2]*pars$Y[[M]])
pars$beta[[M]][1,1]=c(rmvnorm(1,mean=B%*%A,sigma=B))
}
return(pars)
}

ZULFM=function(data,pars,priors){
for(M in 1:data$M){		
for(j in 1:data$J){
pars$Zt[[M]][,j]=c(rtruncnorm(1,mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(1-pars$sig2[M]),a=pars$theta[[M]][j,data$Z[[M]][,j]],b=pars$theta[[M]][j,1+data$Z[[M]][,j]]))}}
return(pars)
}

YULFM=function(data,pars,priors){
for(M in 1:data$M){	
B=c(1/((1/pars$sig2[M])+1/(1-pars$sig2[M])*sum(pars$beta[[M]][,2]^2)))
A=(1/pars$sig2[M])*data$X[[M]]%*%pars$alpha[M,]
for(j in 1:data$J){
A=A+pars$beta[[M]][j,2]*1/(1-pars$sig2[M])*(pars$Zt[[M]][,j]-pars$beta[[M]][j,1])}
pars$Y[[M]]=c(rnorm(data$n[M],mean=B*A,sd=sqrt(B)))
}
return(pars)
}

thetaULFM=function(data,pars,priors){
M=1
theta.c=pars$theta[[M]]
yo=matrix(NA,nrow=data$J,ncol=3)
for(j in 1:data$J){
yo[j,]=rnorm(3,mean=c(log(pars$theta[[M]][j,3]),log(pars$theta[[M]][j,4]-pars$theta[[M]][j,3]),log(pars$theta[[M]][j,5]-pars$theta[[M]][j,4])),sd=priors$theta.sd)
theta.c[j,3:5]=c(exp(yo[j,1]),exp(yo[j,1])+exp(yo[j,2]),exp(yo[j,1])+exp(yo[j,2])+exp(yo[j,3]))}
topY=0
for(M in 1:data$M){
for(j in 1:data$J){
p0=pnorm(theta.c[j,2], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(1-pars$sig2[M]))
p1=pnorm(theta.c[j,3], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(1-pars$sig2[M]))-p0
p2=pnorm(theta.c[j,4], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(1-pars$sig2[M]))-p0-p1
p3=pnorm(theta.c[j,5], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(1-pars$sig2[M]))-p0-p1-p2
Pmat=cbind(p0,p1,p2,p3,1-p0-p1-p2-p3)
check0=log(diag(Pmat[,data$Z[[M]][,j]]))
check0[which(check0< -100)]=-100
topY=topY+sum(check0)}}
topProp=0 
topPrior=sum(dnorm(yo,0,1,log=T),na.rm=T)
botY=0
for(M in 1:data$M){
for(j in 1:data$J){
p0=pnorm(pars$theta[[M]][j,2], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(1-pars$sig2[M]))
p1=pnorm(pars$theta[[M]][j,3], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(1-pars$sig2[M]))-p0
p2=pnorm(pars$theta[[M]][j,4], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(1-pars$sig2[M]))-p0-p1
p3=pnorm(pars$theta[[M]][j,5], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(1-pars$sig2[M]))-p0-p1-p2
Pmat=cbind(p0,p1,p2,p3,1-p0-p1-p2-p3)
check0=log(diag(Pmat[,data$Z[[M]][,j]]))
check0[which(check0< -100)]=-100
botY=botY+sum(check0)}}
botProp=0
botPrior=sum(dnorm(c(log(pars$theta[[M]][,3]),log(pars$theta[[M]][,4]-pars$theta[[M]][,3]),log(pars$theta[[M]][,5]-pars$theta[[M]][,4])),0,1,log=T))
mh=topY+topPrior+topProp-botY-botProp-botPrior
r=log(runif(1))
if(mh>r){
	for(M in 1:data$M){
	pars$theta[[M]]=theta.c}}	
return(pars)}

runULFM=function(data,pars,priors,iter,print.out,thin){
out=list()
out$data=data
out$priors=priors
out$beta=list()
out$theta=list()
out$Y=list()
for(M in 1:data$M){
out$beta[[M]]=array(dim=c(data$J,2,iter/thin+1))
out$theta[[M]]=array(dim=c(data$J,ncol(pars$theta[[M]]),iter/thin+1))
out$Y[[M]]=matrix(nrow=iter/thin+1,ncol=data$n[M])}
out$alpha=array(dim=c(data$M,data$p,iter/thin+1))
out$alpha.M=matrix(nrow=iter/thin+1,ncol=data$p)
out$alpha.V=matrix(nrow=iter/thin+1,ncol=data$p)
out$sig2=matrix(nrow=iter/thin+1,ncol=data$M)
out$corMat=array(dim=c(data$M,data$J+1,data$J+1,iter/thin))
out$covMat=array(dim=c(data$M,data$J+1,data$J+1,iter/thin))
for(M in 1:data$M){
out$beta[[M]][,,1]=pars$beta[[M]]
out$Y[[M]][1,]=pars$Y[[M]]
out$theta[[M]][,,1]=pars$theta[[M]]}
out$alpha[,,1]=pars$alpha
out$alpha.M[1,]=pars$alpha.M
out$alpha.V[1,]=pars$alpha.V
out$sig2[1,]=pars$sig2

for(i in 1:iter){	
pars=sig2ULFM(data,pars,priors)
pars=YULFM(data,pars,priors)	
pars=alphaULFM(data,pars,priors)
pars=thetaULFM(data,pars,priors)
pars=betaULFM(data,pars,priors)
pars=ZULFM(data,pars,priors)	
if(i%%thin==0){
out$alpha[,,1+i/thin]=pars$alpha
out$alpha.M[1+i/thin,]=pars$alpha.M
out$alpha.V[1+i/thin,]=pars$alpha.V
out$sig2[1+i/thin,]=pars$sig2
for(M in 1:data$M){
out$theta[[M]][,,1+i/thin]=pars$theta[[M]]	
out$beta[[M]][,,1+i/thin]=pars$beta[[M]]
out$Y[[M]][1+i/thin,]=pars$Y[[M]]
out$corMat[M,,,i/thin]=cor(cbind(pars$Zt[[M]],pars$Y[[M]]))
out$covMat[M,,,i/thin]=cov(cbind(pars$Zt[[M]],pars$Y[[M]]))
}}
if(i%%print.out==0){print(i)}	
}		
return(out)	
}
