#MCMC algorithm for Multivariate Latent Factor Model
library(mvtnorm)
library(truncnorm)
library(MCMCpack)


setupBLFM=function(dataAthletes,Ycols,Xcols,lagT,R){

out=list()
out$data=list()
out$data$X=list()
out$data$X1=list()
out$data$X2=list()
out$data$Z=list()
out$data$Lmat=list()
out$data$n=rep(0,length(R))
out$data$M=length(R)
out$data$p=lagT
out$data$m=length(Xcols)
out$data$J=length(Ycols)
out$data$Cuts=list()
out$pars=list()
out$pars$beta=list()
out$pars$Y=list()
out$pars$Zt=list()
out$pars$theta=list()
out$pars$alpha=array(0,dim=c(out$data$M,out$data$m,out$data$p))
out$pars$sig2=matrix(nrow=out$data$M,ncol=out$data$m+1)
out$pars$alpha.V1=rep(1,length=out$data$p)
out$pars$alpha.M1=rep(0,length=out$data$p)
out$pars$alpha.V2=rep(1,length=out$data$p)
out$pars$alpha.M2=rep(0,length=out$data$p)

for(r in 1:length(R)){
data=data.frame(dataAthletes[which(dataAthletes$Athlete==R[r]),])
S=data	
Smat=S[-(1:(lagT-1)),Ycols]
n1=nrow(Smat)
for(l in (lagT-1):0){
	Smat=cbind(Smat,S[(l+(1:n1)),Xcols])}

out$data$Z[[r]]=as.matrix(Smat[,1:out$data$J])
out$data$X[[r]]=as.matrix(Smat[,-(1:out$data$J)])
out$data$X1[[r]]=out$data$X[[r]][,seq(1,(out$data$m*out$data$p),by=out$data$m)]
out$data$X2[[r]]=out$data$X[[r]][,seq(2,(out$data$m*out$data$p),by=out$data$m)]

out$data$n[r]=nrow(out$data$X[[r]])
out$pars$theta[[r]]=matrix(c(rep(-Inf,out$data$J),rep(0,out$data$J),rep(1,out$data$J),rep(2,out$data$J),rep(3,out$data$J),rep(Inf,out$data$J)),nrow=out$data$J)

out$pars$beta[[r]]=matrix(1,ncol=out$data$m+1,nrow=out$data$J)
out$pars$beta[[r]][,1]=0
out$pars$Y[[r]]=matrix(nrow=out$data$n[r],ncol=out$data$m)
out$pars$Y[[r]][,1]=out$data$X1[[r]]%*%(out$pars$alpha[r,1,])
out$pars$Y[[r]][,2]=out$data$X2[[r]]%*%(out$pars$alpha[r,2,])
out$pars$Zt[[r]]=matrix(nrow=out$data$n[r],ncol=out$data$J)
for(j in 1:out$data$J){
out$pars$Zt[[r]][,j]=cbind(rtruncnorm(out$data$n[r],mean=cbind(rep(1,out$data$n[r]),out$pars$Y[[r]])%*%out$pars$beta[[r]][j,],sd=sqrt(.5),a=out$pars$theta[[r]][j,out$data$Z[[r]][,j]],b=out$pars$theta[[r]][j,1+out$data$Z[[r]][,j]]))}
out$pars$sig2[r,]=rep(1/(out$data$m+1),out$data$m+1)}

out$priors=list()
out$priors$beta.V=10
out$priors$alpha.var=10
out$priors$theta.sd=.01
out$priors$sig2.a=.01
out$priors$sig2.b=.01
out$priors$sig2.Dprior=10
out$priors$sig2.Dprop=1000

return(out)}

alphaBLFM=function(data,pars,priors){
for(M in 1:data$M){
B=solve(diag(1/pars$alpha.V1)+1/pars$sig2[M,1]*t(data$X1[[M]])%*%data$X1[[M]])
A=1/pars$sig2[M,1]*t(data$X1[[M]])%*%c(pars$Y[[M]][,1])+pars$alpha.M1/pars$alpha.V1
pars$alpha[M,1,]=c(rmvnorm(1,mean=B%*%A,sigma=B))
B=solve(diag(1/pars$alpha.V2)+1/pars$sig2[M,2]*t(data$X2[[M]])%*%data$X2[[M]])
A=1/pars$sig2[M,2]*t(data$X2[[M]])%*%c(pars$Y[[M]][,2])+pars$alpha.M2/pars$alpha.V2
pars$alpha[M,2,]=c(rmvnorm(1,mean=B%*%A,sigma=B))
}
B=diag(1/((1/priors$alpha.var+data$M*(1/pars$alpha.V1))))
A=apply(diag(1/pars$alpha.V1)%*%t(pars$alpha[,1,]),1,sum)
pars$alpha.M1=c(rmvnorm(1,mean=B%*%A,sigma=B))
B=diag(1/((1/priors$alpha.var+data$M*(1/pars$alpha.V2))))
A=apply(diag(1/pars$alpha.V2)%*%t(pars$alpha[,2,]),1,sum)
pars$alpha.M2=c(rmvnorm(1,mean=B%*%A,sigma=B))
for(P in 1:data$p){
A=priors$sig2.a+data$M/2
B=priors$sig2.b+1/2*sum((pars$alpha[,1,P]-pars$alpha.M1[P])^2)	
pars$alpha.V1[P]=c(rinvgamma(1,A,B))
A=priors$sig2.a+data$M/2 
B=priors$sig2.b+1/2*sum((pars$alpha[,2,P]-pars$alpha.M2[P])^2)	
pars$alpha.V2[P]=c(rinvgamma(1,A,B))}	
return(pars)
}

sig2BLFM=function(data,pars,priors){	
for(M in 1:data$M){	
sig2.c=rdirichlet(1,alpha=1+priors$sig2.Dprop*pars$sig2[M,])
top=0
bot=0
top=top+sum(dnorm(pars$Y[[M]][,1],data$X1[[M]]%*%pars$alpha[M,1,],sd=sqrt(sig2.c[1]),log=T))
bot=bot+sum(dnorm(pars$Y[[M]][,1],data$X1[[M]]%*%pars$alpha[M,1,],sd=sqrt(pars$sig2[M,1]),log=T))
top=top+sum(dnorm(pars$Y[[M]][,2],data$X2[[M]]%*%pars$alpha[M,2,],sd=sqrt(sig2.c[2]),log=T))
bot=bot+sum(dnorm(pars$Y[[M]][,2],data$X2[[M]]%*%pars$alpha[M,2,],sd=sqrt(pars$sig2[M,2]),log=T))
for(j in 1:data$J){
top=top+sum(dnorm(pars$Zt[[M]][,j],mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(sig2.c[data$m+1]),log=T))
bot=bot+sum(dnorm(pars$Zt[[M]][,j],mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(pars$sig2[M,data$m+1]),log=T))}
topPrior=log(ddirichlet(sig2.c,rep(priors$sig2.Dprior,data$m+1)))
botPrior=log(ddirichlet(pars$sig2[M,],rep(priors$sig2.Dprior,data$m+1)))
topProp=log(ddirichlet(pars$sig2[M,],1+priors$sig2.Dprop*sig2.c))
botProp=log(ddirichlet(sig2.c,1+priors$sig2.Dprop*pars$sig2[M,]))
mh=top+topProp-bot-botProp+topPrior-botPrior
r=log(runif(1))
if(mh>r){pars$sig2[M,]=sig2.c}
}
return(pars)	
}

betaBLFM=function(data,pars,priors){
for(M in 1:data$M){	
for(j in 2:data$J){
B=solve(solve(diag(priors$beta.V,1+data$m))+1/(pars$sig2[M,data$m+1])*t(cbind(rep(1,data$n[M]),pars$Y[[M]]))%*%cbind(rep(1,data$n[M]),pars$Y[[M]]))
A=1/(pars$sig2[M,data$m+1])*t(cbind(rep(1,data$n[M]),pars$Y[[M]]))%*%c(pars$Zt[[M]][,j])
pars$beta[[M]][j,]=c(rmvnorm(1,mean=B%*%A,sigma=B))}	
B=solve(solve(priors$beta.V)+1/(pars$sig2[M,data$m+1])*data$n[M])
A=1/(pars$sig2[M,data$m+1])*sum(pars$Zt[[M]][,1]-pars$Y[[M]]%*%matrix(pars$beta[[M]][1,-1],ncol=1))
pars$beta[[M]][1,1]=c(rmvnorm(1,mean=B%*%A,sigma=B))
}
return(pars)
}

ZBLFM=function(data,pars,priors){
for(M in 1:data$M){	
for(j in 1:data$J){
pars$Zt[[M]][,j]=c(rtruncnorm(1,mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(pars$sig2[data$m+1]),a=pars$theta[[M]][j,data$Z[[M]][,j]],b=pars$theta[[M]][j,1+data$Z[[M]][,j]]))}}
return(pars)
}

YBLFM=function(data,pars,priors){
for(M in 1:data$M){	
B=c(1/((1/pars$sig2[M,1])+1/pars$sig2[M,data$m+1]*sum(pars$beta[[M]][,2]^2)))
A=(1/pars$sig2[M,1])*data$X1[[M]]%*%pars$alpha[M,1,]
for(j in 1:data$J){
A=A+pars$beta[[M]][j,2]*(1/pars$sig2[M,data$m+1])*(pars$Zt[[M]][,j]-pars$beta[[M]][j,1]-pars$beta[[M]][j,3]*pars$Y[[M]][,2])}
pars$Y[[M]][,1]=c(rnorm(data$n[M],mean=B*A,sd=sqrt(B)))

B=c(1/((1/pars$sig2[M,2])+1/pars$sig2[M,data$m+1]*sum(pars$beta[[M]][,3]^2)))
A=(1/pars$sig2[M,2])*data$X2[[M]]%*%pars$alpha[M,2,]
for(j in 1:data$J){
A=A+pars$beta[[M]][j,3]*(1/pars$sig2[M,data$m+1])*(pars$Zt[[M]][,j]-pars$beta[[M]][j,1]-pars$beta[[M]][j,2]*pars$Y[[M]][,1])}
pars$Y[[M]][,2]=c(rnorm(data$n[M],mean=B*A,sd=sqrt(B)))
}	
return(pars)
}

thetaBLFM=function(data,pars,priors){
M=1
theta.c=pars$theta[[M]]
yo=matrix(NA,nrow=data$J,ncol=3)
for(j in 1:data$J){
yo[j,]=rnorm(3,mean=c(log(pars$theta[[M]][j,3]),log(pars$theta[[M]][j,4]-pars$theta[[M]][j,3]),log(pars$theta[[M]][j,5]-pars$theta[[M]][j,4])),sd=priors$theta.sd)
theta.c[j,3:5]=c(exp(yo[j,1]),exp(yo[j,1])+exp(yo[j,2]),exp(yo[j,1])+exp(yo[j,2])+exp(yo[j,3]))}

topY=0
for(M in 1:data$M){
for(j in 1:data$J){
p0=pnorm(theta.c[j,2], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(pars$sig2[M,data$m+1]))
p1=pnorm(theta.c[j,3], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(pars$sig2[M,data$m+1]))-p0
p2=pnorm(theta.c[j,4], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(pars$sig2[M,data$m+1]))-p0-p1
p3=pnorm(theta.c[j,5], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(pars$sig2[M,data$m+1]))-p0-p1-p2
Pmat=cbind(p0,p1,p2,p3,1-p0-p1-p2-p3)
check0=log(diag(Pmat[,data$Z[[M]][,j]]))
check0[which(check0< -100)]=-100
topY=topY+sum(check0)}}
topProp=0 
topPrior=sum(dnorm(yo,0,1,log=T),na.rm=T)
botY=0
for(M in 1:data$M){
for(j in 1:data$J){
p0=pnorm(pars$theta[[M]][j,2], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(pars$sig2[M,data$m+1]))
p1=pnorm(pars$theta[[M]][j,3], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(pars$sig2[M,data$m+1]))-p0
p2=pnorm(pars$theta[[M]][j,4], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(pars$sig2[M,data$m+1]))-p0-p1
p3=pnorm(pars$theta[[M]][j,5], mean=cbind(rep(1,data$n[M]),pars$Y[[M]])%*%pars$beta[[M]][j,],sd=sqrt(pars$sig2[M,data$m+1]))-p0-p1-p2
Pmat=cbind(p0,p1,p2,p3,1-p0-p1-p2-p3)
check0=log(diag(Pmat[,data$Z[[M]][,j]]))
check0[which(check0< -100)]=-100
botY=botY+sum(check0)}}
botProp=0
botPrior=sum(dnorm(c(log(pars$theta[[M]][,3]),log(pars$theta[[M]][,4]-pars$theta[[M]][,3]),log(pars$theta[[M]][,5]-pars$theta[[M]][,4])),0,1,log=T))
mh=topY+topPrior+topProp-botY-botProp-botPrior
r=log(runif(1))
if(mh>r){
	for(M in 1:data$M){
	pars$theta[[M]]=theta.c}}	
return(pars)}

runBLFM=function(data,pars,priors,iter,print.out,thin){
out=list()
out$data=data
out$priors=priors
out$beta=list()
out$theta=list()
out$Y=list()
for(M in 1:data$M){
out$beta[[M]]=array(dim=c(data$J,data$m+1,iter/thin+1))
out$alpha[[M]]=array(dim=c(data$m,data$p,iter/thin+1))
out$theta[[M]]=array(dim=c(data$J,ncol(pars$theta[[M]]),iter/thin+1))
out$Y[[M]]=array(dim=c(data$n[M],data$m,iter/thin+1))
}
out$alpha.M1=matrix(nrow=iter/thin+1,ncol=data$p)
out$alpha.V1=matrix(nrow=iter/thin+1,ncol=data$p)
out$alpha.M2=matrix(nrow=iter/thin+1,ncol=data$p)
out$alpha.V2=matrix(nrow=iter/thin+1,ncol=data$p)
out$sig2=array(dim=c(data$M,data$m+1,iter/thin+1))
out$corMat=array(dim=c(data$M,data$J+2,data$J+2,iter/thin))
out$covMat=array(dim=c(data$M,data$J+2,data$J+2,iter/thin))

for(M in 1:data$M){
out$beta[[M]][,,1]=pars$beta[[M]]
out$Y[[M]][,,1]=pars$Y[[M]]
out$theta[[M]][,,1]=pars$theta[[M]]
out$alpha[[M]][,,1]=pars$alpha[M,,]
out$sig2[M,,1]=pars$sig2[M,]
}
out$alpha.M1[1,]=pars$alpha.M1
out$alpha.M2[1,]=pars$alpha.M2
out$alpha.V1[1,]=pars$alpha.V1
out$alpha.V2[1,]=pars$alpha.V2

for(i in 1:iter){	
pars=sig2BLFM(data,pars,priors)
pars=YBLFM(data,pars,priors)	
pars=alphaBLFM(data,pars,priors)
pars=thetaBLFM(data,pars,priors)
pars=betaBLFM(data,pars,priors)
pars=ZBLFM(data,pars,priors)	
if(i%%thin==0){
for(M in 1:data$M){
out$beta[[M]][,,1+i/thin]=pars$beta[[M]]
out$Y[[M]][,,1+i/thin]=pars$Y[[M]]
out$theta[[M]][,,1+i/thin]=pars$theta[[M]]
out$alpha[[M]][,,1+i/thin]=pars$alpha[M,,]
out$sig2[M,,1+i/thin]=pars$sig2[M,]
out$corMat[M,,,i/thin]=cor(cbind(pars$Zt[[M]],pars$Y[[M]]))
out$covMat[M,,,i/thin]=cov(cbind(pars$Zt[[M]],pars$Y[[M]]))
}
out$alpha.M1[1+i/thin,]=pars$alpha.M1
out$alpha.M2[1+i/thin,]=pars$alpha.M2
out$alpha.V1[1+i/thin,]=pars$alpha.V1
out$alpha.V2[1+i/thin,]=pars$alpha.V2
}
if(i%%print.out==0){print(i)}	
}		
return(out)	
}
