***Estimate Glass Ceilings in the PASS


cap log close
cap log using "$log/2_PASS_GC", text replace

********Merge to PASS survey
use "$orig/PENDDAT.dta", clear
merge 1:1 pnr welle using "$data\PASS_beh_match.dta"


**********Managers from KldB
cap drop manager_kldb
gen manager_kldb=mod(beruf2010_4, 10)

gen kldb_manager=. if manager_kldb==.
replace kldb_manager=1 if manager_kldb==9
replace kldb_manager=0 if manager_kldb<9
replace kldb_manager=1 if beruf2010_4==7110 | beruf2010_4==7122



***Managers from survey infromation
tab PET2700
gen manager=.
replace manager=1 if PET2700==1
replace manager=0 if PET2700==2

cap drop logit*
cap drop logit


***keep only valid values
keep if tentgelt!=. & beruf2010_4!=. & manager!=. & educ!=. & age_spell!=. & frau!=. & year!=.

***Controls
global control "c.tentgelt##c.tentgelt##c.tentgelt i.educ  i.age_spell i.frau i.year c.realexp##c.realexp c.jobtenure##c.jobtenure"


***Predict managerial status with the full sample
logit manager i.beruf2010_3 $control
est store logit_3digit
est save "$data/manager_pred_3d", replace

logit manager i.beruf2010_4 $control
est store logit_4digit
est save "$data/manager_pred_4d", replace


logit manager i.kldb_manager $control
est store logit_manager
est save "$data/manager_pred", replace


est restore logit_3digit
predict logit_3digit
est restore logit_4digit
predict logit_4digit
est restore logit_manager
predict logit_manager





*******predict number of managers
gen manager_3digit=1 if logit_3digit>0.8 &  logit_3digit!=.
replace manager_3digit=0 if logit_3digit<=0.8 &  logit_3digit!=.


gen manager_3digit_70=1 if logit_3digit>0.7 &  logit_3digit!=.
replace manager_3digit_70=0 if logit_3digit<=0.7 &  logit_3digit!=.

gen manager_4digit=1 if logit_4digit>0.8 &  logit_4digit!=.
replace manager_4digit=0 if logit_4digit<=0.8 &  logit_4digit!=.


gen manager_simple=1 if logit_manager>0.8 &  logit_manager!=.
replace manager_simple=0 if logit_manager<=0.8 &  logit_manager!=.

replace manager_3digit=1 if kldb_manager==1
sum manager_3digit  manager_4digit manager_simple



**Overall
********Comparisions
tab manager manager_3digit, cell
tab manager manager_3digit_70, cell
tab manager manager_4digit, cell
tab manager manager_simple, cell
tab kldb_manager manager_3digit, cell
tab kldb_manager manager_3digit_70, cell
tab kldb_manager manager_4digit, cell
tab kldb_manager manager_simple, cell

count if kldb_manager==1
count if manager_3digit_70==1


****To word
label var manager "Manager PASS"
foreach y of varlist manager_simple manager_3digit manager_3digit_70 manager_4digit {
	tab  manager `y'
	estpost tabulate manager `y'
	esttab . , unstack varlabels(`e(labels)')  eqlabels(`e(eqlabels)')
	esttab . using "$log/tabulate_`y'.rtf" , unstack replace
}


*********Test in regressions
***Replace managers that are likely managers
replace manager_3digit=1 if kldb_manager==1
replace manager_4digit=1 if kldb_manager==1
replace manager_simple=1 if kldb_manager==1
replace manager_3digit_70=1 if kldb_manager==1
sum manager_3digit  manager_4digit manager_simple

***Estimate Glass Ceilings
foreach y of varlist manager kldb_manager manager_simple manager_3digit manager_3digit_70 manager_4digit {
    reg `y' frau c.realexp##c.realexp c.jobtenure##c.jobtenure i.educ i.year i.age_spell, cl(pnr)
	sum `y' if frau==0
	estadd scalar mean=`r(mean)' 
	eststo `y'_res 
}
esttab *_res, drop(*yea*) b(%9.3f) se(%9.3f) stats(mean N, fmt(a3 %14.0f) labels("Male mean" "N"))
esttab *_res using "$log/results_PASS.rtf", replace drop(*yea*) b(%9.3f) se(%9.3f) stats(mean N, fmt(a3 %14.0f) labels("Male mean" "N"))
 


cap log close