library(foreign)

mt<- read.spss("hals2009.sav")
mt<- as.data.frame(mt)

N<- nrow(mt)
mt$year<- ifelse(mt$birthyr> 80, 1800 + mt$birthyr, 1900 + mt$birthyr)
start01= paste("15",mt$birthmth,mt$year,sep="/") 
mt$start= as.Date(start01,format="%d/%m/%Y")
end01= paste(rep(15,N), rep(6,N), rep(2009,N),sep="/") 
mt$end= as.Date(end01,format="%d/%m/%Y")

mt$ageMax= as.numeric((mt$end - mt$start)/365.24)
mt$age= ifelse(mt$deathage== 0, mt$ageMax, mt$deathage)
mt$status= ifelse(mt$deathage== 0, 0, 1)
mt$id01<- mt$serno

mt01<- read.spss("hals1.sav")
mt01<- as.data.frame(mt01)
mt$id02<- mt01$serno
mt$smoking= ifelse(mt01$sm1!="NEVER EVER SMOKED", 1,0)
mt$smoking= ifelse(mt01$sm1==9,-1, mt$smoking)
mt$agesurvey= mt01$agyrs
mt$control= mt$age - mt$agesurvey
mt$sex<- (mt01$sex=="MALE")

mt$ss<- ifelse(mt01$rgsc=="SCI", 1,5)
mt$ss<- ifelse(mt01$rgsc=="SCII", 2, mt$ss)
mt$ss<- ifelse(mt01$rgsc=="SCIII   NON-MAN" | mt01$rgsc=="SCIII   MANUAL",3,mt$ss)
mt$ss<- ifelse(mt01$rgsc=="SCIV", 4, mt$ss)
# mt$flagcode

I<- which(mt$smoking != -1 & mt$flagcode != "no flag yet rec." & mt$control>= 0)
dt<- mt[I,]

#####################################################################################

# 1=MALE

N<- nrow(dt)
table(dt$sex)/N

#####

library(survival)
A0<- survfit(Surv(age,status)~ 1, data=dt[dt$smoking==0,])
A1<- survfit(Surv(age,status)~ 1, data=dt[dt$smoking==1,])

par(mar=(c(5,5,1,1)))
plot(A0, ylab="Survival Function", xlab="Age of death", lwd=c(5,1,1),col=c("blue","white","white"), xlim=c(50,100),frame=FALSE, cex.axis=2, cex.lab=2 )
for(i in 200:950) polygon(c(A0$time[i],A0$time[i],A0$time[i+1],A0$time[i+1]), c(A0$lower[i],A0$upper[i],A0$upper[i+1],A0$lower[i+1]),col=adjustcolor("blue", 0.05), border="NA")

ix=which(A1$time>50 & A1$time<100)
lines(A1$time[ix], A1$surv[ix], lwd=5, col=c("red"), xlim=c(50,100))
for(i in 150:1070) polygon(c(A1$time[i],A1$time[i],A1$time[i+1],A1$time[i+1]), c(A1$lower[i],A1$upper[i],A1$upper[i+1],A1$lower[i+1]),col=adjustcolor("red", 0.1), border="NA")

lines(c(55,60), c(0.2,0.2), col="red", lwd=5)
text(61,0.2, "Ever-Smokers",cex=2,pos=4)
lines(c(55,60), c(0.27,0.27), col="blue", lwd=5)
text(61,0.27, "Never-Smokers",cex=2,pos=4)

axis(1,xaxp=c(50,100,60),tcl=-0.2,labels=F)
axis(2,yaxp=c(0,1,50),tcl=-0.2,labels=F)

######################### gHR no ajustado

summary(coxph(Surv(age,status)~ smoking, data=dt))

exp(0.56994 - 1.96*0.04159)
exp(0.56994 + 1.96*0.04159)

##########################

remove(gROC)
library(nsROC)
library(mice)

ac<- function(time,exitus,TR)
{
 dt0<- cbind(time, exitus, TR)
 dt<- dt0[order(time),]
 dt<- as.data.frame(dt)

 j1<- which(dt$TR==1); n1<- length(j1)
 j0<- which(dt$TR==0); n0<- length(j0)

 r0<- nelsonaalen(dt[j0,],time,exitus); r1<- nelsonaalen(dt[j1,],time,exitus)
 time0<- dt$time[j0]; time1<- dt$time[j1]
 F0<- stepfun(time0, 1 - c(1,exp(-r0) )); F1<- stepfun(time1, 1 - c(1,exp(-r1) ));
 
 tm= seq(min(time), min(max(time[j0]), max(time[j1])), length.out = 1000)
 p= seq(0,1,0.005)
 auc<- p[2]*sum(approxfun( c(1,1-F0(tm),0), c(1, 1-F1(tm),0))(p))
 V1<- mean(exitus[j1])^-0.17*p[2]*sum(approxfun(c(0, F1(tm),1), c(0, F0(tm)^2,1))(p))
 V0<- mean(exitus[j0])^-0.17*p[2]*sum(approxfun(c(0,F0(tm),1), c(0,F1(tm)^2,1))(p))
 S=  (( (V0 - (1-auc)^2)  +  (n1/n0)^0.5*(V1 - auc^2) )/n1)^0.5
 ci= c(auc - 1.96*S, auc + 1.96*S)
 list(auc= auc, ciL= ci[1], ciU=ci[2], sd=S)
}

delta<- function(AC)
{
 ghr= (1-AC$auc)/AC$auc
 sghr= (ghr+1)^2*AC$sd/ghr
 ci= exp(c(log(ghr) - 1.96*sghr, log(ghr) + 1.96*sghr))
 list(ghr=ghr, s=sghr, ciL= ci[1], ciU=ci[2])
}


pM<- ac(dt$age,dt$status,dt$smoking)
delta(pM)

#########

i0<- which(dt$smoking==0)
i1<- which(dt$smoking==1)

M0<- survreg(Surv(age,status) ~ as.factor(ss) + sex + agesurvey, data=dt[i0,], dist="weibull")
M1<- survreg(Surv(age,status) ~ as.factor(ss) + sex + agesurvey, data=dt[i1,], dist="weibull")

dt0<- NULL
dt0$age= dt$age[i0]
dt0= as.data.frame(dt0)
dt0$status= dt$status[i0]
dt0$AGE= dt$agesurvey[i0]
dt0$SS= dt$ss[i0]
dt0$sex= dt$sex[i0]
dt0$res= dt0$age - predict(M0)

dt1<- NULL
dt1$age= dt$age[i1]
dt1= as.data.frame(dt1)
dt1$status= dt$status[i1]
dt1$AGE= dt$agesurvey[i1]
dt1$SS= dt$ss[i1]
dt1$sex= dt$sex[i1]
dt1$res= dt1$age - predict(M1)

dt$posib= dt$agesurvey + dt$sex*100 + 1000*dt$ss
NM<- names(table(dt$posib))
PD<- as.numeric(table(dt$posib))
nrep= length(NM)
AC<- rep(-1, nrep)


for (i in 1:nrep)
{
ii<- which(dt$posib== NM[i])
dtN= NULL
dtN$ss= dt$ss[ii[1]]  
dtN$agesurvey= dt$agesurvey[ii[1]]
dtN$sex= dt$sex[ii[1]]
dtN= as.data.frame(dtN)

time0<- dt0$res + rep(as.numeric(predict(M0, newdata=dtN)), length(dt0$res))
time1<- dt1$res + rep(as.numeric(predict(M1, newdata=dtN)), length(dt1$res))

AC[i]<- ac(c(time0,time1), c(dt0$status, dt1$status), c(rep(0, length(i0)),rep(1,length(i1))))$auc
}

########################### BOOTSTRAP

B<- 5000
acB<- rep(-1,B)

for (b in 1:B)
{
 ib<- sample(1:N, replace=TRUE)
 dtB<- dt[ib,]

i0<- which(dtB$smoking==0)
i1<- which(dtB$smoking==1)

M0<- survreg(Surv(age,status) ~ as.factor(ss) + sex + agesurvey, data=dtB[i0,], dist="weibull")
M1<- survreg(Surv(age,status) ~ as.factor(ss) + sex + agesurvey, data=dtB[i1,], dist="weibull")

dt0<- NULL
dt0$age= dtB$age[i0]
dt0= as.data.frame(dt0)
dt0$status= dtB$status[i0]
dt0$AGE= dtB$agesurvey[i0]
dt0$SS= dtB$ss[i0]
dt0$sex= dtB$sex[i0]
dt0$res= dt0$age - predict(M0)

dt1<- NULL
dt1$age= dtB$age[i1]
dt1= as.data.frame(dt1)
dt1$status= dtB$status[i1]
dt1$AGE= dtB$agesurvey[i1]
dt1$SS= dtB$ss[i1]
dt1$sex= dtB$sex[i1]
dt1$res= dt1$age - predict(M1)

dtB$posib= dtB$agesurvey + dtB$sex*100 + 1000*dtB$ss
NM<- names(table(dtB$posib))
PD<- as.numeric(table(dtB$posib))
nrep= length(NM)
AC<- rep(-1, nrep)

for (i in 1:nrep)
{
ii<- which(dtB$posib== NM[i])
dtN= NULL
dtN$ss= dtB$ss[ii[1]]  
dtN$agesurvey= dtB$agesurvey[ii[1]]
dtN$sex= dtB$sex[ii[1]]
dtN= as.data.frame(dtN)

time0<- dt0$res + rep(as.numeric(predict(M0, newdata=dtN)), length(dt0$res))
time1<- dt1$res + rep(as.numeric(predict(M1, newdata=dtN)), length(dt1$res))

AC[i]<- ac(c(time0,time1), c(dt0$status, dt1$status), c(rep(0, length(i0)),rep(1,length(i1))))$auc
}

acB[b]= ( (1 - sum(AC*PD)/sum(PD)))/(sum(AC*PD)/sum(PD))

print(c(b,acB[b]))
}


######################3


summary(coxph(Surv(age, status)~ smoking + as.factor(ss) + sex + agesurvey, data=dt))















