#### 5. Monte Carlo simulations

source("functions.R")  # The simulation study makes use of the R functions gROC() and gAUC.test(), provided as on-line Supplementary Material

#############
## Table 1 ##
#############

results.Table1 <- function(n = 200, m = 200, scenario = c("1","2"), mean1 = 0, sd1 = 1.37, B = 2000, gAUCreal = 0.6){

	scenario <- match.arg(scenario)
	
	N <- function(m){replicate(B, {rnorm(m)})}
  	P <- function(n, mean1, sd1){replicate(B, {rnorm(n, mean1, sd1)})}

	if(scenario == "1"){
  		N_samples <- N(m = m)
  		P_samples <- P(n = n, mean1 = mean1, sd1 = sd1)
	}else{
  		mean1 <- sqrt(2) * qnorm(gAUCreal); sd1 <- 1
   		N_samples <- N(m = m)
  		P_samples <- P(n = n, mean1 = mean1, sd1 = sd1)
	}
  
  results <- NULL
  bar <- txtProgressBar(min = 0, max = B, initial = 0) 
  
  for(i in 1:B){
    
    setTxtProgressBar(bar, i)
    
    N <- N_samples[,i]; P <- P_samples[,i]
    groc_Youden <- gROC(c(N,P), c(rep(0,m),rep(1,n)), side = "both", restric = TRUE, t0 = NULL)
    t0_Sp050 <- round(0.5*(m+1))
    groc_t0_050 <- gROC(c(N,P), c(rep(0,m),rep(1,n)), side = "both", restric = TRUE, t0 = t0_Sp050)

    test_Youden <- gAUC.test(groc_Youden)
    test_t0_050 <- gAUC.test(groc_t0_050)
    results[[i]] <- list(test_Youden = test_Youden, test_t0_050 = test_t0_050)
      
  }
  
  results_Youden <- matrix(NA, nrow = B, ncol = 3)
  results_t0_050 <-matrix(NA, nrow = B, ncol = 3)
  for(i in 1:B){
    results_Youden[i,] <- c(results[[i]]$test_Youden$gauc,
                            (results[[i]]$test_Youden$conf.int[1] <= gAUCreal)*(results[[i]]$test_Youden$conf.int[2] >= gAUCreal),
                            diff(results[[i]]$test_Youden$conf.int))
    results_t0_050[i,] <- c(results[[i]]$test_t0_050$gauc,
                            (results[[i]]$test_t0_050$conf.int[1] <= gAUCreal)*(results[[i]]$test_t0_050$conf.int[2] >= gAUCreal),
                            diff(results[[i]]$test_t0_050$conf.int))      
  }
  
  results <- cbind(results_Youden, results_t0_050)
  
}
  
  
results_Table1_SceI_gAUC060_200_200 <- results.Table1()
results_Table1_SceI_gAUC060_200_400 <- results.Table1(m = 400)
results_Table1_SceI_gAUC070_200_200 <- results.Table1(n = 200, m = 200, mean1 = 0.5, sd1 = 1.86, gAUCreal = 0.70)
# (...)
results_Table1_SceI_gAUC090_200_400 <- results.Table1(n = 200, m = 400, mean1 = 3.5, sd1 = 4.75, gAUCreal = 0.90)

results_Table1_SceII_gAUC060_200_200 <- results.Table1(scenario = "2")
results_Table1_SceII_gAUC060_200_400 <- results.Table1(scenario = "2", m = 400)
results_Table1_SceII_gAUC070_200_200 <- results.Table1(scenario = "2", n = 200, m = 200, gAUCreal = 0.70)
# (...)
results_Table1_SceII_gAUC090_200_400 <- results.Table1(scenario = "2", n = 200, m = 400, gAUCreal = 0.90)






#############
## Table 2 ##
#############

results.Table2.SceI.SceI <- function(rho = c(1/3,2/3), n = 200, m = 200, mean1 = 0, sd1 = 1.37, mean2 = 0, sd2 = 1.37, B = 2000, gAUCreal1 = 0.6, gAUCreal2 = 0.6){
  
  Nrho <- function(rho, m){replicate(B, {
    N1 <- rnorm(m)
    N2 <- rho * N1 + sqrt(1 - rho^2) * rnorm(m)
    c(N1,N2)})}
  
  Prho <- function(rho, n, mean1, sd1, mean2, sd2){replicate(B, {
    P1 <- rnorm(n, mean1, sd1)
    P2 <- mean2 + sd2*(rho * (P1 - mean1)/sd1 + sqrt(1 - rho^2) * rnorm(n))
    c(P1,P2)})}
  
  rho1 <- rho[1]; rho2 <- rho[2]
  Nrho1_samples <- Nrho(rho = rho1, m = m)
  Prho1_samples <- Prho(rho = rho1, n = n, mean1 = mean1, sd1 = sd1, mean2 = mean2, sd2 = sd2)
  Nrho2_samples <- Nrho(rho = rho2, m = m)
  Prho2_samples <- Prho(rho = rho2, n = n, mean1 = mean1, sd1 = sd1, mean2 = mean2, sd2 = sd2)
  
  results <- NULL
  t0_Sp050 <- round(0.5*(m+1))
  bar <- txtProgressBar(min = 0, max = B, initial = 0) 
  
  for(i in 1:B){
    
    setTxtProgressBar(bar, i)
    
    N1rho1 <- Nrho1_samples[1:m,i]; P1rho1 <- Prho1_samples[1:n,i]
    N2rho1 <- Nrho1_samples[(m+1):(2*m),i]; P2rho1 <- Prho1_samples[(n+1):(2*n),i]
    groc1_rho1 <- gROC(c(N1rho1,P1rho1), c(rep(0,m),rep(1,n)), side = "both", restric = TRUE, t0 = t0_Sp050)
    groc2_rho1 <- gROC(c(N2rho1,P2rho1), c(rep(0,m),rep(1,n)), side = "both", restric = TRUE, t0 = t0_Sp050)    

    N1rho2 <- Nrho2_samples[1:m,i]; P1rho2 <- Prho2_samples[1:n,i]
    N2rho2 <- Nrho2_samples[(m+1):(2*m),i]; P2rho2 <- Prho2_samples[(n+1):(2*n),i]
    groc1_rho2 <- gROC(c(N1rho2,P1rho2), c(rep(0,m),rep(1,n)), side = "both", restric = TRUE, t0 = t0_Sp050)
    groc2_rho2 <- gROC(c(N2rho2,P2rho2), c(rep(0,m),rep(1,n)), side = "both", restric = TRUE, t0 = t0_Sp050)    
    
    test_rho1 <- gAUC.test(groc1_rho1, groc2_rho1)
    test_rho2 <- gAUC.test(groc1_rho2, groc2_rho2)
    results[[i]] <- list(test_rho1 = test_rho1, test_rho2 = test_rho2)
    
  }
  
  results_rho1 <- matrix(NA, nrow = B, ncol = 4)
  results_rho2 <-matrix(NA, nrow = B, ncol = 4)  
  for(i in 1:B){
    results_rho1[i,] <- c(results[[i]]$test_rho1$gauc2 - results[[i]]$test_rho1$gauc1,
                            (results[[i]]$test_rho1$conf.int[1] <= (gAUCreal2 - gAUCreal1))*(results[[i]]$test_rho1$conf.int[2] >= (gAUCreal2 - gAUCreal1)),
                            diff(results[[i]]$test_rho1$conf.int),
                            1 - (results[[i]]$test_rho1$conf.int[1] <= 0)*(results[[i]]$test_rho1$conf.int[2] >= 0))
    results_rho2[i,] <- c(results[[i]]$test_rho2$gauc2 - results[[i]]$test_rho2$gauc1,
                            (results[[i]]$test_rho2$conf.int[1] <= (gAUCreal2 - gAUCreal1))*(results[[i]]$test_rho2$conf.int[2] >= (gAUCreal2 - gAUCreal1)),
                            diff(results[[i]]$test_rho2$conf.int),
                            1 - (results[[i]]$test_rho2$conf.int[1] <= 0)*(results[[i]]$test_rho2$conf.int[2] >= 0))   
  }
  
  results <- cbind(results_rho1, results_rho2)
  
}


results_Table2_SceISceI_rho_gAUCs_060_060_m_200 <- results.Table2.SceI.SceI()
results_Table2_SceISceI_rho_gAUCs_060_070_m_200 <- results.Table2.SceI.SceI(mean2 = 0.5, sd2 = 1.86, gAUCreal1 = 0.6, gAUCreal2 = 0.7)
# (...)
results_Table2_SceISceI_rho_gAUCs_090_090_m_400 <- results.Table2.SceI.SceI(n = 200, m = 400, mean1 = 3.5, sd1 = 4.75, mean2 = 3.5, sd2 = 4.75, gAUCreal1 = 0.9, gAUCreal2 = 0.9)





#############
## Table 3 ##
#############

results.Table3.SceI.SceII <- function(rho = c(1/3,2/3), n = 200, m = 200, mean1 = 0, sd1 = 1.37, B = 2000, gAUCreal1 = 0.6, gAUCreal2 = 0.6){
  
  Nrho <- function(rho, m){replicate(B, {
    N1 <- rnorm(m)
    N2 <- rho * N1 + sqrt(1 - rho^2) * rnorm(m)
    c(N1,N2)})}
  
  Prho <- function(rho, n, mean1, sd1){replicate(B, {
    P1 <- rnorm(n, mean1, sd1)
    mean2 <- sqrt(2) * qnorm(gAUCreal2)
    P2 <- mean2 + rho * (P1 - mean1)/sd1 + sqrt(1 - rho^2) * rnorm(n)
    c(P1,P2)})}
  
  rho1 <- rho[1]; rho2 <- rho[2]
  Nrho1_samples <- Nrho(rho = rho1, m = m)
  Prho1_samples <- Prho(rho = rho1, n = n, mean1 = mean1, sd1 = sd1)
  Nrho2_samples <- Nrho(rho = rho2, m = m)
  Prho2_samples <- Prho(rho = rho2, n = n, mean1 = mean1, sd1 = sd1)
  
  results <- NULL
  t0_Sp050 <- round(0.5*(m+1))
  bar <- txtProgressBar(min = 0, max = B, initial = 0) 
  
  for(i in 1:B){
    
    setTxtProgressBar(bar, i)
    
    N1rho1 <- Nrho1_samples[1:m,i]; P1rho1 <- Prho1_samples[1:n,i]
    N2rho1 <- Nrho1_samples[(m+1):(2*m),i]; P2rho1 <- Prho1_samples[(n+1):(2*n),i]
    groc1_rho1 <- gROC(c(N1rho1,P1rho1), c(rep(0,m),rep(1,n)), side = "both", restric = TRUE, t0 = t0_Sp050)
    groc2_rho1 <- gROC(c(N2rho1,P2rho1), c(rep(0,m),rep(1,n)), side = "both", restric = TRUE, t0 = t0_Sp050)    
    
    N1rho2 <- Nrho2_samples[1:m,i]; P1rho2 <- Prho2_samples[1:n,i]
    N2rho2 <- Nrho2_samples[(m+1):(2*m),i]; P2rho2 <- Prho2_samples[(n+1):(2*n),i]
    groc1_rho2 <- gROC(c(N1rho2,P1rho2), c(rep(0,m),rep(1,n)), side = "both", restric = TRUE, t0 = t0_Sp050)
    groc2_rho2 <- gROC(c(N2rho2,P2rho2), c(rep(0,m),rep(1,n)), side = "both", restric = TRUE, t0 = t0_Sp050)    
    
    test_rho1 <- gAUC.test(groc1_rho1, groc2_rho1)
    test_rho2 <- gAUC.test(groc1_rho2, groc2_rho2)
    results[[i]] <- list(test_rho1 = test_rho1, test_rho2 = test_rho2)
    
  }
  
  results_rho1 <- matrix(NA, nrow = B, ncol = 4)
  results_rho2 <-matrix(NA, nrow = B, ncol = 4)  
  for(i in 1:B){
    results_rho1[i,] <- c(results[[i]]$test_rho1$gauc2 - results[[i]]$test_rho1$gauc1,
                          (results[[i]]$test_rho1$conf.int[1] <= (gAUCreal2 - gAUCreal1))*(results[[i]]$test_rho1$conf.int[2] >= (gAUCreal2 - gAUCreal1)),
                          diff(results[[i]]$test_rho1$conf.int),
                          1 - (results[[i]]$test_rho1$conf.int[1] <= 0)*(results[[i]]$test_rho1$conf.int[2] >= 0))
    results_rho2[i,] <- c(results[[i]]$test_rho2$gauc2 - results[[i]]$test_rho2$gauc1,
                          (results[[i]]$test_rho2$conf.int[1] <= (gAUCreal2 - gAUCreal1))*(results[[i]]$test_rho2$conf.int[2] >= (gAUCreal2 - gAUCreal1)),
                          diff(results[[i]]$test_rho2$conf.int),
                          1 - (results[[i]]$test_rho2$conf.int[1] <= 0)*(results[[i]]$test_rho2$conf.int[2] >= 0))   
  }
  
  results <- cbind(results_rho1, results_rho2)
  
}


results_Table3_SceISceII_rho_gAUCs_060_060_m_200 <- results.Table3.SceI.SceII()
results_Table3_SceISceII_rho_gAUCs_060_070_m_200 <- results.Table3.SceI.SceII(gAUCreal1 = 0.6, gAUCreal2 = 0.7)
# (...)
results_Table3_SceISceII_rho_gAUCs_080_090_m_200 <- results.Table3.SceI.SceII(mean1 = 0.75, sd1 = 2.96, gAUCreal1 = 0.8, gAUCreal2 = 0.9)
# (...)
results_Table3_SceISceII_rho_gAUCs_090_090_m_400 <- results.Table3.SceI.SceII(n = 200, m = 400, mean1 = 3.5, sd1 = 4.75, gAUCreal1 = 0.9, gAUCreal2 = 0.9)
