# # ----------------------------------- READ ME ------------------------------------------- ##
# # The following code reproduces the cross validation for the simulation study in the manuscript 
# # “More than one way: Exploring the capabilities of different estimation approaches to joint 
# # models for longitudinal and time-to-event outcomes.”
# # It is structured as follows:
# #   0. Load packages and functions
# #   1. Initialize working function 
# #   2. Initialize values for data simulation
# #   3. Cross validation
# # -------------------------      !!!! WARNING !!!!      ------------------------------
# #                          !! Excessively long run time!!
# #
# # This code is meant to be run on a multi-kernel machine with at least 20 kernels.
# # Please, remember to adapt parameters if code is meant to run serially!
# # If run serially, please, also remember Windows doesn't allow for the use of mclapply!
# #
# # Below is an overview of the run times for cross validation by model in hours. These run times
# # were generated by the R = 100 simulation runs per model, each run was paralleled on 10 kernels.
# # Each kernel was a Intel(R) Xeon(R) CPU E5-2699 v4 @ 2.20GHz
# # Further parallelization is possible (see code below). If this code is to be run serially, the below
# # run times will increase by the factor 10 at least. 
# #
# #      AM1               AM2              AM3              V1M1             V1M2          
# # Min.   :0.3597   Min.   :0.08778   Min.   :0.1772   Min.   :0.3328   Min.   :0.1764  
# # 1st Qu.:1.0106   1st Qu.:0.26785   1st Qu.:0.5107   1st Qu.:1.3817   1st Qu.:0.3174  
# # Median :1.0560   Median :0.32611   Median :0.5553   Median :1.4296   Median :0.3803  
# # Mean   :1.1716   Mean   :0.32772   Mean   :0.5924   Mean   :1.7874   Mean   :0.4308  
# # 3rd Qu.:1.0856   3rd Qu.:0.41243   3rd Qu.:0.5853   3rd Qu.:2.0297   3rd Qu.:0.5064  
# # Max.   :2.8725   Max.   :0.64361   Max.   :2.0244   Max.   :5.3178   Max.   :0.7639  
# #     V1M3              V2M1               V2M2             V2M3             V3M1           
# # Min.   :0.2650   Min.   :0.8228   Min.   :0.2375   Min.   :0.2142   Min.   : 0.0425  
# # 1st Qu.:0.5755   1st Qu.:1.3299   1st Qu.:0.8574   1st Qu.:0.8737   1st Qu.: 4.0565  
# # Median :0.7553   Median :2.5150   Median :1.0071   Median :1.0796   Median : 5.2969  
# # Mean   :0.8369   Mean   :2.5461   Mean   :1.0353   Mean   :1.3361   Mean   : 7.3745  
# # 3rd Qu.:0.9369   3rd Qu.:3.2690   3rd Qu.:1.2212   3rd Qu.:1.4518   3rd Qu.: 9.6769  
# # Max.   :2.6511   Max.   :8.3817   Max.   :3.2236   Max.   :7.6961   Max.   :27.8772  
# #     V3M2              V3M3          
# # Min.   : 0.4519   Min.   : 1.044  
# # 1st Qu.: 3.3494   1st Qu.: 3.030  
# # Median : 4.0619   Median : 3.883  
# # Mean   : 4.1614   Mean   : 4.065  
# # 3rd Qu.: 5.0194   3rd Qu.: 5.021  
# # Max.   :10.1553   Max.   :11.158  

## ######################################################################################### ##
## 0. Load packages and functions 
## ######################################################################################### ##
rm(list = ls())
RNGversion("3.5.1")

##  --------------------------- ////////// Important \\\\\\\\\\\ ---------------------------- ##
## Please set me to the directory this source code lies in! --------------------------------- ##
##
path <- ""
##
##  --------------------------- \\\\\\\\\\\\\\\ //////////////// ---------------------------- ##

source(paste0(path, "01_Code/", "f_JMboost.R"))
source(paste0(path, "01_Code/", "f_simJME_A.R"))
source(paste0(path, "01_Code/", "f_cv.R"))

library(assertthat)
library(parallel)

## ######################################################################################### ##
## 1. Initialize working function 
## ######################################################################################### ##
## Function checks if there is already a cross validation result available for this model and data set. 
## If not carries out cross validation and saves result to folder "02_Results/01_CV/".

cvFun <- function(x, modelname, n, n_i, int, betal, betals, betas, betat, alpha, sigma2, lambda, noninfl = 0, noninfls = 0, noninfs = 0,
                  grid1, grid2, grid3, thresh = NULL, multicore = T) {
  gc()
  # generate data
  set.seed(12345 + x)
  dat <- simJM(n = n, n_i = n_i, int = int, betal = betal, betas = betas, betals = betals, betat = betat, alpha = alpha, lambda = lambda, 
               sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls)
  
  if (betat == 0) {time.effect <- FALSE} else {time.effect <- TRUE}
  
  cvJMbErr <- try(load(paste0(path, "02_Results/01_CV/", "CV_", modelname, "_", x, ".RData")))
  if (is.error(cvJMbErr)) {
    cvJMb <- cvJM(data = dat, grid1 = grid1, grid2 = grid2, grid3 = grid3, time.effect = time.effect, multicore = multicore, thresh = thresh)
    save(cvJMb, file = paste0(path, "02_Results/01_CV/", "CV_", modelname, "_", x, ".RData"))
  }
}

## ######################################################################################### ##
## 2. Initialize values for data simulation
## ######################################################################################### ##

n = 100
n_i = 5
alpha = 0.1
lambda = 0.4
int <- 1.5
betal <- c(-0.5, 0.7, 1.3, 0.3, 0.5)
betat <-  0.4
betals <- c(0.9, 0.3, -1, 0.2, -0.4)
betas <-  0.1
sigma2 <- 0.5

## ######################################################################################### ##
## 3. Cross validation
## ######################################################################################### ##

noninfl <- noninfs <- noninfls <- 0

modelname <- "AM1"
mclapply(1:100, cvFun, modelname = modelname, 
         n = n, n_i = n_i, int = int, betal = 0, betas = betas, betals = c(betal, betals), betat = betat, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(3, 27, 3), grid2 = seq(30, 150, 30), grid3 = seq(330, 600, 30), thresh = c(27, 150, 300, 600, 900, 4200),
         mc.cores = 2)

modelname <- "AM2"
mclapply(1:100, cvFun, modelname = modelname,
         n = n, n_i = n_i, int = int, betal = c(betal, betat), betas = betas, betals = 0, betat = 0, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(30, 150, 30), grid2 = seq(3, 27, 3), grid3 = seq(3, 27, 3),
         mc.cores = 2)

modelname <- "AM3"
mclapply(1:100, cvFun, modelname = modelname,
         n = n, n_i = n_i, int = int, betal = betal, betas = betas, betals = betals, betat = betat, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(30, 150, 30), grid2 = seq(30, 150, 30), grid3 = seq(330, 600, 30), thresh = c(27, 150, 300, 600, 900, 4200),
         mc.cores = 2)


noninfl <- noninfs <- noninfls <- 5

modelname <- "V1M1"
mclapply(1:100, cvFun, modelname = modelname, 
         n = n, n_i = n_i, int = int, betal = 0, betas = betas, betals = c(betal, betals), betat = betat, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(3, 27, 3), grid2 = seq(30, 150, 30), grid3 = seq(330, 600, 30), thresh = c(27, 150, 300, 600, 900, 4200),
         mc.cores = 2)

modelname <- "V1M2"
mclapply(1:100, cvFun, modelname = modelname,
         n = n, n_i = n_i, int = int, betal = c(betal, betat), betas = betas, betals = 0, betat = 0, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(30, 150, 30), grid2 = seq(3, 27, 3), grid3 = seq(30, 150, 30),
         mc.cores = 2)

modelname <- "V1M3"
mclapply(1:100, cvFun, modelname = modelname,
         n = n, n_i = n_i, int = int, betal = betal, betas = betas, betals = betals, betat = betat, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(30, 150, 30), grid2 = seq(30, 150, 30), grid3 = seq(330, 600, 30), thresh = c(27, 150, 300, 600, 900, 4200),
         mc.cores = 2)


noninfl <- noninfs <- noninfls <- 50

modelname <- "V2M1"
mclapply(1:100, cvFun, modelname = modelname,
         n = n, n_i = n_i, int = int, betal = 0, betas = betas, betals = c(betal, betals), betat = betat, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(3, 27, 3), grid2 = seq(30, 150, 30), grid3 = seq(330, 600, 30),
         mc.cores = 2)

modelname <- "V2M2"
mclapply(1:100, cvFun, modelname = modelname,
         n = n, n_i = n_i, int = int, betal = c(betal, betat), betas = betas, betals = 0, betat = 0, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(30, 150, 30), grid2 = seq(3, 27, 3), grid3 = seq(3, 27, 3),
         mc.cores = 2)

modelname <- "V2M3"
mclapply(1:100, cvFun, modelname = modelname,
         n = n, n_i = n_i, int = int, betal = betal, betas = betas, betals = betals, betat = betat, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(30, 150, 30), grid2 = seq(3, 27, 3), grid3 = seq(30, 150, 30),
         mc.cores = 2)


noninfl <- noninfs <- noninfls <- 250

modelname <- "V3M1"
mclapply(1:100, cvFun, modelname = modelname,
         n = n, n_i = n_i, int = int, betal = 0, betas = betas, betals = c(betal, betals), betat = betat, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(3, 27, 3), grid2 = seq(3, 27, 3), grid3 = seq(30, 150, 30),
         mc.cores = 2)

modelname <- "V3M2"
mclapply(1:100, cvFun, modelname = modelname,
         n = n, n_i = n_i, int = int, betal = c(betal, betat), betas = betas, betals = 0, betat = 0, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(30, 150, 30), grid2 = seq(3, 27, 3), grid3 = seq(3, 27, 3),
         mc.cores = 2)

modelname <- "V3M3"
mclapply(1:100, cvFun, modelname = modelname,
         n = n, n_i = n_i, int = int, betal = betal, betas = betas, betals = betals, betat = betat, alpha = alpha, lambda = lambda,
         sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls,
         grid1 = seq(30, 150, 30), grid2 = seq(3, 27, 3), grid3 = seq(30, 150, 30),
         mc.cores = 2)