readOutA <- function(res, modelname){
  ## JM ------------------------------------------------------------------- #
  assign(modelname, res$JM)
  long <- lapply(1:length(get(modelname)), function(x) get(modelname)[[x]]$coefficients$betas)
  surv <- lapply(1:length(get(modelname)), function(x) c(get(modelname)[[x]]$coefficients$gammas, get(modelname)[[x]]$coefficients$alpha))
  vars <- lapply(1:length(get(modelname)), function(x) c(get(modelname)[[x]]$coefficients$sigma,get(modelname)[[x]]$coefficients$D))
  
  long[which(unlist(lapply(long, is.null)))] <- NA
  surv[which(unlist(lapply(surv, is.null)))] <- NA
  vars[which(unlist(lapply(vars, is.null)))] <- NA
  
  long <- Reduce(rbind, long)
  surv <- Reduce(rbind, surv)
  vars <- Reduce(rbind, vars)
  
  timeind <- grep("T_long", colnames(long))
  if(modelname %in% paste0(c("A", paste0("V", 1:3)), "M2")) {
    shared <- if(timeind == ncol(long)) {NA} else {long[, (timeind + 1) : ncol(long)]}
    long <- long[, 1:timeind]
  } else {
    shared <- long[, (timeind) : ncol(long)]
    long <- long[, 1:(timeind-1)]
  }
  
  JM <- list("long" = long, "shared" = shared, "surv" = surv, "vars" = vars)
  
  ## joineRML ------------------------------------------------------------------- #
  assign(modelname, res$joineRML)
  long <- lapply(1:length(get(modelname)), function(x) get(modelname)[[x]]$coefficients$beta)
  surv <- lapply(1:length(get(modelname)), function(x) get(modelname)[[x]]$coefficients$gamma)
  vars <- lapply(1:length(get(modelname)), function(x) c(get(modelname)[[x]]$coefficients$sigma2,get(modelname)[[x]]$coefficients$D))
  
  long[which(unlist(lapply(long, is.null)))] <- NA
  surv[which(unlist(lapply(surv, is.null)))] <- NA
  vars[which(unlist(lapply(vars, is.null)))] <- NA
  
  long <- Reduce(rbind, long)
  surv <- Reduce(rbind, surv)
  vars <- Reduce(rbind, vars)
  
  timeind <- grep("T_long", colnames(long))
  if(modelname %in% paste0(c("A", paste0("V", 1:3)), "M2")) {
    shared <- if(timeind == ncol(long)) {NA} else {long[, (timeind + 1) : ncol(long)]}
    long <- long[, 1:timeind]
  } else {
    shared <- long[, (timeind) : ncol(long)]
    long <- long[, 1:(timeind-1)]
  }
  
  JRML <- list("long" = long, "shared" = shared, "surv" = surv, "vars" = vars)
  
  ## JMbayes ------------------------------------------------------------------- #
  assign(modelname, res$JMbayes)
  long <- lapply(1:length(get(modelname)), function(x) {
    bad <- any(Reduce(c, get(modelname)[[x]]$EffectiveSize)[ -grep("Bs", names(Reduce(c, get(modelname)[[x]]$EffectiveSize)))] < 200)
    if(bad) {
      return(NA)
    } else {
      return(get(modelname)[[x]]$postMeans$betas)
    }
  })   
  surv <- lapply(1:length(get(modelname)), function(x) {
    bad <- any(Reduce(c, get(modelname)[[x]]$EffectiveSize)[ -grep("Bs", names(Reduce(c, get(modelname)[[x]]$EffectiveSize)))] < 200)
    if(bad) {
      return(NA)
    } else {
      return(c(get(modelname)[[x]]$postMeans$gammas, get(modelname)[[x]]$postMeans$alphas))
    }
  }) 
  
  vars <- lapply(1:length(get(modelname)), function(x) {
    bad <- any(Reduce(c, get(modelname)[[x]]$EffectiveSize)[ -grep("Bs", names(Reduce(c, get(modelname)[[x]]$EffectiveSize)))] < 200)
    if(bad) {
      return(NA)
    } else {
      return(c(get(modelname)[[x]]$postMeans$sigma, get(modelname)[[x]]$postMeans$D))
    }
  }) 
  
  long[which(unlist(lapply(long, is.null)))] <- NA
  surv[which(unlist(lapply(surv, is.null)))] <- NA
  vars[which(unlist(lapply(vars, is.null)))] <- NA
  
  long <- Reduce(rbind, long)
  surv <- Reduce(rbind, surv)
  vars <- Reduce(rbind, vars)
  
  timeind <-  grep("T_long", colnames(long))
  if(modelname %in% paste0(c("A", paste0("V", 1:3)), "M2")) {
    shared <- if(timeind == ncol(long)) {NA} else {long[, (timeind + 1) : ncol(long)]}
    long <- long[, 1:timeind]
  } else {
    shared <- long[, (timeind) : ncol(long)]
    long <- long[, 1:(timeind-1)]
  }
  
  JMbayes <- list("long" = long, "shared" = shared, "surv" = surv, "vars" = vars)
  
  ## JMboost ------------------------------------------------------------------- #
  assign(modelname, res$JMboost)
  # load(paste0(path, "JMboost_", modelname, ".RData")) # ---------------------------------------------------------
  # load(paste0(path, "03_CV300/CV_", modelname, "boost_checked.RData"))
  # ind <- which(cvJMb$fail == "fail")
  # assign(modelname, lapply(1:length(get(modelname)), function(x) {
  #   # if(modelname == "AM1" && x == 3) {
  #   if(x %in% ind) {
  #     fitJMb <- NULL
  #   } else {
  #     load(paste0(path, "JMb_", modelname, "boost_", x, ".RData"))
  #   }
  #   return(fitJMb)}
  # ))
  long <- lapply(1:length(get(modelname)), function(x) get(modelname)[[x]]$coefficients$long)
  shared <- lapply(1:length(get(modelname)), function(x) get(modelname)[[x]]$coefficients$shared)
  surv <- lapply(1:length(get(modelname)), function(x) get(modelname)[[x]]$coefficients$surv)
  vars <- lapply(1:length(get(modelname)), function(x) get(modelname)[[x]]$coefficients$sigma2)
  
  long[which(unlist(lapply(long, is.null)))] <- NA
  shared[which(unlist(lapply(shared, is.null)))] <- NA
  surv[which(unlist(lapply(surv, is.null)))] <- NA
  vars[which(unlist(lapply(vars, is.null)))] <- NA
  
  long <- Reduce(rbind, long)
  shared <- Reduce(rbind, shared)
  surv <- Reduce(rbind, surv)
  vars <- sqrt(Reduce(rbind, vars))
  
  JMb <- list("long" = long, "shared" = shared, "surv" = surv, "vars" = vars)
  # return(JMb)
  return(list("JM" = JM, "JRML" = JRML, "JMbayes" = JMbayes, "JMb" = JMb))
}

ToDataFrame <- function(modelname) {
  plotdat <- lapply(get(modelname), function(z) {lapply(z, function(x) stack(data.frame(x)))})
  
  plotdat0 <- plotdat
  for(i in names(plotdat)) {
    for(j in names(plotdat[[i]])){
      plotdat[[i]][[j]] <- data.frame(plotdat[[i]][[j]], "pred" = j, "pack" = i)
    }
  }
  plotdat <- Reduce("rbind", lapply(plotdat, function(x) Reduce("rbind", x)))
  
  with(plotdat, table(ind, pack, pred))
  plotdat$ind <- as.character(plotdat$ind)
  unique(plotdat$ind)
  
  alphanam <- unique(plotdat$ind[plotdat$pred=="surv"])[-grep("X", unique(plotdat$ind[plotdat$pred=="surv"]))]
  plotdat$ind[plotdat$ind %in% alphanam] <- "alpha"
  plotdat$ind <- sub("_1", "", plotdat$ind)
  interceptnam <- c("x", "X.Intercept.")
  plotdat$ind[plotdat$ind %in% interceptnam] <- "Intercept"
  timenam <- c("T_long", "time_effect")
  plotdat$ind[plotdat$ind %in% timenam] <- "time"
  return(data.frame(plotdat, model = modelname))
}

readOutV <- function(res, modelname){
  # length R of simulation study
  R <- max(lengths(res))
  
  ## JM ------------------------------------------------------------------- #
  # print("JM")
  assign(modelname, res$JM)
 
  ci <- lapply(1:length(get(modelname)), function(x) {
    tryCatch({
      if(get(modelname)[[x]]$convergence == 0 & all(!is.na(get(modelname)[[x]]$Hessian))) {
        confint(get(modelname)[[x]])
      } else {
        return(NA)
      }
    }, error= function(e) return(NA))
  })
  
  ind <- which(lengths(ci) == 1)
  firstok <- which(lengths(ci) != 1)[1]
  ## expand NULL-Models/ NAs into a matrix 
  if(!is.na(firstok)) {ci[ind] <- lapply(ind, function(x) ifelse(!is.na(ci[[firstok]]), NA, ci[[firstok]] - ci[[firstok]]))}
  
  ci <- lapply(1:length(get(modelname)), function(x) cbind("R" = x, ci[[x]]))
  ci <- Reduce(rbind, ci)
  
  if(!is.na(firstok)){
    namdf <- data.frame("ind" = unique(rownames(ci)), "pred" = NA)
    
    if(modelname %in% paste0(c("A", paste0("V", 1:3)), "M2")) {
      pos <- grep("T_long", namdf$ind)
    } else {
      pos <- grep("T_long", namdf$ind) - 1
    }
    err <- try(1:pos)
    if(!is.error(err)) {namdf$pred[1:pos] <- "long"}
    namdf$pred[grep("T.", namdf$ind, fixed = T)] <- "surv"
    namdf$pred[is.na(namdf$pred)] <- "shared"
    
    ci <- data.frame("ind" = rownames(ci), ci)
    ci <- merge(ci, namdf, all.x = T, sort = FALSE)
    ci$pack <- "JM"
  }
  successes <- sum(unlist(lapply(get(modelname), function(x) x$convergence == 0 & all(!is.na(x$Hessian)))))
  fails <- R - successes
  JM <- list("dat" = ci, "fails" =  c("TRUE" = max(length(ind), fails), "FALSE" = min(R -length(ind), successes)))
  
  ## joineRML ------------------------------------------------------------------- #
  # print("JRML")
  assign(modelname, res$joineRML)
  # ci <- lapply(1:length(get(modelname)), function(x) {
  #     err <- try(confint(get(modelname)[[x]]))
  #     if(is.error(err)) {
  #       return(NA)
  #       } else {
  #         est1 <- get(modelname)[[x]]$coefficients$beta
  #         names(est1) <- paste("Y", names(est1), sep = ".")
  #         est2 <- get(modelname)[[x]]$coefficients$gamma
  #         names(est2) <- paste("T", names(est2), sep = ".")
  #         return(cbind("est" = c(est1, est2),
  #                       confint(get(modelname)[[x]])))
  #       }
  # })
  
  ci <- lapply(1:length(get(modelname)), function(x) {
    tryCatch({
      if(get(modelname)[[x]]$conv) {
        est1 <- get(modelname)[[x]]$coefficients$beta
        names(est1) <- paste("Y", names(est1), sep = ".")
        est2 <- get(modelname)[[x]]$coefficients$gamma
        names(est2) <- paste("T", names(est2), sep = ".")
        return(cbind("est" = c(est1, est2),
                     confint(get(modelname)[[x]])))
      } else {
        return(NA)
      }
    }, error= function(e) return(NA))
    })
  
  
  ind <- which(lengths(ci) == 1)
  firstok <- which(lengths(ci) != 1)[1]
  if(!is.na(firstok)) {ci[ind] <- lapply(ind, function(x) ifelse(!is.na(ci[[firstok]]), NA, ci[[firstok]] - ci[[firstok]]))}
  
  ci <- lapply(1:length(get(modelname)), function(x) cbind("R" = x, ci[[x]]))
  ci <- Reduce(rbind, ci)
  
  if(!is.na(firstok)){
    namdf <- data.frame("ind" = unique(rownames(ci)), "pred" = NA)
    if(modelname %in% paste0(c("A", paste0("V", 1:3)), "M2")) {
      pos <- grep("T_long", namdf$ind)
    } else {
      pos <- grep("T_long", namdf$ind) - 1
    }
    err <- try(1:pos)
    if(!is.error(err)) {namdf$pred[1:pos] <- "long"}
    namdf$pred[grep("T.", namdf$ind, fixed = T)] <- "surv"
    namdf$pred[is.na(namdf$pred)] <- "shared"
    
    ci <- data.frame("ind" = rownames(ci), ci)
    ci <- merge(ci, namdf, all.x = T, sort = FALSE)
    ci$pack <- "joineRML"
  }
  successes <- sum(unlist(lapply(get(modelname), function(x) x$conv)))
  fails <- R - successes
  JRML <- list("dat" = ci, "fails" =  c("TRUE" = max(length(ind), fails), "FALSE" = min(R -length(ind), successes)))
  
  ## JMbayes ------------------------------------------------------------------- #
  # print("JMbayes")
  assign(modelname, res$JMbayes)
  # ci <- lapply(1:length(get(modelname)), function(x) {
  #   bad <- any(Reduce(c, get(modelname)[[x]]$EffectiveSize)[ -grep("Bs", names(Reduce(c, get(modelname)[[x]]$EffectiveSize)))] < 200)
  #   if (bad) {
  #     return(NA)
  #   } else {
  #     err <- try(confint(get(modelname)[[x]]))
  #     if(is.error(err)) {
  #       return(NA)
  #     } else {
  #       est1 <- get(modelname)[[x]]$postMeans$betas
  #       names(est1) <- paste("Y", names(est1), sep = ".")
  #       est2 <- Reduce(c, get(modelname)[[x]]$postMeans[c('gammas', 'alphas')])
  #       names(est2) <- paste("T", names(est2), sep = ".")
  #       return(cbind("est" = c(est1, est2),
  #                    Reduce(rbind, lapply(get(modelname)[[x]]$CIs[c('betas','gammas', 'alphas')], t))))
  #     }
  #   }
  # })
  
  ci <- lapply(1:length(get(modelname)), function(x) {
    tryCatch({
      bad <- any(Reduce(c, get(modelname)[[x]]$EffectiveSize)[ -grep("Bs", names(Reduce(c, get(modelname)[[x]]$EffectiveSize)))] < 200)
      if (bad == FALSE) {
        est1 <- get(modelname)[[x]]$postMeans$betas
        names(est1) <- paste("Y", names(est1), sep = ".")
        est2 <- Reduce(c, get(modelname)[[x]]$postMeans[c('gammas', 'alphas')])
        names(est2) <- paste("T", names(est2), sep = ".")
        return(cbind("est" = c(est1, est2),
                     Reduce(rbind, lapply(get(modelname)[[x]]$CIs[c('betas','gammas', 'alphas')], t))))
      } else {
        return(NA)
      }
    }, error= function(e) return(NA))
  })
  
  
  ind <- which(lengths(ci) == 1)
  firstok <- which(lengths(ci) != 1)[1]
  if(!is.na(firstok)) {ci[ind] <- lapply(ind, function(x) ifelse(!is.na(ci[[firstok]]), NA, ci[[firstok]] - ci[[firstok]]))}
  
  ci <- lapply(1:length(get(modelname)), function(x) cbind("R" = x, ci[[x]]))
  ci <- Reduce(rbind, ci)
  
  if(!is.na(firstok)){
    namdf <- data.frame("ind" = unique(rownames(ci)), "pred" = NA)
    if(modelname %in% paste0(c("A", paste0("V", 1:3)), "M2")) {
      pos <- grep("T_long", namdf$ind)
    } else {
      pos <- grep("T_long", namdf$ind) - 1
    }
    err <- try(1:pos)
    if(!is.error(err)) {namdf$pred[1:pos] <- "long"}
    namdf$pred[grep("T.", namdf$ind, fixed = T)] <- "surv"
    namdf$pred[is.na(namdf$pred)] <- "shared"
    
    ci <- data.frame("ind" = rownames(ci), ci)
    ci <- merge(ci, namdf, all.x = T, sort = FALSE)
    ci$pack <- "JMbayes"
  }
  successes <- sum(unlist(lapply(1:length(get(modelname)), 
                                 function(x) all(Reduce(c, get(modelname)[[x]]$EffectiveSize)[ -grep("Bs", names(Reduce(c, get(modelname)[[x]]$EffectiveSize)))] >= 200))
                          ))
  fails <- R - successes
  JMbayes <- list("dat" = ci, "fails" = c("TRUE" = max(length(ind), fails), "FALSE" = min(R -length(ind), successes)))

  #
  ## JMboost ------------------------------------------------------------------- #
  # print("JMboost")
  assign(modelname, res$JMboost)
  ci <- lapply(1:length(get(modelname)), function(x) {
    if(is.error(get(modelname)[[x]]) | is.null(get(modelname)[[x]])) {
      return(NA)
    } else {
      est1 <- cbind("est" = get(modelname)[[x]]$coefficients$long, "pred" = "long")
      est2 <- cbind("est" = get(modelname)[[x]]$coefficients$shared, "pred" = "shared")
      est3 <- cbind("est" = get(modelname)[[x]]$coefficients$surv, "pred" = "surv")
      rownames(est1) <- paste("Y", rownames(est1), sep = ".")
      rownames(est2) <- paste("Y", rownames(est2), sep = ".")
      rownames(est3) <- paste("T", rownames(est3), sep = ".")
      return(rbind(est1, est2, est3))
    }
  })
  
  ci[which(unlist(lapply(get(modelname), class)) == "try-error")] <- NA
  
  # ind <- which(unlist(lapply(ci, class)) == "logical")
  # firstok <- which(unlist(lapply(ci, class)) != "logical")[1]
  # ci[ind] <- lapply(ind, function(x) ifelse(!is.na(ci[[firstok]]), NA, ci[[firstok]]))
  
  ind <- which(lengths(ci) == 1)
  firstok <- which(lengths(ci) != 1)[1]
  if(!is.na(firstok)) {ci[ind] <- lapply(ind, function(x) ifelse(!is.na(ci[[firstok]]), NA, ci[[firstok]] - ci[[firstok]]))}
  
  ci <- lapply(1:length(get(modelname)), function(x) cbind("R" = x, ci[[x]]))
  ci <- Reduce(rbind, ci)
  
  if(!is.na(firstok)){
    ci <- data.frame("ind" = rownames(ci), ci, "X2.5." = NA, "X97.5." = NA)
    ci$pack <- "JMboost"
  }
  
  ind <- unlist(lapply(get(modelname), class)) == "try-error"
  
  # JMb <- list("dat" = ci, "fails" = table(unlist(lapply(get(modelname), class)) == "try-error"))
  JMb <- list("dat" = ci, "fails" = c("TRUE" = sum(ind), "FALSE" = R - sum(ind)))
  
  # NA check -------------------------------------------------------
  packs <- c("JM", "JRML", "JMbayes", "JMb")
  
  for(i in packs) {
    assign(paste0(i, "na"), get(i)$fails["TRUE"] == R)
  }
  
  if(any(c(JMna, JRMLna, JMbayesna, JMbna), na.rm = T)){
    for(i in which(c(JMna, JRMLna, JMbayesna, JMbna))) {
      if (all(table(JMb$dat$ind)== R)) {
        dummy <- JMb$dat
        dummy$est <- NA
        dummy$pack <- packs[i]
        assign(packs[i], list("dat" = dummy, "fails" = get(packs[i])$fails))
      }
    }
  }
  # print(modelname)
  return(list("JM" = JM, "JRML" = JRML, "JMbayes" = JMbayes, "JMb" = JMb))
}
