predFun <- function(xx, modelname, n, n_i, int, betal, betals, betas, betat, alpha, sigma2, lambda, noninfl = 0, noninfls = 0, noninfs = 0){
  res <- get(paste0("res", modelname))

  fitJRML <- res$joineRML[[xx]]
  fitJMbayes <- res$JMbayes[[xx]]

  fitJMb <- res$JMboost[[xx]]
  fitJM <- res$JM[[xx]]

  ## generate data
  RNGversion("3.5.1")
  set.seed(9812345 + xx)
  dat <- simJM(n = n, n_i = n_i, int = int, betal = betal, betas = betas, betals = betals, betat = betat, alpha = alpha, lambda = lambda, 
               sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls)
  for(i in c("Xl", "Xs", "Xls")) {
    if(is.null(colnames(dat[[i]]))) colnames(dat[[i]]) <- rep("", ncol(dat[[i]]))
    if(ncol(dat[[i]]) != 0) colnames(dat[[i]]) <- gsub("x", "n", colnames(dat[[i]]))
    if(ncol(dat[[i]]) != 0) colnames(dat[[i]]) <- paste0(i, colnames(dat[[i]]))
  }
  df <- with(dat, data.frame(id, y, Xl, T_long, Xls))
  df.id <- with(dat, data.frame("id" = unique(id), T_surv, delta, Xs))
  
  resLong <- predLong(xx, df = df, df.id = df.id, fitJM = fitJM, fitJRML = fitJRML, fitJMbayes = fitJMbayes, fitJMb = fitJMb)
  resSurv <- predSurv(xx, df = df, df.id = df.id, fitJM = fitJM, fitJRML = fitJRML, fitJMbayes = fitJMbayes, fitJMb = fitJMb)
  
  res <- rbind(data.frame(resLong, "type" = "Long", "R" = xx, "modelname" = modelname),
               data.frame(resSurv, "type" = "Surv", "R" = xx, "modelname" = modelname))
  return(res)
}

predLong <- function(x, df, df.id, fitJM, fitJRML, fitJMbayes, fitJMb) {
  fulldf <- merge(df, df.id, by = "id")
  
  ## true y
  true.y <- df$y
  
  ## Result vector
  pred.err <- numeric(4)
  names(pred.err) <- c("JM", "joineRML", "JMbayes", "JMboost")
  
  # Prediction ############################################################# #
  ## JM 
  if (is.null(fitJM) || is.error(fitJM)) {
    pred.err["JM"] <- NA 
  } else if (fitJM$convergence == 1 || any(is.na(fitJM$Hessian))) {
    pred.err["JM"] <- NA 
  } else {
    # Long
    # dat.y <- model.matrix(as.formula(paste0("y~", paste(names(df)[3 : ncol(df)], collapse = "+"))), data = df)
    # beta.y <- fitJM$coefficients$betas[match(colnames(dat.y),  names(fitJM$coefficients$betas))]
    # y.hat <-  dat.y %*% beta.y
    y.hat <- predict.jointModel(fitJM, newdata = fulldf)
    MSEP.y <- 1/length(df$id) * sum((true.y - y.hat)^2)
    
    pred.err["JM"] <- MSEP.y
  }
  # print("JM ok")
  
  ## JRML
  if (is.null(fitJRML) || is.error(fitJRML)) {
    pred.err["joineRML"] <- NA 
  } else if (fitJRML$conv == FALSE) {
    pred.err["joineRML"] <- NA 
  } else {
    # # Long
    dat.y <- model.matrix(as.formula(paste0("y~", paste(names(df)[3 : ncol(df)], collapse = "+"))), data = df)
    names(fitJRML$coefficients$beta) <- sub("_1", "", names(fitJRML$coefficients$beta))
    beta.y <- fitJRML$coefficients$beta[match(colnames(dat.y),  names(fitJRML$coefficients$beta))]
    y.hat <-  dat.y %*% beta.y
    MSEP.y <- 1/length(df$id) * sum((true.y - y.hat)^2)
    
    pred.err["joineRML"] <- MSEP.y
  }
  # print("JRML ok")
  
  ## JMbayes
  # test <- tryCatch({load(paste0(path, "02_Results/", "JMbayes_", modelname, "_", x, ".RData"))},
  #          error = function(e) {
  #            fitJMbayes <- NULL
  #            return(fitJMbayes)
  #          }) #-------------------------------------------------------------------- #
  
  if (is.null(fitJMbayes) || is.error(fitJMbayes)) {
    pred.err["JMbayes"] <- NA 
  } else if (any(Reduce(c, fitJMbayes$EffectiveSize)[ -grep("Bs", names(Reduce(c, fitJMbayes$EffectiveSize)))] < 200)) {
    pred.err["JMbayes"] <- NA 
  } else {
    # Long
    # dat.y <- model.matrix(as.formula(paste0("y~", paste(names(df)[3 : ncol(df)], collapse = "+"))), data = df)
    # beta.y <- fitJMbayes$postMeans$betas[match(colnames(dat.y),  names(fitJMbayes$postMeans$betas))]
    # y.hat <-  dat.y %*% beta.y
    y.hat <- predict.JMbayes(fitJMbayes, newdata = fulldf)
    MSEP.y <- 1/length(df$id) * sum((true.y - y.hat)^2)
    
    pred.err["JMbayes"] <- MSEP.y
  }
  # print("JMbayes ok")
  
  
  if (is.null(fitJMb)) {
    pred.err["JMboost"] <- NA
  } else {
    # Long
    dat.y <- model.matrix(as.formula(paste0("y~", paste(names(df)[3 : ncol(df)], collapse = "+"))), data = df)
    beta.y <- c(fitJMb$coefficients$long, fitJMb$coefficients$shared)
    names(beta.y)[grep("time_effect", names(beta.y))] <- "T_long"
    beta.y <- beta.y[match(colnames(dat.y),  names(beta.y))]
    y.hat <-  dat.y %*% beta.y
    MSEP.y <- 1/length(df$id) * sum((true.y - y.hat)^2)
    
    pred.err["JMboost"] <- MSEP.y
    
    # print("JMboost ok")
    # print(x)
  }
  res <- data.frame("MSPE" = pred.err)
  return(data.frame(res, "pack" = rownames(res)))
}

predSurv <- function(x, df, df.id, fitJM, fitJMbayes, fitJRML, fitJMb)  {
  if (!is.null(fitJM)) {if (is.error(fitJM) || fitJM$convergence == 1 || any(is.na(fitJM$Hessian))) fitJM <- NULL}
  if (!is.null(fitJRML)) {if (is.error(fitJRML) || fitJRML$conv == FALSE) fitJRML <- NULL}
  bayesConv <- any(Reduce(c, fitJMbayes$EffectiveSize)[ -grep("Bs", names(Reduce(c, fitJMbayes$EffectiveSize)))] < 200)
  if (!is.null(fitJMbayes)) {if (is.error(fitJMbayes) || bayesConv) fitJMbayes <- NULL}
  
  res <- lapply(1:nrow(df.id), predSurvID, df = df, df.id = df.id, 
                fitJM = fitJM, fitJMbayes = fitJMbayes, fitJRML = fitJRML, fitJMb = fitJMb)
  res <- Reduce("rbind", res)
  res <- data.frame("MSPE" = tapply(res$predErr, res$pack, mean, na.rm = T))
  return(data.frame(res, "pack" = rownames(res)))
}

predSurvID <- function(z, df, df.id, fitJM, fitJMbayes, fitJRML, fitJMb)
{
  # print(z)
  tmpdf <- subset(df, id == z)
  tmpdf.id <- subset(df.id, id == z)
  tmpfulldf <- merge(tmpdf, tmpdf.id, by = "id")
  
  Ti <- as.numeric(unique(tmpdf.id$T_surv))
  u <- max(tmpdf$T_long) + 30/365
  
  delta <- tmpdf.id$delta
  
  predJM <- tryCatch({JM::survfitJM(object = fitJM, newdata = tmpfulldf, survTimes = u, idVar = "id", simulate = F)}, error = function(e) return(NULL))
  predJMbayes <- tryCatch({JMbayes::survfitJM(fitJMbayes, newdata = tmpfulldf, survTimes = u, idVar = "id", simulate = F)}, error = function(e) return(NULL))
  predJRML <- tryCatch({dynSurv(fitJRML, newdata = tmpdf, newSurvData = tmpdf.id, u = u)}, error = function(e) return(NULL))
  predJMb <- tryCatch({JMpredSurv(object = fitJMb, dat = tmpdf, Survdat = tmpdf.id , u = u, heuristic = F)}, error = function(e) return(NULL))
  
  resdf <- suppressWarnings(data.frame("pack" = c("JM", "JMbayes", "joineRML", "JMboost"),
                                       "predTime" = NA,
                                       "predSurv" = NA,
                                       "weights" = 1,
                                       subset(df.id, id == z, select = c(id, T_surv, delta)))
  )
  # resdf <- resdf[, c("id", "T_surv", "delta", names(resdf)]
  if(!is.null(predJM)) resdf[resdf$pack == "JM", 2:3] <- predJM$summaries[[1]] # sapply(Surv.censThoriz$summaries, "[", 2)
  if(!is.null(predJMbayes)) resdf[resdf$pack == "JMbayes", 2:3] <- predJMbayes$summaries[[1]]
  if(!is.null(predJRML)) resdf[resdf$pack == "joineRML", 2:3] <- predJRML$pred
  if(!is.null(predJMb)) resdf[resdf$pack == "JMboost", 2:3] <- predJMb
  
  if (delta == 0) {
    resdf$weights <- resdf$predSurv
  }
  
  resdf$predErr <- with(resdf,
                        (T_surv > predTime) * (1 - predSurv)^2
                        + delta * (T_surv < predTime) * (0 - predSurv)^2
                        + (1 - delta) * (T_surv < predTime) * (weights * (1 - predSurv)^2 + (1 - weights) * (0 - predSurv)^2)
  )
  
  resdf <- resdf[, c("id", "T_surv", "delta", "pack", "predTime", "predSurv", "weights", "predErr")]
  return(resdf)
  
  # # troublshooting
  # predJRML <- tryCatch(
  #   {
  #     dynSurv(fitJRML, newdata = tmpdf, newSurvData = tmpdf.id, u = u)
  #   },
  #   # error = function(e) return(NULL)
  #   error = function(e) e
  # )
  # return(predJRML)
}
