estFun <- function(x, modelname, method, CACHE = F,
                   n, n_i, betal, betals, betas, betat, alpha, sigma2, lambda, noninfl = 0, noninfls = 0, noninfs = 0, param = "td-value", ...) {
  RNGversion("3.5.1")
  verbose <- TRUE
  
  # print(paste(method, x, sep = "_"))
  # generate data
  set.seed(12345 + x)
  dat <- simJM(n = n, n_i = n_i, int = int, betal = betal, betas = betas, betals = betals, betat = betat, alpha = alpha, lambda = lambda, 
               sigma2 = sigma2, noninfl = noninfl, noninfs = noninfs, noninfls = noninfls)
  
  for(i in c("Xl", "Xs", "Xls")) {
    if(is.null(colnames(dat[[i]]))) colnames(dat[[i]]) <- rep("", ncol(dat[[i]]))
    if(ncol(dat[[i]]) != 0) colnames(dat[[i]]) <- gsub("x", "n", colnames(dat[[i]]))
    if(ncol(dat[[i]]) != 0) colnames(dat[[i]]) <- paste0(i, colnames(dat[[i]]))
  }
  
  df <- with(dat, data.frame(id, y, Xl, T_long, Xls))
  df.id <- with(dat, data.frame("id" = unique(id), T_surv, delta, Xs))
  
  # fit with JM
  if (method == "JM") {
    if(verbose) print(paste(modelname, method, x))
    fitLME <- tryCatch({ do.call("lme", list(fixed = as.formula(paste0("y~", paste(names(df)[3 : ncol(df)], collapse = "+"))),
                                             data = df, 
                                             random = ~ T_long | id, 
                                             na.action = na.exclude, 
                                             control = lmeControl(opt='optim'))) },
                       error = function(e){cat("ERROR :", conditionMessage(e), "/n")})
    fitSURV <- tryCatch({ coxph(Surv(time = T_surv, event=delta) ~ . -id, data = df.id, x = TRUE, na.action = na.exclude) } ,
                        error = function(e){cat("ERROR :",conditionMessage(e), "/n")})
    fitJM <-  tryCatch({ jointModel(fitLME, fitSURV, timeVar = "T_long", method = "piecewise-PH-aGH") },
                       error = function(e){cat("ERROR :",conditionMessage(e), "/n")})
    if (CACHE) { save(fitJM, file = paste0(path, "02_Results/03_Estimation_single/", "JM_", modelname, "_", x, ".RData")) }
    return(fitJM)
  }
  
  # fit with JMbayes
  if (method == "JMbayes") {
    if(verbose) print(paste(modelname, method, x))
    fitLME <- tryCatch({ do.call("lme", list(fixed = as.formula(paste0("y~", paste(names(df)[3 : ncol(df)], collapse = "+"))),
                                             data = df, 
                                             random = ~ T_long | id, 
                                             na.action = na.exclude, 
                                             control = lmeControl(opt='optim'))) },
                       error = function(e){cat("ERROR :", conditionMessage(e), "/n")})
    fitSURV <-  tryCatch({ coxph(Surv(time = T_surv, event=delta) ~ . -id, data = df.id, x = TRUE, na.action = na.exclude) } ,
                         error = function(e){cat("ERROR :",conditionMessage(e), "/n")})
    fitJMbayes <-  tryCatch({ jointModelBayes(fitLME, fitSURV, timeVar = "T_long", param = param, baseHaz = "P-splines") },
                            error = function(e){cat("ERROR :",conditionMessage(e), "/n")})
    if (CACHE) { save(fitJMbayes, file = paste0(path, "02_Results/03_Estimation_single/", "JMbayes_", modelname, "_", x, ".RData")) }
    return(fitJMbayes)
  }
  
  # fit with joineRML
  if (method == "joineRML") {
    if(verbose) print(paste(modelname, method, x))
    fitJRML <- tryCatch({ do.call("mjoint", list(formLongFixed = list(as.formula(paste0("y~", paste(names(df)[3 : ncol(df)], collapse="+")))),
                                                 formLongRandom = list(~ T_long | id),
                                                 formSurv = Surv(time = T_surv, event = delta) ~ . -id,
                                                 data = list(df),
                                                 survData = df.id, 
                                                 timeVar = "T_long")) },
                        error=function(e){cat("ERROR :", conditionMessage(e), "/n")})
    if (CACHE) { save(fitJRML, file = paste0(path, "02_Results/03_Estimation_single/", "JRML_", modelname, "_", x, ".RData")) }
    return(fitJRML)
  }
  
  
  # "fit" JMboost
  if (method == "JMboost") {
    if(verbose) print(paste(modelname, method, x))
    if (betat == 0) {timeInXls <- F} else {timeInXls <- T} 
    pos <- which(names(df) == "T_long")
    if (timeInXls) {pos <- pos - 1}
    load(paste0(path, "02_Results/01_CV/", "CV_", modelname, "_", x, ".RData"))
    if (any(cvJMb$best == max(cvJMb$control$threshold))) {cvJMb$best <- rep(NA, 3)}
    
    conArg <- list(mstop_l = cvJMb$best[1], mstop_ls = cvJMb$best[3], mstop_s = cvJMb$best[2])
    
    fitJMb <- tryCatch({ do.call("JMboost.this", list(long = if(pos < 3) {y ~ 1} else {as.formula(paste0("y~", paste(names(df)[3 : pos], collapse="+")))},
                                                      shared = if((pos + 1) > ncol(df)) {~ 1} else {as.formula(paste0("~", paste(names(df)[(pos + 1) : ncol(df)], collapse="+")))},
                                                      surv = survival:::Surv(time = T_surv, event = delta) ~ . -id,
                                                      data = df, survData = df.id,
                                                      timeVar = "T_long", idVar = "id",
                                                      control = conArg
                                                      # control = list(mstop_l = cvJMb$best[1], mstop_ls = cvJMb$best[3], mstop_s = cvJMb$best[2])
    )) },
    error=function(e){cat("ERROR :", conditionMessage(e), "/n")})
    if (CACHE) { save(fitJMb, file = paste0(path, "02_Results/03_Estimation_single/", "JMb_", modelname, "_", x, ".RData")) }
    return(fitJMb)
  }
}
