cvJM.this <- function(long, shared, surv, data, survData = NULL, timeVar, idVar, control = list(), ...) {
  
  long <- update(long, ~ . - 1)
  mf <- model.frame(long, data = data)
  y <- model.response(mf)
  Xl <- model.matrix(long, data = data)
  if (ncol(Xl) == 0) { Xl <-  NULL}
  shared <- update(shared, ~ . - 1)
  Xls <- model.matrix(shared, data = data)
  if (ncol(Xls) == 0) { Xls <-  NULL}
  if (is.null(survData)) {
    survData <- data[!duplicated(data[, idVar]), ]
  }
  survdat <- survData
  smf <- model.frame(surv, survdat)
  T_surv <- model.response(smf)[,1]
  delta <- model.response(smf)[,2]
  Xs <- model.matrix(surv, data = survdat)[,-1, drop = FALSE]
  if (ncol(Xs) == 0) { Xs <-  NULL}
  
  if (timeVar %in% colnames(Xls)) {time.effect <- TRUE; Xls <- Xls[, colnames(Xls) != timeVar]} else {time.effect <- FALSE}
  id <- data[, idVar]
  T_long <- data[, timeVar]
  
  con <- list(k = 10, grid1 = NULL, grid2 = NULL, grid3 = NULL, candgrid = NULL, thresh = NULL, multicore = F)
  con[(conArgs <- names(control))] <- control
  # 
  fit <- do.call("cvJM", list(data = list(y = y, Xl = Xl, Xs = Xs, Xls = Xls, T_long = T_long, T_surv = T_surv, delta = delta, id = id), 
                              time.effect = time.effect, k = con$k, multicore = con$multicore,
                              grid1 = con$grid1, grid2 = con$grid2, grid3 = con$grid3, 
                              candgrid = con$candgrid, thresh = con$thresh))
  return (fit)
}


cvJM <- function(data, k = 10, grid1 = NULL, grid2 = NULL, grid3 = NULL, candgrid = NULL, 
                 thresh = NULL, time.effect, multicore = F, ...){
  ## split data set into k=10 folds --------------------------------------------------------- ##
  RNGversion("3.5.1")
  set.seed(81264)
  
  m <- ceiling(length(unique(data$id))/k) # (over)size of each subset
  testset <- numeric(length(unique(data$id)))
  eventInd <- which(data$delta == 1)
  censInd <- which(data$delta == 0)
  vecE <- c(rep(1:k, length.out = k * floor(length(eventInd) / k)), # generate candidates for fold assignment, evenly distribute events across folds by deterministically setting fold as a multiple of k
            sample(1:k, length(eventInd) %% k)) # randomly select folds for the remaining (modulo) events not yet distributed 
  testset[eventInd] <- sample(vecE, replace = F) # randomly distribute the fold indicators for individuals with events 
  vecC <- rep(1:k, m - table(vecE)) # generate candidates for fold assigment for censored indidviduals taking assign folds for those with events into account
  tooMany <- length(vecC) - length(censInd) # randomly remove excess fold allocation (as a result of oversized subsets)
  if(tooMany != 0) {
    ind <- lapply(1:k, function(kk) which(vecC == kk))
    delInd <- unlist(lapply(sample(1:k, tooMany), function(x) sample(ind[[x]], 1)))
    vecC <- vecC[-delInd]
  }
  testset[censInd] <- sample(vecC, replace = F) # randomly distribute the fold indicators for censored individuals
  
  rm(vecC, vecE, eventInd, censInd, tooMany, ind, delInd)
  
  ## Initialize vectors, arrays and lists
  if (is.null(candgrid)) {candgrid <-  c(seq(3, 27, 3), seq(30, 900, 30))}
  if (is.null(thresh)) {thresh <- c(27, 150, 300, 600, 900, 3000)}
  
  if (is.null(grid1)) {grid1 <- seq(30, 300, 30)}
  if (is.null(grid2)) {grid2 <- seq(30, 300, 30)}
  if (is.null(grid3)) {grid3 <- seq(30, 300, 30)}
  
  likres <- indres <- array(NA, rep(length(candgrid), 3),
                            dimnames = list(candgrid, candgrid, candgrid))
  
  intervals <- findInterval(candgrid, thresh, left.open = T)
  
  gridlist <- list(grid1, grid2, grid3)
  names(gridlist) <- c("ml", "ms", "mls")

  cond <- F

  sset <- function(d, filter){
    cand_un <- which(unique(data$id) %in% unique(data$id)[filter])
    cand <- which(data$id %in% unique(data$id)[filter])
    
    if(is.matrix(d)){
      if(dim(d)[1]==length(unique(data$id))){d[cand_un,,drop=FALSE]}else{d[cand,,drop=FALSE]}
    }else{
      if(length(d)==length(unique(data$id))){d[cand_un]}else{d[cand]}
    }
  }
  
  CVFUN <- function (kk) {
    data.train <- lapply(data, sset, testset!=kk)
    data.pred <- lapply(data, sset, testset==kk)
    cv.res <- tryCatch({cvres(data.train = data.train, data.pred = data.pred, gridlist = gridlist, time.effect = time.effect)},
                       error=function(e){cat("ERROR :", conditionMessage(e), "\n")})
    return(cv.res)
  }
  
 while (cond == F) {
    # perform CV
    # res <- lapply(1:k, function (kk) {
    #   data.train <- lapply(data, sset, testset!=kk)
    #   data.pred <- lapply(data, sset, testset==kk)
    #   cv.res <- tryCatch({cvres(data.train = data.train, data.pred = data.pred, gridlist = gridlist, time.effect = time.effect)},
    #                      error=function(e){cat("ERROR :", conditionMessage(e), "\n")})
    #   return(cv.res)
    # })
    
    if (multicore) {
      res <- mclapply(1:k, CVFUN, mc.cores = 10)
    } else {
      res <- lapply(1:k, CVFUN)
    }
    
    # Combine results
    ind <- Reduce("+", lapply(1:length(res), function(x) res[[x]]$indarr))
    lik <- Reduce("+", lapply(1:length(res), function(x) res[[x]]$likarr))
    
    if (any(ind != 0, na.rm = T)) {lik[ind != 0] <- NA} 
    
    # store cv results in likelihood placeholder
    dims <- lapply(gridlist, function(x) candgrid %in% x)
    likres[dims[[1]], dims[[2]], dims[[3]]] <- lik
    indres[dims[[1]], dims[[2]], dims[[3]]] <- ind
    
    # determine best iteration numbers
    bestInd <- which(likres == max(likres, na.rm = T), arr.ind = T)
    bestInd <- bestInd[1,]
    bestCand <- c(candgrid[bestInd[1]], candgrid[bestInd[2]], candgrid[bestInd[3]]) 
    names(bestCand) <- c("ml","ms","mls")
    
    # define bounds and whether different iteration values need to be searched a.k.a search grid needs expansion
    LB <- unlist(lapply(gridlist, min)) # Lower Bounds of candidate grids
    UB <- unlist(lapply(gridlist, max)) # Upper bounds of candidate grids
    
    # decide if other iteration candidates need to be visited and in which direction to move on the candgrid in order to find them
    gridExp <- -(LB == bestCand) + (UB == bestCand) # grid expansion -1 is lower values, 1 is larger values
    if (any(which(LB == min(candgrid)) %in%  which(gridExp == -1))) {gridExp[gridExp == -1 & LB == min(candgrid)] <- 0}
    
    # define updated gridlist
    gridlist <- lapply(1:3, function(x) {
      currIntvl <- unique(intervals[candgrid %in% gridlist[[x]]])
      newIntvl <- currIntvl + gridExp[x]
      candgrid[intervals == newIntvl]
    }
    )
    names(gridlist) <- c("ml", "ms", "mls")
    
    # define break off condition
    cond <- any(c(all(gridExp == 0), # no expansion needed, maximum is within visited iteration candidates
                  which(UB == max(candgrid)) %in% which(gridExp == 1) # maximum currently lies at upper limit of iteration candidates, algorithm has not yet found true max
    ))
    if (cond) {break}
  }

  # if while broke off due to it reaching the max bounds of the candgrid and if this happened only to one set of candidate iterations
  # iterate only that one further 
  cond2 <- which(UB == max(candgrid)) %in% which(gridExp == 1) # maximum currently lies at upper limit of iteration candidates, algorithm has not yet found true max
  if (all(cond2)) {
    if(sum(UB == max(candgrid)) == 1) {
      # set aside exisiting arrays of likelihood and failure indicator
      likres0 <- likres
      indres0 <- indres
      
      # define new gridlist existing of two single scalars and one vector
      gridlist <- lapply(1:3, function(x) {
        if(bestCand[x] == max(bestCand)) {
          bestCand[x] : max(thresh)
        } else {
          bestCand[x]
        }
      })
      names(gridlist) <- c("ml", "ms", "mls")
      
      # initialize new placeholder arrays for likelihood and failure indicator, now spans the size of candgrid and the one gridlist expansion beyond the candgrid
      likres <- indres <- array(NA, 
                                dim = c(length(unique(c(candgrid, gridlist$ml))),
                                        length(unique(c(candgrid, gridlist$ms))),
                                        length(unique(c(candgrid, gridlist$mls)))),
                                dimnames = list(unique(c(candgrid, gridlist$ml)),
                                                unique(c(candgrid, gridlist$ms)),
                                                unique(c(candgrid, gridlist$mls))))
      
      # write existing likelihood and failure indicator values into new placeholders
      dims <- lapply(1:3, function(x) dimnames(likres)[[x]] %in% dimnames(likres0)[[x]])
      likres[dims[[1]], dims[[2]], dims[[3]]] <- likres0
      indres[dims[[1]], dims[[2]], dims[[3]]] <- indres0
      
      # rerun CV for that particular set of gridlist candidate values
      res <- lapply(1:k, function (kk) {
        data.train <- lapply(data, sset, testset!=kk)
        data.pred <- lapply(data, sset, testset==kk)
        cv.res <- tryCatch({cvres2(data.train = data.train, data.pred = data.pred, gridlist = gridlist, time.effect = time.effect)},
                           error=function(e){cat("ERROR :", conditionMessage(e), "\n")})
        return(cv.res)
      })
      
      # Combine results, no ind needed, chances of failure about 0
      lik <- Reduce("+", lapply(1:length(res), function(x) res[[x]]$likarr))
      
      # store cv results in likelihood placeholder
      dims <- lapply(1:3, function(x) dimnames(likres)[[x]] %in% gridlist[[x]])
      likres[dims[[1]], dims[[2]], dims[[3]]] <- lik
      # indres[dims[[1]], dims[[2]], dims[[3]]] <- 0
      
      # determine best iteration numbers
      bestInd <- which(likres == max(likres, na.rm = T), arr.ind = T)
      bestInd <- bestInd[1,]
      bestCand <- as.numeric(unlist(lapply(1:3, function(x) dimnames(likres)[[x]][bestInd[x]])))
      names(bestCand) <- c("ml","ms","mls")
    }
  }

return(list("best" = bestCand,
            "likelihood" = likres,
            "fails" = indres,
            "control" = list("startgrids" = list(grid1, grid2, grid3),
                             "n_folds" = k,
                             "candidate grid" = candgrid,
                             "threshold" = thresh,
                             "parallel" = multicore)))
}


cvres <- function(data.train, data.pred, gridlist, time.effect){
  
  grid1 <- gridlist$ml
  grid2 <- gridlist$ms
  grid3 <- gridlist$mls
  
  likarr <- indarr <- array(0, c(length(grid1), length(grid2), length(grid3)),
                            dimnames = list(grid1, grid2, grid3))  # grid1=ml, grid2=ms, grid3=mls
  for(ml_akt in grid1){
    for(ms_akt in grid2){
      for(mls_akt in grid3){
        # print(c(ml_akt, ms_akt, mls_akt))
        mod <- tryCatch({JMboost(y = data.train$y, Xl = data.train$Xl, Xs = data.train$Xs, Xls = data.train$Xls, delta = data.train$delta,
                                 T_long = data.train$T_long, T_surv = data.train$T_surv, id = data.train$id, time.effect = time.effect,
                                 mstop_l = ml_akt, mstop_s = ms_akt, mstop_ls = mls_akt, verbose = F)},
                        error=function(e){cat("ERROR :", conditionMessage(e), "\n")})
        
        like <-  tryCatch({like_cv(y = data.pred$y,  Xl = data.pred$Xl, Xs = data.pred$Xs, Xls = data.pred$Xls, delta = data.pred$delta,
                                   T_surv = data.pred$T_surv, T_long = data.pred$T_long, id = data.pred$id, int = mod$int, 
                                   betal = as.matrix(mod$betal), betas = as.matrix(mod$betas), betals = as.matrix(mod$betals), betat = mod$betat, 
                                   alpha = mod$alpha, lambda = mod$lambda, sigma2 = mod$sigma2)},
                          error=function(e){cat("ERROR :",conditionMessage(e), "\n")})
        
        if (is.null(mod)) {
          likarr[as.character(ml_akt), as.character(ms_akt), as.character(mls_akt)] <-  0
          indarr[as.character(ml_akt), as.character(ms_akt), as.character(mls_akt)] <-  1
        } else {
          likarr[as.character(ml_akt), as.character(ms_akt), as.character(mls_akt)] <-  like
        }
        
      }
    }
  }
  return(list("likarr" = likarr, "indarr" = indarr))
}

cvres2 <- function(data.train, data.pred, gridlist, time.effect) {
  grid1 <- gridlist$ml
  grid2 <- gridlist$ms
  grid3 <- gridlist$mls
  
  likarr <- array(0, c(length(grid1), length(grid2), length(grid3)), dimnames = list(grid1, grid2, grid3))
  
  mod <- tryCatch({JMboost(y = data.train$y, Xl = data.train$Xl, Xs = data.train$Xs, Xls = data.train$Xls, delta = data.train$delta,
                           T_long = data.train$T_long, T_surv = data.train$T_surv, id = data.train$id, time.effect = time.effect,
                           mstop_l = max(grid1), mstop_s = max(grid2), mstop_ls = max(grid3), verbose = F)},
                  error=function(e){cat("ERROR :", conditionMessage(e), "\n")})
  
  like <- lapply(gridlist[[which(lengths(gridlist) != 1)]], function(y) {
    tryCatch({
      like_cv(y = data.pred$y,  Xl = data.pred$Xl, Xs = data.pred$Xs, Xls = data.pred$Xls, delta = data.pred$delta,
              T_surv = data.pred$T_surv, T_long = data.pred$T_long, id = data.pred$id, int = mod$INT[y],
              betal = mod$BETAL[,y], betas = mod$BETAS[,y], betals = mod$BETALS[,y], betat = mod$BETAT[y],
              alpha = mod$ALPHA[y], lambda = mod$LAMBDA[y], sigma2 = mod$SIGMA2[y])
    }, error=function(e){cat("ERROR :",conditionMessage(e), "\n")})
  })
  
  likarr[as.character(grid1), as.character(grid2), as.character(grid3)] <- unlist(like)
  
  return(list("likarr" = likarr))
}

like_cv = function(y, Xl, Xs, Xls, delta, T_surv, T_long, id,
                   int, betal, betas, betals, betat, alpha, lambda, sigma2, gamma0 = 0, gamma1 = 0) {
  # for prediction likelihood e.g. in CV settings gamma0/ gamma1 == 0, else estimated gamma0/gamma1
  
  first = rep(FALSE, length(id))
  for (i in unique(id)) {
    first[which.max(id==i)] = TRUE
  }
  if (!is.null(Xls)) {Xls_un = as.matrix(Xls[first==1,])}
  if (is.null(Xl)) {Xl = 0}
  if (is.null(Xs)) {Xs = 0}
  if (is.null(Xls)) {Xls = 0; Xls_un = 0}
  
  Xr1 <- as.matrix(Matrix::bdiag(lapply(table(id), function(x) rep(1, x))))
  Xr2 <- Xr1*T_long
  Xr <- cbind(Xr1, Xr2)
  if (gamma0 == 0) {gamma0 <- rep(0, ncol(Xr1))}
  if (gamma1 == 0) {gamma1 <- rep(0, ncol(Xr2))}
  rm(Xr1, Xr2)
  
  etal = as.vector(int + Xl%*%betal)
  etas = as.vector(Xs%*%betas)
  etals = as.vector(Xr%*%c(gamma0, gamma1) + as.vector(Xls%*%betals) + T_long*betat)
  etals_un = as.vector(gamma0 + gamma1*T_surv + as.vector(Xls_un%*%betals) + betat*T_surv)
  
  time.eff.ind <- (betat + gamma1) != 0
  integral <- as.matrix(ifelse(time.eff.ind,
                               lambda*exp(etas)*(exp(alpha*etals_un) - exp(alpha*(etals_un - (gamma1 + betat)*T_surv)))/(alpha*(betat+gamma1)),
                               lambda*exp(etas)*exp(alpha*etals_un)*T_surv)
  )
  
  surv = delta*(log(lambda) + etas + alpha*etals_un) - integral
  long = log(1/sqrt(2*pi*sigma2)) - (y - etals - etal)^2/(2*sigma2)
  like = sum(surv) + sum(long)
  return(like)
}

